/* config.h */
/* architecture-customized config.h for zsh 2.5.0 */

/* define this if you use pure SYSV */
/*#define SYSV*/

/* some environments have broken termios, for example ULTRIX */
/* define this if you use termios */
/*#define HAS_TERMIOS 1*/
#define HAS_TERMIO 1

/* define this if you use <dirent.h> */
#define HAS_DIRENT 1

/* define this if you use <unistd.h> */
#define HAS_UNISTD 1

/* define this if you use <stdlib.h> */
#define HAS_STDLIB 1

/* define this if you use <string.h> */
#define HAVE_STRING_H 1

/* define this if you use <memory.h> */
/*#define HAVE_MEMORY 1*/

/* define this if you use <locale.h> */
/*#define HAS_LOCALE 1*/

/* define this if you use <utmpx.h> */
/*#define HAS_UTMPX*/

/* define this if you use host field in utmp */
/*#define UTMP_HOST 1*/

/* define this if you use <time.h> */
#define HAS_TIME

/* define this if you use <wait.h> */
/*#define HAS_WAIT*/

/* define this if you use waitpid() */
#define HAS_WAITPID 1

/* define this if you use select() */
/*#define HAS_SELECT 1*/

/* define this if you use "struct fd_set" in <sys/select.h> */
/*#define HAS_SYS_SELECT*/

/* we can't just test for S_IFIFO or check to see if the mknod worked,
   because the NeXTs sold by a vendor which will remain nameless will
   happily create the FIFO for you, and then panic when you try to do
	something weird with them, because they aren't supported by the OS. */
/* define this if you use fifos */
/*#define HAS_FIFOS 1*/

/* define this if you use strftime() */
#define HAS_STRFTIME 1

/* define this if you use tcsetpgrp() */
/*#define HAS_TCSETPGRP 1*/

/* define this if you use tcgetattr() and friends */
#define HAS_TCCRAP 1

/* define this if you use setpgid() */
/*#define HAS_SETPGID 1*/

/* define this if you use sigrelse() */
/*#define HAS_SIGRELSE*/

/* define this if you use RFS */
/*#define HAS_RFS*/

/* the stress is on "a working wait3()" because for example HP-UX has
 * sort of working getrusage() but nothing like wait3() */
/* define this if you use getrusage() and wait3() */
/*#define HAS_RUSAGE 1*/

/* define this if you use NIS */
/*#define HAS_NIS 1*/

/* define this if you use username caching */
/*#define CACHE_USERNAMES*/

/* define this if you use signal handlers returning void */
/*#define SIGVOID 1*/

/* define this if you use automatically reset signal handlers */
#define HAS_AUTORESETHAND 1

/* define this if you use sigset() to install said signal handlers */
/*#define USE_SIGSET*/

#if defined(SIGVOID) || defined(IRIX5) || defined(SCO)
#define HANDTYPE void
#else
#define HANDTYPE int
#define INTHANDTYPE
#endif

/* a string corresponding to the host type */

#define HOSTTYPE "os2-x86"

/* the default editor for the fc builtin */
#define DEFFCEDIT "vi"

/* the path of wtmp */
#define WTMP_FILE "nul"

/* the path of utmp */
#define UTMP_FILE "nul"
/* default prefix for temporary files */
#define DEFTMPPREFIX "./zsh"
/* the global file to source absolutely first whenever zsh is run;
if undefined, don't source anything */
#define GLOBALZSHENV "/etc/zshenv"
/* the global file to source whenever zsh is run;
if undefined, don't source anything */
#define GLOBALZSHRC "/etc/zshrc"
/* the global file to source whenever zsh is run as a login shell;
if undefined, don't source anything */
#define GLOBALZLOGIN "/etc/zlogin"
/* the global file to source whenever zsh is run as a login shell,
before zshrc is read; if undefined, don't source anything */
#define GLOBALZPROFILE "/etc/zprofile"
/* define this if you use "suspended" instead of "stopped" */
#define USE_SUSPENDED 1

/* the default history buffer size in lines */
#define DEFAULT_HISTSIZE 30
#define _BSD_COMPAT		/* this could be IRIX,  you never know */
#define _BSD_TYPES		/* this could be IRIX5, you never know */
#define _BSD			/* this could be HP-UX, you never know */
#define _BSD_INCLUDES		/* this could be AIX,   you never know */
#define _BBN_POSIX_SUPPORT	/* this could be nX,    you never know */

/* if your compiler doesn't like void *,
 * change this to char * and ignore all the warnings. */

typedef void * void_ptr;

#define JOB_CONTROL

/* define this if you want to use zsh's own allocator */
/* #define USE_ZSH_MALLOC */

#ifdef USE_ZSH_MALLOC

/* define this if you want the allocator to store information */

/* #define MEM_DEBUG */

/* define this if you want to get error messages from the allocator */

/* #define MEM_WARNING */

/* define this if you want free() to be really save */

/* #define SECURE_FREE */

#endif /* USE_ZSH_MALLOC */

#define SJIS 		1
#define HAS_DRIVE	1
/* end of config.h */
