/* zenhan.c */
/*****************************************************************************
					s@o@wsq

							mSpEpϊn
*****************************************************************************/

#include "xtr.h"

/* ANK-ϊpz */

#if UNIX

static ushort asczen[] = {
  0x8140, 0x8149, 0x8168, 0x8194, 0x8190, 0x8193, 0x8195, 0x8166, /* @Ihf */
  0x8169, 0x816a, 0x8196, 0x817b, 0x8143, 0x817c, 0x8144, 0x815e, /* ij{C|D^ */
  0x824f, 0x8250, 0x8251, 0x8252, 0x8253, 0x8254, 0x8255, 0x8256, /* OPQRSTUV */
  0x8257, 0x8258, 0x8146, 0x8147, 0x8183, 0x8181, 0x8184, 0x8148, /* WXFGH */
  0x8197, 0x8260, 0x8261, 0x8262, 0x8263, 0x8264, 0x8265, 0x8266, /* `abcdef */
  0x8267, 0x8268, 0x8269, 0x826a, 0x826b, 0x826c, 0x826d, 0x826e, /* ghijklmn */
  0x826f, 0x8270, 0x8271, 0x8272, 0x8273, 0x8274, 0x8275, 0x8276, /* opqrstuv */
  0x8277, 0x8278, 0x8279, 0x816d, 0x818f, 0x816e, 0x814f, 0x8151, /* wxymnOQ */
  0x8165, 0x8281, 0x8282, 0x8283, 0x8284, 0x8285, 0x8286, 0x8287, /* e */
  0x8288, 0x8289, 0x828a, 0x828b, 0x828c, 0x828d, 0x828e, 0x828f, /*  */
  0x8290, 0x8291, 0x8292, 0x8293, 0x8294, 0x8295, 0x8296, 0x8297, /*  */
  0x8298, 0x8299, 0x829a, 0x816f, 0x8162, 0x8170, 0x8150, 0x0000  /* obpP   */
};

static ushort kanazen[] = {
          0x8142, 0x8175, 0x8176, 0x8141, 0x8145, 0x8392, 0x8340, /*   BuvAE@ */
  0x8342, 0x8344, 0x8346, 0x8348, 0x8383, 0x8385, 0x8387, 0x8362, /* BDFHb */
  0x815b, 0x8341, 0x8343, 0x8345, 0x8347, 0x8349, 0x834a, 0x834c, /* [ACEGIJL */
  0x834e, 0x8350, 0x8352, 0x8354, 0x8356, 0x8358, 0x835a, 0x835c, /* NPRTVXZ\ */
  0x835e, 0x8360, 0x8363, 0x8365, 0x8367, 0x8369, 0x836a, 0x836b, /* ^`cegijk */
  0x836c, 0x836d, 0x836e, 0x8371, 0x8374, 0x8377, 0x837a, 0x837d, /* lmnqtwz} */
  0x837e, 0x8380, 0x8381, 0x8382, 0x8384, 0x8386, 0x8388, 0x8389, /* ~ */
  0x838a, 0x838b, 0x838c, 0x838d, 0x838f, 0x8393, 0x814a, 0x814b, /* JK */
  0x0000
};

static ushort hwtok1[] = {
  0x8390, 0x8391, 0x838e, 0x8395, 0x8396, 0x8394, 0x834b, 0x834d, /* KM */
  0x834f, 0x8351, 0x8353, 0x8355, 0x8357, 0x8359, 0x835b, 0x835d, /* OQSUWY[] */
  0x835f, 0x8361, 0x8364, 0x8366, 0x8368, 0x836f, 0x8370, 0x8372, /* _adfhopr */
  0x8373, 0x8375, 0x8376, 0x8378, 0x8379, 0x837b, 0x837c, 0x0000  /* suvxy{|   */
};
static ushort hwtok2[] = {
  0x814c, 0x814e, 0x8165, 0x8167, 0x816b, 0x816c, 0x8171, 0x8172, /* LNegklqr */
  0x8173, 0x8174, 0x8177, 0x8178, 0x8179, 0x817a, 0x815c, 0x0000  /* stwxyz\   */
};

static ushort daku_zen[] = {
  0x8394, 0x834b, 0x834d, 0x834f, 0x8351, 0x8353, 0x8355, 0x8357, /* KMOQSUW */
  0x8359, 0x835b, 0x835d, 0x835f, 0x8361, 0x8364, 0x8366, 0x8368, /* Y[]_adfh */
  0x836f, 0x8372, 0x8375, 0x8378, 0x837b, 0x0000		  /* orux{       */
};

static ushort handaku_zen[] = { 0x8370, 0x8373, 0x8376, 0x8379, 0x837c, 0x0000 };

#else /* !UNIX */

static uchar asczen[]  =
				 "@Ihfij{C|D^"
				 "OPQRSTUVWXFGH"
				 "`abcdefghijklmn"
				 "opqrstuvwxymnOQ"
				 "e"
				 "obpP";

static uchar kanazen[] =
				  "BuvAE@BDFHb"
				"[ACEGIJLNPRTVXZ\"
				"^`cegijklmnqtwz}"
				"~JK";

static uchar hwtok1[] = "KMOQSUWY[]"
						"_adfhoprsuvxy{|";
static uchar hwtok2[] = "LNegklqrstwxyz\";

static uchar daku_zen[] = "KMOQSUWY[]_adfhorux{";

static uchar handaku_zen[] = "psvy|";

#endif /* !UNIX */

static uchar daku_han[] = {
  0xb3, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, /* EJLNPRTV */
  0xbd, 0xbe, 0xbf, 0xc0, 0xc1, 0xc2, 0xc3, 0xc4, /* XZ\^`ceg */
  0xca, 0xcb, 0xcc, 0xcd, 0xce, 0x00		  /* nqtwz       */
};

static uchar handaku_han[] = { 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0x00 }; /* nqtwz */

#define HANDAKUTEN		0xdf	/* K */
#define DAKUTEN			0xde	/* J */

#if UNIX
static int
windex(ushort *wstr, ushort wc)
{
  int n;

  n = 0;
  while (*wstr) {
    if (*wstr++ == wc)
      return n;
    n++;
  }
  return -1;
}
#endif

unsigned 
ANKtoHW(unsigned ank)
/* `mjmdbQoCgpɕϊ */
{
	if (ank < 0x20 || ank > 0xdf)
		return (ank);
	else if (ank == SP)
		return (HWSP);
	else if (ank >= 0xa1)
		return ((0x859f - 0xa1) + ank);
	else if (ank >= 0x7f)
		return (ank);
	else if (ank >= 0x60)
		return ((0x8580 - 0x60) + ank);
	else
		return ((0x8540 - 0x21) + ank);
}


unsigned 
HWtoANK(unsigned hw)
/* QoCgp`mjɕϊ */
{
	if (hw == HWSP)
		return (SP);
	else if (hw < 0x8540 || hw > 0x85dd)
		return (hw);
	else if (hw >= 0x859f)
		return (hw - 0x859f + 0xa1);
	else if (hw >= 0x8580)
		return (hw - 0x8580 + 0x60);
	else if (hw == 0x857f)
		return (hw);
	else
		return (hw - 0x8540 + 0x21);
}

unsigned 
HWtoZen(unsigned hw)
/* QoCgpSpɕϊ */
{
	if (hw == HWSP)
		return (ZENSP);
	else if (hw <= 0x85dd)
		return (ANKtoZen(HWtoANK(hw)));
	else if (hw <= 0x85fc)
#if UNIX
		return hwtok1[hw - 0x85de];
#else
		return (MkMoji(hwtok1[(hw - 0x85de) * 2],
					   hwtok1[(hw - 0x85de) * 2 + 1]));
#endif
	else if (hw <= 0x867e)
		return (hw + 0x86a0 - 0x8641);
	else if (hw <= 0x868f)
		return (hw + 0x86de - 0x8680);
	else if (hw <= 0x869e)
#if UNIX
		return hwtok2[hw - 0x8690];
#else
		return (MkMoji(hwtok2[(hw - 0x8690) * 2],
					   hwtok2[(hw - 0x8690) * 2 + 1]));
#endif
	else
		return (ANKtoZen(hw));
}


unsigned 
ANKtoZen(unsigned ank)
{
	if (ank >= 0xe0)
		return (ank);
	else if (ank >= 0xa1)
#if UNIX
		return kanazen[ank - 0xa1];
#else
		return (MkMoji(kanazen[(ank - 0xa1) * 2],
					   kanazen[(ank - 0xa1) * 2 + 1]));
#endif
	else if (ank >= 0x7f)
		return (ank);
	else if (ank >= 0x20)
#if UNIX
		return asczen[ank - 0x20];
#else
		return (MkMoji(asczen[(ank - 0x20) * 2],
					   asczen[(ank - 0x20) * 2 + 1]));
#endif
	else
		return (ank);
}

unsigned 
ANKtoZen2(unsigned ank, unsigned ank2, unsigned *dakuten)
{
	uchar *p;

	assert(dakuten != NULL);
	*dakuten = 0;
	if (ank >= 0xe0) {
		return ank;
	} else if (ank2 == HANDAKUTEN && (p = (uchar *)strchr((char *)handaku_han, ank)) != NULL) {
		*dakuten = HANDAKUTEN;
#if UNIX
		return handaku_zen[(ulong)p - (ulong)handaku_han];
#else
		return MkMoji(handaku_zen[(p - handaku_han) * 2],
					  handaku_zen[(p - handaku_han) * 2 + 1]);
#endif
	} else if (ank2 == DAKUTEN && (p = (uchar *)strchr((char *)daku_han, ank)) != NULL) {
		*dakuten = DAKUTEN;
#if UNIX
		return daku_zen[(ulong)p - (ulong)daku_han];
#else
		return MkMoji(daku_zen[(p - daku_han) * 2],
					  daku_zen[(p - daku_han) * 2 + 1]);
#endif
	} else {
		return ANKtoZen(ank);
	}
}

unsigned 
ASCtoZen(unsigned asc)
{
	if (asc < 0x20 || asc > 0x7e)
		return (asc);
	else
#if UNIX
		return asczen[asc - 0x20];
#else
		return (MkMoji(asczen[(asc - 0x20) * 2],
					   asczen[(asc - 0x20) * 2 + 1]));
#endif
}


unsigned 
ZentoASC(unsigned zen)
/* Sp̉pL𔼊p̃AXL[ (0x20`0x7e) ɕϊ */
{
#if UNIX
	int n;

	if (Is1B(zen) || !IsANKZen(zen) || (n = windex(asczen, zen)) < 0)
		return zen;
	else
		return 0x20 + n;
#else
	uchar *p;

	if (Is1B(zen) || !IsANKZen(zen) || (p = jstrchr(asczen, zen)) == NULL)
		return zen;
	else
		return 0x20 + (p - asczen) / 2;
#endif
}

unsigned 
ZentoANK(unsigned zen)
{
#if UNIX
	int n;

	if (Is1B(zen) || !IsANKZen(zen))
		return zen;
	else if ((n = windex(asczen, zen)) >= 0)
		return 0x20 + n;
	else if ((n = windex(kanazen, zen)) >= 0)
		return 0xa1 + n;
	else
		return zen;
#else
	uchar *p;

	if (Is1B(zen) || !IsANKZen(zen))
		return zen;
	else if ((p = jstrchr(asczen, zen)) != NULL)
		return 0x20 + (p - asczen) / 2;
	else if ((p = jstrchr(kanazen, zen)) != NULL)
		return 0xa1 + (p - kanazen) / 2;
	else
		return zen;
#endif
}

unsigned 
ZentoANK2(unsigned zen, unsigned *dakuten)
{
#if UNIX
	int n;

	assert(dakuten != NULL);
	*dakuten = 0;
	if (Is1B(zen) || !IsANKZen(zen)) {
		return zen;
	} else if ((n = windex(handaku_zen, zen)) >= 0) {
		*dakuten = HANDAKUTEN;
		return handaku_han[n];
	} else if ((n = windex(daku_zen, zen)) >= 0) {
		*dakuten = DAKUTEN;
		return daku_han[n];
	} else {
		return ZentoANK(zen);
	}
#else
	uchar *p;

	assert(dakuten != NULL);
	*dakuten = 0;
	if (Is1B(zen) || !IsANKZen(zen)) {
		return zen;
	} else if ((p = jstrchr(handaku_zen, zen)) != NULL) {
		*dakuten = HANDAKUTEN;
		return handaku_han[(p - handaku_zen) / 2];
	} else if ((p = jstrchr(daku_zen, zen)) != NULL) {
		*dakuten = DAKUTEN;
		return daku_han[(p - daku_zen) / 2];
	} else {
		return ZentoANK(zen);
	}
#endif
}

unsigned 
ChangeANKtoZen(unsigned ank, unsigned zen)
/* ANK-ϊe[uCA
 * ANKɑ΂Ăǂ̊Ή邩w肷B
 * uO̊R[hԂB
 * ANKÃR[h͈͊OȂ 0 ԂB
 */
{
#if UNIX
	ushort *tblp = NULL;
	unsigned oldzen;

	if (!IsANKZen(zen))
		;
	else if (0x20 <= ank && ank < 0x7f)
		tblp = &asczen[ank - 0x20];
	else if (0xa1 <= ank && ank < 0xe0)
		tblp = &kanazen[ank - 0xa1];
	
	if (tblp == NULL)
		return 0;
	else {
		oldzen = *tblp;
		*tblp = zen;
		return oldzen;
	}
#else
	uchar *tblp = NULL;
	unsigned oldzen;
	
	if (!IsANKZen(zen))
		;
	else if (ank >= 0xe0)
		;
	else if (ank >= 0xa1)
		tblp = kanazen + (ank - 0xa1) * 2;
	else if (ank >= 0x7f)
		;
	else if (ank >= 0x20)
		tblp = asczen + (ank - 0x20) * 2;
	
	if (tblp == NULL)
		return 0;
	else {
		oldzen = MojiK(tblp);
		SetKanji_(zen, tblp);
		return oldzen;
	}
#endif
}

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
