/* xstring.c */
/*****************************************************************************
					s@o@wsq

							m̏n
*****************************************************************************/

#include "xtr.h"



/******************************** MkRomNum ********************************/
/* [}B
*/

static uchar *
MkRomNum1(uchar *p, int i, int v, int x, int n)
{
	if (v && (n == 4) || x && (n == 9)) {
		*p++ = i;
		*p++ = (n == 4 ? v : x);
	} else {
		if (v && (n >= 5)) {
			*p++ = v;
			n -= 5;
		}
		while (--n >= 0) {
			*p++ = i;
		}
	}
	return (p);
}

int 
MkRomNum(uchar *dst, int n, int upperflag)
{
	static uchar rom[5][2]
		= {{'i', 'v'}, {'x', 'l'}, {'c', 'd'}, {'m', 0}, {0, 0}};
	uchar *dstp = dst;
	int i, k;
	
	if (n >= 1 && n <= 3999) {
		for (i = 3, k = 1000; i >= 0; i--, k /= 10) {
			dstp = MkRomNum1(dstp, rom[i][0], rom[i][1], rom[i+1][0], n / k);
			n %= k;
		}
	} else {
		/* ͈͊Oł */
		dstp += WtNum(dstp, n);
	}
	*dstp = 0;
	if (upperflag)
		strupr((char *)dst);
	return dstp - dst;
}

/******************************** MkNthNum ********************************/
/* B 0th 1st 2nd 3rd 4th 5th ...
*/

int 
MkNthNum(uchar *dst, long n)
{
	int len;
	int nn;

	sprintf((char *)dst, "%ld", n);
	len = strlen((char *)dst);
	nn = (int)(Abs(n) % 100);
	if (nn >= 20)
		nn %= 10;
	switch (nn) {
	case 1:
		len += CopyStr(dst+len, "st");
		break;
	case 2:
		len += CopyStr(dst+len, "nd");
		break;
	case 3:
		len += CopyStr(dst+len, "rd");
		break;
	default:
		len += CopyStr(dst+len, "th");
	}
	return len;
}


/**************************************/

int 
RTrimSpace(uchar *str)
/* ̉ẼXy[X폜ijIj */
/* ʂ̒̕Ԃ */
{
	return RTrimSpaceN(str, strlen((char *)str));
}

int 
RTrimSpaceN(uchar *str, int len)
{
	uchar *p = BackSkipSpace(str, str + len);
	*p = '\0';
	return p - str;
}

/**************************************/

uchar *
SkipSpace(const uchar *p)
{
	while (isspace(*p))
		p++;
	return (uchar*)p;
}

uchar *
BackSkipSpace(const uchar *s, const uchar *p)
{
	while (p > s && isspace(*(p-1)))
		--p;
	return (uchar*)p;
}

uchar *
SkipSym2(const uchar *p)
/* p܂ '_' XLbv */
{
	while (IsSym2_(*p)) p++;
	return (uchar*)p;
}

uchar *
SkipKSym2(const uchar *p)
/* p܂ '_'A܂͋󔒈ȊO̊XLbv */
{
	while (IsKSym2Str(p))
		p = SkipMoji(p);

	return (uchar*)p;
}

uchar *
SkipAlpha(const uchar *p)
{
	while (isalpha(*p)) p++;
	return (uchar*)p;
}

uchar *
SkipAlnum(const uchar *p)
{
	while (isalnum(*p)) p++;
	return (uchar*)p;
}


uchar *
SkipDigit(const uchar *p)
{
	while (isdigit(*p)) p++;
	return (uchar*)p;
}

uchar *
SkipXDigit(const uchar *p)
{
	while (isxdigit(*p)) p++;
	return (uchar*)p;
}


/**************************************/

#define SetDefaultTrimChrs()	\
  do { if (chrs == NULL) chrs = SSPACES; } while (0)


int 
StrSpn(const uchar *src, const uchar *chrs)
/* strspn ̊gBchrs  NULL w肷ƁAXy[XW
 * w肵ƂɂȂB
 */
{
	const uchar *p;
	SetDefaultTrimChrs();
	if (nokanjimode)
		return strspn((const char *)src, (const char *)chrs);
	else
		return (p = (uchar *)jstrskip((const char *)src, (const char *)chrs)) ? p - src : strlen((const char *)src);
}

int 
StrCSpn(const uchar *src, const uchar *chrs)
{
	const uchar *p;
	SetDefaultTrimChrs();
	if (nokanjimode)
		return strcspn((const char *)src, (const char *)chrs);
	else
		return (p = (uchar *)jstrmatch((const char *)src, (const char *)chrs)) ? p - src : strlen((const char *)src);
}

int 
StrRSpn(const uchar *src, int len, const uchar *chrs)
{
	const uchar *p;
	int  len2 = len;
	SetDefaultTrimChrs();

	while (len2 > 0) {
		p = StrLastN(src, len2);
		if (*p && (nokanjimode ? strchr((const char *)chrs, *p) : jstrchr((const char *)chrs, Moji(p))))
			len2 = p - src;
		else
			break;
	}
	return len - len2;
}

int 
StrRCSpn(const uchar *src, int len, const uchar *chrs)
{
	const uchar *p;
	int  len2 = len;
	SetDefaultTrimChrs();

	while (len2 > 0) {
		p = StrLastN(src, len2);
		if (*p && (nokanjimode ? strchr((const char *)chrs, *p) : jstrchr((const char *)chrs, Moji(p))))
			break;
		else
			len2 = p - src;
	}
	return len - len2;
}

/**************************************/

int 
CopyStr(uchar *dst, const uchar *src)
{
	assert(dst != NULL);
	return CopyStrN(dst, src, (src ? strlen((const char *)src) : 0));
}

int 
CopyStrDiff(uchar *dst, const uchar *src_s, const uchar *src_e)
/* ̎n_ src_s I_ src_e ܂łobt@ dst ɃRs[B*/
{
	assert(dst != NULL);
	assert(src_s != NULL);
	assert(src_e != NULL);
	assert(src_e >= src_s);
	return CopyStrN(dst, src_s, src_e - src_s);
}


int 
CopyStrN(uchar *dst, const uchar *src, int len)
{
	assert(dst != NULL);
	assert(len == 0 || src != NULL);
	assert(len >= 0);
	memmove(dst, src, len);		/* ʌƕʐ̗̈悪dĂĂ悢 */
	*(dst + len) = '\0';
	return len;
}

uchar *
DupStr(const uchar *src)
{
	return DupStrN(src, (src ? strlen((const char *)src) : 0));
}

uchar *
DupStrDiff(const uchar *src_s, const uchar *src_e)
/* ̎n_ src_s I_ src_e ܂ł malloc Ŋmۂ̈
   ɃRs[B*/
{
	assert(src_s != NULL);
	assert(src_e != NULL);
	assert(src_e >= src_s);
	return DupStrN(src_s, src_e - src_s);
}

uchar *
DupStrN(const uchar *src, int len)
/* V̈mۂĕRs[B */
{
	uchar *dst;
	assert(len == 0 || src != NULL);
	assert(len >= 0);

	dst = (uchar *)XMalloc(len + 1);
	memcpy(dst, src, len);
	*(dst + len) = '\0';
	return dst;
}

/**************************************/

static int 
StrCapitalizeF(uchar *dst, const uchar *src, int onlytopflag)
{
	uchar *dstp = dst;
	const uchar *srcp = src;
	unsigned c;
	int bowflag = 1;			/* beginning of word flag */

	while (*srcp) {
		c = RdMoji(srcp);
		if (Is1B(c) && bowflag && isalnum(c)) {
			*dstp++ = TOUPPER(c);
			bowflag = 0;
		} else if (Is1B(c) && !onlytopflag &&
						!isalnum(c) && c != '\'' && c != '"') {
			bowflag = 1;
			*dstp++ = c;
		} else
			dstp += SetMoji(c, dstp);
	}
	*dstp = 0;
	return dstp - dst;
}

int 
StrCapitalize(uchar *dst, const uchar *src)
/* eP̐擪啶ĕRs[ */
{
	return StrCapitalizeF(dst, src, 0);
}

int 
StrCapitalize1(uchar *dst, const uchar *src)
/* ŏ̒P̐擪啶ĕRs[ */
{
	return StrCapitalizeF(dst, src, 1);
}

/**************************************/

typedef int (CDECL *conv1fnp_t)(int);
typedef unsigned (*conv2fnp_t)(unsigned);

static int 
StrConv1(uchar *dst, const uchar *src, conv1fnp_t func)
/* ϊ֐iPoCg̕ϊpj*/
/* func  toupper ̂悤ȕWCu֐ւ̃|C^ */
{
	uchar *dstp = dst;

	while (*src) {
		if (IsKanjiStr(src))
			*((ushort*)dstp)++ = *((ushort*)src)++;
		else
			*dstp++ = (*func)(*src++);
	}
	*dstp = 0;
	return dstp - dst;
}

static int 
StrConv2(uchar *dst, const uchar *src, conv2fnp_t func)
/* ϊ֐iėpj*/
/* func  ANKtoZen ̂悤 unsigned  unsigned ɕϊ֐ */
{
	uchar *dstp = dst;
	unsigned c;

	while (*src) {
		c = (*func)(RdMoji(src));
		dstp += SetMoji(c, dstp);
	}
	*dstp = 0;
	return dstp - dst;
}


int 
StrUpper(uchar *dst, const uchar *src)
/* 啶ɕϊĕRs[ */
{
	return StrConv1(dst, src, (conv1fnp_t)TOUPPER);
}


int 
StrLower(uchar *dst, const uchar *src)
/* 啶ɕϊĕRs[ */
{
	return StrConv1(dst, src, (conv1fnp_t)TOLOWER);
}


int 
StrZen(uchar *dst, const uchar *src)
/* pSpɕϊĕRs[iJi͂̂܂܁j */
{
	return StrConv2(dst, src, ASCtoZen);
}


int 
StrZen2(uchar *dst, const uchar *src)
/* pSpɕϊĕRs[iJij */
{
	uchar *dstp = dst;
	unsigned c, c2;

	while (*src) {
		c = RdMoji(src);
		if (Is1B(c)) {
			c = ANKtoZen2(c, *src, &c2);
			if (c2)
				src++;
		}
		dstp += SetMoji(c, dstp);
	}
	*dstp = 0;
	return dstp - dst;
}

int 
StrZen3(uchar *dst, const uchar *src)
/* pSpɕϊĕRs[i_E_̏Ȃj*/
{
	return StrConv2(dst, src, ANKtoZen);
}

int 
StrHan(uchar *dst, const uchar *src)
/* Sp𔼊p ASCII  (0x20`0x7e) ɕϊĕRs[ */
{
	return StrConv2(dst, src, ZentoASC);
}

int 
StrHan2(uchar *dst, const uchar *src)
/* Sp𔼊p ANK ɕϊĕRs[ */
{
	uchar *dstp = dst;
	unsigned c, c2;

	while (*src) {
		c = ZentoANK2(RdMoji(src), &c2);
		dstp += SetMoji(c, dstp);
		if (c2)
			dstp += SetMoji(c2, dstp);
	}
	*dstp = 0;
	return dstp - dst;
}

int 
StrHan3(uchar *dst, const uchar *src)
/* Sp𔼊p ANK ɕϊĕRs[i_E_̏Ȃj*/
{
	return StrConv2(dst, src, ZentoANK);
}

static unsigned 
XJmstoJis(unsigned c)
{
	if (Is1B(c))
		return c;
	else
		return jmstojis(c);
}
int 
StrJis(uchar *dst, const uchar *src)
/* Vtgihrihrɕϊ */
{
	return StrConv2(dst, src, XJmstoJis);
}



/******************************** StrQuote ********************************/

static uchar esctblf[] = "\f\n\r\t\0" "fnrt";

static int 
StrQuoteSub(uchar *dst, const uchar *src, int n, int wildflag)
/* _uNH[gň͂ <qstring> `ɂB*/
/* Kvɉ \-GXP[vB */
/* ɂĂł镶 ANSI-C  string literal Ƃ݊B */
/* wildflag ^Ȃ SP Ƌ؂蕶ׂĂGXP[vB */
{
	uchar *dstp = dst;
	const uchar *srcp = src;
	const uchar *src_e = src + n;
	uchar *p;

	assert(n >= 0);

	*dstp++ = '"';
	while (srcp < src_e) {
		if (*srcp == '?' && srcp+1 < src_e && *(srcp+1) == '?') {
			dstp += CopyStr(dstp, "\\?\\?");
			srcp += 2;
		} else if (*srcp == '"' || *srcp == '\\' ||
					wildflag && (*srcp == SP || ispunct(*srcp))) {
			*dstp++ = '\\';
			*dstp++ = *srcp++;
		} else if (*srcp && (p = (uchar *)strchr((char *)esctblf, *srcp))) {
			*dstp++ = '\\';
			*dstp++ = *(p + sizeof(esctblf) / 2);
			srcp++;
		} else if (isprkana(*srcp)) {
			*dstp++ = *srcp++;
		} else if (IsKanjiStr(srcp)) {
			*dstp++ = *srcp++;
			*dstp++ = *srcp++;
		} else {
			if (*srcp) {
				sprintf((char *)dstp, "\\x%02x", *srcp);
				dstp += strlen((char *)dstp);
			} else {
				dstp += CopyStr(dstp, "\\0");
			}
			if (++srcp < src_e &&
					(*(srcp-1) ? isxdigit(*srcp) : isdigit(*srcp))) {
				*dstp++ = '"';
				*dstp++ = '"';
			}
		}
	}
	*dstp++ = '"';
	*dstp = 0;
	return dstp - dst;
}


int 
StrQuote(uchar *dst, const uchar *src, int n)
{
	return StrQuoteSub(dst, src, n, 0);
}


int 
StrQuote2(uchar *dst, const uchar *src, int n)
{
	return StrQuoteSub(dst, src, n, 1);
}


/******************************** StrBrace ********************************/

#if 0		/* {c */
int 
StrBrace(uchar *dst, const uchar *src, int n)
/* 𒆊ʂň͂ <fstring> `ɕϊB*/
/* "%"  "%%" ɁA"}"  "%\}" ƂȂǂ̃GXP[v𔺂B */
#if 0
{
	uchar *dstp = dst;
	const uchar *srcp = src;
	const uchar *src_e = src + n;
	uchar *p;

	const uchar *rpos = NULL;

	assert(n >= 0);

	*dstp++ = '{';
	while (srcp < src_e) {
		if (*srcp == '%') {
			srcp++;
			*dstp++ = '%';
			*dstp++ = '%';
		} else if (*srcp == '{') {
			srcp++;
			if (rpos || (rpos = PairSearch(srcp, '{', '}')) != NULL)
				*dstp++ = '{';
			else
				dstp += CopyStr(dstp, "%\\{");
		} else if (*srcp == '}') {
			if (!rpos)
				dstp += CopyStr(dstp, "%\\}");
			else {
				*dstp++ = '}';
				assert(srcp <= rpos);
				if (srcp == rpos)
					rpos = NULL;
			}
			srcp++;
		} else if (*srcp && (p = strchr(esctblf, *srcp))) {
			*dstp++ = '%';
			*dstp++ = '\\';
			*dstp++ = *(p + sizeof(esctblf) / 2);
			srcp++;
		} else if (isprkana(*srcp)) {
			*dstp++ = *srcp++;
		} else if (IsKanjiStr(srcp)) {
			*dstp++ = *srcp++;
			*dstp++ = *srcp++;
		} else {
			int nextisdigit = ++srcp < src_e &&
					(*(srcp-1) ? isxdigit(*srcp) : isdigit(*srcp));

			*dstp++ = '%';
			if (nextisdigit) *dstp++ = '"';

			if (srcp[-1]) {
				sprintf((char *)dstp, "\\x%02x", srcp[-1]);
				dstp += strlen((char *)dstp);
			} else {
				dstp += CopyStr(dstp, "\\0");
			}

			if (nextisdigit) *dstp++ = '"';
		}
	}
	*dstp++ = '}';
	*dstp = 0;
	return dstp - dst;
}
#else	/* Ȍȃo[W */
{
	uchar *dstp = dst;

	dstp += CopyStr(dstp, "{%(");
	dstp += StrQuote(dstp, src, n);
	dstp += CopyStr(dstp, ")}");
	return dstp - dst;
}
#endif
#endif

/**************************** ReadEscSequence *****************************/


int 
ReadEscSequence(uchar *dst, const uchar *src, const uchar **endp)
/* src: <\-sequence2>   -- '\' ̎̕w */
{
	const uchar *srcp = src;
	uchar *dstp = dst;
	const uchar *sp0;
	unsigned c;
	uchar *p;
	static uchar esctbl[] = {
		'a',    'b',    'f',    'n',    'r',    't',
		'v',    'e',    'c',    's',    'q',    'y',  '\000',
		'\007', '\b',   '\f',   '\n',   '\r',   '\t',
		'\v',   '\033', '\034', ' ',    '"',    '\\', '\000'
	};

	assert(nevflag || dst != NULL);
	assert(src != NULL);

	switch (*srcp++) {

	case 'x':
	case 'X':
		/* PUi */
		if (isxdigit(*srcp)) {
			int maxdig = *(srcp-1) == 'X' ? 2 : 4;
			srcp = SkipXDigit(sp0 = srcp);
			if (srcp > sp0 + maxdig)
				srcp = sp0 + maxdig;

			if (!nevflag) {
				CopyStrDiff(dst, sp0, srcp);
				c = (unsigned)strtoul((char *)dst, (char **)NULL, 16);
				if (c < 0x100) {
					*dstp++ = c;
				} else {
					if (!(iskanji(Moji_1(c)) && iskanji2(Moji_2(c)))) {
						/* LShift-JISR[hłȂȂ */
						c = jistojms(c);			/* JISShift-JIS ϊ */
						if (!c && !noerrmode)
							Error("Invalid kanji code: \\x%.*s",
									(int)(srcp-sp0), sp0);
					}
					dstp += SetKanji(c, dstp);
				}
			}
		}
		break;

	case 'o':			/* Wi */
#if 0
	_case_o:
#endif
		c = 8;
		goto _case_d_1;

	case 'd':			/* POi */
	_case_d:
		c = 10;
	_case_d_1:
		if (isdigit(*srcp)) {
			srcp = SkipDigit(sp0 = srcp);
			if (srcp > sp0 + 3)
				srcp = sp0 + 3;
			if (!nevflag) {
				CopyStrDiff(dst, sp0, srcp);
				c = (unsigned)strtoul((char *)dst, (char **)NULL, c);
				*dstp++ = c;
			}
		}
		break;
	case 'z':
	case '\n':
		break;
	case 'S':
		if (!nevflag) {
			dstp += SetKanji(ZENSP, dstp);
		}
		break;
	case '\0':
		--srcp;
		break;
	default:
		--srcp;
		if (isdigit(*srcp)) {
#if 0
			goto _case_o;
#else
			goto _case_d;
#endif
		} else if (*srcp && (p = (uchar *)strchr((char *)esctbl, *srcp))) {
			srcp++;
			if (!nevflag)
				*dstp++ = *(p + sizeof(esctbl) / 2);
		} else {
			unsigned c = RdMoji(srcp);
			if (!nevflag) {
				dstp += SetMoji(c, dstp);
			}
		}
	}
	if (endp) *endp = srcp;
	if (!nevflag) *dstp = 0;
	assert(!nevflag || dstp == dst);
	return dstp - dst;
}


/**************************** ReadString **********************************/

int 
ReadString(uchar *dst, const uchar *src)
{
	return ReadStringB(dst, src, (const uchar **)NULL, EOF);
}

uchar *
SkipStringB(const uchar *p, int brkchr)
{
	int nevflag0 = nevflag;
	int noerrmode0 = noerrmode;
	nevflag = TRUE;
	noerrmode = TRUE;
	ReadStringB((uchar *)NULL, p, &p, brkchr);
	nevflag = nevflag0;
	noerrmode = noerrmode0;
	return (uchar*)p;
}

int 
ReadStringB(uchar *dst, const uchar *src, const uchar **endp, int brkchr)
/*
 * \-sequence t̕A؂蕶 brkchr ̎O܂œǂށB
 * Abrkchr  EOF ȂA̍Ōi'\0'j܂œǂށB
 * brkchr  0 ȂAXy[XW؂蕶ƂB
 * ؂蕶 brkchr NH[g "'"  '"' łȂꍇA
 * rA_uNH[gi'"'j΁Ã_uNH[g܂ŁA
 * ؂蕶𖳎Bi_uNH[ǵÂĂj
 */
{
	uchar *dstp = dst;
	const uchar *srcp = src;
	int  quoteflag = FALSE;
	unsigned c;

	assert(nevflag || dst != NULL);
	assert(src != NULL);

	while (*srcp && (quoteflag ||
					 (brkchr ? *srcp != brkchr : !isspace(*srcp)))) {
		if (*srcp == '"' && brkchr != '\'') {
			srcp++;
			quoteflag = !quoteflag;
		} else if (*srcp == '\\') {
			srcp++;
			dstp += ReadEscSequence(dstp, srcp, &srcp);
		} else {
			c = RdMoji(srcp);
			if (!nevflag)
				dstp += SetMoji(c, dstp);
		}
	}
	if (endp) *endp = srcp;
	if (!nevflag) *dstp = 0;
	assert(!nevflag || dstp == dst);
	return dstp - dst;
}


int 
ReadStringN(uchar *dst, const uchar *src, int n)
{
	uchar *dstp = dst;
	uchar *dp1 = dst;
	const uchar *srcp = src;
	const uchar *src_e = src + n;

	assert(dst != NULL);
	assert(src != NULL);
	assert(n >= 0);

	while (srcp < src_e) {
		dp1 = dstp;
		if (*srcp == '"')
			srcp++;
		else if (*srcp == '\\')
			dstp += ReadEscSequence(dstp, srcp+1, &srcp);
		else
			MoveMojiAdv(dstp, srcp);
	}
	if (srcp > src_e)
		dstp = dp1;
	*dstp = 0;
	return dstp - dst;
}


/**************************************/

unsigned 
StrNthE(const uchar *str, int n)
/*  str  n oCgڂ̕ԂB
 * Aꂪ̂QoCgڂA \ ŃGXP[vĂ镶
 * ꍇ́A0 ԂB
 */
{
	const uchar *p = str+n;

	if (n >= 0 && !NthIsKanji2(str, n)
			   && (n == 0 || *(p-1) != '\\' || StrNthE(str, n-1) != '\\'))
		return Moji(p);
	else
		return 0;
}


/******************************* PairSearch *******************************/

#if 0		/* {c */
uchar *
PairSearch(const uchar *p, int lpar, int rpar)
/* E rpar BÅԂɍ lpar ΁A
 * ΉEʂ̓XLbvB
 * Eʂ΁Aւ̃|C^AȂ NULL ԂB
 * NH[gGXP[v̏͂ȂB
 */
{
	int nestlevel = 1;

	while (*p) {
		if (*p == rpar) {
			if (--nestlevel == 0)
				break;
		} else if (*p == lpar) {
			nestlevel++;
		}
		p = SkipMoji(p);
	}
	if (*p)
		return (uchar*)p;
	else
		return NULL;
}
#endif


/*************************** gݍݕ֐ ***************************/

int 
SubStr(uchar *dst, const uchar *src, int len, int start, int n)
{
	assert(len >= 0);

	if (n < 0) {
		n = 0;
	}
	if (start < 0) {
		start = 0;
	}

	if (NthIsKanji2(src, start))
		--start;
	if (NthIsKanji2(src, start + n))
		--n;
	if (start >= len)
		n = 0;
	else if (n > len - start)
		n = len - start;
	return CopyStrN(dst, src + start, n);
}

int 
BSubStr(uchar *dst, const uchar *src, int len, int start, int n)
{
	assert(len >= 0);

	if (n < 0) {
		n = 0;
	}
	if (start < 0) {
		start = 0;
	}
	if (start >= len)
		n = 0;
	else if (n > len - start)
		n = len - start;
	return CopyStrN(dst, src + start, n);
}

int 
BIndex(const uchar *str1, int len1, const uchar *str2, int len2)
{
	const uchar *p;
	const uchar *endp = str1 + len1 - len2;

	assert(len1 >= 0);
	assert(len2 >= 0);

	if (len2 == 0)
		return 0;
	
	for (p = str1; p <= endp && (p = memchr(p, *str2, endp-p+1)); p++) {
		if (!memcmp(p, str2, len2))
			return (int)(p - str1);
	}
	return -1;
}

int 
StrRep(uchar *dst, const uchar *src, int len, int n)
{
	uchar *dstp = dst;
	assert(len >= 0);
	for ( ; n > 0; n--)
		dstp += CopyStrN(dstp, src, len);
	return dstp - dst;
}

int 
StrFil(uchar *dst, const uchar *src, int len, int n)
{
	uchar *dstp = dst;
	assert(len >= 0);

	if (n < 0) n = 0;

	if (len == 0) {
		memset(dst, SP, n);
	} else {
		while (dstp - dst < n)
			dstp += CopyStrN(dstp, src, len);
		if (dstp - dst > n) {
			if (NthIsKanji2(dst, n))
				--n;
		}
	}
	dst[n] = '\0';
	return n;
}

int 
StrCommaNum(uchar *dst, const uchar *src, int len,
	    const uchar *comma, int commalen, int n)
{
	uchar *dstp = dst;
	const uchar *srcp = src;
	int klen = nokanjimode ? len : btom((const char *)src, len);
	int i;

	if (!comma) {
		comma = ",";
		commalen = 1;
	}
	if (n == 0)
		n = INT_MAX;

	MoveMojiAdv(dstp, srcp);			/* n߂̕Rs[ */
	for (i = 1; i < klen; i++) {
		if ((n < 0 ? i % -n : (klen - i) % n) == 0)
			dstp += CopyStrN(dstp, comma, commalen);	/* comma  */
		MoveMojiAdv(dstp, srcp);
	}
	*dstp = 0;
	return dstp - dst;
}

static uchar kansuujis[] = "ZOlܘZ";

#define NAKAGURO		0x8145		/* 'E' */
#define TOUTEN			0x8141		/* 'A' */

int 
StrKanjiNum(uchar *dst, const uchar *src, int len)
{
	uchar *dstp = dst;
	const uchar *srcp = src;
	const uchar *src_e = src + len;
	unsigned c;
	unsigned a;
	
	while (srcp < src_e) {
		c = RdMoji(srcp);
		if (Is1B(c))
			a = c;
		else
			a = ZentoASC(c);
		if (Isdigit(a)) {
			/* ɕϊ */
			uchar *p = kansuujis + (a - '0') * 2;
			c = Moji(p);
		} else if (a == ',') {
			/* ؂̃R} 'A' ɕϊ */
			c = TOUTEN;
		} else if (a == '.') {
			/* _ 'E' ɕϊ */
			c = NAKAGURO;
		}
		dstp += SetMoji(c, dstp);
	}
	*dstp = 0;
	return dstp - dst;
}

#undef TOLOWER
#undef TOUPPER

int
TOLOWER(int c)
{
	return isupper(c) ? tolower(c) : c ;
}

int
TOUPPER(int c)
{
	return islower(c) ? toupper(c) : c ;
}
/**************************************/

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
