/* xmacro.c */
/*****************************************************************************
					s@o@wsq

						m}NR}hEϐ̏n
*****************************************************************************/

#include "xtr.h"


/*************************** User variable ****************************/

/* ϐ var [JŗL蓾邩 */
#define IsLocalVar(var)		(islower(*(var)) || *(var) == '$')

uchar *
GetVar(const uchar *name, int *lenp)
/* ϐ̒loB`ȂA󕶎Ԃ */
/* NULL łȂ lenp ^ꂽAɒi[ */
{
	var_t  *p;

	assert(name != NULL);

	p = IsLocalVar(name) ? localvarlist : varlist;
	while (p) {
		if (equ(name, p->name)) {
			if (lenp)
				*lenp = p->len;
			return p->val;
		}
		p = p->prev;
	}
	if (lenp) *lenp = 0;
	return "";
}


void 
PutVar(const uchar *name, const uchar *val, int len)
/* ϐ name ɒl val  */
/* Aval  NULL ܂ len  0 ȂAϐ폜 */
{
	int islocalvar = IsLocalVar(name);

	var_t  **pp;
	var_t  *p;

	assert(name != NULL);
	
	if (len == 0)
		val = NULL;

	pp = islocalvar ? &localvarlist : &varlist;
	p = *pp;
	while (p) {
		if (equ(name, p->name)) {
			if (val) {
				/* l̕tւ */
				XFree((voidstar)p->val);
				p->val = DupStrN(val, len);
				p->len = len;
			} else {
				/* 폜 */
				*pp = p->prev;
				XFree((voidstar)p->name);
				XFree((voidstar)p->val);
				XFree((voidstar)p);
			}
			return;
		}
		pp = &p->prev;
		p = *pp;
	}
	
	/* `ϐȂ */
	pp = islocalvar ? &localvarlist : &varlist;
	if (val) {
		p = (var_t *)XMalloc(sizeof(var_t));
		p->name = DupStr(name);
		p->val = DupStrN(val, len);
		p->len = len;
		p->prev = *pp;
		*pp = p;
	}
}


/************************ Macro command processing ************************/

/* }NAwhile[vAubN甲邩炭 */
static enum BREAK_LEVEL {
	B_RETURN = -1,
	B_NOBREAK,
	B_CONTINUE,
	B_BREAK,
} break_level;

int 
CopyArg(uchar *dst, int n)
{
	if (n < 0)
		n = margc + n + 1;
	
	if (margv && n <= margc) {
		return CopyStrN(dst, margv[n].s, margv[n].len);
	} else {
		*dst = 0;
		return 0;
	}
}


/**************************************/

static void Cmd_if(const uchar *argp);
static void Cmd_while(const uchar *argp);
static void Cmd_for(const uchar *argp);
static void Cmd_break(const uchar *argp);
static void Cmd_continue(const uchar *argp);
static void Cmd_return(const uchar *argp);

typedef void (*cmdfnp_t)(const uchar *argp);

static struct SYSCMDTBL {
	uchar *name;
	cmdfnp_t fnp;
} syscmdtbl[] = {
	{"if",			Cmd_if},
	{"while",		Cmd_while},
	{"for",			Cmd_for},
	{"break",		Cmd_break},
	{"continue",	Cmd_continue},
	{"return",		Cmd_return},
};

#define N_SYSCMD		  (sizeof(syscmdtbl) / sizeof(syscmdtbl[0]))

#define MkSysCmdMacp(i)		((macro_t *)(ulong)((i)+1))
#define IsSysCmdMacp(p)		((ulong)(p) <= (ulong)N_SYSCMD)
#define SysCmdFnp(macp)		(syscmdtbl[(int)(long)(macp)-1].fnp)
#define SysCmdName(macp)		(syscmdtbl[(int)(long)(macp)-1].name)

/**************************************/

macro_t *
GetMacro(const uchar *name)
/* }N`o */
{
	macro_t  *p = macrolist;
	int  i;

	assert(name != NULL);

	while (p) {
		if (equ(name, p->name)) {
			return p;
		}
		p = p->prev;
	}
	for (i = 0; i < N_SYSCMD; i++) {
		if (equ(syscmdtbl[i].name, name))
			return MkSysCmdMacp(i);
	}
	return NULL;
}


/**************************************************************************/


void 
FreeMargv(int argc, marg_t *argv)
{
	int i;
	for (i = argc; i >= 0; --i)
		XFree((voidstar)argv[i].s);
	XFree((voidstar)argv);
}


#define IsEvalArg(arg)	(*(arg)=='(' || *(arg)=='{')

static uchar *
MakeBlockArg(int *lenp, uchar **nextp)
{
	int	bufsize = 1024;
	uchar *buf = (uchar *)XMalloc(bufsize);
	uchar *bp = buf;
	uchar *cmdln;
	uchar *p;
	int len = 0;
	unsigned c;
	assert(lenp != NULL);
	assert(nextp != NULL);

	for ( ; ; ) {
		c = GetChr();
		if (c == EOF2) {
			*nextp = NULL;
			break;
		}
		if ((int)c == cmddot_mchar || cmddot_char && (int)c == cmddot_char) {
			cmdln = GetCommandLine(&len);
			if (CheckBlockEnd(cmdln, len, FALSE, (const uchar **)&p)) {
				CutSpace(p);
				*nextp = *p ? DupStrDiff(p, cmdln + len) : NULL;
				XFree((voidstar)cmdln);
				break;
			}
			if (bp + (len+2) - buf >= bufsize) {
				uchar *buf2 = (uchar *)XRealloc((voidstar)buf, bufsize += len + 1024);
				bp = buf2 + (bp - buf);
				buf = buf2;
			}
			*bp++ = cmddot_mchar;
			bp += CopyStrN(bp, cmdln, len);
			*bp++ = '\n';
			*bp = '\0';
			XFree((voidstar)cmdln);
		} else {
			UngetChr(c);
			len = GetLine();
			if (bp + len - buf >= bufsize) {
				uchar *buf2 = (uchar *)XRealloc((voidstar)buf, bufsize += len + 1024);
				bp = buf2 + (bp - buf);
				buf = buf2;
			}
			bp += CopyStrN(bp, ibuf, len);
		}
		ILineNoCount();
	}
	*lenp = bp - buf;
	return (uchar *)XRealloc((voidstar)buf, (bp - buf) + 1);
}


/**************************************/

#if UNIX
#define ERROR_SS(fmt,n,s)												\
	do {																\
		uchar *_n, *_s;													\
		_n = (uchar *)alloca(strlen((char *)(n)) * 2 + 1);				\
		sjis2mbstring((char *)_n, (char *)(n));							\
		_s = (uchar *)alloca(strlen((char *)(s)) * 2 + 1);				\
		sjis2mbstring((char *)_s, (char *)(s));							\
		Error((fmt), _n, _s);											\
	} while (0)
#endif

/* mfflag ̒l */
#define M_COMMAND		0
#define M_FUNCTION		1
#define M_SYSCMD		2

static const uchar *macname = NULL;		/* }NLiG[\pj */

static marg_t *
MakeMargv(int *argcp, const uchar *argp, matype_t typ, int maxargc, int mfflag)
/* R}hxN^쐬 */
{
	marg_t argvb[MAXMARGC+1];
	marg_t *newargv;
	int  argc = 0;
	const uchar *p = NULL;
	const uchar *p0;
	const uchar *p1;
	uchar *bp = NULL;
	int len;
	uchar *nextbuf = NULL;
	const uchar *mname = macname ? macname : (uchar *)"";

	assert(argcp != NULL);
	assert(argp != NULL);
	assert(maxargc <= MAXMARGC);

	CutSpace(argp);
	argvb[0].len = len = strlen((const char *)argp);
	argvb[0].s = DupStrN(argp, len);
	argvb[0].typ = MA_VERBATIM;

	if (maxargc >= 0) {
		p = argp;
		while (*p && argc < MAXMARGC) {
			argc++;
			p1 = p0 = p;
			if (mfflag == M_FUNCTION || typ == MA_EXPR) {
				/* R}؂̏ꍇ */
				while (*p && *p != ',') {
					p = SkipSpace(p1 = SkipExpr(p, EXPR_SEMIMAX, SKIP_ELSE1));
				}
				if (*p == ',')
					p = SkipSpace(p+1);
			} else if (typ == MA_FSTRING) {
				p = p1 = StrEnd(p0);
			} else {
				p1 = SkipCommandArg(p0);
				p = SkipSpace(p1);
			}
			if (!*p && mfflag != M_FUNCTION && StrNthE(p0, p1-p0-1) == '{') {
				if (p1 - p0 != 1) {
					p = --p1;
					p1 = BackSkipSpace(p0, p1);
				} else {
					p = p0 = p1 = NULL;
					XFree((voidstar)nextbuf);
					bp = MakeBlockArg(&len, &nextbuf);
					if (typ == MA_FSTRING || typ == MA_AUTO) {
						argvb[argc].s = AEvalStringN(&len, bp, len);
						argvb[argc].len = len;
						argvb[argc].typ = MA_FBLOCK;
						XFree((voidstar)bp);
					} else {
						argvb[argc].s = bp;
						argvb[argc].len = len;
						argvb[argc].typ = MA_VBLOCK;
					}
					if (!nextbuf)
						break;

					p = (const uchar *)nextbuf;
					continue;
				}
			} else if (mfflag == M_SYSCMD) {
				/* `̈̏ꍇ́AXy[XJbgȂ */
				p1 = p;
			}
			bp = DupStrN(p0, (len = p1 - p0));
			if (typ == MA_VERBATIM) {
				argvb[argc].s = bp;
				argvb[argc].len = len;
				argvb[argc].typ = MA_VERBATIM;
			} else if (typ == MA_EXPR || mfflag == M_FUNCTION || 
										typ == MA_AUTO && IsEvalArg(bp)) {
				argvb[argc].s = AEvalExprStr(&len, bp);
				argvb[argc].len = len;
				argvb[argc].typ = MA_EXPR;
				XFree((voidstar)bp);
			} else if (typ == MA_FSTRING) {
				argvb[argc].s = AEvalStringN(&len, bp, len);
				argvb[argc].len = len;
				argvb[argc].typ = MA_FSTRING;
				XFree((voidstar)bp);
			} else {
				argvb[argc].s = AReadString(&len, bp);
				argvb[argc].len = len;
				argvb[argc].typ = MA_QSTRING;
				XFree((voidstar)bp);
			}
		}
	}

	if (maxargc >= 0 && argc > maxargc) {
#if UNIX
		ERROR_SS((const uchar *)(mfflag == M_FUNCTION ? "Too many arguments: %s(%s)"
														: "Too many arguments: %s %s"),
				 mname, argp);
#else
		Error((const uchar *)(mfflag == M_FUNCTION ? "Too many arguments: %s(%s)"
												   : "Too many arguments: %s %s"),
							mname, argp);
#endif
	} else if (p ? *SkipSpace(p)
				 : maxargc < 0 && StrNthE(argp, len-1) == '{') {
#if UNIX
		ERROR_SS("Invalid argument: %s %s", mname, argp);
#else
		Error("Invalid argument: %s %s", mname, argp);
#endif
	}

	XFree((voidstar)nextbuf);

	newargv = (marg_t*)XMalloc((argc+1) * sizeof(marg_t));
	memcpy(newargv, argvb, (argc+1) * sizeof(marg_t));
	*argcp = argc;
	return newargv;
}

static void 
FreeVarList(var_t *p)
{
	var_t *p1;

	while (p) {
		p1 = p;
		p = p->prev;
		XFree((voidstar)p1->name);
		XFree((voidstar)p1->val);
		XFree((voidstar)p1);
	}
}


/**************************************/

#define ArgEqu(a, str)	((a).typ == MA_VERBATIM && \
									ArgEqu2((a).s, (str)))
static int
ArgEqu2(const uchar *p, const uchar *name)
{
	uchar s[128];
	CopyStr(s, p);
	RTrimSpace(s);
	return equ(s, name);
}

#define ArgIsElse(a)	ArgEqu(a, "else")
#define ArgIsIf(a)		ArgEqu(a, "if")


static int 
DoArgCommand(marg_t *arg, int restargs)
{
	uchar *buf = (uchar *)XMalloc(evalbufsize);
	uchar *p = buf;
	int if_else_nest = 0;
	int argcnt = 0;

	restargs++;

	while (restargs > 0 && arg->typ == MA_VERBATIM) {
		if (ArgIsIf(*arg))
			if_else_nest++;
		else if (ArgIsElse(*arg)) {
			if (if_else_nest == 0)
				break;
			else
				--if_else_nest;
		}
		
		p += CopyStrN(p, arg->s, arg->len);
		arg++;
		restargs--;
		argcnt++;
	}
	buf = (uchar *)XRealloc((voidstar)buf, (p - buf) + 1);
	Command(buf);
	XFree((voidstar)buf);
	return argcnt;
}

static int 
DoArg(marg_t *arg, int restargs)
{
	int argcnt;

	break_level = B_NOBREAK;

	if (arg->typ == MA_VBLOCK || arg->typ == MA_FBLOCK) {
		int solflag0 = solflag;
		int sol2flag0 = sol2flag;

		solflag = sol2flag = TRUE;
		DoText(arg->s, arg->len);

		solflag = solflag0;
		sol2flag = sol2flag0;
		return 1;
	} else if (arg->typ == MA_VERBATIM &&
				(argcnt = DoArgCommand(arg, restargs))) {
		return argcnt;
	} else {
		assert(FALSE);
		return 1;
	}
}

/**************************************/

/* break ȂǂΊÕubN悤 */
#define BreakThrow()													\
    do {																\
		if (break_level != B_NOBREAK && inmtextflag)					\
			sbufp = SBUFBTM;											\
	} while (0)

#if UNIX
#define StatementErr(cmd, args)		ERROR_SS("Invalid statement: %s %s", cmd, args)
#else
#define StatementErr(cmd, args)		Error(f_StatementErr, cmd, args)
static uchar f_StatementErr[] = "Invalid statement: %s %s";
#endif

static void 
Cmd_if(const uchar *argp)
/*
 * if (<expr>) {<cmd>}* { else if (<expr>) {<cmd>}* }* [ else {<cmd>}* ]
 */
{
	marg_t *argv;
	int argc;
	int i = 1;
	int cond = 0;
	int else_if_flag = FALSE;
	
	argv = MakeMargv(&argc, argp, MA_VERBATIM, MAXMARGC, M_SYSCMD);
	
	do {
		if (argc <= i || *argv[i].s != '(')
			StatementErr("if", argv[0].s);
		cond = EvalExprVal(argv[i].s, (const uchar **)NULL, EXPR_PRIM) != 0;
		i++;

		while (i <= argc && !ArgIsElse(argv[i])) {
			if (cond)
				i += DoArg(&argv[i], argc-i);
			else
				i++;
			if (break_level != B_NOBREAK)
				goto _if_end;
		}
		if (!cond && i <= argc && (++i, ArgIsIf(argv[i]))) {
			/* else ̒オ if ̂Ƃ */
			else_if_flag = TRUE;
			i++;
		} else
			else_if_flag = FALSE;
	} while (else_if_flag);

	/* else-part */
	if (!cond) {
		while (break_level == B_NOBREAK && i <= argc) {
			i += DoArg(&argv[i], argc-i);
		}
	}
_if_end:
	BreakThrow();
	FreeMargv(argc, argv);
}

#define CheckNoArg(argp,name)											\
    do {																\
		if (!(!*CutSpace(argp) || *(argp) == ';'))						\
			StatementErr(name, argp);									\
	} while (0)

static void 
Cmd_break(const uchar *argp)
/*
 * break
 */
{
	CheckNoArg(argp, "break");

	break_level = B_BREAK;			/* [vI邽߂̃tOZbg */
	if (inmtextflag)
		sbufp = SBUFBTM;			/* ubNsI点 */
}

static void 
Cmd_continue(const uchar *argp)
/*
 * continue
 */
{
	CheckNoArg(argp, "continue");

	break_level = B_CONTINUE;		/* [v̍ŌɒԂ߂̃tOZbg */
	if (inmtextflag)
		sbufp = SBUFBTM;			/* ubNsI点 */
}


static void 
Cmd_return(const uchar *argp)
/*
 * return  [ <expr> ]
 */
{
	EvalReturnExpr(argp, EXPR_MAX);
	break_level = B_RETURN;
	if (inmtextflag)
		sbufp = SBUFBTM;			/* ubNsI点 */
}


static void 
Cmd_while_for_Sub(const uchar *argp, int is_for)
{
	marg_t *argv;
	int argc;
	int i = 0;
	const uchar *test_expr = NULL;
	const uchar *incr_expr = NULL;

	argv = MakeMargv(&argc, argp, MA_VERBATIM, MAXMARGC, M_SYSCMD);

	if (argc >= 1 && *argv[1].s == '(') {
		if (is_for) {
			const uchar *p = argv[1].s + 1;
			p = SkipExpr(p, EXPR_MAX, SKIP_NORMAL);
			if (*CutSpace(p) == ';') {
				p++;
				if (*CutSpace(p) != ';') {
					test_expr = p;
					p = SkipExpr(p, EXPR_MAX, SKIP_NORMAL);
					CutSpace(p);
				}
				if (*p == ';') {
					p++;
					if (*CutSpace(p) != ')') {
						incr_expr = p;
						p = SkipExpr(p, EXPR_MAX, SKIP_NORMAL);
						incr_expr = DupStrDiff(incr_expr, p);
						CutSpace(p);
					}
					if (*p == ')' && !*SkipSpace(p+1))
						i++;
				}
			}
		} else {
			test_expr = argv[1].s;
			i++;
		}
	}
	if (i == 0)
		StatementErr(is_for ? "for" : "while", argv[0].s);

	break_level = B_NOBREAK;

	if (is_for) {
		EvalExprVal(argv[1].s + 1, (const uchar **)NULL, EXPR_MAX);
	}

	while ((break_level == B_NOBREAK || break_level == B_CONTINUE) &&
				(!test_expr || EvalExprVal(test_expr, (const uchar **)NULL, 
								is_for ? EXPR_MAX : EXPR_PRIM) != 0)) {
		for (i = 2; i <= argc;) {
			i += DoArg(&argv[i], argc-i);
			if (break_level != B_NOBREAK)
				break;
		}
		if (incr_expr && (break_level==B_NOBREAK || break_level==B_CONTINUE)) {
			EvalExprVal(incr_expr, (const uchar **)NULL, EXPR_MAX);
		}
#if MSDOS || WINNT || __human68k__
		/* [vɂĂ ^C 荞݂Œfł悤 */
		(void)kbhit();
#endif
	}

	if (break_level != B_RETURN)
		break_level = B_NOBREAK;

	XFree((voidstar)incr_expr);
	FreeMargv(argc, argv);
}

static void 
Cmd_while(const uchar *argp)
/*
 * while <expr> {<cmd>}*
 */
{
	Cmd_while_for_Sub(argp, 0);
}

static void 
Cmd_for(const uchar *argp)
/*
 * for (<expr>;<expr>;<expr>) {<cmd>}*
 */
{
	Cmd_while_for_Sub(argp, 1);
}

/**************************************/

static void 
BindArgs(const uchar *pvars)
/*
 * pvars: ['@'] {<var>}*
 */
{
	int i;
	uchar *buf;
	uchar *p;
	uchar *name;
	
	if (!pvars || !*pvars)
		return;
	
	if (*pvars == '@') {
		i = 0;
		pvars++;
	} else {
		i = 1;
	}
	p = buf = DupStr(pvars);
	while (*p && i <= margc) {
		name = p;
		p = SkipKSym2(p);
		if (*p) *p++ = '\0';
		PutVar(name, margv[i].s, margv[i].len);
		i++;
		CutSpace(p);
	}
	XFree((voidstar)buf);
}


/**************************************/


#define NeedNewLocalVarEnv(mp)		((mp)->pvars==NULL || *((mp)->pvars)!='!')

static void 
CallMacro(macro_t *macp, const uchar *argp, int mfflag)
{
	marg_t *margv0 = margv;
	int margc0 = margc;
	marg_t *newmargv = NULL;
	int newmargc = 0;
	var_t *localvarlist0;

	macname = macp->name;			/* G[\pɖOL */

	newmargv = MakeMargv(&newmargc, argp, macp->matyp, macp->maxargc, mfflag);
	margv = newmargv;
	margc = newmargc;

	localvarlist0 = localvarlist;

	if (NeedNewLocalVarEnv(macp)) {
		localvarlist = NULL;
		BindArgs(macp->pvars);
	}

	ClearRetValue();

	DoArg(&macp->body, 0);

	if (NeedNewLocalVarEnv(macp)) {
		FreeVarList(localvarlist);
		localvarlist = localvarlist0;
	}
	FreeMargv(margc, margv);
	margv = margv0;
	margc = margc0;
	macname = NULL;
}

/****************************** MacroCommand ******************************/

int 
MacroCommand(const uchar *cmd)
{
	const uchar *argp;
	uchar *p;
	macro_t *macp = NULL;

	if (!IsKSym1Str(cmd))
		return FALSE;

	argp = SkipKSym2(cmd);

	if (IsFuncArgStr(argp))
		return FALSE;

	p = DupStrDiff(cmd, argp);
	macp = GetMacro(p);
	XFree((voidstar)p);

	if (macp) {
		if (IsSysCmdMacp(macp)) {
			/* VXeR}h */
			macname = SysCmdName(macp);
			(SysCmdFnp(macp))(argp);
			macname = NULL;
		} else {
			CallMacro(macp, argp, M_COMMAND);
		}
		return TRUE;
	} else {
		/* łȂȂ */
		return FALSE;
	}
}


/***************************** FuncMacroCall ******************************/

int 
FuncMacroCall(uchar *dst, macro_t *macp, const uchar *args)
{
	assert(dst != NULL);
	assert(macp != NULL);
	assert(args != NULL);

	if (IsSysCmdMacp(macp)) {
		/* VXeR}h֐ƂČĂяoƂ͋Ȃ */
#if UNIX
		ERROR_SS("Illegal function: %s(%s)", SysCmdName(macp), args);
#else
		Error("Illegal function: %s(%s)", SysCmdName(macp), args);
#endif
	} else {
		CallMacro(macp, args, M_FUNCTION);
	}
	return CopyStrN(dst, retvalue.s, retvalue.len);
}

/***************************** DefineCommand ******************************/

static void 
PutMacro(const uchar *name, const marg_t *body, matype_t matyp,
	 int maxargc, const uchar *pvars)
{
	macro_t  **pp;
	macro_t  *p;
	
	assert(name != NULL);
	
	pp = &macrolist;
	p = *pp;
	while (p) {
		if (equ(name, p->name)) {
			if (body) {
				/* l̕tւ */
				XFree((voidstar)p->body.s);
				XFree((voidstar)p->pvars);
				p->body.s = DupStrN(body->s, body->len);
				p->body.len = body->len;
				p->body.typ = body->typ;
				p->maxargc = maxargc;
				p->matyp = matyp;
				p->pvars = DupStr(pvars);
			} else {
				/* 폜 */
				*pp = p->prev;
				XFree((voidstar)p->name);
				XFree((voidstar)p->body.s);
				XFree((voidstar)p->pvars);
				XFree((voidstar)p);
			}
			return;
		}
		pp = &p->prev;
		p = *pp;
	}
	
	/* `Ȃ */
	pp = &macrolist;
	if (body) {
		p = (macro_t *)XMalloc(sizeof(macro_t));
		p->name = DupStr(name);
		p->body.s = DupStrN(body->s, body->len);
		p->body.len = body->len;
		p->body.typ = body->typ;
		p->maxargc = maxargc;
		p->matyp = matyp;
		p->pvars = DupStr(pvars);
		p->prev = *pp;
		*pp = p;
	}
}


#if UNIX
#define DefErr()														\
	do {																\
		uchar *mbs = (uchar *)alloca(strlen((char *)src) * 2 + 1);		\
		sjis2mbstring((char *)mbs, (char *)src);						\
		Error("Invalid definition: ##%s", mbs);							\
	} while (0)
#else
#define DefErr()		Error(f_DefErr, src)
static uchar f_DefErr[] = "Invalid definition: ##%s";
#endif


void 
DefineCommand(const uchar *src)
/*
 * '##' <name>										-- `̍폜
 * '##' <name> <def-body>							-- Ȃ֐`
 * '##' <name> <param-list> <def-body>				-- t֐`
 *
 * <param-list>:
 *  '(' ['!' | ':' | '&' | '^' | '#'] 
 *      ['@' <var> [',']] {<var> [',']}* [<num> | '*'] ')'
 */
{
	const uchar *argp;
	uchar *name;
	marg_t *argv;
	int argc;
	matype_t matyp = MA_NOARG;
	int maxargc = -1;
	marg_t *body = NULL;
	uchar *pvars = NULL;

	CutSpace(src);
	if (!IsKSym1Str(src))
		DefErr();

	argp = SkipKSym2(src);
	name = DupStrDiff(src, argp);
	CutSpace(argp);

	argv = MakeMargv(&argc, argp, MA_VERBATIM, MAXMARGC, M_COMMAND);

	if (argc < 0 || argc == 2 && *argv[1].s != '(' || argc > 2)
		DefErr();
	
	if (argc == 0) {
		/* `̍폜 */
		body = NULL;
	} else if (argc == 1) {
		/* Ȃ */
		body = &argv[1];
		maxargc = 0;
	} else {
		/*  */
		uchar *dst = (uchar *)XMalloc(argv[1].len+1);
		uchar *dstp = dst;
		uchar *srcp = argv[1].s;
		uchar *sp1 = srcp;
		int varc = 0;
		int nobindflag = 0;
		
		assert(*srcp == '(');
		srcp++;
		while (*CutSpace(srcp) != ')') {
			if (varc == 0 && *srcp == '@') {
				srcp = SkipSpace(srcp+1);
				if (IsKSym1Str(srcp)) {
					srcp = SkipKSym2(sp1 = srcp);
					*dstp++ = '@';
					dstp += CopyStrDiff(dstp, sp1, srcp);
					*dstp++ = ' ';
				}
			} else if (IsKSym1Str(srcp)) {
				varc++;
				srcp = SkipKSym2(sp1 = srcp);
				dstp += CopyStrDiff(dstp, sp1, srcp);
				*dstp++ = ' ';
			} else if (*srcp == '!') {
				nobindflag++;
				srcp++;
			} else if (*srcp == ':') {
				matyp = MA_VERBATIM;
				srcp++;
			} else if (*srcp == '&') {
				matyp = MA_FSTRING;
				srcp++;
			} else if (*srcp == '^') {
				matyp = MA_QSTRING;
				srcp++;
			} else if (*srcp == '#') {
				matyp = MA_EXPR;
				srcp++;
			} else if (*srcp == '*') {
				maxargc = MAXMARGC;
				srcp++;
			} else if (isdigit(*srcp)) {
				maxargc = RdNum(srcp, (const uchar **)&srcp);
			} else {
				DefErr();
			}
			if (*CutSpace(srcp) == ',')
				srcp++;
		}
		if (maxargc == -1 && varc)
			maxargc = varc;

		if (matyp == MA_NOARG)
			matyp = MA_AUTO;

		if (dstp > dst && *(dstp-1) == ' ')
			--dstp;

		if (nobindflag) {
			if (dst != dstp)
				DefErr();
			*dstp++ = '!';					/* ϐȂ̈ */
		}

		*dstp = '\0';
		pvars = dst;
		body = &argv[2];
	}
	PutMacro(name, body, matyp, maxargc, pvars);
	XFree((voidstar)pvars);
	FreeMargv(argc, argv);
	XFree((voidstar)name);
}


/********************************* DoText *********************************/

void 
DoText(const uchar *src, int len)
{
	int inmtextflag0 = inmtextflag;
	uchar *sbufp0 = sbufp;
	uchar *sbufp2 = NULL;			/* \[XeLXgobt@eۑ */
	jmp_buf	errorjb0;

	memcpy(errorjb0, errorjb, sizeof(jmp_buf));

	if (setjmp(errorjb) == 0) {
		if (sbufp != SBUFBTM) {
			/* \[XeLXgobt@łȂ */
			sbufp2 = DupStrDiff(sbufp, SBUFBTM);	/* Rs[ */
			sbufp = SBUFBTM;						/* NA */
		}
		UngetN(src, len);
		inmtextflag = TRUE;
		Trans1();

		if (cc == EOF2)
			cc = prevc;

	} else {
		/* G[Œł */
		break_level = B_RETURN;						/* }N甲 */
	}
	inmtextflag = inmtextflag0;

	if (sbufp2) {
		/* Õ\[XeLXgobt@eLĂȂ */
		sbufp = sbufp0;
		memcpy(sbufp, sbufp2, SBUFBTM - sbufp);		/*  */
		XFree((voidstar)sbufp2);
	}
	/* ÕG[߂ꏊɖ߂ */
	memcpy(errorjb, errorjb0, sizeof(jmp_buf));
}

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
