/* xalloc.c */
/*****************************************************************************
					s@o@wsq

							mAP[gn
*****************************************************************************/

#include "xtr.h"

#ifdef __TURBOC__
 #pragma option -N			/* ON: Check stack overflow */
#endif

#if defined(_MSC_VER)
 #pragma check_stack(on)
#endif

static void 
MemErr(void)
/* ubNlłȂ */
{
	FError("Memory over");
}


voidstar
XMalloc(size_t len)
{
	uchar *p;
	if ((p = (uchar *)malloc(len)) == NULL)
		MemErr();

#ifndef NDEBUG
	if (debug & 2) {
#ifdef UNIX
		Message(" Malloc: %08lx %5lu\n", p, (unsigned long)len);
#else
		Message(" Malloc: %9Fp %5lu\n", (void FAR*)p, (long)len);
#endif
	}
#endif
	return (voidstar)p;
}

void 
XFree(voidstar p)
{
	if (p == NULL)
		return;

#ifndef NDEBUG
	if (debug & 2) {
#ifdef UNIX
		Message("   Free: %08lx\n", p);
#else
		Message("   Free: %9Fp\n", (void FAR*)p);
#endif
	}
#endif

#if defined(__TURBOC__) && !defined(NDEBUG)
	if (debug & 1) {
		switch (heapchecknode(p)) {
		case _HEAPEMPTY:
			FError("Free: Heap empty");
			break;
		case _HEAPCORRUPT:
			FError("Free: Heap corrupt");
			break;
		case _BADNODE:
			FError("Free: Bad node (%9Fp)", (void FAR*)p);
			break;
		case _FREEENTRY:
			FError("Free: Free entry (%9Fp)", (void FAR*)p);
			break;
		case _USEDENTRY:
			;									/* OK */
			break;
		default:
			assert(FALSE);
		}
	}
#endif

	free(p);
}

voidstar
XRealloc(voidstar p, size_t len)
{
	uchar *newp;

	if (p == NULL)
		return NULL;

#if defined(__TURBOC__) && !defined(NDEBUG)
	if (debug & 1) {
		switch (heapchecknode(p)) {
		case _HEAPEMPTY:
			FError("Realloc: Heap empty");
			break;
		case _HEAPCORRUPT:
			FError("Realloc: Heap corrupt");
			break;
		case _BADNODE:
			FError("Realloc: Bad node (%9Fp)", (void FAR*)p);
			break;
		case _FREEENTRY:
			FError("Realloc: Free entry (%9Fp)", (void FAR*)p);
			break;
		case _USEDENTRY:
			;									/* OK */
			break;
		default:
			assert(FALSE);
		}
	}
#endif

	if ((newp = (uchar*)realloc(p, len)) == NULL)
		MemErr();

#ifndef NDEBUG
	if (debug & 2) {
#ifdef UNIX
		if (newp == p)
			Message("Realloc: %08lx %5lu\n", p, (unsigned long)len);
		else 
			Message("Realloc: %08lx %5lu %08lx\n", p, (unsigned long)len, newp);
#else
		if (newp == p)
			Message("Realloc: %9Fp %5lu\n", (void FAR*)p, (long)len);
		else 
			Message("Realloc: %9Fp %5lu %9Fp\n",
				(void FAR*)p, (long)len, (void FAR*)newp);
#endif
	}
#endif
	return (voidstar)newp;
}


void 
AllocEnd(void)
{
#if defined(__TURBOC__) && !defined(NDEBUG)
	if (debug & 4) {
		struct heapinfo hi;
		uchar buf[120];

		hi.ptr = NULL;
		Message("\n Address   Length  Status\n"
		          "---------  ------  ------\n");
		while (heapwalk(&hi) == _HEAPOK) {
			buf[0] = '\0';
			if (hi.in_use) {
				int over = hi.size - 4 > 24;
				int len = over ? 24 : hi.size - 4;
				StrQuote(buf, (uchar*)hi.ptr, len);
				if (over)
					strcat(buf, "...");
			}
			Message("%9Fp  %5lu    %s %s\n",
				(void FAR *)hi.ptr,
				(long)(hi.size - 4), hi.in_use ? "used" : "free",
				buf
				);
		}
	}
#endif
}

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
