/* replace.c */
/*****************************************************************************
					s@o@wsq

							mun
*****************************************************************************/

#include "xtr.h"

/**************************************************************************/

#ifdef __TURBOC__
 #pragma option -N			/* ON: Check stack overflow */
#endif

#if defined(_MSC_VER)
 #pragma check_stack(on)
#endif

/**************************************************************************/

static void
SetAttrib(def_t *cntrl, uchar *rpl, int len, unsigned rmode)
{
	uchar *rpl0 = cntrl->rpl;
	int  len0 = cntrl->rpllen;
	unsigned  rmode0 = cntrl->mode;

	cntrl->rpl = rpl;				/* %-ϊ̏ꍇ̂ */
	cntrl->rpllen = len;
	cntrl->mode = rmode;

	if (cntrl->cmode != C_RESET && cntrl->cmode != C_RESET2) {
		c_attr = RemCntrl(c_attr, cntrl);
		c_wide = RemCntrl(c_wide, cntrl);
		c_vexpand = RemCntrl(c_vexpand, cntrl);
		c_qexpand = RemCntrl(c_qexpand, cntrl);
		c_half = RemCntrl(c_half, cntrl);
		c_font = RemCntrl(c_font, cntrl);
	}
	switch (cntrl->cmode) {
	case C_ATTR:
		c_attr = AddCntrl(c_attr, cntrl);
		break;
	case C_WIDE:
		c_wide = AddCntrl(c_wide, cntrl);
		wexpflag = ON;
		break;
	case C_VEXPAND:
		c_vexpand = AddCntrl(c_vexpand, cntrl);
		vexpflag = ON;
		break;
	case C_QEXPAND:
		c_qexpand = AddCntrl(c_qexpand, cntrl);
		wexpflag = vexpflag = ON;
		break;
	case C_HALF:
		c_half = AddCntrl(c_half, cntrl);
		wexpflag = ON;
		break;
	case C_FONT:
		c_font = AddCntrl(c_font, cntrl);
		break;
	case C_KICODE:
		ResetCntrl(&c_kicode);
		c_kicode = AddCntrl((def_t *)NULL, cntrl);
 		break;
	case C_KOCODE:
		ResetCntrl(&c_kocode);
		c_kocode = AddCntrl((def_t *)NULL, cntrl);
		break;
	case C_HICODE:
		ResetCntrl(&c_hicode);
		c_hicode = AddCntrl((def_t *)NULL, cntrl);
		break;
	case C_HOCODE:
		ResetCntrl(&c_hocode);
		c_hocode = AddCntrl((def_t *)NULL, cntrl);
		break;
	case C_RESET2:
		c_attr = c_wide = c_vexpand = c_qexpand = c_half = NULL;
		break;
	case C_RESET:
		c_attr = c_wide = c_vexpand = c_qexpand = c_half = c_font = NULL;
		break;
	default:
		;
	}

	cntrl->rpl = rpl0;
	cntrl->rpllen = len0;
	cntrl->mode = rmode0;

	/* ߍݐR[ḧʒuL */
	SetCntrlPosVects();

}


/**************************************/



/* ȍċAI}Nũ`FbNp */
static def_t *recurmrpl = NULL;

static void
TextMacroRpl(def_t *def, const uchar *rpl, int rpllen)
/* eLXg}Nu̎s */
{
	if (rpllen > 0) {
		def_t *recurmrpl0 = recurmrpl;
		recurmrpl = def;
		DoText(rpl, rpllen);
		recurmrpl = recurmrpl0;
	}
}

static void
TextNormalRpl(const uchar *rpl, int rpllen)
/* eLXgʏu̎s */
{
	if (rpllen > 0) {
		int rplmode0 = rplmode;
		rplmode = OFF;
		DoText(rpl, rpllen);
		rplmode = rplmode0;
	}
}


/**************************************/

#define IsMCmdDotChar(c)	((int)(c) == cmddot_mchar && !binarymode)

#define IsCmdDotChar(c)		((int)(c) == cmddot_mchar || (int)(c) == cmddot_char)

#define MacroDotCommand(c)	((solflag && (c) && IsMCmdDotChar(c)) \
							 && (cc = prevc, TextDotCommand(1),  TRUE))


static void
TextDotCommand(int solmode)
{
	uchar *cmdbuf;

	cmdbuf = GetCommandLine((int *)NULL);
	Command(cmdbuf);			/* ߍ݃R}hs */
	ILineNoCount();
	if (solmode && mada_start_of_line) {
		/* s̓rłȂȂ */
		unsigned nc;
		/* hbgi */
		if (*cmdbuf ||
			(UngetChr(nc = GetChr()), nc != EOF2 && !IsCmdDotChar(nc)))
				/* R}hsłȂ */
				/* sߍ݃R}hsłȂȂ */
			InitParag();			/* i */
	}
	XFree((voidstar)cmdbuf);
}


static void
TextEscape(void)
/* eLXgGXP[v */
{
	textescapeflag = ON;
}


static void
TextPcForm(void)
/* ߍ %-ϊ̏ */
{
	int len;
	uchar *p;
	uchar *vbuf;
	int vlen;
	uchar *ibufp1;
	uchar *ibuf1;

	len = GetLine();						/* s܂œǂ */

	ibuf1 = DupStrDiff(ibuf, ibufp);
	ibufp1 = ibuf1 + (ibufp - ibuf);

	nevflag = 1;
	EvalPcForm((uchar *)NULL, ibuf1, (const uchar **)&p); /* ܂AXL̂ */
	nevflag = 0;

	CopyStrDiff(ibuf, ibuf1, ibufp1);
	ibufp = ibuf + (ibufp1 - ibuf1);

	UngetStrN(len - (p - ibuf1));

	vbuf = AEvalPcForm(&vlen, ibuf1, (const uchar **)&p);

	TextNormalRpl(vbuf, vlen);

	XFree((voidstar)ibuf1);
	XFree((voidstar)vbuf);
}

static void
RplCntrl(def_t *cntrl, uchar *rpl, int len, unsigned rmode)
{
	switch (cntrl->cmode) {
	case C_DOTCMD:
		TextDotCommand(cntrl->mode & R_SOL);
		break;
	case C_INDSET:
		aindent = x;
		indentsetflag = ON;
		break;
	case C_LEXPAND:
		SetChrExpPos(x, CHREXP_PREVCHR);
		break;
	case C_REXPAND:
		SetChrExpPos(x, CHREXP_NEXTCHR);
		break;
	case C_ESCAPE:
		if (madaindentflag)
			MkIndentEnd();
		TextEscape();
		break;
	case C_PCFORM:
		if (madaindentflag)
			MkIndentEnd();
		TextPcForm();
		break;
	case C_LBREAK:
		FreshLine();			/* s̓rȂs */
		break;
	case C_VBEGIN:
		PushParam(-1);			/* ݂̃p[^Ԃۑ */
		Command(clrcmd1);		/* 񐮌`[h */
		break;
	case C_VEND:
		PopParam(-1);			/* Õp[^Ԃ𕜌 */
		break;
	case C_ATTR:
		SetAttrib(cntrl, rpl, len, rmode);		/* e푮L */
		if (madaindentflag) {
			MkIndentEnd();
		} else {
			if (sjmode && IsHanSp(prevc) && kemode) {
				/* sjmode  prevc pXy[Xŉ[h̏ꍇ */
				unsigned nc;
				UngetChr(nc = GetChr());	/* ̕ */
				if (IsNewSentence(nc))		/* V̎n܂ł */
					PutChr1(SP);			/* Xy[XQɂ */
			}
			PutCntrl1(rpl, len);		/* CR[h𖄂ߍ */
		}
		break;
	case C_WIDE:
	case C_HALF:
	case C_VEXPAND:
	case C_QEXPAND:
		SetAttrib(cntrl, rpl, len, rmode);		/* e푮L */
		if (!madaindentflag) {
			PutCntrl1(rpl, len);
		}
		break;
	case C_RESET2:				/* C */
		if (!madaindentflag) {
			if (c_attr)
				PutResetCntrl(c_attr, c_areset);
			if (c_wide)
				PutResetCntrl(c_wide, c_wreset);
			if (c_vexpand)
				PutResetCntrl(c_vexpand, c_vreset);
			if (c_qexpand)
				PutResetCntrl(c_qexpand, c_qreset);
			if (c_half)
				PutResetCntrl(c_half, c_hreset);
			PutCntrl1(rpl, len);
		}
		SetAttrib(cntrl, rpl, len, rmode);		/* e푮L */
		break;
	case C_ARESET:
	case C_WRESET:
	case C_VRESET:
	case C_QRESET:
	case C_HRESET:
		SetAttrib(cntrl, rpl, len, rmode);		/* e푮L */
		PutCntrl1(rpl, len);
		/* cntrl o͂ƂňꏏɉĂ܂C𕜌 */
		ReputCntrl(cntrl);
		break;
	default:
		/* ̑ȂC`ꂽR[ho */
		SetAttrib(cntrl, rpl, len, rmode);		/* e푮L */
		PutCntrl1(rpl, len);
	}
}


/**************************************/

typedef struct wildarg {
	uchar		*s;
	short		len;
	struct wildarg *next;
} wildarg_t;

static wildarg_t *wildlist = NULL;
static int wildcnt = 0;

static void
AddWild(const uchar *strp, int len)
{
	wildarg_t *w = (wildarg_t*)XMalloc(sizeof(wildarg_t));
	
	w->s = DupStrN(strp, len);
	w->len = len;
	w->next = wildlist;
	wildlist = w;
	wildcnt++;
}

static void
FreeWildList(void)
{
	wildarg_t *w;

	while (wildlist != NULL) {
		wildlist = (w = wildlist)->next;
		XFree((voidstar)w->s);
		XFree((voidstar)w);
	}
	wildcnt = 0;
}

static void
MakeWildMargv(void)
{
	wildarg_t *w;
	int i;

	assert(wildcnt > 0);

	margc = wildcnt - 1;
	margv = (marg_t*)XMalloc((margc+1) * sizeof(marg_t));

	for (i = 0; i <= margc; i++) {
		assert(wildlist != NULL);

		w = wildlist;
		margv[i].s = w->s;
		margv[i].len = w->len;
		margv[i].typ = MA_VERBATIM;

		wildlist = w->next;
		XFree((voidstar)w);
	}
	assert(wildlist == NULL);
	wildcnt = 0;
}

static uchar *
AEvalRplString(int *lenp, const uchar *str, int len)
{
	uchar	*p;
	marg_t	*margv0 = margv;
	int		margc0 = margc;

	MakeWildMargv();
	p = AEvalStringN(lenp, str, len);					/* %-ϊ */
	FreeMargv(margc, margv);

	margc = margc0;
	margv = margv0;

	return p;
}

/**************************************/

static int match_context_flag;	/* ̒ł̒u */
static int match_length;		/* veLXg̒i[ */
static const uchar *match_text;

#define IsKakkoX(c)			((c) && NULL != strchr("[({\"'])}", (c)))

static int 
EndMatch(const uchar *textp, unsigned mode)
/* Ō̏`FbN */
{
	unsigned c;

	if (*textp == '\0')				/* ̍ŌȂ琬 */
		return TRUE;

	if (!match_context_flag) {		/* 񕶖[hȂsSvŎs */
		return FALSE;
	}
	if (mode & R_EOL) {				/* sw '$' */
		c = Moji(textp);
		/* sȂΐ */
		return IsVSpace(c);
	} else if (mode & R_EOL2) {		/* sQw '$$' */
		while ((c = RdMoji(textp), IsHSpace(c)));
		/* 󔒂Ƃ΂čsȂΐ */
		return IsVSpace(c);
	} else if (mode & R_EOW2) {		/* ꖖQw '}}' */
		c = Moji(textp);
		/* 󔒕Ȃ琬 */
		return IsXSpace(c);
	} else if (mode & R_EOW1) {		/* ꖖPw '}' */
		c = Moji(textp);
		/* pȂ琬 */
		return !IsXAlnum(c);
	}
	return TRUE;
}


static uchar *
WildMatch(const uchar *textp, const uchar *fndp, const uchar *fndend, unsigned mode)
{
	const uchar *tp0, *tp1;
	unsigned c, c2, c3;

	while (fndp < fndend) {
		if (*fndp == WILD_PREF) {
			int	wildmark = *++fndp;

			tp0 = textp;
			if (wildmark == WILD_SINGLE) {
				/* ChJ[h '?' : 1 ̔Cӂ̕Ƀ}b` */
				if (*textp == '\0' || *textp == '\n')
					return NULL;
				fndp++;
				textp = SkipMoji(textp);
				if ((tp1 = WildMatch(textp, fndp, fndend, mode)) == NULL)
					return NULL;

				AddWild(tp0, textp - tp0);
				textp = tp1;
				break;
			} else if (wildmark == WILD_MULTI || wildmark == WILD_XMULTI) {
				/* ChJ[h '*' : 0 ȏ̔Cӂ̕Ƀ}b` */
				/* ChJ[h "**": Ƀ}b` */
				fndp++;
				if (fndp == fndend) {
					/* ChJ[h '*' ̍Ōɂꍇ */
					if (!match_context_flag)
						textp = (const uchar *)strchr((const char *)textp, '\0');
					else if (mode & (R_EOL | R_EOL2))
						for ( ; *textp && !IsVSpace(*textp); textp++);
					else if (mode & R_EOW2)
						for ( ; *textp && (c = Moji(textp), !IsXSpace(c));
								textp = SkipMoji(textp));
					else if (mode & R_EOW1)
						for ( ; *textp && (c = Moji(textp), IsXAlnum(c));
								textp = SkipMoji(textp));
					else if (wildmark == WILD_XMULTI && IsKakkoX(*textp)) {
						textp = SkipExpr(textp, EXPR_PRIM, SKIP_ELSE0);
						if (textp == match_text)
							return NULL;
					}
					if (textp == match_text) {
						/* uΏۂ̒ 0 ͋Ȃ */
						if (*textp == '\0' || *textp == '\n')
							return NULL;
						else
							textp = SkipMoji(textp);
					}
					AddWild(tp0, textp - tp0);
					break;
				} else {
					while (!(tp1 = WildMatch(textp,fndp,fndend,mode))) {
						if (*textp == '\0' || *textp == '\n')
							return NULL;
						if (wildmark == WILD_XMULTI && IsKakkoX(*textp)) {
							tp1 = SkipExpr(textp, EXPR_PRIM, SKIP_ELSE0);
							if (textp == tp1)
								return NULL;
							textp = tp1;
						} else {
							textp = SkipMoji(textp);
						}
					}
					assert(tp1 != NULL);

					AddWild(tp0, textp - tp0);
					textp = tp1;
					break;
				}
			} else if (wildmark == WILD_SPACE || wildmark == WILD_OPTSPACE) {
				/* ChJ[h " " : 0 ȏ̋󔒕XLbv */
				/* ChJ[h "  " : 1 ȏ̋󔒕XLbv */
				if (*textp == '\0')
					return NULL;
				fndp++;
				for ( ; *textp && (c = Moji(textp), IsHSpace(c));
						textp = SkipMoji(textp));
				if (textp == tp0 && wildmark != WILD_OPTSPACE)
					return NULL;
			} else if (*textp++ != WILD_PREF) {
				return NULL;
			}
		} else if (!(mode & (R_ICASE | R_IZENHAN))) {
			if (*fndp++ != *textp++)
				return NULL;
		} else if (IsKanjiStr(fndp)) {
			c = MojiK(fndp);
			fndp += 2;
			c2 = RdMoji(textp);
			if (c != c2) {
				if (Is1B(c2)) {
					if (!(mode & R_IZENHAN) ||
						(c = ZentoANK2(c, &c3), !Is1B(c)) ||
						(mode & R_ICASE ? TOUPPER(c) != TOUPPER(c2)
										: c != c2) ||
						c3 && (c3 != RdMoji(textp))) {
						return NULL;
					}
				} else if (!(mode & R_ICASE) || jtoupper(c) != jtoupper(c2)) {
					return NULL;
				}
			}
		} else {
			c = *fndp++;
			c2 = RdMoji(textp);
			if (c != c2) {
				if (Is1B(c2)) {
					if (!(mode & R_ICASE) || TOUPPER(c) != TOUPPER(c2)) {
						return NULL;
					}
				} else if (!(mode & R_IZENHAN) ||
						   (c2 = ZentoANK2(c2, &c3), !Is1B(c2)) ||
						   (mode & R_ICASE ? TOUPPER(c) != TOUPPER(c2)
										   : c != c2) ||
						   c3 && (c3 != RdMoji(fndp))) {
					return NULL;
				}
			}
		}
	}
	if (!EndMatch(textp, mode))
		return NULL;

	return (uchar*)textp;
}

/**************************************/

#define NextIsSol(s, len)	(*StrLastN(s, len) == '\n')


static int 
Match(const uchar *text, def_t *slist)
{
	const uchar *textp;
	uchar *fndp;
	uchar *fndend;
	unsigned mode = slist->mode;
	
	match_text = text;
	
	if (match_context_flag) {					/* O̎̕w肪ꍇ */
		if (mode & R_SPECIAL) {
		 	return FALSE;
		} else if (mode & R_SOL) {
			if (!solflag)
				/* sw '^' ōsłȂȂ */
				return FALSE;
		} else if (mode & R_SOL2) {
			if (!sol2flag)
				/* sQw '^^' ōs󔒕łȂȂ */
				return FALSE;
		} else if (mode & R_SOW2) {
			if (!IsXSpace(prevc))
				/* ꓪQw '{{' őO̕󔒕łȂȂ */
				return FALSE;
		} else if (mode & R_SOW1) {
			if (IsXAlnum(prevc))
				/* ꓪPw '{' őO̕pȂ */
				return FALSE;
		}
	}

	if (recurmrpl && recurmrpl == slist) {
		/* AȍċAIȃ}NR[ȂAsƂ */
		return FALSE;
	}

	textp = text;
	fndp = slist->fnd;
	fndend = fndp + slist->fndlen;

#ifdef RE3_REGEXP
	if (remodeno == 3) {
		struct reg_match_t *matchs;
		int nmatch;
		int i;

		FreeWildList();

		if (!reg_match((char *)fndp, fndend - fndp, mode,
					   (const char *)textp, &nmatch, &matchs))
			return FALSE;

		if (matchs != NULL) {
			textp = text + matchs[0].len;
			for (i = nmatch - 1; i > 0; --i)
				AddWild((const uchar *)matchs[i].beg, matchs[i].len);
			XFree((voidstar)matchs);
		}

		if (textp == text || !EndMatch(textp, mode))
			return FALSE;
	} else
#endif
	if (mode & (R_WILD | R_ICASE | R_IZENHAN)) {
		/* ChJ[hȂǂ̃}b`O */
		FreeWildList();
		if (!(textp = WildMatch(textp, fndp, fndend, mode)) || textp == text) {
			return FALSE;
		}
	} else {
		while (fndp < fndend) {
			if (*fndp++ != *textp++)
				return FALSE;
		}
		if (!EndMatch(textp, mode))
			return FALSE;
	}

	match_length = textp - text;		/* v̒L */
	return TRUE;
}



/******************************** Replace *********************************/


int
Replace(void)
/*
* @݂̕ cc uXg prefi擪jɂ邩
* `FbNAȂ炳ɓǂݐi߂Ēuł邩ǂĂ݂B
* uɐ TRUEi1jԂAsȂAǂݐi񂾕͖߂āA
* FALSEi0jԂB
*/
{
	register rpl_t *rlist = rlist_top;
	register def_t *slist;
	unsigned mode;
	unsigned cmode;
	int n;
	unsigned c = Is1B(cc) ? TOUPPER(cc) : Moji_1(cc);		/* 擪PoCg */
	uchar *rpl;
	int rpllen;
	int newrplflag;
	int nextsolflag;

	if (MacroDotCommand(cc))		/* hbgR}h̃}Nł */
		return TRUE;

	do {
		/* uXg擪̕Ō */
		for ( ; rlist != NULL && rlist->pref != c; rlist = rlist->prev) {
			if (rlist->pref == WILD_PREF) {
				if (rlist->gmode & G_WILD)
					break;

				/* Spp̂ */
				if (Is1B(cc) ? !iscntrl(cc) : IsANKZen(cc))
					break;
			}
		}
		if (rlist == NULL)
			return FALSE;

		UngetChr(cc);
		n = GetStr((rlist->gmode & G_WILD) && (rlist->gmode & G_OVERNL)
				   ? evalbufsize : rlist->maxlen,
				   rlist->gmode);

		match_context_flag = TRUE;
		FreeWildList();
		for (slist = rlist->slist;
			 slist != NULL && !Match(ibuf, slist);
			 slist = slist->prev);

		if (slist == NULL) {
			/* ȂȂ */
			UngetStrN(n);			/* ǂݐi񂾕߂ */
			c = GetChr();
			assert(c == cc);
			FreeWildList();
			rlist = rlist->prev;
		}
	} while (slist == NULL);
	
	/* Ȃ */
	
	if (*ibuf == '\n')
		ILineNoCount();
	
	if (n > match_length)
		UngetStrN(n - match_length);		/* ]vɓǂ񂾕߂ */
	
	ibufp = ibuf + match_length;
	
	mode = slist->mode;
	cmode = slist->cmode;
	rpl = slist->rpl;
	rpllen = slist->rpllen;

	nextsolflag = NextIsSol(ibuf, match_length);

	newrplflag = 0;

	if (mode & R_EVAL) {
		def_t *recurmrpl0 = recurmrpl;
		AddWild(ibuf, match_length);
		recurmrpl = slist;
		rpl = AEvalRplString(&rpllen, rpl, rpllen);			/* %-ϊ */
		recurmrpl = recurmrpl0;
		newrplflag = 1;
	}

	if (mode & R_SAMELEN) {
		uchar *rpl2 = (uchar *)XMalloc(match_length+1);
		rpllen = SubStr(rpl2, rpl, rpllen, 0, min(rpllen, match_length));
		if (match_length > rpllen)
			memset(rpl2+rpllen, SP, match_length - rpllen);
		
		if (newrplflag)
			XFree((voidstar)rpl);
		rpl = rpl2;
		newrplflag = 1;
		rpllen = match_length;
	}

	FreeWildList();

	cc = prevc;				/* Zbg */
	if (cmode) {			/* wȂ */
		RplCntrl(slist, rpl, rpllen, mode & ~R_EVAL);
		if (cmode == C_DOTCMD) {
			nextsolflag = ON;
		}
	} else if (mode & R_MACRO) {				/* }NȂ */
		/* eLXg}Nus */
		TextMacroRpl(slist, rpl, rpllen);
	} else {
		/* eLXgʏu */
		TextNormalRpl(rpl, rpllen);
	}

	solflag = sol2flag = nextsolflag;

	if (newrplflag)
		XFree((voidstar)rpl);

	return TRUE;
}


/******************************** RplStr ***********************************/

/* R[hLWJ */

static uchar *
RplStr2(const uchar *str, rpl_t *rlist, int crplmode)
{
	register def_t *slist;
	int c = TOUPPER(*str);					/* 擪PoCg */

	clength = 0;

	/* uXg擪̕Ō */

	do {
		for ( ;
				rlist != NULL && rlist->pref != c && rlist->pref != WILD_PREF;
				rlist = rlist->prev);

		if (rlist == NULL)
			return NULL;

		match_context_flag = FALSE;
		FreeWildList();
		for (slist = rlist->slist;
			 slist != NULL && !Match(str, slist);
			 slist = slist->prev);
		
		if (slist == NULL) {
			FreeWildList();
			rlist = rlist->prev;
		}
	} while (slist == NULL);

	if (slist->mode & R_EVAL) {
		uchar *p;
		AddWild(str, match_length);
		p = AEvalRplString(&clength, slist->rpl, slist->rpllen);
		if (clength < CBUFSIZE)
			CopyStrN(cbuf, p, clength);
		XFree((voidstar)p);
	} else {
		clength = CopyStrN(cbuf, slist->rpl, slist->rpllen);
	}
	FreeWildList();

	if (clength >= CBUFSIZE)
		FError("Code buffer over");

	if (crplmode == 1 || crplmode == 2)
		SetAttrib(slist, cbuf, clength, slist->mode & ~R_EVAL);
								/* ɉݒ */
	if (crplmode == 1) {
		switch (slist->cmode) {
		case C_ATTR:
		case C_WIDE:
		case C_HALF:
		case C_VEXPAND:
		case C_QEXPAND:
			/* ̓eLXgs̔󔒕̑OɎœ邽
			   ł͏o͂Ȃ */
		case C_KICODE:
			/* ́Ao͂̑OɎIɏo͂邽߂ł͏o͂Ȃ */
		case C_HICODE:
			/* po͂̑OɎIɏo͂邽߂ł͏o͂Ȃ */
			/* Ƃ킯ŁA 0 ̕Ԃ */
			clength = 0;
			*cbuf = '\0';
			break;
		default:
			;
		}
	}
	return cbuf;
}



uchar *
RplStr(const uchar *str, int crplmode)
/* ^ꂽuXg rlist ŌC
   u cbuf gĕԂBi clengthj
   iCR[hȂkj
   Ȃ NULL Ԃ
*/
/* crplmode ̒l̈Ӗ
     1        pBꕔ͕̂̂ԂȂB
     2        pBׂĕԂB
     ̑   pȂBׂĕԂB
*/

{
	uchar *p;

	if ((p = RplStr2(str, srlist_top, crplmode)) != NULL)
		return p;					/* ʒuXgɂ΁AԂ */
	else
		return RplStr2(str, rlist_top, crplmode);
}

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
