/* main.c */
/*****************************************************************************
					s@o@wsq

				mO[o`C֐Cp[^n
*****************************************************************************/

#include "xtr.h"

static uchar *dummy = "";

/* XTR Version */
#if UNIX
uchar *xtrver;
#else
uchar *xtrver = "XTR " XTR_VER;
#endif

static uchar  *helpmsg[]  = {
" Text Processor XTR %s Copyright (C) Murakami Sinyu, 1990-92 ",
"",
"                    ssseLXg`c[Ewsqttt",
"g",
#if UNIX
"        xtr yIvV cz y-R}h cz y̓t@C cz",
"",
"IvV",
"  --ctype=EUC             o͕R[hEUC-JAPANɂ.",
"  --ctype=SJIS            o͕R[hSJISɂ.",
"  --tmpdir=fBNg e|t@C쐬fBNgw.",
#else
"        xtr y-R}h cz y̓t@C cz y>o̓t@Cz",
#endif
"",
"R}h",
"  e   ߍ݃R}hLɂ.",
"  wyPš(72)z    w茅ōs܂肽.",
"  f   s̋lߍ݂s.",
"  a   ss. (s̋󔒂𒲐čs𑵂)",
"  aj  ss. Ƃ̃eLXg̗]ȋ󔒂͖.",
"  sj  ̓eLXgs̗]ȋ󔒂𖳎.",
"  ac  񂹎w.",
"  ar  E񂹎w.",
"  ab  [iϓzujw.",
"  as  aԃXy[X.",
"  ss  aԃXy[X.",
"  al  i̋؂ɋ󔒍s.",
"  ai  I[gCfg[h.",
"  iCfg(0)       w茅.",
"  hyCfg(2)z   îQsڈȍ~w茅.",
"  ipyCfg(2)z  i̍ŏ̍sw茅.",
"  ii                ̓eLXg̃Cfg𖳎.",
"  il                ̓eLXg̋󔒍s𖳎.",
"  ly󔒍s(1)z  wsɏo͂.",
"  qy/z      es̍Ɂg> h܂͎w蕶\.",
"  ty^uԊu(8)z  ^uXy[XɓWJ.",
"  sy^uԊu(8)z  Xy[X^uɕϊďo͂.",
"  sz                ȂׂSpXy[Xo.",
"  sh                SpXy[X𔼊pɕϊ.",
"  sn                s[̃Xy[X𖳎Ȃ.",
"  pgyy[Wԍl(1)z y[Wt[h.",
"  pỹy[Wԍ(1)z    y[W.",
"  nyKvȎcs(4)z      y[W̎csȂΉy[W.",
"  spy󔒍s(1)z 󔒍so͖.",
"  lnysԍz      y[W̍sʒu␳.",
"  pls(58)        Py[W̍si{̂݁jw.",
"  ph///Ey/wb_s(3)z  y[Wwb_w.",
"  pf///Ey/tb^s(3)z  y[Wtb^w. (- %%p -)",
"  ps                y[Wwb_^tb^šȂǐݒ.",
"  pts(1)         y[W̏]ʂsŎw肷.",
"  pbs(1)         y[W̉]ʂsŎw肷.",
"  po(0)         Ŝɕt鍶]̌w肷.",
"  ppy/zJny[W/Iy[Wy/y[WԊuz   y[Ww蕔o.",
"  px  y[WtSsȂ.",
"  pn  v^R[ho͂Ȃ.",
"  np  y[WR[ho͂Ȃ.",
#if MSDOS || WINNT || __human68k__
"  nr  AR[ho͂Ȃ.",
#if !__human68k__
"  pj  `mjQoCgpɂ.",
#endif
#endif
"  pm  CȉIŎ.",
"  pvԍ  cg僂[hI.",
"  pwԍ  g僂[hI.",
"  r/y^b{zy}b$z/u/y[hcz  eLXgu`.",
"  rc  u`NA.",
#if 0
"  wlyPs̍őoCg(80)z         Psɏo͂oCg𐧌.",
"  wkyVtgR[h̃oCg(2)z  wl ŊVtgR[ht.",
#endif
"  ko  Ԃ牺֑Ȃ.",
"  kn  SppނŃ[hbvȂ.",
"  kh  p󔒕Ԃłs.",
"  kc  ppŃ[hbvȂ.",
"  kz  Spł󔒂łsȂ.",
"  kk  Ǔ_ނłsȂ.",
"  kx  ֑Ȃ.",
"  kf  slߍݎɃXy[X}Ȃ.",
"  ke  `[h.",
"  kty=cb/cz  s֑w.",
"  kdy=cb/cz  Ԃ牺֎~̍s֑w.",
"  kmy=cb/cz  s֑w.",
"  kay=cb/cz  p̂悤Ɉ镶w.",
"  kiy=cb/cz  ӏڋLw.",
"  ksy=cb/cz  ɋ󔒂SpLw.",
"  kpy=cb/cz  Oɋ󔒂SpLw.",
"  hz/Sc               p^Spϊe[uC.",
"  ch  Sp𔼊pɒu.",
"  cz  pSpɒu.",
#if __human68k__
"  myPʂ̍s(29)z      o͂ʂŌƂ, Pʖɕ\.",
#else
"  myPʂ̍s(22)z      o͂ʂŌƂ, Pʖɕ\.",
#endif
"  oy=t@Cb.gqz  o̓t@Cw.",
"  nn  sŃt@CI邱Ƃ̂Ȃ悤ɂ.",
#if MSDOS || WINNT
"  nz  o̓t@C̍Ō ^Z tȂ.",
#endif
"  nk  񊿎[h.",
"  b   oCi[h.",
"  -   p[^NA.",
"  /   soߕ\Ȃ.",
"  @t@C       t@C̎荞. (gqȗF.XTR)",
"  [C ]             `[h̋L^. (ꎞI`[hw)",
"  $ysz         wso͌Ƃ̐`[hɖ߂.",
"",
"ߍ݃R}hL",
"  .  (sIhŎn܂s)  R}hs.",
"  ~.         s̓rł悢R}hs.",
"  ~/         Cfgݒ.",
"  ~>C~<     ^EL΂.",
"  ~\\         GXP[v. (̕ʒʂ)",
"  ~%%         q%%-ϊřʂeLXgɖ߂.",
"  ~{C~}     ͂܂ꂽ͈͂ōsȂǂȂ.",
"  ~|         s.",
"",
"ϐ",
"    XTR      g`R}hZbgĂ.",
"    XTRPATH  荞݃t@CfBNgw.",
#if UNIX
"    TMPDIR   e|t@C쐬fBNgw.",
#else
"    TMP      e|t@C쐬fBNgw.",
#endif
"",
"̑",
"  Egp, Rs[, ĔzzȂǂ͎RɍsĂ.",
"  Eڂ̓}jA.",
"                                                    ^Y (Murakami Sinyu)",
"                                                   QGA03215@niftyserve.or.jp"
#if UNIX
,
"",
"                                                   Ported for HUMAN68K/UN*X",
"                                                    K (Katsuyuki Okabe)",
"                                                   hgc02147@niftyserve.or.jp"
#endif
};

/**************************************************************************/

#if MSDOS
/* ߖ̂ helpmsg ̗̈[N̈ɓ]pB */
/* ȂȂA̒`폜B */
 #define HELPMSG_AS_WORKAREA

/* helpmsg[] ͕萔̔złAevfÄɂ邱ƂA
 *   ̗̈悪\ł邱Ƃb͋K肵ĂȂB
 */
#endif

/**************************************************************************/

/* emode == ON ̂ƂZbg */
uchar esetcmd_s[] = "r/^.//.\
/~.//.\
/~%//%\
/~>//>\
/~<//<\
/~\\///\\/\
/~\\\\//\\\\\
/~|//|\
/~\\{//{\
/~\\}//}";
uchar *esetcmd = esetcmd_s;

/* emode == OFF ̂ƂZbg */
uchar eclrcmd_s[] = "r/^.//-\
/~.//-\
/~%//-\
/~>//-\
/~<//-\
/~\\///-\
/~\\\\//-\
/~|//-\
/~\\{//-\
/~\\}//-";
uchar *eclrcmd = eclrcmd_s;

/* s֑ */
uchar gtkinsoku_s[] = "\244\241,.;:\245)]}>\243\337\336!?\
\201\101\201\102\201\103\201\104\201\107\201\106\201\105\201\111\
\201\110\201\146\201\150\201\152\201\154\201\156\201\160\201\162\
\201\164\201\204\201\166\201\170\201\172";
/* ,.;:)]}>!?ABCDGFEIHfhjlnprtvxz */
uchar *gtkinsoku = gtkinsoku_s;

/* Ԃ牺֎~̍s֑ */
uchar gtkinsoku2_s[] = "";
uchar *gtkinsoku2 = gtkinsoku2_s;

/* s֑ */
uchar gmkinsoku_s[] = "([{<\242\
\201\145\201\147\201\151\201\153\201\155\201\157\201\161\201\163\
\201\203\201\165\201\167\201\171";
/* ([{<egikmoqsuwy */
uchar *gmkinsoku = gmkinsoku_s;

/* ŝߌɋ󔒂Ă悢 */
uchar postspadjchrs_s[] = "\
\201\101\201\102\201\103\201\104\201\150\201\152\201\154\201\156\
\201\160\201\162\201\164\201\166\201\170\201\172";
/* ABCDhjlnprtvxz */
uchar *postspadjchrs = postspadjchrs_s;

/* ŝߑOɋ󔒂Ă悢 */
uchar prespadjchrs_s[] = "\
\201\147\201\151\201\153\201\155\201\157\201\161\201\163\201\165\
\201\167\201\171";
/* gikmoqsuwy  */
uchar *prespadjchrs = prespadjchrs_s;

/* p̂悤Ɉ镶 */
uchar alnum2_s[] = "";
uchar *alnum2 = alnum2_s;

uchar itemmark_s[] = "-*\245\
\201\105\201\210\201\226\201\230\201\231\201\232\201\233\201\234\
\201\235\201\236\201\237\201\240\201\241\201\242\201\243\201\244\
\201\245\201\246\201\346\201\364\201\365\201\366\201\367\
\207\100\207\101\207\102\207\103\207\104\207\105\207\106\207\107\
\207\110\207\111\207\112\207\113\207\114\207\115\207\116\207\117\
\207\120\207\121\207\122\207\123\
\207\124\207\125\207\126\207\127\207\130\207\131\207\132\207\133\
\207\134\207\135";
/* -*E */
/* @ABCDEFGHIJKLMNOPQRS */
/* TUVWXYZ[\] */
uchar *itemmark = itemmark_s;

uchar quotestr_s[] = "> ";
uchar *quotestr = quotestr_s;

uchar phleft_s[] = "";
uchar phcenter_s[] = "";
uchar phright_s[] = "";
uchar pfleft_s[] = "";
uchar pfcenter_s[] = "- %p -";
uchar pfright_s[] = "";
uchar *phleft = phleft_s;
uchar *phcenter = phcenter_s;
uchar *phright = phright_s;
uchar *pfleft = pfleft_s;
uchar *pfcenter = pfcenter_s;
uchar *pfright = pfright_s;

uchar *newpfleft = pfleft_s;
uchar *newpfcenter = pfcenter_s;
uchar *newpfright = pfright_s;


/* `[hNAR}hP */
uchar *clrcmd1 = "w- f- a- sj- aj- ac- ar- ab- ai- af- as- "
				 "ss- al- h- ip- ii- il-";

/* `[hNAR}hQ */
uchar *clrcmd2 = "r-";

/* `[h^p[^ */
int emode = OFF;			/* e  Fߍ݃R}h */
int wrapmode = OFF;			/* w  Fw茅ōs܂ */
int width  = 72;
int wlmode = OFF;			/* wl Fs̃oCǧE^ */
int wlimit = 80;
int wkmode = OFF;			/* wk FKI/KO ꂽꍇ̃oCgJEg */
int kikosize = 2;			/*     @KI/KO R[h̃oCg */
int fillmode = OFF;			/* f  FiȂsȂ */
int normadjmode = OFF;		/* a  Fs */
int spadjlimit = 5;
int ajmode = OFF;			/* aj F */
int sjmode = OFF;			/* sj F]ȃX[y[XJbg */
int ssmode = OFF;			/* ss FaԃXy[XJbg */
int centeradjmode = OFF;	/* ac F */
int rightadjmode = OFF;		/* ar FE */
int bothadjmode = OFF;		/* ab FE낦iϓzj */
int asmode = OFF;			/* as FaԃXy[X */
int almode = OFF;			/* al Fi̋؂ɋ󔒍s */
int aimode = OFF;			/* ai FI[gCfgs */
int afmode = OFF;			/* af FCfgtꂽeLXgĐ` */
int bindentmode = OFF;		/* i  F{Cfgw */
int indent = 0;
int ignoreindentmode = OFF;	/* ii F͂̃Cfg𖳎 */
int ignorelinespmode = OFF;	/* il F͂̋󔒍s𖳎 */
int hindentmode = OFF;		/* h  FHanging indent */
int hindent = 2;
int pindentmode = OFF;		/* ip FIndented Paragraph */
int pindent = 2;
int linespmode = OFF;		/* l  Fs̓xɋs */
int splines = 1;
int quotemode = OFF;		/* q  FɎw̕\ */
int tabtospmode = OFF;		/* t  F^uXy[XɓWJ */
int itabstop = 8;
int sptotabmode = OFF;		/* s  FXy[X^uŏo͂ */
int otabstop = 8;
int szmode = OFF;			/* sz FXy[XSp󔒂ŏo͂ */
int shmode = OFF;			/* sh FXy[X𔼊p󔒂ŏo͂ */
int skmode = OFF;			/* sk F^uʂȃXy[Xɕϊ */
int alttabsp = 0xa0;
int snmode = OFF;			/* sn Fs[Xy[X𖳎Ȃ */
int rplmode = OFF;			/* r  Fu` */
int remodeno = 2;			/* re Fu`K\[h */
int pagemode = OFF;			/* p  Fy[Wt */
uchar *pagebegin = "";		/* pp Fy[Ww蕔o */
uchar *pageend = "";
int pagelines = 58;			/* pl FPy[W̍s */
int phlines = 3;			/* ph Fy[Wwb_ */
int pflines = 3;			/* pf Fy[Wtb^ */
int pagetopsp = 1;			/* pt Fy[W] */
int pagebtmmode = OFF;		/* pb Fy[W] */
int pagebtmsp = 1;
int pageoffset = 0;			/* po Fy[W] */
int pagestep = 1;
int absppmode = OFF;
int anktohwmode = OFF;		/* pj F`mjQoCgpɕϊ */
int vexpmodeno = 3;			/* pv Fcg僂[hI */
int wexpmodeno = 3;			/* pw Fg僂[hI */
int sgr98mode = OFF;		/* pc FSGR(ESC[m)seqg;hŎIɘA */
int prkikomodeno = 3;		/*    FKIKO[h */
int prhihomodeno = 3;		/*    FHIHO[h */
int pmmode = OFF;			/* pm FCȉIŎ */
int nocntrlmode = OFF;		/* pn FR[ho͂Ȃ */
int noffmode = OFF;			/* np Fy[WR[ho͂Ȃ */
#if NL_IS_CRLF
int nocrmode = OFF;			/* nr FAR[ho͂Ȃ */
#else
int nocrmode = ON;
#endif
int oidasimode = OFF;		/* ko Fǂô֑ */
int kkmode = OFF;			/* kk FǓ_ōs؂ */
int khmode = OFF;			/* kh Fpł󔒈ȊOōs܂ */
int kzmode = OFF;			/* kz FSpł󔒈ȊOł͍s܂Ȃ */
int knmode = OFF;			/* kn FSpppȂ */
int kcmode = OFF;			/* kc FpppȂ */
int kemode = OFF;			/* ke F[h */

int binarymode = OFF;		/* b  FoCi[[h */
int moremode = OFF;			/* m  Flnqd[hCp[^͉ʂ̍s */
#if __human68k__
int moresize = 29;
#else
int moresize = 22;
#endif
int mkbakmode = OFF;		/* o  FOςȂAƂ̂ .BAK Ɏc*/
int ofilemode = OFF;		/* o= Fw̃t@Cɏo */
int chgextmode = OFF;		/* o. Fgqςt@Cɏo */
int delaymode = OFF;		/* d  F胂[hCp[^͒x */
int delaytime = 10;

int debug = 0;				/* dd  Fdebug mode */

int plaintextmode = OFF;	/* px FPȂeLXgt@Cɂ */

int hanzenconv = 0;			/* czFpSpϊ */
int zenhanconv = 0;			/* chFSppϊ */
	/*  zenhanconv == -hanzenconv 藧 */

int nountermlinemode = OFF;	/* nn FsŃt@CIȂ悤 */
int noctrlzmode = OFF;		/* nz FŌEOF(^Z)o͂Ȃ */

int kxmode = OFF;			/* kx F֑sȂ */
int kfmode = OFF;			/* kf Flߍ݂ŋ󔒂Ȃ */
int jtexmode = OFF;			/* kj F{TeX݊slߍ */

int zerolinefeedmode = OFF;	/* z  F[s[h */

int nokanjimode = OFF;		/* nk F񊿎[h */

int noerrmode;				/* nw FȂׂG[oȂ[h */

unsigned  evalbufsize = EVALBUFSIZE;	/* be : Eval Buffer size */

int silentmode = OFF;		/* / Fsilent mode */

int cmddot_char = 0;		/* R}hs̃}[N */
int cmddot_mchar = 0xff;	/* }NŎgpR}hs̃}[N */


/* o */
int stdinmode;				/* W͂ */
uchar *ifilename;			/* ݂̓̓t@C */
uchar *ifilename1;			/* ̓t@C̑\ */
FILE *ifp = stdin;
int stdoutmode;				/* Wo͂֏o */
uchar *ofilename;
FILE *ofp = stdout;
uchar *bakfilename;			/* .BAK Ƀl[ꂽ̓t@C */


/* ԃtO */

int solflag;		/* ̓eLXg̍sł */
int sol2flag;		/* ̓eLXg̍s܂󔒂ǂłȂ */

int newlineflag;	/* ܂sɉĂȂ */
int madaindentflag;	/* s̎n߂܂󔒕ɏoĂȂƂ */
					/* iCCfgŉ邽߁j */
int inindentflag;	/* ̂ƎĂ邪Csr̋󔒂Ȃǂł ON ɂȂ */
					/* iI[gCfgCWXeBt@C̊Jnʒuj*/
int linebreak;		/* iłPšzčs܂JEgAbv */
int lineoverflag;	/* Pš̍őlz߁CCobt@eo*/
int nonewlineflag;	/* Cobt@̓efos͂Ȃ */
int firstphmadaflag;/* ŏ̃y[Wł܂wb_o͂ĂȂ */
int pageendflag;	/* y[WIĂĉy[WKv */
int pagecutflag;	/* Py[W̍sz߉y[W */
int wlimitflag;		/* s̃oCgÊ߂ɍs܂ */
int indentsetflag;	/* Cfgʒu肸 */
int chrexpflag;		/* L΂wi~<, ~>j */

int textescapeflag = OFF;	/* eLXgGXP[vw (~\)  */

int intextflag;		/* eLXgsł */
int includeflag;	/* t@C荞ݒł */
int inmtextflag;	/* }NeLXgs */
int tmpincludeflag;	/* e|t@C荞ݒł */
int coninmode;		/* ͂R\[ł */
int conoutmode;		/* o͂R\[ł */
int prnoutmode;		/* o͂v^ł */
int eotflag;		/* eLXg̏I */
int resetmadaflag;	/* v^ZbgR[h܂oĂȂ */
int vexpflag;		/* cgsł */
int wexpflag;		/* sɉg傪܂܂Ă */
int printpagemadaflag;	/* Jny[Wɂ܂BĂȂƂ */
int printpageflag;	/* ݃y[Ŵł邱Ƃ */

int nevflag;			/* No eval mode flag */

int errorflag = 0;		/* G[Ƃ */

int spacelines = 0;			/* 󔒍sJEg */
int linespaced = 0;			/* 󔒍so̓R}ĥƂł邱Ƃ */

params_t *params = NULL;	/* `p[^eۑpX^bNXg */


int aindent = 0;			/* s܂Ƃ̃I[gCfgʒu */
int bindent = 0;			/* Cfg̊ʒuA̓eLXg
							   Cobt@̌ʒu̍ɂȂ */

uchar *bindentp;			/* *lbv[bindent]  */

int first_indent = 0;		/* ȋsڂ̃Cfg */

int nobreakpos = 0;	/* wrapmode  ON  OFF ɂȂʒuL^ */

int wlrem;					/* oCgE wlimit ܂ł̎coCg */

int morecnt;			/* lnqd̂߂̍sJE^ */

unsigned ilineno = 1;		/* ͍sJE^ */
unsigned nlcount = 0;		/* ͂̉s𐔂 */
unsigned lineno = 1;		/* sJE^ */
int pageno = 1;				/* y[WԍJE^ */
int abspageno = 1;			/* ΃y[WԍJE^(ďȂ) */
int pagestepcnt = 0;		/* ƂтƂуy[Wo͗pJE^ */
int newpageno = -1;			/* y[WԍrŕύXƂ̂ */
int phpfchgflag = OFF;		/* y[Wwb_tb^ύXĂ邱Ƃ */

unsigned cc = '\f';			/* ݏ̕ */
unsigned prevc = '\f';		/* O̕ */

unsigned indentchar;	/* I[gCfg̃CfgɎg󔒕 */


int pagewidth = 0;		/* ͂߂ WritePage Ă΂ꂽƂ width ̒l */
				   		/* ƂŃwb_Atb^ʒuςȂ悤ɂ */

int pagehwmode = OFF;	/* ͂߂ WritePage Ă΂ꂽƂQoCgp
						   ɕϊ郂[hȂ ON ɂāAȍ~s */


/* up */

rpl_t *rlist_top = NULL;	/* uXg̃gbv */
rpl_t *srlist_top = NULL;	/* ʒuXg̃gbv */

marg_t *margv;				/* }NR}hxN^ */
int   margc = 0;			/* }NR}h̐ */
strdesc_t  retvalue = {NULL, 0};	/* Ōɕ]̒lێ */

int fargc = 0;				/* gݍ݊֐Ăяö̐ */

var_t	*varlist = NULL;		/* ϐXg */
var_t	*localvarlist = NULL;	/* [JϐXg */
macro_t	*macrolist = NULL;		/* }NXg */


/* R[h̒` */
def_t *c_reset = NULL;
def_t *c_terminate = NULL;
def_t *c_newline = NULL;
def_t *c_newpage = NULL;
def_t *c_reset2 = NULL;
def_t *c_areset = NULL;
def_t *c_vreset = NULL;
def_t *c_qreset = NULL;
def_t *c_wreset = NULL;
def_t *c_hreset = NULL;
def_t *c_freset = NULL;
def_t *c_kicode = NULL;
def_t *c_kocode = NULL;
def_t *c_hicode = NULL;
def_t *c_hocode = NULL;
def_t *c_attr = NULL;
def_t *c_wide = NULL;
def_t *c_vexpand = NULL;
def_t *c_qexpand = NULL;
def_t *c_half = NULL;
def_t *c_font = NULL;

def_t *c_pagefont = NULL; /* ͂߂ WritePage Ă΂ꂽƂ c_font ̒l */
def_t *c_pagekicode = NULL; /*  c_kicode ̒l */
def_t *c_pagekocode = NULL; /*  c_kocode ̒l */


/* Wvobt@ */
jmp_buf errorjb;		/* G[ long jump ̂ */

/* ϐ */
uchar *xtrenv;			/* ϐ XTR ̒l */
uchar *xtrpath;			/* ϐ XTRPATH ̒l */
uchar *tmppath;			/* ϐ TMP ̒l */

/* XTR NpX */
uchar *xtrprog;

/* obt@֌W */

uchar *lbuf;				/* o̓eLXg쐬邽߂̃Cobt@ */
uchar *lbv[LBVSIZE];	/* lbuf ւ̃|C^ւ̔z */
int	x = 0;					/* JE^Albv[]̃CfbNX */

uchar *sbuf;				/* \[XeLXgobt@iGetChr/UngetChrpj*/
uchar *sbufp;				/* sbuf ւ̃|C^ */
uchar *sbufbtm;				/* sbuf ̒ւ̃|C^ */

uchar *ibuf;				/* ͕obt@iGetStr/UngetStrNpj*/
uchar *ibufp;				/* ibufւ̃|C^ */

uchar *cbuf;				/* R[ĥ߂̃obt@ */
uchar *cbufp;				/* cbuf ւ̃|C^ */
int clength = 0;			/* R[h֐ŒԂ߂̃WX^ */

#if __human68k__
int (*STRCMP)();
#endif


/****************************************************************************/

static void
Help(void)
{
	int i;

	moremode = ON;
	coninmode = OFF;
	for (i = 0; i < sizeof(helpmsg)/sizeof(helpmsg[0]); i++) {
      		printf((char *)helpmsg[i], XTR_VER);
		putchar('\n');
		More();
	}
}

/****************************************************************************/


#if UNIX
struct mblocale {
	uchar *name;
	int type;
};

static struct mblocale mblocales[] = {
	{ "ja_JP.EUC", MBTYPE_EUC },
	{ "ja_JP.ujis", MBTYPE_EUC },
	{ "ja_JP.SJIS", MBTYPE_SJIS },
	{ "ja_JP.mscode", MBTYPE_SJIS },
	{ "japan", MBTYPE_EUC },
	{ "Japan", MBTYPE_EUC },
	{ "japanese", MBTYPE_EUC },
	{ "Japanese", MBTYPE_EUC },
	{ NULL, -1 }
};

static int
search_mbtype(const uchar *s)
{
	int i;

	for (i = 0; mblocales[i].name != NULL; ++i)
		if (strcmp((const char *)s, (char *)mblocales[i].name) == 0)
			return mblocales[i].type;
	return -1;
}

static void
set_mbtype(void)
{
	int xtr_ctype;
	uchar *env;

	xtr_ctype = -1;
	if ((env = (uchar *)getenv("XTR_CTYPE")) != NULL) {
		if (stricmp((char *)env, "euc") == 0)
			xtr_ctype = MBTYPE_EUC;
		else if (stricmp((char *)env, "sjis") == 0)
			xtr_ctype = MBTYPE_SJIS;
		else
			xtr_ctype = search_mbtype(env);
	}
	if (xtr_ctype < 0) {
		env = (uchar *)getenv("LC_CTYPE");
		if (env == NULL)
			env = (uchar *)getenv("LANG");
		if (env != NULL)
			xtr_ctype = search_mbtype(env);
	}
	if (xtr_ctype < 0)
		xtr_ctype = strcmp("", "\244\242") == 0 ? MBTYPE_EUC : MBTYPE_SJIS ;
	mbinit(xtr_ctype);
}
#endif

static void
Initialize(void)
{
#if __human68k__
	extern char *_toslash();
	extern long TwentyOneOptions();
	int twon;
#define ISTWONCASE(f) ((f) & (1 << 30))
#endif
#if UNIX
	set_mbtype();
#endif
#ifdef HELPMSG_AS_WORKAREA
 #define WBuf_START		(helpmsg[2])
 #define WBuf_END		(helpmsg[sizeof(helpmsg)/sizeof(helpmsg[0])-1])
	/* z sbuf[]  lbuf[]  helpmsg[] ̗̈ WBuf_START`WBuf_END ɍ */
	assert(WBuf_START != dummy);
	assert(WBuf_END != dummy);
	sbuf = WBuf_START;
	assert(sbuf + SBUFSIZE + 2 < WBuf_END);
#else
	sbuf = (uchar *)XMalloc(SBUFSIZE + 2);
#endif
	cbuf = (uchar *)XMalloc(CBUFSIZE + 2);
	lbuf = (uchar *)XMalloc(LBUFSIZE + 2);
	ibuf = (uchar *)XMalloc(IBUFSIZE + 2);

	sbufp = sbufbtm = sbuf + SBUFSIZE;
	ibufp = ibuf;
	cbufp = cbuf;
	bindentp = lbuf;

	xtrenv = (uchar *)getenv(XTR_ENV);
	xtrpath = (uchar *)getenv(XTRPATH_ENV);
	tmppath = (uchar *)getenv(TMPPATH_ENV);
#if __human68k__
	if (tmppath == NULL)
		tmppath = getenv("temp");
	if (tmppath == NULL)
		tmppath = getenv("TMP");
	if (tmppath != NULL)
		_toslash(tmppath);
	twon = TwentyOneOptions();
	if (twon == -1)
		twon = 0;
	STRCMP = ISTWONCASE(twon) ? strcmp : stricmp ;
#else
#if UNIX
	if (tmppath == NULL)
		tmppath = (uchar *)getenv("TMP");
	if (tmppath == NULL)
		tmppath = "/tmp";
#endif
#endif

	InitCBreak();
}


void
Terminate(int exit_status)
/* I */
{
	if (exit_status == 0 && errorflag)
		exit_status = 1;

	WriteCntrl(c_terminate);
	TermCBreak();
	AllocEnd();
	exit(exit_status);
}


/****************************************************************************/
/*					͂܂												*/
/******************************** main **************************************/

static void LookStrVal ARGS((const uchar *str));
static int check_option ARGS((const uchar *str));

static int look_opt_flag;	/* -c?? ̂悤ȃIvV̂ */

void
main(int argc, uchar **argv)
{
	int i;
	int i0;
	int firstflag;

	xtrprog = argv[0];
#if __human68k__
	{
		char *p;
		if ((p = strrchr(xtrprog, '.')) != NULL && stricmp(p, ".x") == 0)
			*p = '\0';
	}
#endif
#if UNIX
	xtrver = alloca(6 + strlen(XTR_VER) + strlen(VERSION));
	strcpy((char *)xtrver, "XTR ");
	strcat((char *)xtrver, XTR_VER);
	strcat((char *)xtrver, "-");
	strcat((char *)xtrver, VERSION);
	setbuf(stdin, (char *)NULL);
#endif

	Initialize();							/*  */

	morecnt = moresize;
	stdoutmode = ON;
	ofilename = "(output)";
	ofp = stdout;
	ifilename1 = ifilename = "(input)";		/* Zbg */
	ifp = stdin;
	SetInMode(ifp);							/* ̓_CNg`FbN */
	SetOutMode(ofp);						/* o̓_CNg`FbN */
	if (coninmode && argc < 2 || argc == 2 && strcmp((char *)argv[1], "-?") == 0) {
		/* ̓_CNgŃp[^A
		   邢̓p[^ -? ݂̂Ȃgdko */
		Help();
		Terminate(0);
	}
	stdinmode = !coninmode;
	SetModeB(ofp, 1);

	/* R}hLZ̈ "-" ΁ÄʒuL */
	for (i0 = argc - 1; i0 > 0 && !equ1(argv[i0], '-'); i0--) ;

	/* Ō̓̓t@CL */
	for (i = argc - 1; i > i0 && !IsFileName(argv[i]); i--) ;
	if (i == i0) {			/* t@Cw薳Ȃ */
		stdinmode = ON;			/* W͂ */
	} else {
		stdinmode = OFF;
		ifilename1 = ifilename = argv[i];
	}

	printpagemadaflag = ON;
	pagestepcnt = 0;
	printpageflag = ON;
	madaindentflag = ON;
	resetmadaflag = ON;
	firstphmadaflag = ON;
	pageendflag = ON;
	pagecutflag = OFF;
	pageno = 1;
	abspageno = 1;
	lineno = 1;
	eotflag = OFF;

	/* R}hLZw薳ŁAϐ XTR ΂̓e
		R}hƂď */
	if (i0 == 0 && xtrenv != NULL)
		Command(xtrenv);

	firstflag = ON;
	for (i = i0 + 1; i < argc; i++) {
		eotflag = intextflag = OFF;
		if (!IsFileName(argv[i])) {
#if UNIX
			const uchar *arg, *p;

			arg = p = (uchar *)XMalloc(strlen(argv[i]) * 2 + 1);
			mb2sjisstring((char *)p, (char *)argv[i]);
			if (check_option(p) != OK) {
#else
			const uchar *p = argv[i];
#endif
			while (*p == SWITCHAR)
				p++;
			if (*p == '?' || *p == '#') {
				uchar *v = AEvalExprStr((int *)NULL, p+1);
				if (*p == '?') {
					look_opt_flag = 1;
					LookStrVal(v);
				}
				XFree((voidstar)v);
			} else {
				look_opt_flag = 1;
				SimpleCommand(p);
			}
			look_opt_flag = 0;
#if UNIX
			}
			XFree((voidstar)arg);
#endif
		} else {
			if (mkbakmode && argv[i] == ifilename1)
				ifilename = bakfilename;
			else
				ifilename = argv[i];
			if (!firstflag)
				fclose(ifp);
			if ((ifp = fopen((char *)ifilename, "r")) == NULL) {
				Error("Can't open file: %s", ifilename);
			}
			SetInMode(ifp);

			intextflag = ON;
			Trans();			/* eLXgϊs */
			Disp(1);				/* soߕ\ */
			firstflag = OFF;
		}
	}
	if (stdinmode) {
		if (!coninmode) {	/* ͂_CNgĂ */
			ChgStdin();		/* stdin R\[ɕς */
		}
		intextflag = ON;
		Trans();					/* eLXgϊs */
		Disp(1);						/* soߕ\ */
	}
	/* ߂菈 */
	eotflag = ON;
	if (pagemode) {					/* y[Wt[hȂ */
		WritePage();				/* Ō̃y[Wtb^o */
	}
#if MSDOS || WINNT
#if EOFCHAR != -1
	if (!c_terminate && !pagemode && !noctrlzmode && !binarymode 
	         && !conoutmode && !prnoutmode) {
		/* PȂeLXgt@Cꍇ */
		Write1(EOFCHAR);			/* Ctrl-Z o */
	}
#endif
#endif
	Terminate(0);
}




/*************************** CheckOption *************************************/

#if UNIX
static int
check_option(const uchar *str)
{
	int result = OK;

	if (strncmp((const char *)str, "--ctype=", 8) == 0) {
		if (stricmp((const char *)str + 8, "euc") == 0) {
			mbinit(MBTYPE_EUC);
		} else if (stricmp((const char *)str + 8, "sjis") == 0) {
			mbinit(MBTYPE_SJIS);
		} else {
	        	Message("unrecognized option `%s'\n", str);
			result = ERR;
		}
	} else if (strncmp((const char *)str, "--tmpdir=", 9) == 0) {
#if __human68k__
		extern char *_toslash();
		tmppath = _toslash(DupStr(str + 9));
#else
		tmppath = DupStr(str + 9);
#endif
	} else
		result = ERR;

	return result;
}
#endif




/************************** SimpleCommand ************************************/

/* \-GXP[vV[PX܂ޕǂ */
#define AReadStr(p)			AReadString((int *)NULL, (p))

/* \-GXP[vV[PX܂ޕ brkchr ̎O܂œǂ */
/* Ƃ̕ւ̃|C^ p ͓ǂ񂾕i߂ */
#define AReadStrB(p, brkchr)	AReadStringB((int *)NULL, (p), &(p), (brkchr))


static const uchar *cmdstr;

static void
UnkCmdErr(void)
{
#if UNIX
	uchar *mbs = (uchar *)alloca(strlen((char *)cmdstr) * 2 + 1);
	sjis2mbstring((char *)mbs, (char *)cmdstr);
	Error("Unknown command: %s", mbs);
#else
	Error("Unknown command: %s", cmdstr);
#endif
}

static int
ParamErr(void)
{
#if UNIX
	uchar *mbs = (uchar *)alloca(strlen((char *)cmdstr) * 2 + 1);
	sjis2mbstring((char *)mbs, (char *)cmdstr);
	Error("Invalid parameter: %s", mbs);
#else
	Error("Invalid parameter: %s", cmdstr);
#endif
	return 0;	/* Never */
}

#define IsStrParam(p)		(*(p) == '"' || *(p) == '/')

static void
LookStrVal(const uchar *str)
{
	int len = strlen((const char *)str);

	if (len == 0)
		ClearRetValue();
	else
		SetRetValue(DupStr(str), len);

	if (look_opt_flag) {
		/* N͒l\ */
		fprintf(ofp, "%s\r\n", str);
		stdinmode = OFF;		/* t@Cw薳łW͂gȂ */
	}
}

static void
LookParamVal(int n)
{
	uchar str[80];
	WtNum(str, n);
	LookStrVal(str);
}

#define SW_ON			255		/* XCb`̂݃Zbgꍇ ON ̒l */

/* [hXCb`Ɛlp[^Zbg */
/* sG[CZbgXCb`̒lԂ */
#define SetSwNE(sw, n, nmin, nmax) 	FSetSwNE(p, &(sw), &(n), (nmin), (nmax))
static int
FSetSwNE(const uchar *p, int *swp, int *np, int nmin, int nmax)
/* p:
 *		'?'['?'] | [{'+'|'-'|'='}][<expr>][{'+'|'-'}]
 */
{
	uchar *buf = DupStr(CutSpace(p));
	uchar *bp = buf;
	assert(p != NULL);
	assert(swp != NULL);
	assert(np != NULL);

	RTrimSpace(bp);

	if (*bp == '?') {
		int n = *++bp == '?' ? (++bp, *np) : *swp;
		if (*bp)
			ParamErr();
		LookParamVal(n);
	} else {
		int numflg = 0;			/* '+': plus / '-': minus / '=': direct */
		int swflg = 0;			/* '+': ON / '-': OFF / 0: no touch */
		uchar *bp1;
	
		bp1 = StrLast(bp);
		if (*bp1 == '+' || *bp1 == '-') {
			swflg = *bp1;
			*bp1 = '\0';
			RTrimSpace(bp);
		}
		if (*bp == '+' || *bp == '-') {
			numflg = *bp++;
		} else if (*bp == '=') {
			bp++;
		} else if (swflg == 0) {
			swflg = '+';
		}
		if (*CutSpace(bp) && !numflg)
			numflg = '=';

		if (numflg) {
			int num = (int)EvalExprVal(bp, (const uchar **)&bp1, EXPR_MAX);
			if (*bp1)
				ParamErr();
			if (numflg == '+')
				*np += num;
			else if (numflg == '-')
				*np -= num;
			else
				*np = num;

			if (*np < nmin)
				*np = nmin;
			else if (*np > nmax)
				*np = nmax;
		}
		if (swflg == '-')
			*swp = OFF;
		else if (swflg == '+' && (swp == np ? !numflg : !*swp))
			*swp = SW_ON;
	}
	XFree((voidstar)buf);
	return *swp;
}

/* 񐔒lp[^ƂȂꍇ */
/* +^- ȊÕp[^L̂Ƃ͐^Ԃ */
#define SetSwS(sw)	FSetSwS(p, &sw)
static int
FSetSwS(const uchar *p, int *swp)
{
	if (!*p || *p == '?' || (*p == '+' || *p == '-') && !*SkipSpace(p+1)) {
		if (*p == '?') {
			int looksw = *++p == '?' ? (++p, FALSE) : TRUE;
			if (*p)
				ParamErr();
			if (looksw) {
				LookParamVal(*swp);
				return FALSE;
			} else {
				ClearRetValue();
				return TRUE;
			}
		} else {
			*swp = *p == '-' ? OFF : ON;
			return FALSE;
		}
	}
	if (*p == '/' || *p == '"')
		*swp = ON;

	return TRUE;
}

/* sG[CZbgXCb`̒lԂ */
#define SetSwE(sw)	FSetSwE(p, &sw)
static int
FSetSwE(const uchar *p, int *swp)
{
	return FSetSwNE(p, swp, swp, 0, UCHAR_MAX);
}

/* p[^̐擪 '/'  '=' 菜. ʂ̕擪ȂG[ */
/* A'"'  null Ȃ炻̂܂܂ɂ */
#define ParamStr(p)		FParamStr(&p)
static uchar *
FParamStr(const uchar **pp)
{
	if (!**pp || **pp == '"')
		;
	else if (**pp == '/' || **pp == '=')
		++*pp;
	else
		ParamErr();
	return (uchar *)*pp;
}


/* ZbgZbg^ǉ */
#define SetChrSet(cset)		FSetChrSet(&cset, _Paste2(cset, _s), p)
static void
FSetChrSet(uchar **csetp, uchar *cset_s, const uchar *p)
{
	uchar *cset = *csetp;

	if (!*p) {
		SReset(cset);				/* ftH[g cset_s ɖ߂ */
	} else if (*p == '?') {
		LookStrVal(cset);			/* ݒl\ */
	} else if (*p == '=') {
		SFree(cset);
		cset = AReadStr(p + 1);		/* u */
	} else {
		uchar *addp = AReadStr(ParamStr(p));
		uchar *newp = (uchar *)XMalloc(strlen((char *)cset) + strlen((char *)addp) + 1);
		strcpy((char *)newp, (char *)cset);
		strcat((char *)newp, (char *)addp);			/* ǉ */
		SFree(cset);
		cset = newp;
	}
	*csetp = cset;
}

/* Zbg */
#define SetStr(str)		FSetStr(&str, _Paste2(str, _s), p)
static void
FSetStr(uchar **strp, uchar *str_s, const uchar *p)
{
	uchar *str = *strp;

	if (!*p) {
		SReset(str);				/* ftH[g str_s ɖ߂ */
	} else if (*p == '?') {
		LookStrVal(str);			/* ݒl\ */
	} else {
		SFree(str);
		str = AReadStr(ParamStr(p));			/* u */
	}
	*strp = str;
}

static void
CheckPageBE1(const uchar *page)
{
	const uchar *p = page;

	if (!*p) {
		return;
	} else if (isdigit(*p)) {
		while (*++p && isdigit(*p));
		if (!*p)
			return;
	} else if (!absppmode && islower(*p)) {
		if (!p[strspn((const char *)p, "ivxlcdm")])
			return;
	} else if (!absppmode && isupper(*p)) {
		if (!p[strspn((const char *)p, "IVXLCDM")])
			return;
	}
	Error("Page error: %s", page);
}

static void
CheckPageBE(void)
/* pagebegin, pageend y[Wԍ̍\`FbN */
{
	while (*pagebegin == '0' && *(pagebegin + 1))
		++pagebegin;
	while (*pageend == '0' && *(pageend + 1))
		++pageend;
	CheckPageBE1(pagebegin);
	CheckPageBE1(pageend);
}


static void
ChangeHanZenTable(const uchar *hanzens)
{
	unsigned ank;
	unsigned zen;
	while (*hanzens) {
		ank = RdMoji(hanzens);
		zen = RdMoji(hanzens);
		if (ChangeANKtoZen(ank, zen) == 0)
			ParamErr();
	}
}

static void
SetHanZen(const uchar *p)
{
	if (!*p) {
		;
	} else if (*p == '?') {
		#define HZTBLSIZE	(((0x7f-0x20)+(0xe0-0xa1)) * 3 + 1)
		uchar hztbl[HZTBLSIZE];
		uchar *tp = hztbl;
		unsigned c, c2;
		for (c = 0x20; c < 0xe0; c++) {
			if (c == 0x7f) c = 0xa1;
			*tp++ = c;
			c2 = ANKtoZen(c);
			tp += SetKanji(c2, tp);
		}
		*tp = '\0';
		assert(tp == hztbl + HZTBLSIZE - 1);
		LookStrVal(hztbl);
	} else {
		uchar *str = AReadStr(ParamStr(p));
		ChangeHanZenTable(str);
		XFree((voidstar)str);
	}
}

static int
PrimitiveCommand(const uchar *cmd)
{
	const uchar *p = cmd;
	const uchar *p1;
	int sw = 1;
	int num = -1;

	if (!islower(*p) || (++p, islower(*p)) && (++p, islower(*p))) {
		/* pP܂͂QȊO̓v~eBuR}hłȂ */
		return FALSE;
	}
	p1 = p;

	switch ((p - cmd) > 1 ? MkMoji(*cmd, *(cmd+1)) : *cmd) {
	case 'w':			/* w: Wrap mode */
		sw = wrapmode;
		SetSwNE(wrapmode, width, indent + 2, MAXWIDTH);
		if (wrapmode != sw && x <= width) {
			if (wrapmode)
				nobreakpos = 0;
			else
				nobreakpos = x;		/* ON  OFF ɂȂʒuL */ 
		}
		break;
	case2('w','l'):		/* wl: Width byte count Limit */
		SetSwNE(wlmode, wlimit, 1, LBUFSIZE);
		break;
	case2('w','k'):		/* wk: Width Kiko byte count mode */
		wlmode = SetSwNE(wkmode, kikosize, 0, LBUFSIZE);
		break;
	case 'f':			/* f: line Fill mode */
		SetSwE(fillmode);
		break;
	case 'e':			/* e: Enable intext commands */
		sw = emode;
		SetSwE(emode);
		if (sw != emode) {
			if (emode)
				Command(esetcmd);		/* ߍ݃R}h` */
			else
				Command(eclrcmd);		/* `NA */
		}
		break;
	case2('e','s'):		/* es: set e-set command str */
		SetStr(esetcmd);
		if (*p != '?') {
			Command(eclrcmd);		/* O̒`NA */
			Command(esetcmd);		/* VɃZbg */
		}
		break;
	case2('e','c'):		/* ec: set e-clear command str */
		SetStr(eclrcmd);
		break;
	case 'a':			/* a: normal Adjusting mode */
		SetSwNE(normadjmode, spadjlimit, 0, UCHAR_MAX);
		break;
	case2('a','j'):		/* aj: normal AdJusting mode */
		sjmode = normadjmode = SetSwE(ajmode);
		break;
	case2('a','c'):		/* ac: Center adjusting mode */
		if (SetSwE(centeradjmode))
			rightadjmode = bothadjmode = OFF;
		break;
	case2('a','r'):		/* ar: Right adjusting mode */
		if (SetSwE(rightadjmode))
			centeradjmode = bothadjmode = OFF;
		break;
	case2('a','b'):		/* ab: Both adjusting mode */
		if (SetSwE(bothadjmode))
			centeradjmode = rightadjmode = OFF;
		break;
	case2('a','i'):		/* ai: Auto Indent mode */
		SetSwE(aimode);
		break;
	case2('a','f'):		/* af: Auto-indented text Fill */
		fillmode = aimode = SetSwE(afmode);
		break;
	case2('a','s'):		/* as: Auto jpn-eng Space */
		SetSwE(asmode);
		break;
	case2('a','l'):		/* al: Auto Line space */
		SetSwE(almode);
		break;
	case 'l':			/* l: Line space */
		SetSwNE(linespmode, splines, 0, UCHAR_MAX);
		break;
	case2('l','n'):		/* ln: Line Number */
		num = lineno;
		SetSwNE(sw, num, 0, pagelines);
		/* y[WȂƂ .ln-1 ΁Ay[WȂȂ
		   悤ɂ */
		if (pageendflag && pagecutflag && ((long)lineno > pagelines)
				&& (num <= pagelines)) {
			pageendflag = pagecutflag = OFF;
		}
		lineno = num;
		break;
	case 'i':			/* i: Indent */
		SetSwNE(bindentmode, indent, 0, width - 2);
		break;
	case2('i','i'):		/* ii: Ignore Indent mode */
		SetSwE(ignoreindentmode);
		break;
	case2('i','p'):		/* ip: Paragraph indent */
		SetSwNE(pindentmode, pindent, 0, width - 2);
		break;
	case 'h':			/* h: Hanging indent */
		SetSwNE(hindentmode, hindent, 0, width - 2);
		break;
	case 'q':			/* q: Quote mode */
		if (SetSwS(quotemode))
			SetStr(quotestr);
		break;
	case 't':			/* t: Tab to space */
		SetSwNE(tabtospmode, itabstop, 1, width - 2);
		break;
	case 's':			/* s: Space to tab */
		SetSwNE(sptotabmode, otabstop, 1, width - 2);
		break;
	case2('s','z'):		/* sz: output Zenkaku space */
		SetSwE(szmode);
		break;
	case2('s','h'):		/* sh: output Hankaku space */
		SetSwE(shmode);
		break;
	case2('s','k'):		/* sk: skmode */
		SetSwNE(skmode, alttabsp, 0, 255);
		break;
	case2('s','n'):		/* sn: Space No ignore */
		SetSwE(snmode);
		break;
	case2('s','s'):		/* ss: Skip jpn-eng Space */
		SetSwE(ssmode);
		break;
	case2('s','j'):		/* sj: Space adJusting */
		SetSwE(sjmode);
		break;
	case2('s','p'):		/* sp: Space Lines */
		num = 1;
		if (SetSwNE(sw, num, 0, UCHAR_MAX)) {
			num -= spacelines;	/* Oɋ󔒍so͂Ă炻̕ */
			linespaced = 0;
			FreshLine();
			while (num-- > 0)
				NewLine();
			linespaced = 1;
		}
		break;
	case2('i','l'):		/* il: Ignore Line space */
		SetSwE(ignorelinespmode);
		break;
	case 'r':			/* r: Replace */
		if (SetSwS(rplmode)) {
			if (*p == '?')
				LookStrVal("");
			else
				DefineRplStr(ParamStr(p));
		}
		break;
	case2('r','e'):		/* re: Replace Expression mode# */
		SetSwNE(sw, remodeno, 0, 3);
		break;
	case2('r', 'c'):	/* rc: Replace Clear */
		num = 0;
		if (SetSwNE(sw, num, 0, 2)) {
			ResetRplList(&rlist_top);	/* uXgNA */
			switch (num) {
			case 2:
				ResetRplList(&srlist_top);
				ResetCntrlLists();	/* R[h`ׂăNA */
				break;
			case 1:					/* PȂuXgNA */
			case 0:
			default:;
			}
			if (emode)				/* ߍ݃R}hLȂ */
				Command(esetcmd);	/* ߍ݃R}h` */
		}
		break;
	case2('p','g'):		/* pg: Paging mode */
		SetSwNE(pagemode, pageno, 0, SHRT_MAX);
		break;
	case 'p':			/* p: Page */
		SetSwNE(pagemode, newpageno, 0, SHRT_MAX);
		if (pagemode && intextflag) {
			pagecutflag = OFF;		/* Ry[Wł͂Ȃ */
			WritePage();	/* y[WD߂ĂȂwb_̂ݏo */
							/* Ỏy[ŴƂȂȂɂȂ */
		} else if (newpageno != -1){
			pageno = newpageno;
			newpageno = -1;
		}
		break;
	case2('p','p'):		/* pp: Partial Print */
		if (isdigit(*p)) {
			absppmode = ON;			/* pp ̒オȂ΃y[Ww */
		} else {
			ParamStr(p);
			absppmode = OFF;
		}
		pagebegin = AReadStrB(p, '/');
		if (!*p) {
			/* AJny[W̎w肵ȂAIy[W = Jny[W */
			pageend = pagebegin;
		} else {
			ParamStr(p);
			pageend = AReadStrB(p, '/');
			ParamStr(p);
		}
		CheckPageBE();
		SetSwNE(pagemode, pagestep, 0, UCHAR_MAX);
		break;
	case2('p','h'):		/* ph: Page Header */
		if (!*p || IsStrParam(p)) {
			SReset(phleft);
			SReset(phcenter);
			SReset(phright);
			if (*p) {
				ParamStr(p);
				phleft = AReadStrB(p, '/');
				ParamStr(p);
				phcenter = AReadStrB(p, '/');
				ParamStr(p);
				phright = AReadStrB(p, '/');
				ParamStr(p);
			}
		}
		SetSwNE(pagemode, phlines, 0, UCHAR_MAX);
		phpfchgflag = ON;
		break;
	case2('p','f'):		/* pf: Page Footer */
		if (!*p || IsStrParam(p)) {
			if (newpfleft != pfleft && newpfleft != pfleft_s)
				XFree((voidstar)newpfleft);
			if (newpfcenter != pfcenter && newpfcenter != pfcenter_s)
				XFree((voidstar)newpfcenter);
			if (newpfright != pfright && newpfright != pfright_s)
				XFree((voidstar)newpfright);
			newpfleft = pfleft_s;
			newpfcenter = pfcenter_s;
			newpfright = pfright_s;
			if (*p) {
				ParamStr(p);
				newpfleft = AReadStrB(p, '/');
				ParamStr(p);
				newpfcenter = AReadStrB(p, '/');
				ParamStr(p);
				newpfright = AReadStrB(p, '/');
				ParamStr(p);
			}
		}
		SetSwNE(pagemode, pflines, 0, UCHAR_MAX);
		phpfchgflag = ON;
		break;
	case2('p','s'):		/* ps: Page header/footer setting */
		if (SetSwE(pagemode))
			PageSetting();
		break;
	case2('p','l'):		/* pl: Page Length */
		SetSwNE(sw, pagelines, 0, UCHAR_MAX);
		break;
	case2('p','t'):		/* pt: Page Top space */
		SetSwNE(sw, pagetopsp, 0, UCHAR_MAX);
		break;
	case2('p','b'):		/* pb: Page Botom space */
		SetSwNE(pagebtmmode, pagebtmsp, 0, UCHAR_MAX);
		break;
	case2('p','o'):		/* po: Page Offset */
		SetSwNE(sw, pageoffset, 0, MAXWIDTH);
		break;
	case2('p','j'):		/* pj: ANK to HW */
#if MSDOS || WINNT
		SetSwE(anktohwmode);
#endif
		break;
	case2('p','v'):		/* pv: Vertical expand mode# */
		SetSwNE(sw, vexpmodeno, 0, 3);
		break;
	case2('p','w'):		/* pw: Width expand mode# */
		SetSwNE(sw, wexpmodeno, 0, 3);
		break;
	case2('p','x'):		/* px: Plain teXt output mode */
		SetSwE(plaintextmode);
		break;
	case2('p','m'):		/* pm: */
		SetSwE(pmmode);
		break;
	case2('p','n'):		/* pn: No cntrl output */
		SetSwE(nocntrlmode);
		break;
	case2('n','p'):		/* np: No form feed output */
		SetSwE(noffmode);
		break;
	case2('n','r'):		/* nr: No Return output */
		SetSwE(nocrmode);
		break;
	case2('p','c'):		/* pc: for pc98 SGR seq */
		SetSwE(sgr98mode);
		break;
	case 'n':			/* n: Need # lines */
		num = 4;
		if (SetSwNE(sw, num, 1, UCHAR_MAX)) {
			if (pagemode && pagelines && pagelines - (long)lineno + 1 < num) {
				/* cswsɖȂΉy[W */
				pagecutflag = OFF;		/* Ry[Wł͂Ȃ */
				WritePage();
			}
		}
		break;
	case 'o':			/* o: Output file */
		if (SetSwS(mkbakmode)) {
			if (*p == '?') {
				LookStrVal("");
			} else {
				mkbakmode = stdoutmode = OFF;
				if (!(chgextmode = (*p == '.')) && *p != '=') {
					ParamErr();
				}
				SetOFile(++p);
			}
		} else if (*p != '?') {
			if (mkbakmode) {
				if (stdinmode)
					mkbakmode = OFF;
				else
					stdoutmode = OFF;
				if (mkbakmode)
					SetOFile(p);
			} else {
				stdoutmode = ON;
				ofp = stdout;
			}
		}
		break;
	case2('n','k'):		/* nk: No Kanji mode */
		SetSwE(nokanjimode);
		break;
	case2('n','w'):		/* nw: No Warning mode */
		SetSwE(noerrmode);
		break;
	case2('n','n'):		/* nn: No Newlineless line */
		SetSwE(nountermlinemode);
		break;
	case 'b':			/* b: Binary mode */
		SetSwE(binarymode);
		SetFModeB(binarymode);		/* ftH[g binary file mode */
		SetModeB(ifp, binarymode);	/* ifp oCi[h */
		break;
	case 'm':			/* m: More mode */
		SetSwNE(moremode, moresize, 0, UCHAR_MAX);
		morecnt = moresize;
		break;
	case 'd':			/* d: Delay mode */
		SetSwNE(delaymode, delaytime, 0, 1000);
		break;
	case2('k','o'):		/* ko: Oidasi kinsoku only */
		SetSwE(oidasimode);
		break;
	case2('k','k'):		/* kk: Kinsoku mode K */
		SetSwE(kkmode);
		break;
	case2('k','h'):		/* kh: Kinsoku mode H */
		SetSwE(khmode);
		break;
	case2('k','z'):		/* kz: Kinsoku mode Z */
		SetSwE(kzmode);
		break;
	case2('k','n'):		/* kn: Kinsoku mode N */
		SetSwE(knmode);
		break;
	case2('k','c'):		/* kc: Kinsoku mode C */
		SetSwE(kcmode);
		break;
	case2('k','e'):		/* ke: for English text */
		SetSwE(kemode);
		break;
	case2('k','x'):		/* kx: no kinsoku */
		SetSwE(kxmode);
		break;
	case2('k','f'):		/* kf: fill whithout space */
		SetSwE(kfmode);
		break;
	case2('k','j'):		/* kj: for japanese TeX text */
		SetSwE(jtexmode);
		break;
	case2('k','t'):		/* kt: gyouTou kinsoku chars */
		SetChrSet(gtkinsoku);
		break;
	case2('k','d'):		/* kd: gyoutou kinsoku 2 chars */
		SetChrSet(gtkinsoku2);
		break;
	case2('k','m'):		/* km: gyouMatu kinsoku chars */
		SetChrSet(gmkinsoku);
		break;
	case2('k','a'):		/* ka: Alphabetic chars */
		SetChrSet(alnum2);
		break;
	case2('k','i'):		/* ki: Item mark chars */
		SetChrSet(itemmark);
		break;
	case2('k','s'):		/* ks: post-Space adjustable chars */
		SetChrSet(postspadjchrs);
		break;
	case2('k','p'):		/* kp: Pre-space adjustable chars */
		SetChrSet(prespadjchrs);
		break;
	case2('h','z'):		/* hz: change Hankaku-Zenkaku table */
		SetHanZen(p);
		break;
	case2('c','h'):		/* ch: Convert zenkaku to Hankaku */
		SetSwE(zenhanconv);
		if (*p != '?') {
			if (zenhanconv > 3)
				zenhanconv = 1;
			if (zenhanconv)
				rplmode = ON;
			hanzenconv = -zenhanconv;
		}
		break;
	case2('c','z'):		/* cz: Convert hankaku to Zenkaku */
		SetSwE(hanzenconv);
		if (*p != '?') {
			if (hanzenconv > 3)
				hanzenconv = 1;
			if (hanzenconv)
				rplmode = ON;
			zenhanconv = -hanzenconv;
		}
		break;
	case2('n','z'):		/* nz: No ctrl-Z */
#if MSDOS || WINNT
		SetSwE(noctrlzmode);
#endif
		break;
	case 'z':			/* z: Zero line feed mode */
		SetSwE(zerolinefeedmode);
		break;
	case2('b','e'):		/* be: Eval Buffer size */
		SetSwNE(sw, *(int *)&evalbufsize, 1, SHRT_MAX);
		break;
	case 'v':			/* v: Verbatim */
		if (*p)
			ParamErr();
		Command("-");
		break;

	case2('d','d'):		/* dd : debug */
		SetSwNE(debug, debug, SHRT_MIN, SHRT_MAX);
		p = NULL;
		break;

	default:
		return FALSE;
	}

	if (*p1 != '?')
		ClearRetValue();

	return TRUE;
}


void
SimpleCommand(const uchar *p)
{
	assert(p != NULL);

	cmdstr = p;				/* G[\pɋL */

	if (!*p)
		return;

	if (IsKSym1Str(p)) {
		if (PrimitiveCommand(p)) {
			/* v~eBuR}h */
			look_opt_flag = 0;
			return;
		} else if (IsFuncArgStr(SkipKSym2(p))) {
			/* ֐ďoR}h */
			look_opt_flag = 0;
			EvalReturnExpr(p, EXPR_PRIM);
			return;
		}
	}

	look_opt_flag = 0;

	switch(*p++) {
	case '=':							/* = : output cntrl seq (direct) */
	case ':':							/* : : output cntrl seq (symbol) */
		if (*cmdstr == '=') {
			clength = ReadString(cbuf, p);
		} else {
			uchar *sym = AReadStr(p);
			if (!RplStr(sym, 1)) {
#if UNIX
				uchar *mbs = (uchar *)alloca(strlen((char *)p) * 2 + 1);
				sjis2mbstring((char *)mbs, (char *)p);
				Error("Undefined symbol: %s", mbs);
#else
				Error("Undefined symbol: %s", p);
#endif
			}
			XFree((voidstar)sym);
		}
		WriteNC(cbuf, clength);
		break;
	case '@':							/* @ : include a file */
		if (*p == '=') {
			Include(p+1, 1);
		} else 
			Include(p, 0);
		break;
	case '(':							/* '(' <expr> ')'	*/
	case '{':
	case '"':
		EvalReturnExpr(p-1, EXPR_PRIM);
		break;
	case '/':							/* / : silentmode */
		if (!(intextflag || includeflag)) {
			SetSwE(silentmode);
		}
		break;
	default:
		UnkCmdErr();
	}
}


/**************************************/

void
PushParam(int count)
/* ݂̐`p[^̓eX^bNɕۑ */
/* count ̏ꍇC count so͂ PopParam Ă΂
   ۑꂽԂ */
{
	params_t *ps;

	ps = (params_t *)XMalloc(sizeof(params_t));
	ps->e_	= emode;
	ps->w_	= wrapmode;
	ps->f_	= fillmode;
	ps->a_	= normadjmode;
	ps->aj_	= ajmode;
	ps->ac_	= centeradjmode;
	ps->ar_	= rightadjmode;
	ps->ab_	= bothadjmode;
	ps->as_	= asmode;
	ps->ss_	= ssmode;
	ps->sj_	= sjmode;
	ps->al_	= almode;
	ps->ai_	= aimode;
	ps->af_	= afmode;
	ps->i_	= bindentmode;
	ps->h_	= hindentmode;
	ps->ip_	= pindentmode;
	ps->ii_ = ignoreindentmode;
	ps->il_	= ignorelinespmode;
	ps->l_	= linespmode;
	ps->q_	= quotemode;
	ps->t_	= tabtospmode;
	ps->s_	= sptotabmode;
	ps->sz_ = szmode;
	ps->sh_ = shmode;
	ps->sk_ = skmode;
	ps->sn_ = snmode;
	ps->pj_	= anktohwmode;
	ps->pm_	= pmmode;
	ps->r_	= rplmode;
	ps->ko_	= oidasimode;
	ps->kn_	= knmode;
	ps->kh_	= khmode;
	ps->kc_	= kcmode;
	ps->kz_	= kzmode;
	ps->kk_	= kkmode;
	ps->ke_	= kemode;
	ps->kx_	= kxmode;
	ps->kf_	= kfmode;
	ps->kj_	= jtexmode;
	ps->nk_	= nokanjimode;
	ps->z_	= zerolinefeedmode;

	ps->w	= width;
	ps->a	= spadjlimit;
	ps->i	= indent;
	ps->h	= hindent;
	ps->ip	= pindent;
	ps->l	= splines;
	ps->t	= itabstop;
	ps->s	= otabstop;
	ps->sk	= alttabsp;

	ps->count = count;
	ps->prev = params;
	params = ps;
}

void
PopParam(int countmode)
/* X^bNɕۑĂp[^̏Ԃ𕜌 */
/* countmode == -1 ȂJE^tłȂX^bN̏Ԃ܂łǂ */
/* countmode < -1 Ȃ炷ׂĂǂ */
{
	params_t *ps = params;

	if (ps == NULL)			/* X^bN󂾂炷A */
		return;

	if (countmode >= 0 || countmode == ps->count || ps->prev == NULL) {

		if (emode && !ps->e_)
			Command(eclrcmd);
		else if (!emode && ps->e_)
			Command(esetcmd);

		if (ps->w_ != wrapmode && x <= ps->w) {
			if (!wrapmode)
				nobreakpos = 0;
			else
				nobreakpos = x;		/* ON  OFF ɂȂʒuL */ 
		}

		emode			= ps->e_;
		wrapmode		= ps->w_;
		fillmode		= ps->f_;
		normadjmode		= ps->a_;
		ajmode			= ps->aj_;
		centeradjmode	= ps->ac_;
		rightadjmode	= ps->ar_;
		bothadjmode		= ps->ab_;
		asmode			= ps->as_;
		ssmode			= ps->ss_;
		sjmode			= ps->sj_;
		almode			= ps->al_;
		aimode			= ps->ai_;
		afmode			= ps->af_;
		bindentmode		= ps->i_;
		hindentmode		= ps->h_;
		pindentmode		= ps->ip_;
		ignoreindentmode= ps->ii_;
		ignorelinespmode= ps->il_;
		linespmode		= ps->l_;
		quotemode		= ps->q_;
		tabtospmode		= ps->t_;
		sptotabmode		= ps->s_;
		szmode 			= ps->sz_;
		shmode 			= ps->sh_;
		skmode 			= ps->sk_;
		snmode 			= ps->sn_;
		anktohwmode		= ps->pj_;
		pmmode			= ps->pm_;
		rplmode			= ps->r_;
		oidasimode		= ps->ko_;
		knmode			= ps->kn_;
		khmode			= ps->kh_;
		kcmode			= ps->kc_;
		kzmode			= ps->kz_;
		kkmode			= ps->kk_;
		kemode			= ps->ke_;
		kxmode			= ps->kx_;
		kfmode			= ps->kf_;
		jtexmode		= ps->kj_;
		nokanjimode		= ps->nk_;
		zerolinefeedmode= ps->z_;
	
		width			= ps->w;
		spadjlimit		= ps->a;
		indent			= ps->i;
		hindent			= ps->h;
		pindent			= ps->ip;
		splines			= ps->l;
		itabstop		= ps->t;
		otabstop		= ps->s;
		alttabsp		= ps->sk;

		params = ps->prev;
		XFree((voidstar)ps);
	} else {
		params = ps->prev;
		XFree((voidstar)ps);
		PopParam(countmode);
	}
}



void
SetOFile(const uchar *name)
{
	FILE *ofp0 = ofp;

	if (chgextmode) {
		/* gqwȂ */
		if (stdinmode)
			return;

		ofilename = ChgExt(ifilename1, name);
	} else if (!mkbakmode) {
		ofilename = DupStr(name);
	}
	if (SameFile(ofilename, ifilename1))
		mkbakmode = ON;

	fflush(ofp);			/* Ȍo̓Xg[obt@̓e͂ */

	stdoutmode = OFF;

	if ((chgextmode || mkbakmode) && !FileExists(ifilename1))
		Error("Can't open file: %s", ifilename1);

	if (mkbakmode) {
		bakfilename = ChgExt(ifilename1, BAK_EXT);
		if (FileExists(bakfilename))		/* OBAKt@C݂Ă*/
			remove((char *)bakfilename);	/* 폜 */
		if (rename((char *)ifilename1, (char *)bakfilename)) {
#if UNIX
			Error("Can't create .bak file: %s", bakfilename);
#else
			Error("Can't create .BAK file: %s", bakfilename);
#endif
		}
		ofilename = ifilename1;
	} else {
		ofilemode = ON;
	}

	if ((ofp = fopen((char *)ofilename, WRITE_BINARY)) == NULL) {
		ofp = ofp0;
		Error("Can't create file: %s", ofilename);
	}
	SetOutMode(ofp);
}


void
Include(const uchar *fname, int abs_fname_flg)
/* t@C荞 */
/* ċAIȃt@C̎荞݂ł */
/*  abs_fname_flg UȂAt@C .XTR gq
   tāAJgfBNgȊO XTRPATH fBNgLɂ */
{
	uchar *ifilename0 = ifilename;
	FILE  *ifp0 = ifp;
	unsigned ilineno0 = ilineno;
	unsigned nlcount0 = nlcount;
	int includeflag0 = includeflag;
	int inmtextflag0 = inmtextflag;
	uchar *sbufp0 = sbufp;
	uchar *sbufp2 = NULL;			/* \[XeLXgobt@eۑ */
	jmp_buf	errorjb0;
	uchar *ifname;

	memcpy(errorjb0, errorjb, sizeof(jmp_buf));

	if (setjmp(errorjb) == 0) {
		if (!intextflag) {
			/* eLXg̊O̎荞ݎw̏ꍇ */
			SetFModeB(0);			/* 荞݂͕KeLXgt@C */
			Command(esetcmd);		/* ߍ݃R}hLɂ */
		}
		if (abs_fname_flg || FNameExt(fname)) {
			ifname = DupStr(fname);
		} else {
			/* gqtĂȂȂ */
			ifname = ChgExt(fname, XTR_EXT);		/* ".XTR" t */
		}

		if ((ifp = fopen((char *)ifname, "r")) == NULL) {
#if UNIX
			if (!abs_fname_flg && !FNameHasPath(ifname)) {
				uchar *ifname2;
				ifname2 = NULL;
				if (xtrpath && (ifname2 = PathFName(xtrpath, ifname)) != NULL)
					ifp = fopen((char *)ifname2, "r");
#ifdef XTRPATH
				if (ifp == NULL) {
					ifname2 = (uchar *)XMalloc(strlen(XTRPATH) + strlen((char *)ifname) + 2);
					PathCat((uchar *)strcpy((char *)ifname2, XTRPATH), ifname);
					ifp = fopen((char *)ifname2, "r");
				}
#endif
				if (ifp == NULL)
					Error("Can't open file: %s", ifname);
				if (ifname != fname)
					XFree((voidstar)ifname);
				ifname = ifname2;
			}
#else /* !UNIX */
			if (!abs_fname_flg && xtrpath && !FNameHasPath(ifname)) {
				/* t@CJgfBNgɂȂ XTRPATH 
				   `Ă */
				uchar *ifname2 = PathFName(xtrpath, ifname);
				
				if (!ifname2 || (ifp = fopen(ifname2, "r")) == NULL) {
					Error("Can't open file: %s", ifname);
				}
				if (ifname != fname) XFree((voidstar)ifname);
				ifname = ifname2;
			}
#endif /* !UNIX */
			else {
				Error("Can't open file: %s", ifname);
			}
		}
		if (sbufp != SBUFBTM) {
			/* \[XeLXgobt@łȂ */
			sbufp2 = DupStrDiff(sbufp, SBUFBTM);	/* Rs[ */
			sbufp = SBUFBTM;						/* NA */
		}
		includeflag = ON;
		inmtextflag = OFF;
		SetInMode(ifp);
		ifilename = ifname;
		Trans();						/* s */
		Disp(1);						/* soߕ\ */
		fclose(ifp);
	}
	ifilename = ifilename0;
	ifp = ifp0;
	SetInMode(ifp);
	ilineno = ilineno0;
	nlcount = nlcount0;
	includeflag = includeflag0;
	inmtextflag = inmtextflag0;

	if (!includeflag)
		SetFModeB(binarymode);
	if (!emode && !includeflag)
		Command(eclrcmd);

	if (sbufp2) {
		/* Õ\[XeLXgobt@eLĂȂ */
		sbufp = sbufp0;
		memcpy(sbufp, sbufp2, SBUFBTM - sbufp);		/*  */
		XFree((voidstar)sbufp2);
	}
	/* ÕG[߂ꏊɖ߂ */
	memcpy(errorjb, errorjb0, sizeof(jmp_buf));
}

#if UNIX
int
ismbchar(int c)
{
	return IsKanji1(c);
}

#if DIRECT_SH
void
include_fd(int fd)
{
	uchar *save_ifilename = ifilename;
	FILE *save_ifp = ifp;
	unsigned save_ilineno = ilineno;
	unsigned save_nlcount = nlcount;
	int save_includeflag = includeflag;
	int save_inmtextflag = inmtextflag;
	uchar *save_sbufp = sbufp;
	uchar *sbufp2 = NULL;
	jmp_buf save_errorjb;

	memcpy(save_errorjb, errorjb, sizeof(jmp_buf));

	if (setjmp(errorjb) == 0) {
		if (!intextflag) {
			SetFModeB(0);
			Command(esetcmd);
		}
		ifp = fdopen(fd, "r");
		if (sbufp != SBUFBTM) {
			sbufp2 = DupStrDiff(sbufp, SBUFBTM);
			sbufp = SBUFBTM;
		}
		includeflag = ON;
		inmtextflag = OFF;
		SetInMode(ifp);
		ifilename = "(pipe)";
		Trans();
		Disp(1);
		fclose(ifp);
	}
	ifilename = save_ifilename;
	ifp = save_ifp;
	SetInMode(ifp);
	ilineno = save_ilineno;
	nlcount = save_nlcount;
	includeflag = save_includeflag;
	inmtextflag = save_inmtextflag;

	if (!includeflag)
		SetFModeB(binarymode);
	if (!emode && !includeflag)
		Command(eclrcmd);

	if (sbufp2) {
		sbufp = save_sbufp;
		memcpy(sbufp, sbufp2, SBUFBTM - sbufp);
		XFree((voidstar)sbufp2);
	}

	memcpy(errorjb, save_errorjb, sizeof(jmp_buf));
}
#endif /* DIRECT_SH */
#endif /* UNIX */

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
