/* getchr.c */
/*****************************************************************************
					s@o@wsq

							meLXǵn
*****************************************************************************/

#include "xtr.h"

#ifdef UNIX
#define is_kanji(c) ismbuchar(c)
#define is_kanji2(c) ismblchar(c)
#else
#define is_kanji(c) iskanji(c)
#define is_kanji2(c) iskanji2(c)
#endif
#define SBufErr()			FError(f_SBufErr)
#define IBufErr()			FError(f_IBufErr)
static uchar f_SBufErr[] = "Source buffer over";
static uchar f_IBufErr[] = "Input buffer over";


/****************************************************************************/
/*							eLXg									*/
/***************************** GetChr ***************************************/

unsigned
GetChr(void)
/*  ꕶǂ */
{
	int c1, c2;

	if (sbufp == SBUFBTM) {
#ifdef UNIX
		if (inmtextflag || (c1 = getc(ifp)) == EOF)
		  return EOF2;

#ifndef __human68k__
		if (!binarymode && c1 == '\r')
			if ((c2 = getc(ifp)) == '\n')
				c1 = c2;
			else
				ungetc(c2, ifp);
#endif
#else /* !UNIX */
		if (inmtextflag || (c1 = getc(ifp)) == EOF ||
						   c1 == EOFCHAR && !binarymode)
			return (EOF2);
#endif /* !UNIX */
		if (is_kanji(c1) && !nokanjimode) {
			if ((c2 = getc(ifp)) == EOF)
				return (c1);
			else if (is_kanji2(c2))
#ifdef UNIX
				return (*MB2S)(c1, c2);
#else
				return (MkMoji(c1, c2));
#endif
			else {
				if (c2 == '\n') {
					nlcount++;
				}
				UngetChr(c2);
				return (c1);
			}
		} else {
			if (c1 == '\n')
				nlcount++;
			return (c1);
		}
	} else {
		assert(sbufp < SBUFBTM);
		c1 = *sbufp++;
		if (iskanji(c1) && !nokanjimode && sbufp < SBUFBTM) {
			c2 = *sbufp++;
			if (iskanji2(c2))
				return (MkMoji(c1, c2));
			else {
				UngetChr(c2);
				return (c1);
			}
		} else {
			return (c1);
		}
	}
}


void
UngetChr(unsigned c)
/* P߂ */
{
	if (c == EOF2)
		return;

	if (sbufp <= sbuf)
		SBufErr();
	
	if (Is1B(c)) {
		*--sbufp = c;
	} else {
		*--sbufp = Moji_2(c);
		if (sbufp <= sbuf)
			SBufErr();
		
		*--sbufp = Moji_1(c);
	}
}


void
UngetN(const uchar *str, int n)
/*  str  n oCg߂ */
{
	if (sbufp - n < sbuf)
		SBufErr();

	sbufp -= n;
	memcpy(sbufp, str, n);

#if MSDOS || WINNT || __human68k__
	/* }NŖ[vɂĂ ^C Œfł悤 */
	(void)kbhit();
#endif
}


static int lookflag = OFF;

unsigned
LookChr(void)
/* ꕶǂ݂ */
{
	unsigned c;

	if (!lookflag) {
		lookflag = ON;
		ibufp = ibuf;
	}
	if ((c = GetChr()) != EOF2)
		ibufp += SetMoji(c, ibufp);
	return (c);
}



void
UnlookChrs(void)
/* ǂ݂߂ */
{
	UngetN(ibuf, ibufp - ibuf);
	ibufp = ibuf;
	lookflag = OFF;
}



int
GetStr(int n, int gmode)
/* oCg܂ŁAAŌオXy[XE^uȂ炳ɔ󔒕s܂
 * ǂ ibuf Ɋi[Aۂɓǂ񂾃oCgԂB
 */
{
	unsigned c = 0;

	for (ibufp = ibuf;
			(ibufp - ibuf < n || (gmode & G_WILD)) && (c = GetChr()) != EOF2;
			) {
		ibufp += SetMoji(c, ibufp);
		if (c == '\n' && (!(gmode & G_OVERNL) || ibufp - ibuf > n))
			break;
	}

	if (IsHSpace(c)) {
		while ((c = GetChr()) != EOF2
			   && (ibufp += SetMoji(c, ibufp), IsHSpace(c)) );
	}

	if (ibufp >= ibuf + IBUFSIZE)
		IBufErr();

	*ibufp = '\0';
	return ibufp - ibuf;
}


void
UngetStrN(int n)
/* oCg߂ */
{
	assert(ibufp - n >= ibuf);
	UngetN(ibufp - n, n);
}



void
GetSkipSpace(void)
/* ǂ݂ăXy[XƂ΂ */
{
	unsigned c;

	while (c = GetChr(), IsHSpace(c));

	UngetChr(c);
}


int
GetLine(void)
/* s܂œǂŉs܂ ibuf Ɋi[B
 * ǂݍ񂾕ԂB
 * cont_enable_flag ^̏ꍇ͌ps\ƂB
 * is̑O̕ '\\' Ȃ玟̍sǂށj
 */
{
	unsigned c = 0;
	ibufp = ibuf;

	while (c != '\n' && (c = GetChr()) != EOF2) {
		if (ibufp >= ibuf + IBUFSIZE - 2)
			IBufErr();

		ibufp += SetMoji(c, ibufp);
	}
	*ibufp = '\0';
	return ibufp - ibuf;
}


void
ILineNoCount(void)
{
	if (sbufp == SBUFBTM) {
		/* \[XeLXgobt@Ȃ */
		ilineno = nlcount + 1;	/* ͍sԍsɂ킹 */
	} else if (!inmtextflag) {
		ilineno++;		/* ͍sԍJEg */
	}
}

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
