/* funcs.c */
/*****************************************************************************
					s@o@wsq

						mgݍ݊֐EVXeϐn
*****************************************************************************/

#include "xtr.h"


/******************************** `֐ ********************************/

enum SFVAR {
	SFVAR_p,
	SFVAR_P,
	SFVAR_i,
	SFVAR_I,
	SFVAR_f,
	SFVAR_F,
	SFVAR_n,
	SFVAR_N,
	SFVAR_y,
	SFVAR_Y,
	SFVAR_year,
	SFVAR_Year,
	SFVAR_m,
	SFVAR_M,
	SFVAR_mon,
	SFVAR_Mon,
	SFVAR_month,
	SFVAR_Month,
	SFVAR_d,
	SFVAR_D,
	SFVAR_day,
	SFVAR_Day,
	SFVAR_w,
	SFVAR_W,
	SFVAR_wday,
	SFVAR_Wday,
	SFVAR_youbi,
	SFVAR_Youbi,
	SFVAR_t,
	SFVAR_T,
	SFVAR_hh,
	SFVAR_HH,
	SFVAR_h,
	SFVAR_H,
	SFVAR_ampm,
	SFVAR_AMPM,
	SFVAR_mm,
	SFVAR_MM,
	SFVAR_ss,
	SFVAR_SS,
	SFVAR_tmp,
	SFVAR_ret,
#if UNIX
	SFVAR_pid,
#endif
	SFVAR_xtrver,
	SFVAR_xtrprog,
	SFVAR_stackptr,
	SFVAR_coreleft,
	N_SFVAR,
};

uchar *sfvartbl[] = {
	"p",
	"P",
	"i",
	"I",
	"f",
	"F",
	"n",
	"N",
	"y",
	"Y",
	"year",
	"Year",
	"m",
	"M",
	"mon",
	"Mon",
	"month",
	"Month",
	"d",
	"D",
	"day",
	"Day",
	"w",
	"W",
	"wday",
	"Wday",
	"youbi",
	"Youbi",
	"t",
	"T",
	"hh",
	"HH",
	"h",
	"H",
	"ampm",
	"AMPM",
	"mm",
	"MM",
	"ss",
	"SS",
	"tmp",
	"ret",
#if UNIX
	"pid",
#endif
	"xtrver",
	"xtrprog",
	"stackptr",
	"coreleft",
};

static time_t tim = -1;
static time_t ftim = -1;

static struct tm *
GetTm(int tmode)
{
	static uchar *previfilename = NULL;
	time_t tt = -1;

	if (tim == -1)
		tim = time((time_t *)NULL);

	if (ifilename != previfilename) {
		struct stat st;
		fstat(fileno(ifp), &st);
#if UNIX
		ftim = st.st_mtime ? st.st_mtime : tim;
#else
		ftim = st.st_atime ? st.st_atime : tim;
#endif
		previfilename = ifilename;
	}
	tt = tmode == 0 ? tim : tmode == 1 ? ftim : time((time_t *)NULL);
	return localtime(&tt);
}

#define StrFTm(fmt, tmode)	strftime((char *)valbuf, 32, fmt, GetTm(tmode))

static uchar youbis[] = "\
\223\372\214\216\211\316\220\205\226\330\213\340\223\171";
/* ΐ؋y */

uchar *
GetSFVar(int *lenp, const uchar *name)
/* Special variable ̒lo */
/* lRs[ÓÏւ̃|C^Ԃ */
/* `Ȃ NULL Ԃ */
{
	static uchar valbuf[80];
	int len = -1;
	int i;

	assert(lenp != NULL);
	assert(name != NULL);

	assert(N_SFVAR == sizeof(sfvartbl) / sizeof(sfvartbl[0]));

	if (tim == -1)
		tim = time((time_t *)NULL);

	for (i = 0; i < N_SFVAR && !equ(sfvartbl[i], name); i++);

	if (i == N_SFVAR)
		return NULL;

	switch(i) {
	case SFVAR_p:
		len = WtNum(valbuf, pageno);
		break;
	case SFVAR_P:
		len = WtNum(valbuf, abspageno);
		break;
	case SFVAR_i:
		len = MkRomNum(valbuf, pageno, 0);
		break;
	case SFVAR_I:
		len = MkRomNum(valbuf, pageno, 1);
		break;
	case SFVAR_f:
		len = CopyStr(valbuf, ofilename);
		break;
	case SFVAR_F:
		len = CopyStr(valbuf, ifilename);
		break;
	case SFVAR_n:
		sprintf((char *)valbuf, "%u", lineno);
		len = strlen((char *)valbuf);
		break;
	case SFVAR_N:
		sprintf((char *)valbuf, "%u", ilineno);
		len = strlen((char *)valbuf);
		break;

	/* ݎ^̓t@C^CX^v */
	case SFVAR_y:
		len = WtNum(valbuf, GetTm(0)->tm_year % 100);
		break;
	case SFVAR_Y:
		len = WtNum(valbuf, GetTm(1)->tm_year % 100);
		break;
	case SFVAR_year:
		len = WtNum(valbuf, GetTm(0)->tm_year + 1900);
		break;
	case SFVAR_Year:
		len = WtNum(valbuf, GetTm(1)->tm_year + 1900);
		break;
	case SFVAR_m:
		len = WtNum(valbuf, GetTm(0)->tm_mon + 1);
		break;
	case SFVAR_M:
		len = WtNum(valbuf, GetTm(1)->tm_mon + 1);
		break;
	case SFVAR_mon:										/* Jan ...*/
		len = StrFTm("%b", 0);
		break;
	case SFVAR_Mon:
		len = StrFTm("%b", 1);
		break;
	case SFVAR_month:									/* January ...*/
		len = StrFTm("%B", 0);
		break;
	case SFVAR_Month:
		len = StrFTm("%B", 1);
		break;
	case SFVAR_d:
		len = WtNum(valbuf, GetTm(0)->tm_mday);
		break;
	case SFVAR_D:
		len = WtNum(valbuf, GetTm(1)->tm_mday);
		break;
	case SFVAR_day:										/* 31th */
		len = MkNthNum(valbuf, GetTm(0)->tm_mday);
		break;
	case SFVAR_Day:
		len = MkNthNum(valbuf, GetTm(1)->tm_mday);
		break;
	case SFVAR_w:										/* Sun ...*/
		len = StrFTm("%a", 0);
		break;
	case SFVAR_W:
		len = StrFTm("%a", 1);
		break;
	case SFVAR_wday:									/* Sunday ...*/
		len = StrFTm("%A", 0);
		break;
	case SFVAR_Wday:
		len = StrFTm("%A", 1);
		break;
	case SFVAR_youbi:									/* ...*/
		sprintf((char *)valbuf, "%2.2s", youbis + GetTm(0)->tm_wday * 2);
		len = strlen((char *)valbuf);
		break;
	case SFVAR_Youbi:
		sprintf((char *)valbuf, "%2.2s", youbis + GetTm(1)->tm_wday * 2);
		len = strlen((char *)valbuf);
		break;
	case SFVAR_t:
		sprintf((char *)valbuf, "%d:%02d", GetTm(0)->tm_hour, GetTm(0)->tm_min);
		len = strlen((char *)valbuf);
		break;
	case SFVAR_T:
		sprintf((char *)valbuf, "%d:%02d", GetTm(1)->tm_hour, GetTm(1)->tm_min);
		len = strlen((char *)valbuf);
		break;
	case SFVAR_hh:
		len = WtNum(valbuf, GetTm(0)->tm_hour);
		break;
	case SFVAR_HH:
		len = WtNum(valbuf, GetTm(1)->tm_hour);
		break;
	case SFVAR_h:
		len = WtNum(valbuf, 1 + (GetTm(0)->tm_hour + 11) % 12);
		break;
	case SFVAR_H:
		len = WtNum(valbuf, 1 + (GetTm(1)->tm_hour + 11) % 12);
		break;
	case SFVAR_ampm:
		len = StrFTm("%p", 0);
		break;
	case SFVAR_AMPM:
		len = StrFTm("%p", 1);
		break;
	case SFVAR_mm:
		len = WtNum(valbuf, GetTm(0)->tm_min);
		break;
	case SFVAR_MM:
		len = WtNum(valbuf, GetTm(1)->tm_min);
		break;
	case SFVAR_ss:
		len = WtNum(valbuf, GetTm(0)->tm_sec);
		break;
	case SFVAR_SS:
		len = WtNum(valbuf, GetTm(1)->tm_sec);
		break;

	/* ̑ */
	case SFVAR_tmp:
		if (tmppath != NULL)
			len = CopyStr(valbuf, tmppath);
		break;
	case SFVAR_ret:
		if (retvalue.s != NULL) {
			*lenp = retvalue.len;
			return retvalue.s;
		}
		break;
#if UNIX
	case SFVAR_pid:
		len = WtNum(valbuf, (int)getpid());
		break;
#endif
	case SFVAR_xtrver:
		len = CopyStr(valbuf, xtrver);
		break;
	case SFVAR_xtrprog:
		len = CopyStr(valbuf, xtrprog);
		break;
	/* foOp */
	case SFVAR_stackptr:
		len = WtNumber(valbuf, (unsigned)(&name));
							/* X^bN|C^̒l̕t */
		break;
	case SFVAR_coreleft:
#ifdef __TURBOC__
		len = WtNumber(valbuf, coreleft());	/* gp̃ */
#endif
		break;
	default:
		assert(FALSE);
	}
	if (len < 0)
		len = 0;
	
	valbuf[len] = '\0';
	*lenp = len;
	return valbuf;
}



/****************************** gݍ݊֐ ******************************/

#ifdef _MSC_VER
 #pragma warning(disable:4100)	/* QƂ̃[jOoȂ */
#endif
#ifdef __TURBOC__
 #pragma warn -par				/* Warning OFF: Parameter never used */
#endif

static int
SF_code(uchar *dst, const uchar *src, int len, int i, int w)
{
	if (fargc == 2 && (i < 0 || i >= len))
		return WtNum(dst, 0);
	
	if (fargc < 3) {
		if (NthIsKanji2(src, i))
			--i;
		return WtNumber(dst, Moji(src+i));
	} else {
		int 	n = Abs(w);
		int   	revflag = w < 0 ? TRUE : FALSE;
		unsigned long c = 0;
		int		j;
		const uchar	*p;

		for (j = 0; j < n; j++) {
			c *= 0x100;
			p = src + i + (revflag ? n - j - 1 : j);
			if (p >= src && p < src+len)
				c += *p;
		}
		return WtNumber(dst, (exprval_t)(exprintval_t)c);
	}
}
static int
SF_chr(uchar *dst, exprval_t code, exprval_t w)
{
	unsigned long c = (long)code;
	int 	n = (int)Abs(w);
	int   	revflag = w < 0 ? TRUE : FALSE;
	int 	i;
	
	if (fargc < 2) {
		if (c < 0x100) {
			n = 1;
		} else {
			n = 2;
			if (!(iskanji(Moji_1(c)) && iskanji2(Moji_2(c)))) {
				/* LShift-JISR[hłȂȂ */
				c = jistojms((ushort)c);	/* JISShift-JIS ϊ */
				if (c == 0) {
					n = 0;
				}
			}
		}
	}
	for (i = 0; i < n; i++) {
		dst[revflag ? i : n - i - 1] = (uchar)c;
		c /= 0x100;
	}
	dst[n] = '\0';
	return n;
}

static int
SF_len(uchar *dst, const uchar *src, int len)
{
	return WtNum(dst, len);
}
static int
SF_jlen(uchar *dst, const uchar *src, int len)
{
	return WtNum(dst, btom((const char *)src, len));
}
static int
SF_btom(uchar *dst, const uchar *src, int len, int n)
{
	return WtNum(dst, btom((const char *)src, n));
}
static int
SF_mtob(uchar *dst, const uchar *src, int len, int n)
{
	return WtNum(dst, mtob((const char *)src, n));
}
static int
SF_substr(uchar *dst, const uchar *src, int len, int i, int n)
{
	if (fargc < 3)
		n = len;
	return SubStr(dst, src, len, i, n);
}
static int
SF_rsubstr(uchar *dst, const uchar *src, int len, int i, int n)
{
	if (fargc < 3)
		n = len;
	return SubStr(dst, src, len, len - i, n);
}
static int
SF_bsubstr(uchar *dst, const uchar *src, int len, int i, int n)
{
	if (fargc < 3)
		n = len;
	return BSubStr(dst, src, len, i, n);
}
static int
SF_brsubstr(uchar *dst, const uchar *src, int len, int i, int n)
{
	if (fargc < 3)
		n = len;
	return BSubStr(dst, src, len, len - i, n);
}
static int
SF_jsubstr(uchar *dst, const uchar *src, int len, int i, int n)
{
	if (i < 0)
		i = 0;
	if (fargc < 3)
		n = btom((const char *)src, len) - i;
	else if (n < 0)
		n = 0;
	i = mtob((const char *)src, i);
	n = mtob((const char *)src + i, n);
	return SubStr(dst, src, len, i, n);
}
static int
SF_jrsubstr(uchar *dst, const uchar *src, int len, int i, int n)
{
	if (i < 0)
		i = 0;
	if (fargc < 3)
		n = i;
	else if (n < 0)
		n = 0;
	i = mtob((const char *)src, btom((const char *)src, len) - i);
	n = mtob((const char *)src + i, n);
	return SubStr(dst, src, len, i, n);
}
static int
SF_index(uchar *dst, const uchar *str1, int len1, const uchar *str2, int len2)
{
	const uchar *p;
	int val = -1;
	if (str2) {
		p = (const uchar *)(nokanjimode ? strstr((const char *)str1, (const char *)str2) : jstrstr((const char *)str1, (const char *)str2));
		if (p) val = p - str1;
	}
	return WtNum(dst, val);
}

static int
SF_bindex(uchar *dst, const uchar *str1, int len1, const uchar *str2, int len2)
{
	int val = -1;
	if (str2) {
		val = BIndex(str1, len1, str2, len2);
	}
	return WtNum(dst, val);
}

static int
SF_jindex(uchar *dst, const uchar *str1, int len1, const uchar *str2, int len2)
{
	const uchar *p;
	int val = -1;
	if (str2) {
		p = (const uchar *)(nokanjimode ? strstr((const char *)str1, (const char *)str2) : jstrstr((const char *)str1, (const char *)str2));
		if (p) val = btom((const char *)str1, p - str1);
	}
	return WtNum(dst, val);
}

static int
SF_comma(uchar *dst, const uchar *src, int len,	const uchar *comma, int commalen, int n)
{
	if (fargc < 3)
		n = 3;
	return StrCommaNum(dst, src, len, comma, commalen, n);
}

static int
SF_strspn(uchar *dst, const uchar *str, int len, const uchar *chrs, int chrslen)
{
	return WtNum(dst, StrSpn(str, chrs));
}

static int
SF_strcspn(uchar *dst, const uchar *str, int len, const uchar *chrs, int chrslen)
{
	return WtNum(dst, StrCSpn(str, chrs));
}

static int
SF_strrspn(uchar *dst, const uchar *str, int len, const uchar *chrs, int chrslen)
{
	return WtNum(dst, StrRSpn(str, len, chrs));
}

static int
SF_strrcspn(uchar *dst, const uchar *str, int len, const uchar *chrs, int chrslen)
{
	return WtNum(dst, StrRCSpn(str, len, chrs));
}

static int
SF_jstrspn(uchar *dst, const uchar *str, int len, const uchar *chrs, int chrslen)
{
	return WtNum(dst, btom((const char *)str, StrSpn(str, chrs)));
}

static int
SF_jstrcspn(uchar *dst, const uchar *str, int len, const uchar *chrs, int chrslen)
{
	return WtNum(dst, btom((const char *)str, StrCSpn(str, chrs)));
}

static int
SF_jstrrspn(uchar *dst, const uchar *str, int len, const uchar *chrs, int chrslen)
{
	int spn = StrRSpn(str, len, chrs);
	return WtNum(dst, btom((const char *)str + len - spn, spn));
}

static int
SF_jstrrcspn(uchar *dst, const uchar *str, int len, const uchar *chrs, int chrslen)
{
	int spn = StrRCSpn(str, len, chrs);
	return WtNum(dst, btom((const char *)str + len - spn, spn));
}

static int
SF_ltrim(uchar *dst, const uchar *src, int len, const uchar *chrs, int chrslen)
{
	int spn = StrSpn(src, chrs);
	return CopyStrN(dst, src + spn, len - spn);
}

static int
SF_rtrim(uchar *dst, const uchar *src, int len, const uchar *chrs, int chrslen)
{
	len -= StrRSpn(src, len, chrs);
	return CopyStrN(dst, src, len);
}

static int
SF_trim(uchar *dst, const uchar *src, int len, const uchar *chrs, int chrslen)
{
	int spn = StrSpn(src, chrs);
	return SF_rtrim(dst, src + spn, len - spn, chrs, chrslen);
}


static int
SF_expr(uchar *dst, const uchar *str, int len, int level)
{
	const uchar *p = str;
	skipmode_t skipmode = level < 100 ? SKIP_ELSE0 : SKIP_NORMAL;

	if (fargc < 2)
		level = 3;

	level %= 100;

	switch (level) {
	case 0:
	case 1:
	case 2:
	case 3:
		p = SkipExpr(str, (evlev_t)level, skipmode);
		break;
	case 5:
		p = SkipCommandArg(str);
		break;
	default:
		;
	}
	return WtNum(dst, p - str);
}

static int
SF_num(uchar *dst, const uchar *str)
{
	const uchar *p;

	RdNumber(str, &p);
	return WtNum(dst, p - str);
}

static int
SF_val(uchar *dst, const uchar *str, int len, int radix)
{
	const uchar *p;
	exprval_t	val = radix ? (exprval_t)strtol((const char *)str, (char**)&p, radix)
							: RdNumber(str, &p);
	return WtNumber(dst, p == str ? 0 : val);
}

static int
SF_hex(uchar *dst, const uchar *str, int len, int radix)
{
	return SF_val(dst, str, len, radix ? radix : 16);
}

#if 0	/* {c */
static int
SF_pairspn(uchar *dst, const uchar *str, int len, int rpar)
{
	if (!str || !*str || IsKanjiStr(str))
		return WtNum(dst, 0);
	else {
		int lpar = *str;
		const uchar *p;
		if (fargc < 2) {
			rpar = lpar == '(' ? ')'
				 : lpar == '{' ? '}'
				 : lpar == '[' ? ']'
				 : lpar == '<' ? '>'
				 : lpar;
		}
		p = PairSearch(str+1, lpar, rpar);
		if (p)
			p++;
		else
			p = str;
		return WtNum(dst, p - str);
	}
}
#endif


static int
SF_arg(uchar *dst, exprval_t n)
{
	return CopyArg(dst, (int)n);
}

static int
SF_argtyp(uchar *dst, exprval_t n)
{
	int i = (int)n;
	return WtNum(dst, (margv && i <= margc) ? (int)(margv[i].typ) : 0);
}

static int
SF_write(uchar *dst, const uchar *src, int len)
{
	WriteNN(src, len);
	return 0;
}

static int
SF_writeln(uchar *dst, const uchar *src, int len)
{
	WriteNN(src, len);
	WriteNN("\n", 1);
	return 0;
}

static int
SF_cwrite(uchar *dst, const uchar *src, int len)
{
	WriteNC(src, len);
	return 0;
}

static int
SF_rpl(uchar *dst, const uchar *str, int len, int mode)
/* modeF
     0        `݃`FbN
     1        pBꕔ͕̂̂ԂȂB
     2        pBׂĕԂB
     3        pȂBׂĕԂB
*/
{
	if (fargc < 2)
		mode = 3;

	if (RplStr(str, mode)) {
		if (mode == 0)
			return WtNum(dst, 1);
		else
			return CopyStrN(dst, cbuf, clength);
	} else {
		if (mode == 0)
			return WtNum(dst, 0);
		else
			return 0;
	}
}

static int
SF_put(uchar *dst, const uchar *src, int len)
{
	PutStrN(src, len);
	return 0;
}

static int
SF_cput(uchar *dst, const uchar *src, int len)
{
	PutCntrl1(src, len);
	return 0;
}

static int
SF_get(uchar *dst, exprval_t n)
{
	uchar *dstp = dst;
	unsigned c = 0;
	int i = fargc == 0 ? -1 : (int)n;

	while ((i == -1 ? c != '\n' : i-- > 0)
		   && (c = GetChr()) != EOF2)
		dstp += SetMoji(c, dstp);
	*dstp = '\0';
	return dstp - dst;
}

static int
SF_read(uchar *dst, exprval_t n)
{
	if (!inmtextflag)
		return SF_get(dst, n);
	else {
		int inmtextflag0 = inmtextflag;
		uchar *sbufp0 = sbufp;
		int len;
		inmtextflag = OFF;
		sbufp = SBUFBTM;
		len = SF_get(dst, n);
		inmtextflag = inmtextflag0;
		sbufp = sbufp0;
		return len;
	}
}

static int
SF_unget(uchar *dst, const uchar *src, int len)
{
	UngetN(src, len);
	return 0;
}

static int
SF_mtext(uchar *dst, const uchar *src, int len)
{
	DoText(src, len);
	return 0;
}

static int
SF_text(uchar *dst, const uchar *src, int len)
{
	int rplmode0 = rplmode;
	rplmode = OFF;
	DoText(src, len);
	rplmode = rplmode0;
	return 0;
}

static int
SF_msg(uchar *dst, const uchar *src)
{
#if UNIX
	uchar *mbs;

	mbs = alloca(strlen((char *)src) * 2 + 1);
	sjis2mbstring((char *)mbs, (char *)src);
	Message("%s", mbs);
#else /* !UNIX */
	Message("%s", src);
#endif /* !UNIX */
	return 0;
}

static int
SF_error(uchar *dst, const uchar *src)
{
#if UNIX
	if (*src) {
		uchar *mbs = (uchar *)alloca(strlen((char *)src) * 2 + 1);
		sjis2mbstring((char *)mbs, (char *)src);
		Error("%s", mbs);
	} else
		Error((uchar *)NULL);
#else
	Error(*src ? (uchar *)"%s" : (uchar *)NULL, src);
#endif
	return 0;		/* Never return */
}

static int
SF_ferror(uchar *dst, const uchar *src)
{
#if UNIX
	if (*src) {
		uchar *mbs = (uchar *)alloca(strlen((char *)src) * 2 + 1);
		sjis2mbstring((char *)mbs, (char *)src);
		FError("%s", mbs);
	} else
		FError((uchar *)NULL);
#else
	FError(*src ? (uchar *)"%s" : (uchar *)NULL, src);
#endif
	return 0;		/* Never return */
}

static int
SF_exit(uchar *dst, exprval_t n)
{
	Terminate((int)n);
	return 0;		/* Never return */
}

static int
SF_cmd(uchar *dst, const uchar *src)
{
	Command(src);
	return CopyStrN(dst, retvalue.s, retvalue.len);
}

static int
SF_cmd0(uchar *dst, const uchar *src)
{
	Command(src);
	return 0;
}

static int
SF_setind(uchar *dst, exprval_t n)
{
	indentsetflag = ON;
	if (fargc == 0) {
		aindent = x;
	} else {
		aindent = (int)n;
		if (aindent < 0) {
			aindent = -aindent;
			indentsetflag = OFF;
		}
	}
	return 0;
}

static int
SF_setaj(uchar *dst, exprval_t n)
{
	int pos = fargc == 0 ? x : (int)n;

	SetSpAdjPos(pos);
	return 0;
}

static int
SF_cutsp(uchar *dst, exprval_t n)
{
	int mode = (int)n;

	if (mode == 0) {
		if (!linebreak && madaindentflag) {
			DelSpaces();
			while (x < bindent)
				PutChr(SP);
		}
	} else {
		if (mode & 1) {
			if (!madaindentflag)
				DelSpaces();
		}
		if (mode & 2) {
			GetSkipSpace();
		}
	}
	return 0;
}

static int
SF_cvt(uchar *dst, const uchar *fstr, int flen, const uchar *vstr, int vlen)
{
	return PFormat(dst, fstr, vstr, vlen);
}

static int
SF_defined(uchar *dst, const uchar *str)
{
	return WtNum(dst, GetMacro(str) != NULL);
}

static exprval_t CDECL
SF_sval(exprval_t a)
{
	return a;
}

static exprval_t CDECL
SF_abs(exprval_t a)
{
	return a < 0 ? -a : a;
}

#if UNIX

#ifndef HAVE_RANDOM_FUNCS
extern char *initstate ARGS((unsigned int, char *, int));
extern char *setstate ARGS((char *));
#ifndef __human68k__
extern long random ARGS((void));
extern void srandom ARGS((unsigned int));
#endif /* !__human68k__ */
#endif /* !HAVE_RANDOM_FUNCS */

#define RANDOM_MAX 0x7fffffff

static char random_state[512];

#else /* !UNIX */

#define initstate(seed,state,n)
#define setstate(state)
#define random() rand()
#define srandom(seed) srand(seed)

#define RANDOM_MAX RAND_MAX

#endif /* !UNIX */

static int randinitflag = 1;

static int
SF_srand(uchar *dst, exprval_t n)
{
	if (randinitflag) {
		initstate((unsigned)1, random_state, sizeof(random_state));
	} else {
		setstate(random_state);
	}

	srandom(fargc == 0 ? (unsigned)time((time_t *)NULL) : (unsigned)n);
	randinitflag = 0;
	return 0;
}

static exprval_t CDECL
SF_rand(exprval_t n)
{
	if (randinitflag) {
		initstate((unsigned)1, random_state, sizeof(random_state));
		srandom((unsigned)time((time_t *)NULL));
		randinitflag = 0;
	}
#ifdef FLOATEXPR
	if (fargc == 0) {		/* Ȃ [0,1) ̗ */
		return (exprval_t)random() / (RANDOM_MAX+1.0)
			 + (exprval_t)random() / ((RANDOM_MAX+1.0) * (RANDOM_MAX+1.0))
			 + (exprval_t)random() /
			 				((RANDOM_MAX+1.0) * (RANDOM_MAX+1.0) * (RANDOM_MAX+1.0));
	}
#endif
	/* 0`n ̐ */
#if UNIX
	return (int)(n * (random() / (RANDOM_MAX+1.0)));
#else
	return (exprval_t)(((long)n * (long)random()) / (RANDOM_MAX+1L));
#endif
}


static exprval_t CDECL
SF_int(exprval_t a)
{
	return (exprval_t)(exprintval_t)a;
}


#ifdef FLOATEXPR

static exprval_t CDECL
SF_trunc(exprval_t a)
{
	return a < 0 ? ceil(a) : floor(a);
}

static exprval_t CDECL
SF_round(exprval_t a)
{
	exprval_t b = floor(a += 0.5);
	/*  (n+0.5) ̏ꍇAɂȂقɊۂ߂ */
	if (b == a && fmod(b, 2) != 0) {
		b -= 1;
	}
	return b;
}

#endif

static int
SF_fp(uchar *dst, const uchar *path)
{
	return CopyStrDiff(dst, path, FNameName(path));
}

static int
SF_fn(uchar *dst, const uchar *path, int plen, const uchar *fname, int nlen)
{
	if (fargc < 2) {
		strcpy((char *)dst, (char *)FNameName(path));
	} else {
		strcpy((char *)dst, (const char *)path);
		PathCat(dst, fname);
	}
	return strlen((char *)dst);
}

static int
SF_fb(uchar *dst, const uchar *path)
{
	uchar *ext;

	ext = FNameExt(path);
	return CopyStrDiff(dst, path, ext ? ext : path + strlen(path));
}

static int
SF_fe(uchar *dst, const uchar *path, int plen, const uchar *fext, int elen)
{
	uchar *ext;

	if (fargc < 2) {
		ext = FNameExt(path);
		strcpy((char *)dst, ext ? (char *)ext : "");
	} else {
		uchar *newpath = ChgExt(path, fext);
		strcpy((char *)dst, (char *)newpath);
		XFree((voidstar)newpath);
	}
	return strlen((char *)dst);
}

static int
SF_exist(uchar *dst, const uchar *path)
{
	return WtNum(dst, FileExists(path));
}

static uchar *prevfile = NULL;
static FILE *infp = NULL;

static int
SF_close(uchar *dst, const uchar *file)
{
	if (infp) {
		VFree(prevfile);
		fclose(infp);
		infp = NULL;
	}
	return 0;
}

static int
SF_eof(uchar *dst, const uchar *file)
{
	return WtNum(dst, infp && feof(infp));
}

static int
SF_input(uchar *dst, const uchar *file)
{
	int len = 0;
	FILE *fp;

	if (fargc == 0) {
		/* W */
		fflush(stderr);		/* bZ[Wo͂tbV */
		fp = stdin;
	} else {
		if (!prevfile || !*file || !SameFile(prevfile, file)) {
			SF_close((uchar *)NULL, (uchar *)NULL);
			if (!*file) {
				/* t@Cɋ󕶎w肷ƑÕt@C̃N[Ŷ*/
				return 0;
			}
			if ((infp = fopen((const char *)file, "r")) == NULL) {
				Error("Can't open file: %s", file);
			}
			prevfile = DupStr(file);
		}
		fp = infp;
	}
	if (fgets((char *)dst, evalbufsize, fp)) {
		len = strlen((char *)dst);
		if (len && dst[len-1] == '\n')
			dst[--len] = '\0';
	}
	return len;
}


static int
Inkey(uchar *dst, exprval_t mode)
{
	int m = (int)mode;

	if (m || kbhit()) {
		fflush(stderr);		/* bZ[Wo͂tbV */
		while (!kbhit());
		dst[0] = getch();
#if MSDOS || WINNT || __human68k__
		if (m == 2 && iskanji(dst[0])) {
			dst[1] = getch();
			return 2;
		}
#else
#endif
		return 1;
	}
	return 0;
}

static int
SF_inkey(uchar *dst, exprval_t mode)
{
#if MSDOS || WINNT || __human68k__
#define RawMode(f)
#endif
	int c;

	RawMode(ON);
	c = Inkey(dst, mode);
	RawMode(OFF);
	return c;
}

static int
TimeStr(uchar *dst, struct tm *t)
{
	sprintf((char *)dst, "%04d-%02d-%02d %02d:%02d:%02d",
			t->tm_year + 1900,
			t->tm_mon + 1,
			t->tm_mday,
			t->tm_hour,
			t->tm_min,
			t->tm_sec);
	return strlen((char *)dst);
}

static int
SF_time(uchar *dst, exprval_t mode)
{
	return TimeStr(dst, GetTm(fargc == 0 ? -1 : (int)mode));
}

#define ScanNum()		{\
	if (!isdigit(*p)) goto _fail;\
	num = (int)strtoul((char *)p, (char**)&p, 10);\
}

static time_t
TimeVal(const uchar *str)
{
	struct tm *t = localtime(&tim);
	const uchar *p = SkipSpace(str);
	int num;
	time_t tt;

	ScanNum();

	if (*p == '/' || *p == '-') {
		num = num >= 1900 ? num - 1900 : num < 70 ? 100 + num : num;
		t->tm_year = num;
		p++;
		ScanNum();
		if (*p != '/' && *p != '-')
			goto _fail;
		t->tm_mon = num - 1;
		p++;
		ScanNum();
		t->tm_mday = num;
		CutSpace(p);
		if (*p) {
			ScanNum();
		}
	} else if (*p != ':') {
		t = GetTm(num);
	}
	if (*p == ':') {
		t->tm_hour = num;
		p++;
		ScanNum();
		t->tm_min = num;
		if (*p == ':') {
			p++;
			ScanNum();
			t->tm_sec = num;
		} else {
			t->tm_sec = 0;
		}
	}
	if (*CutSpace(p) || (tt = mktime(t)) == -1)
		goto _fail;

	return tt;

_fail:
	return 0;
}

static time_t
SF_timeval(uchar *dst, const uchar *str)
{
	time_t tt;

	if (fargc == 0)
		tt = time((time_t *)NULL);
	else
		tt = TimeVal(str);
	return WtNumber(dst, (exprval_t)tt);
}

static int
SF_valtime(uchar *dst, exprval_t tval)
{
	time_t tt;

	if (fargc == 0)
		tt = tim;
	else
		tt = (time_t)tval;
	return TimeStr(dst, localtime(&tt));
}

static int
SF_settime(uchar *dst, const uchar *str)
{
	if (fargc == 0)
		tim = time((time_t *)NULL);
	else
		tim = TimeVal(str);
	return TimeStr(dst, localtime(&tim));
}


/**************************************************************************/
#ifdef MSDOS			/* MSDOS  i80x86 Ɉˑ */

static union REGS		regs;
static struct SREGS		sregs;

#ifndef MK_FP
#define MK_FP(seg,ofs)	((void FAR*)((ulong)(ushort)(seg)<<16|(ushort)(ofs)))
#endif

#endif

/* varadr(var[,mode])		*/
static int
SF_varadr(uchar *dst, const uchar *var, int vlen, int mode)
{
	int len;
	void FAR *p;
	if (!vlen || !(p = (void FAR*)GetVar(var, &len)) || len == 0) {
		uchar NEAR *nullptr = 0;
		p = (void FAR *)nullptr;
	}
#ifdef MSDOS
	{
		unsigned seg = FP_SEG(p);
		switch (mode) {
		case 1:
			sregs.ds = seg;
			break;
		case 2:
			sregs.es = seg;
			break;
		case 3:
			sregs.es = sregs.ds = seg;
			break;
		default:
			;
		}
	}
#endif
	return WtNumber(dst, (exprval_t)(exprintval_t)p);
}

/* peek(adr)				*/
static exprval_t CDECL
SF_peek(exprval_t a)
{
	if (fargc == 1) {
		ushort FAR* adr = (ushort FAR*)(long)a;
		return *adr;
	} else
		return 0;
}
/* peekb(adr)				*/
static exprval_t CDECL
SF_peekb(exprval_t a)
{
	if (fargc == 1) {
		uchar FAR* adr = (uchar FAR*)(long)a;
		return *adr;
	} else
		return 0;
}

/* poke(adr,val)			*/
static int
SF_poke(uchar *dst, exprval_t a, exprval_t val)
{
	if (fargc == 2) {
		ushort FAR* adr = (ushort FAR*)(long)a;
		*adr = (ushort)val;
	}
	return 0;
}
/* pokeb(adr,val)			*/
static int
SF_pokeb(uchar *dst, exprval_t a, exprval_t val)
{
	if (fargc == 2) {
		uchar FAR* adr = (uchar FAR*)(long)a;
		*adr = (uchar)val;
	}
	return 0;
}

/* peekstr(adr,n)			*/
static int
SF_peekstr(uchar *dst, exprval_t a, exprval_t n)
{
	if (fargc >= 1) {
		uchar FAR* adr = (uchar FAR*)(long)a;
		int len = fargc == 1 ? (IsKanjiStr(adr) ? 2 : 1) : (int)n;
		int nn = len;

		while (--nn >= 0) {
			*dst++ = *adr++;
		}
		return len;
	} else
		return 0;
}

/* pokestr(adr,str)			*/
static int
SF_pokestr(uchar *dst, const uchar *a, int alen, const uchar *src, int len)
{
	if (fargc == 2) {
		uchar FAR* adr = (uchar FAR *)(long)RdNumber(a, (const uchar **)NULL);

		while (--len >= 0) {
			*adr++ = *src++;
		}
	}
	return 0;
}

#ifdef MSDOS			/* MSDOS  i80x86 Ɉˑ */

#ifdef _MSC_VER
/* MSC  TurboC(++) Ŋ֐Ⴄ̂ŁATurboC(++) ɂ킹 */
 #define inport		inpw
 #define inportb	inp
 #define outport	outpw
 #define outportb	outp
#endif

/* ioport(port[,val])		*/
static exprval_t CDECL
SF_ioport(exprval_t a, exprval_t val)
{
	int port = (int)a;

	if (fargc == 0) {
		;
	} else if (fargc == 1) {
		val = (unsigned)inport(port);
	} else {
		outport(port, (unsigned)val);
	}
	return val;
}

/* ioportb(port[,val])		*/
static exprval_t CDECL
SF_ioportb(exprval_t a, exprval_t val)
{
	int port = (int)a;

	if (fargc == 0) {
		;
	} else if (fargc == 1) {
		val = (unsigned)inportb(port);
	} else {
		outportb(port, (uchar)val);
	}
	return val;
}

/* int86x(n)				*/
static int
SF_int86x(uchar *dst, exprval_t n)
{
	if (fargc == 1) {
		int intno = (int)n;
		int86x(intno, &regs, &regs, &sregs);
	}
	return 0;
}

/* segread([mode])			*/
static int
SF_segread(uchar *dst, exprval_t mode)
{
	segread(&sregs);
	return 0;
}

#endif				/* ܂ DOS  i80x86 ˑ֐ */

/**************************************************************************/

#define 	SF	sffnp_t

static struct SFFNTBL {
	uchar 		*name;
	sftype_t	typ;
	sffnp_t		fnptr;
} sffntbl[] = {
	{"int",		SX_X,		(SF)SF_int},		/* int(x)					*/
	{"abs",		SX_X,		(SF)SF_abs},		/* abs(n)					*/
	{"code",	SF_Sn_N_N,	(SF)SF_code},		/* code(str[,i[,n]])		*/
	{"chr",		SF_X_X,		(SF)SF_chr},		/* chr(code[,n])			*/
	{"len",		SF_Sn,		(SF)SF_len},		/* len(str) 				*/
	{"jlen",	SF_Sn,		(SF)SF_jlen},		/* jlen(str) 				*/
	{"upr",		SF_S,		(SF)StrUpper},		/* upr(str)					*/
	{"lwr",		SF_S,		(SF)StrLower},		/* lwr(str)					*/
	{"cap",		SF_S,		(SF)StrCapitalize},	/* cap(str)					*/
	{"cap1",	SF_S,		(SF)StrCapitalize1},/* cap1(str)				*/
	{"zen",		SF_S,		(SF)StrZen},		/* zen(str)					*/
	{"zen2",	SF_S,		(SF)StrZen2},		/* zen2(str)				*/
	{"zen3",	SF_S,		(SF)StrZen3},		/* zen3(str)				*/
	{"han",		SF_S,		(SF)StrHan},		/* han(str) 				*/
	{"han2",	SF_S,		(SF)StrHan2},		/* han2(str) 				*/
	{"han3",	SF_S,		(SF)StrHan3},		/* han3(str) 				*/
	{"jis",		SF_S,		(SF)StrJis},		/* jis(str) 				*/
	{"quo",		SF_Sn,		(SF)StrQuote},		/* quo(str)					*/
	{"quo2",	SF_Sn,		(SF)StrQuote2},		/* quo2(str)				*/
	{"unq",		SF_Sn,		(SF)ReadStringN},	/* unq(str) 				*/
	{"evalf",	SF_Sn,		(SF)EvalStringN},	/* evalf(str) 				*/
	{"eval",	SF_S,		(SF)EvalExprStr},	/* eval(str) 				*/
	{"substr",	SF_Sn_N_N,	(SF)SF_substr},		/* substr(str,i[,len])		*/
	{"bsubstr",	SF_Sn_N_N,	(SF)SF_bsubstr},	/* bsubstr(str,i[,len])		*/
	{"jsubstr",	SF_Sn_N_N,	(SF)SF_jsubstr},	/* jsubstr(str,i[,len]) 	*/
	{"rsubstr",	SF_Sn_N_N,	(SF)SF_rsubstr},	/* rsubstr(str,i[,len])		*/
	{"brsubstr",SF_Sn_N_N,	(SF)SF_brsubstr},	/* brsubstr(str,i[,len])	*/
	{"jrsubstr",SF_Sn_N_N,	(SF)SF_jrsubstr},	/* jrsubstr(str,i[,len])	*/
	{"index",	SF_Sn_Sn,	(SF)SF_index},		/* index(str1,str2) 		*/
	{"bindex",	SF_Sn_Sn,	(SF)SF_bindex},		/* bindex(str1,str2) 		*/
	{"jindex",	SF_Sn_Sn,	(SF)SF_jindex},		/* jindex(str1,str2) 		*/
	{"kan",		SF_Sn,		(SF)StrKanjiNum},	/* kan(str) 				*/
	{"cvt",		SF_Sn_Sn,	(SF)SF_cvt},		/* cvt(fmt,str) 			*/
	{"arg",		SF_X,		(SF)SF_arg},		/* arg(n)					*/
  	{"$",		SF_X,		(SF)SF_arg},		/* $(n)						*/
	{"argtyp",	SF_X,		(SF)SF_argtyp},		/* argtyp(n)				*/
	{"env",		SF_S,		(SF)CopyEnvVal},	/* env(n)					*/
	{"comma",	SF_Sn_Sn_N,	(SF)SF_comma},		/* comma(str[,comma[,n]])	*/
	{"rep",		SF_Sn_N,	(SF)StrRep},		/* rep(str,n) 				*/
	{"fil",		SF_Sn_N,	(SF)StrFil},		/* fil(str,len) 			*/
	{"strspn",	SF_Sn_Sn,	(SF)SF_strspn},		/* strspn(str[,chrs])		*/
	{"strcspn",	SF_Sn_Sn,	(SF)SF_strcspn},	/* strcspn(str[,chrs])		*/
	{"strrspn",	SF_Sn_Sn,	(SF)SF_strrspn},	/* strrspn(str[,chrs])		*/
	{"strrcspn",SF_Sn_Sn,	(SF)SF_strrcspn},	/* strrcspn(str[,chrs])		*/
	{"jstrspn",	SF_Sn_Sn,	(SF)SF_jstrspn},	/* jstrspn(str,chrs)		*/
	{"jstrcspn",SF_Sn_Sn,	(SF)SF_jstrcspn},	/* jstrcspn(str,chrs)		*/
	{"jstrrspn",SF_Sn_Sn,	(SF)SF_jstrrspn},	/* jstrrspn(str,chrs)		*/
	{"jstrrcspn",SF_Sn_Sn,	(SF)SF_jstrrcspn},	/* jstrrcspn(str,chrs)		*/
	{"ltrim",	SF_Sn_Sn,	(SF)SF_ltrim},		/* ltrim(str,chrs)			*/
	{"rtrim",	SF_Sn_Sn,	(SF)SF_rtrim},		/* rtrim(str,chrs)			*/
	{"trim",	SF_Sn_Sn,	(SF)SF_trim},		/* trim(str,chrs) 			*/
	{"btom",	SF_Sn_N,	(SF)SF_btom},		/* btom(str,b)				*/
	{"mtob",	SF_Sn_N,	(SF)SF_mtob},		/* mtob(str,m)				*/
	{"num",		SF_S,		(SF)SF_num},		/* num(str)					*/
	{"expr",	SF_Sn_N,	(SF)SF_expr},		/* expr(str[,level])		*/
	{"write",	SF_Sn,		(SF)SF_write},		/* write(str)				*/
	{"writeln",	SF_Sn,		(SF)SF_writeln},	/* writeln(str)				*/
	{"cwrite",	SF_Sn,		(SF)SF_cwrite},		/* cwrite(str)				*/
	{"rpl",		SF_Sn_N,	(SF)SF_rpl},		/* rpl(str[,mode])			*/
	{"put",		SF_Sn,		(SF)SF_put},		/* put(str)					*/
	{"cput",	SF_Sn,		(SF)SF_cput},		/* cput(str)				*/
	{"get",		SF_X,		(SF)SF_get},		/* get([n])					*/
	{"read",	SF_X,		(SF)SF_read},		/* read([n])				*/
	{"unget",	SF_Sn,		(SF)SF_unget},		/* unget(str)				*/
	{"text",	SF_Sn,		(SF)SF_text},		/* text(str)				*/
	{"mtext",	SF_Sn,		(SF)SF_mtext},		/* mtext(str)				*/
	{"cmd",		SF_S,		(SF)SF_cmd},		/* cmd(str)					*/
	{"_",		SF_S,		(SF)SF_cmd0},		/* _(str) 					*/
	{"rand",	SX_X,		(SF)SF_rand},		/* rand([n])				*/
	{"srand",	SF_X,		(SF)SF_srand},		/* srand([n])				*/
	{"fp",		SF_S,		(SF)SF_fp},			/* fp(path)					*/
	{"fn",		SF_Sn_Sn,	(SF)SF_fn},			/* fn(path[,fname])			*/
	{"fb",		SF_S,		(SF)SF_fb},			/* fb(path)					*/
	{"fe",		SF_Sn_Sn,	(SF)SF_fe},			/* fe(path[,ext])			*/
	{"exist",	SF_S,		(SF)SF_exist},		/* exist(path)				*/
	{"input",	SF_S,		(SF)SF_input},		/* input([file])			*/
	{"eof",		SF_S,		(SF)SF_eof},		/* eof([file])				*/
	{"close",	SF_S,		(SF)SF_close},		/* close([file])			*/
	{"inkey",	SF_X,		(SF)SF_inkey},		/* inkey([mode])			*/
	{"msg",		SF_S,		(SF)SF_msg},		/* msg(str)					*/
	{"error",	SF_S,		(SF)SF_error},		/* error(str)				*/
	{"ferror",	SF_S,		(SF)SF_ferror},		/* ferror(str)				*/
	{"exit",	SF_X,		(SF)SF_exit},		/* exit(n)					*/
	{"time",	SF_X,		(SF)SF_time},		/* time([mode])				*/
	{"settime",	SF_S,		(SF)SF_settime},	/* settime([tstr])			*/
	{"valtime",	SF_X,		(SF)SF_valtime},	/* valtime(tval)			*/
	{"timeval",	SF_S,		(SF)SF_timeval},	/* timeval(tstr)			*/
	{"val",		SF_Sn_N,	(SF)SF_val},		/* val(str[,radix])			*/
	{"hex",		SF_Sn_N,	(SF)SF_hex},		/* hex(str[,radix])			*/
	{"sval",	SX_X,		(SF)SF_sval},		/* sval(x)					*/
	{"strz",	SF_S,		(SF)CopyStr},		/* strz(str)				*/
	{"identity",SF_Sn,		(SF)CopyStrN},		/* identity(str)			*/
	{"defined",	SF_S,		(SF)SF_defined},	/* defined(str)				*/
	{"setind",	SF_X,		(SF)SF_setind},		/* setind([xpos]) 			*/
	{"setaj",	SF_X,		(SF)SF_setaj},		/* setaj([xpos]) 			*/
	{"cutsp",	SF_X,		(SF)SF_cutsp},		/* cutsp([mode]) 			*/
	{"varadr",	SF_Sn_N,	(SF)SF_varadr},		/* varadr(var[,mode])		*/
	{"peek",	SX_X,		(SF)SF_peek},		/* peek(adr)				*/
	{"poke",	SF_X_X,		(SF)SF_poke},		/* poke(adr,val)			*/
	{"peekb",	SX_X,		(SF)SF_peekb},		/* peekb(adr)				*/
	{"pokeb",	SF_X_X,		(SF)SF_pokeb},		/* pokeb(adr,val)			*/
	{"peekstr",	SF_X_X,		(SF)SF_peekstr},	/* peekstr(adr[,n])			*/
	{"pokestr",	SF_Sn_Sn,	(SF)SF_pokestr},	/* pokestr(adr,str)			*/
#ifdef MSDOS
	{"ioport",	SX_X_X,		(SF)SF_ioport},		/* ioport(port[,val])		*/
	{"ioportb",	SX_X_X,		(SF)SF_ioportb},	/* ioportb(adr[,val])		*/
	{"int86x",	SF_X,		(SF)SF_int86x},		/* int86x(n)				*/
	{"segread",	SF_X,		(SF)SF_segread},	/* segread([mode])			*/
#endif
#ifdef FLOATEXPR
	{"acos",	SX_X,		(SF)acos},			/* acos(x)					*/
	{"asin",	SX_X,		(SF)asin},			/* asin(x)					*/
	{"atan",	SX_X,		(SF)atan},			/* atan(x)					*/
	{"atan2",	SX_X_X,		(SF)atan2},			/* atan2(x,y)				*/
	{"ceil",	SX_X,		(SF)ceil},			/* ceil(x)					*/
	{"cos",		SX_X,		(SF)cos},			/* cos(x)					*/
	{"exp",		SX_X,		(SF)exp},			/* exp(x)					*/
	{"floor",	SX_X,		(SF)floor},			/* floor(x)					*/
	{"log",		SX_X,		(SF)log},			/* log(x)					*/
	{"log10",	SX_X,		(SF)log10},			/* log10(x)					*/
	{"sin",		SX_X,		(SF)sin},			/* sin(x)					*/
	{"sqrt",	SX_X,		(SF)sqrt},			/* sqrt(x)					*/
	{"tan",		SX_X,		(SF)tan},			/* tan(x)					*/
	{"trunc",	SX_X,		(SF)SF_trunc},		/* trunc(x)					*/
	{"round",	SX_X,		(SF)SF_round},		/* round(x)					*/
#endif
#if 0		/* {c */
	{"brace",	SF_Sn,		(SF)StrBrace},		/* brace(str) 				*/
	{"pairspn",	SF_Sn_N,	(SF)SF_pairspn},	/* pairspn(str,rpar)		*/
#endif
};

#define N_SFFN 	(sizeof(sffntbl) / sizeof(sffntbl[0]))

sftype_t
GetSFunc(sffnp_t *fnpp, const uchar *name)
{
	int i;

	assert(fnpp != NULL);
	assert(name != NULL);

	if (tim == -1)
		tim = time((time_t *)NULL);

	for (i = 0; i < N_SFFN && !equ(sffntbl[i].name, name); i++) ;

	if (i < N_SFFN) {
		*fnpp = sffntbl[i].fnptr;
		return sffntbl[i].typ;
	} else
		return SF_UNKNOWN;
}


/****************************** VXeϐ ******************************/

static struct SYSVARTBL {
	uchar *name;
	ushort typ;
	void *varptr;
} sysvartbl[] = {
	{"argc",		V_INT,			&margc},
	{"pageno",		V_INT,			&pageno},
	{"apageno",		V_INT,			&abspageno},
	{"width",		V_INT,			&width},
	{"pwidth",		V_INT,			&pagewidth},
	{"pagelines",	V_INT,			&pagelines},
	{"xpos",		V_INT,			&x},
	{"indent",		V_INT,			&indent},
	{"aindent",		V_INT,			&aindent},
	{"indsetflag",	V_INT,			&indentsetflag},
	{"bindent",		V_INT,			&bindent},
	{"findent",		V_INT,			&first_indent},
	{"ppflag",		V_INT,			&printpageflag},
	{"vexpflag",	V_INT,			&vexpflag},
	{"wexpflag",	V_INT,			&wexpflag},
	{"solflag",		V_INT,			&solflag},
	{"sol2flag",	V_INT,			&sol2flag},
	{"linebreak",	V_INT,			&linebreak},
	{"cmddot",		V_INT,			&cmddot_char},
	{"mcmddot",		V_INT,			&cmddot_mchar},
	{"error",		V_INT,			&errorflag},
	{"linespaced",	V_INT,			&linespaced},
	{"spacelines",	V_INT,			&spacelines},
	{"curc",		V_UINT,			&cc},
	{"prevc",		V_UINT,			&prevc},
	{"ilineno",		V_UINT,			&ilineno},
	{"lineno",		V_UINT,			&lineno},
#ifdef MSDOS
	{"ax",			V_UINT,			&regs.x.ax},
	{"bx",			V_UINT,			&regs.x.bx},
	{"cx",			V_UINT,			&regs.x.cx},
	{"dx",			V_UINT,			&regs.x.dx},
	{"si",			V_UINT,			&regs.x.si},
	{"di",			V_UINT,			&regs.x.di},
	{"cflag",		V_UINT,			&regs.x.cflag},
	{"es",			V_UINT,			&sregs.es},
	{"cs",			V_UINT,			&sregs.cs},
	{"ss",			V_UINT,			&sregs.ss},
	{"ds",			V_UINT,			&sregs.ds},
#endif
};

#define N_SYSVAR	(sizeof(sysvartbl) / sizeof(sysvartbl[0]))

unsigned
GetSysVar(void **varpp, const uchar *name)
{
	int i;

	assert(name != NULL);
	assert(varpp != NULL);

	for (i = 0; i < N_SYSVAR && !equ(sysvartbl[i].name, name); i++) ;
	if (i < N_SYSVAR) {
		*varpp = sysvartbl[i].varptr;
		return sysvartbl[i].typ;
	} else
		return V_UNKNOWN;
}

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
