/* expr.c */
/*****************************************************************************
					s@o@wsq

							m̕]n
*****************************************************************************/

#include "xtr.h"

/***************************************************************************

<fstring> : { <%-form> | <char> }*

<%-form>     : '%' [<%-form2>]

<%-form2>    : <env-var> '%'
             | ['-'] <arg-#>
             | ['-'] [<f-width>] {<func> | <func-call>}
             | ':' <format> <expr-prim-f>
             | <expr-prim-f>
             | <\-sequence>
             | '%'
             | '<'
             | '>'

<format>     : {<f-flag>}* [<f-width>] ['.' <f-prec>] <f-type>

<f-flag>     : ' ' | '+' | '-' | '#'
<f-width>    : <num>
<f-prec>     : <num>
<f-type>     : <null>
             | 's' | 'd' | 'u' | 'o' | 'x' | 'X' | 'c' | 'O' | 'k'
             | 'S' | 'C' | 'r' | 'R' | 'a' | 'A' | 'f' | 'e' | 'E'
             | 'g' | 'G'

<func-call>   : <func> { <func-args> | <expr-prim-f> }

<func-args>   : '(' [ <expr-asgn> { ',' <expr-asgn> }* ] ')'

<env-var>     : <name>

<func>        : <name>

<num>         : <digits>

<name>    : {<alpha> | '_'} {<alpha> | '_' | <digit>}*

<arg-#>   : <num>

<expr>    : <expr-asgn> {',' <expr-asgn>}*

<expr-asgn> : <var>
              {'=' | '*=' | '/=' | '%=' | '+=' | '-='
                   | '&=' | '^=' | '|=' | '<<=' | '>>=' | '**='}
              <expr-asgn>
            | <expr-cond>

<expr-cond> : <expr-lor> ['?' <expr> ':' <expr-cond>}]
<expr-lor>  : <expr-land> {'||' <expr-land>}*
<expr-land> : <expr-or> {'&&' <expr-or>}*
<expr-or>   : <expr-xor> {'|' <expr-xor>}*
<expr-xor>  : <expr-and> {'^' <expr-and>}*
<expr-and>  : <expr-rel> {'&' <expr-rel>}*
<expr-rel>  : <expr-conc> {{'==' | '!=' | '<' | '<=' | '>' | '>='}<expr-conc>}*
<expr-conc> : <expr-sh> {<expr-sh>}*
<expr-sh>   : <expr-add> {{'<<' | '>>'} <expr-add>}*
<expr-add>  : <expr-mul> {{'+' | '-'} <expr-mul>}*
<expr-mul>  : <expr-pref> {{'*' | '/' | '%'} <expr-pref>}*
<expr-pref> : {'!' | '~' | '-' | '+'} <expr-pref> | <expr-pow>
<expr-pow>  : <expr-inc> {'**' <expr-inc>}*
<expr-inc>  : {'++' | '--'} <expr-prim> | <expr-prim> [ '++' | '--']

<expr-prim>  : <expr-prim-f>
             | <func-call>
             | <var>
             | <number>

<expr-prim-f> : '(' <expr> ')'
              | '[' <expr> ']'
              | '{' <fstring> '}'
              | '"' <qstring> '"'
              | "'" <echar> "'"
              | '`' <expr-prim>
              | '@' <expr-prim>

<number>  : <digits>
          | '0x' <hexdigits>
          | '0o' <octdigits>
          | '0b' <bindigits>

<var>     : <usr-var> | <sys-var>

<usr-var> : <name>
<sys-var> : '.' <name>

<qstring> : { <echar> }*

<echar>   : { <char> | <\-sequence> }

<\-sequence> : '\' <\-sequence2>

<\-sequence2> : 'a'
              | 'b'
              | 'f'
              | 'n'
              | 'r'
              | 't'
              | 'v'
              | 'e'
              | 'c'
              | 's'
              | 'S'
              | 'z'
              | 'x' <hexdigits>
              | 'o' <octdigits>
              | ['d'] <digits>
              | <char>

***************************************************************************/

#define EXPR1_PREFS			"-!~+."
#define EXPR0_PREFS			"({\"'@`["

/*  p  <expr> ł邩ׂ */
#define IsExpr(p)		(*(p) && (IsKSym2Str(p) || \
							strchr(EXPR0_PREFS, *(p)) || \
							strchr(EXPR1_PREFS, *(p)) && *(p+1) != '='))

/*  p  <expr-prim-f> ł邩ׂ */
#define IsExprPrimF(p)	(*(p) && strchr(EXPR0_PREFS, *(p)))

int
IsFuncArgStr(const uchar *p)
{
	return IsExprPrimF(p);
}

/******************************** EvalExpr ********************************/

#if UNIX
#define ERROR_SE(fmt,s,e)												\
	do {																\
		uchar *_str, *_mbs;												\
		int _len;														\
		_len = (int)((e) - (s));										\
		_str = (uchar *)alloca(_len + 1);								\
		memcpy((char *)_str, (char *)(s), _len);						\
		_str[_len] = '\0';												\
		_mbs = (uchar *)alloca(_len * 2 + 1);							\
		sjis2mbstring((char *)_mbs, (char *)_str);						\
		Error((fmt), _mbs);												\
	} while (0)
#define ExprErr(s, e)		ERROR_SE("Invalid expression: %s", s, e)
#else
#define ExprErr(s, e)		Error(f_ExprErr, (int)((e)-(s)), (s))
static uchar f_ExprErr[] = "Invalid expression: %.*s";
#endif

#if UNIX
#define DivZeroErr(s, e)	ERROR_SE("Can't divide by 0: %s", s, e)
#else
#define DivZeroErr(s, e)	Error(f_DivZeroErr, (int)((e)-(s)), (s))
static uchar f_DivZeroErr[] = "Can't divide by 0: %.*s";
#endif

#if UNIX
#define AsgnErr(s, e)		ERROR_SE("Illegal assignment: %s", s, e)
#else
#define AsgnErr(s, e)		Error(f_AsgnErr, (int)((e)-(s)), (s))
static uchar f_AsgnErr[] = "Illegal assignment: %.*s";
#endif

static int	unclosedflag;	/* ʗނĂȂƂtO */

static const uchar *srcp;
static const uchar *expr;
static uchar *valstr;
static int   vallen;
static exprval_t exprval;

static int
ValNumStr(exprval_t val)
{
	if (nevflag) return 0;

	return vallen = WtNumber(valstr, val);
}

static int
ValNum(exprval_t val)
{
	if (nevflag) return 0;

	if (val == 0) {
		return vallen = WtNum(valstr, 0);
	} else {
		*valstr = 0;
		return vallen = 0;
	}
}

static int
ValStr(exprval_t val)
{
	if (nevflag) return 0;

	if (val == 0 || vallen)
		return vallen;
	else
		return vallen = WtNumber(valstr, val);
}

static exprval_t
ValVal(exprval_t val)
{
	if (nevflag) return 0;

	if (val == 0)
		return RdNumber(valstr, (const uchar **)NULL);
	else
		return val;
}

static exprval_t Expr ARGS((void));
static exprval_t Expr_asgn ARGS((void));
static exprval_t Expr_cond ARGS((void));
static exprval_t Expr_lor ARGS((void));
static exprval_t Expr_land ARGS((void));
static exprval_t Expr_or ARGS((void));
static exprval_t Expr_xor ARGS((void));
static exprval_t Expr_and ARGS((void));
static exprval_t Expr_rel ARGS((void));
static exprval_t Expr_conc ARGS((void));
static exprval_t Expr_sh ARGS((void));
static exprval_t Expr_add ARGS((void));
static exprval_t Expr_mul ARGS((void));
static exprval_t Expr_pref ARGS((void));
static exprval_t Expr_pow ARGS((void));
static exprval_t Expr_inc ARGS((void));
static exprval_t Expr_prim ARGS((void));


int
EvalExpr(uchar *dst, const uchar *src, const uchar **endp, evlev_t evlevel)
/* ]B
 * evlevel łǂ܂Ŏǂނw
 */
{
	int len;
	const uchar *srcp0 = srcp;
	const uchar *expr0 = expr;
	uchar *valstr0 = valstr;
	int   vallen0 = vallen;
	int   nevflag0 = nevflag;

	assert(nevflag || dst != NULL);
	assert(src != NULL);

	expr = srcp = SkipSpace(src);
	if (!nevflag)
		*dst = '\0';

	valstr = dst;
	vallen = 0;

	exprval = 0;

	if (IsExpr(srcp)) {
		switch (evlevel) {
		case EXPR_MAX:
			exprval = Expr();
			break;
		case EXPR_SEMIMAX:
			exprval = Expr_asgn();
			break;
		case EXPR_MIN:
		case EXPR_PRIM:
			exprval = Expr_prim();
			break;
		default:
			assert(FALSE);
		}
	}

	len = ValStr(exprval);
	if (endp)
		*endp = BackSkipSpace(src, srcp);
	else if (*CutSpace(srcp) != '\0' && *srcp != ';' && !noerrmode )
		ExprErr(src, SkipMoji(srcp));

	srcp = srcp0;
	expr = expr0;
	valstr = valstr0;
	vallen = vallen0;
	nevflag = nevflag0;
	return len;
}

/**************************************/

static
exprval_t Expr(void)
/*
 *  <expr>    : <expr-asgn> {',' <expr-asgn>}*
 */
{
	exprval_t val = Expr_asgn();

	while (*CutSpace(srcp) == ',') {
		srcp++;
		val = Expr_asgn();
	}
	return val;
}

#if UNIX
#define UnkSysVarErr(s)													\
	do {																\
		uchar *_mbs = (uchar *)alloca(strlen((char *)(s)) * 2);			\
		sjis2mbstring((char *)_mbs, (char *)(s));						\
		Error("Unknown system variable: %s", _mbs);						\
	} while (0)
#else
#define UnkSysVarErr(s)		Error(f_UnkSysVar, s)
static uchar f_UnkSysVar[] = "Unknown system variable: %s";
#endif

static void
PutVar1(const uchar *name, int nlen, const uchar *s, int len)
{
	uchar nbuf[128];

	CopyStrN(nbuf, name, min(nlen, 127));
	if (*nbuf == '.') {
		exprval_t val = RdNumber(s, (const uchar **)NULL);
		void *varptr;
		unsigned vartyp = GetSysVar(&varptr, nbuf+1);
		if (vartyp == V_UNKNOWN) {
			if (!noerrmode)
				UnkSysVarErr(nbuf);
		} else if (vartyp & V_RONLY) {
			if (!noerrmode)
				AsgnErr(name, name+nlen);
		} else switch (vartyp) {
		case V_INT:
			*(int *)varptr = (int)val;
			break;
		case V_UINT:
			*(unsigned *)varptr = (unsigned)val;
			break;
		default:
			assert(FALSE);
		}
	} else {
		PutVar(nbuf, s, len);
	}
}

static uchar *
GetVar1(const uchar *name, int nlen, int *lenp, exprval_t *valp)
{
	uchar nbuf[128];
	
	assert(name != NULL);
	
	CopyStrN(nbuf, name, min(nlen, 127));
	if (*nbuf == '.') {
		void *varptr;
		unsigned vartyp = GetSysVar(&varptr, nbuf+1);

		assert(valp != NULL);

		if (vartyp == V_UNKNOWN) {
			if (!noerrmode)
				UnkSysVarErr(nbuf);
		} else switch (vartyp & ~V_RONLY) {
		case V_INT:
			*valp = (exprval_t)(*(int *)varptr);
			break;
		case V_UINT:
			*valp = (exprval_t)(*(unsigned *)varptr);
			break;
		default:
			assert(FALSE);
		}
		if (lenp) *lenp = 0;
		return NULL;
	} else {
		uchar *p = GetVar(nbuf, lenp);
		if (valp != NULL)
			*valp = RdNumber(p, (const uchar **)NULL);
		return p;
	}
}

#ifdef FLOATEXPR
 #define Add(a, b)		FAdd(a, b)
 #define Sub(a, b)		FAdd(a, -(b))

/* _̉ZŁAʂ̒lƂ 0 ɂȂ悤ɂ */

static exprval_t
FAdd(exprval_t a, exprval_t b)
{
	exprval_t c = a + b;
	if (Abs(c) > Abs(a) * _Paste2(10e-, DBL_DIG))
		return c;
	else {
		uchar buf[32];
		WtNumber(buf, a);
		a = RdNumber(buf, (const uchar **)NULL);
		WtNumber(buf, b);
		if (a + RdNumber(buf, (const uchar **)NULL) == 0)
			return 0;
		else
			return c;
	}
}

#else
 #define Add(a, b)		((a) + (b))
 #define Sub(a, b)		((a) - (b))
#endif


static exprval_t Ex_sh ARGS((exprval_t a, exprval_t b, int rflag));
static exprval_t Ex_pow ARGS((exprval_t a, exprval_t b));

#define IsAsgnOp(p)		(*((p)+1) != '=' ? \
							*(p) == '=' || \
							 *((p)+2) == '=' && \
							  (*(p) == '<' || *(p) == '>' || *(p) == '*') && \
							  *(p) == *((p)+1) : \
						    *(p) && strchr("*%/+-&^|", *(p)))

#define SkipAsgnOp(p)	((p) + (*(p) == '=' ? 1 : *((p)+1) == '=' ? 2 : 3))

#define IsVarStr(p)		(*(p) == '.' ? IsSym1_(*((p)+1)) : IsKSym1Str(p))
#define SkipVar(p)		(*(p) == '.' ? SkipSym2((p)+1) : SkipKSym2(p))

static exprval_t
Expr_asgn(void)
/*
 *  <expr-asgn> : <var>
 *                {'=' | '*=' | '/=' | '%=' | '+=' | '-='
 *                     | '&=' | '^=' | '|=' | '<<=' | '>>=' || '**='}
 *                <expr-asgn>
 *              | <expr-cond>
 */
{
	const uchar *sp0 = CutSpace(srcp);
	const uchar *sp1;
	int  op;
	exprval_t  val;
	exprval_t  val2;

	if (!IsVarStr(srcp)) {
		val = Expr_cond();
		CutSpace(srcp);
		if (IsAsgnOp(srcp) && (srcp = SkipAsgnOp(srcp), !noerrmode))
			AsgnErr(sp0, srcp);
		return val;
	}
	sp1 = SkipVar(srcp);
	srcp = SkipSpace(sp1);
	if (!IsAsgnOp(srcp)) {
		srcp = sp0;
		val = Expr_cond();
		CutSpace(srcp);
		if (IsAsgnOp(srcp) && (srcp = SkipAsgnOp(srcp), !noerrmode))
			AsgnErr(sp0, srcp);
		return val;
	}
	op = *srcp;
	if (op == '*' && *(srcp+1) == '*') op = 'P';
	srcp = SkipAsgnOp(srcp);

	if (nevflag)
		return Expr_asgn();

	if (op == '=') {
		val = Expr_asgn();
		ValStr(val);
		PutVar1(sp0, sp1-sp0, valstr, vallen);
	} else {
		GetVar1(sp0, sp1-sp0, (int *)NULL, &val);
		val2 = Expr_asgn();
		if (val2 == 0 && (op == '/' || op == '%')) {
			if (!noerrmode)
				DivZeroErr(sp0, srcp);
			else
				val2 = 1;
		}
		switch (op) {
		case '*':
			val *= val2;
			break;
		case '/':
			val /= val2;
			break;
		case '%':
#ifdef FLOATEXPR
			val = fmod(val, val2);
#else
			val %= val2;
#endif
			break;
		case '+':
			val = Add(val, val2);
			break;
		case '-':
			val = Sub(val, val2);
			break;
		case '&':
			val = (exprintval_t)val & (exprintval_t)val2;
			break;
		case '^':
			val = (exprintval_t)val ^ (exprintval_t)val2;
			break;
		case '|':
			val = (exprintval_t)val | (exprintval_t)val2;
			break;
		case '<':						/* <<= */
			val = Ex_sh(val, val2, 0);
			break;
		case '>':						/* >>= */
			val = Ex_sh(val, val2, 1);
			break;
		case 'P':						/* **= */
			val = Ex_pow(val, val2);
			break;
		default:
			assert(FALSE);				/* Never */
		}
		ValNumStr(val);
		PutVar1(sp0, sp1-sp0, valstr, vallen);
	}
	return val;
}

static exprval_t
Expr_cond(void)
/*
 *  <expr-cond>  : <expr-lor> ['?' <expr> ':' <expr-cond>}]
 */
{
	const uchar *sp0 = srcp;
	exprval_t val_c = Expr_lor();
	exprval_t val_th;
	exprval_t val_el;
	int nevflag0 = nevflag;

	if (*CutSpace(srcp) != '?')
		return val_c;
	
	srcp++;
	if (!val_c) nevflag = TRUE;
	val_th = Expr();
	if (*CutSpace(srcp) != ':') {
		if (!noerrmode)
			ExprErr(sp0, SkipMoji(srcp));
		else
			--srcp;
	}
	srcp++;
	nevflag = nevflag0;
	if (val_c) nevflag = TRUE;
	val_el = Expr_cond();
	nevflag = nevflag0;
	if (val_c)
		return val_th;
	else
		return val_el;
}

static exprval_t
Expr_lor(void)
/*
 *  <expr-lor> : <expr-land> {'||' <expr-land>}*
 */
{
	exprval_t val = Expr_land();
	int nevflag0 = nevflag;

	while (*CutSpace(srcp) == '|' && *(srcp+1) == '|') {
		srcp += 2;
		if (val) {
			nevflag = TRUE;
			Expr_land();
		} else {
			val = Expr_land();
		}
	}
	nevflag = nevflag0;
	return val;
}

static exprval_t
Expr_land(void)
/*
 *  <expr-land> : <expr-or> {'&&' <expr-or>}*
 */
{
	exprval_t val = Expr_or();
	int nevflag0 = nevflag;

	while (*CutSpace(srcp) == '&' && *(srcp+1) == '&') {
		srcp += 2;
		if (val) {
			val = Expr_or();
		} else {
			nevflag = TRUE;
			Expr_or();
		}
	}
	nevflag = nevflag0;
	return val;
}

static exprval_t
Expr_or(void)
/*
 *  <expr-or>  : <expr-xor> {'|' <expr-xor>}*
 */
{
	exprval_t val = Expr_xor();
	while (*CutSpace(srcp) == '|' && *(srcp+1) != '|' && *(srcp+1) != '=') {
		srcp++;
		if (!nevflag)
			val = (exprintval_t)val | (exprintval_t)Expr_xor();
		else
			(void)Expr_xor();
		ValNum(val);
	}
	return val;
}

static exprval_t
Expr_xor(void)
/*
 *  <expr-xor> : <expr-and> {'^' <expr-and>}*
 */
{
	exprval_t val = Expr_and();
	while (*CutSpace(srcp) == '^' && *(srcp+1) != '=') {
		srcp++;
		if (!nevflag)
			val = (exprintval_t)val ^ (exprintval_t)Expr_and();
		else
			(void)Expr_and();
		ValNum(val);
	}
	return val;
}

static exprval_t
Expr_and(void)
/*
 *  <expr-and>  : <expr-rel> {'&' <expr-rel>}*
 */
{
	exprval_t val = Expr_rel();
	while (*CutSpace(srcp) == '&' && *(srcp+1) != '&' && *(srcp+1) != '=') {
		srcp++;
		if (!nevflag)
			val = (exprintval_t)val & (exprintval_t)Expr_rel();
		else
			(void)Expr_rel();
		ValNum(val);
	}
	return val;
}

static exprval_t
Expr_rel(void)
/*
 *  <expr-rel>  : <expr-conc> {{'==' | '!=' | '<' | '<=' | '>' | '>='}
 *                             <expr-conc>}*
 */
{
	exprval_t val = Expr_conc();
	exprval_t val2;
	uchar *valstr0 = valstr;
	int  op;
	int  vallen0 = vallen;
	
	while (1) {
		if ((op = *CutSpace(srcp)) == '=' ? *(srcp+1) == '=' :
		                  *srcp == '!' && *(srcp+1) == '=' ) {
			srcp += 2;
			ValStr(val);
			if (!nevflag)
				valstr += vallen + 1;
			vallen0 = vallen;
			val2 = Expr_conc();
			val = ((Sub(val, val2) == 0) && (vallen0 == ValStr(val2)) &&
						!memcmp(valstr0, valstr, vallen));
						/* 񂪒܂߂ĊSɈvꍇ̂ݐ^ */
			if (op == '!')
				val = !val;
			valstr = valstr0;
			ValNum(val);
		} else if (*srcp == '<' && *(srcp+1) == '=') {
			srcp += 2;
			val = Sub(val, Expr_conc()) <= 0;
			ValNum(val);
		} else if (*srcp == '<' && *(srcp+1) != '<') {
			srcp++;
			val = Sub(val, Expr_conc()) < 0;
			ValNum(val);
		} else if (*srcp == '>' && *(srcp+1) == '=') {
			srcp += 2;
			val = Sub(val, Expr_conc()) >= 0;
			ValNum(val);
		} else if (*srcp == '>' && *(srcp+1) != '>') {
			srcp++;
			val = Sub(val, Expr_conc()) > 0;
			ValNum(val);
		} else
			break;
	}
	return val;
}


static exprval_t
Expr_conc(void)
/*
 *  <expr-conc> : <expr-sh> {<expr-sh>}*
 */
{
	uchar *valstr0 = valstr;
	exprval_t val = Expr_sh();

	CutSpace(srcp);
	if (IsExpr(srcp)) {
		do {
			valstr += ValStr(val);
			val = Expr_sh();
			CutSpace(srcp);
		} while (IsExpr(srcp));
		
		if (!nevflag) {
			ValStr(val);
			vallen += valstr - valstr0;
		}
		valstr = valstr0;
		val = ValVal(0);
	}
	return val;
}

static exprval_t
Ex_sh(exprval_t a, exprval_t b, int rflag)
{
	if (b < 0) {
		rflag = !rflag;
		b = -b;
	}
	if (rflag)
		return (exprval_t)(exprintval_t)((unsigned long)a >> (exprintval_t)b);
	else
		return (exprval_t)(exprintval_t)((unsigned long)a << (exprintval_t)b);
}

static exprval_t
Expr_sh(void)
/*
 *  <expr-sh>  : <expr-add> {{'<<' | '>>'} <expr-add>}*
 */
{
	exprval_t val = Expr_add();
	while (*CutSpace(srcp) == '<' && *(srcp+1) == '<' && *(srcp+2) != '=' ||
		             *srcp == '>' && *(srcp+1) == '>' && *(srcp+2) != '=') {
		int rflag = *srcp == '>';
		srcp += 2;
		val = Ex_sh(val, Expr_add(), rflag);
		ValNum(val);
	}
	return val;
}

static exprval_t
Expr_add(void)
/*
 *  <expr-add>  : <expr-mul> {{'+' | '-'} <expr-mul>}*
 */
{
	exprval_t val = Expr_mul();
	while (1)
		if (*CutSpace(srcp) == '+' && *(srcp+1) != '+' && *(srcp+1) != '=') {
			srcp++;
			val = Add(val, Expr_mul());
			ValNum(val);
		} else if (*srcp == '-' && *(srcp+1) != '-' && *(srcp+1) != '=') {
			srcp++;
			val = Sub(val, Expr_mul());
			ValNum(val);
		} else
			break;
	return val;
}

static exprval_t
Expr_mul(void)
/*
 *  <expr-mul>  : <expr-pref> {{'*' | '/' | '%'} <expr-pref>}*
 */
{
	const uchar *sp0 = CutSpace(srcp);
	exprval_t val = Expr_pref();
	exprval_t val2;
	int op;

	while (((op = *(CutSpace(srcp))) == '*' || op == '/' || op == '%') &&
			*(srcp+1) != '*' && *(srcp+1) != '=') {
		srcp++;
		val2 = Expr_pref();
		if (!nevflag) {
			if (val2 == 0 && op != '*') {
				if (!noerrmode)
					DivZeroErr(sp0, srcp);
				else
					val2 = 1;
			}
			switch (op) {
			case '*':
				val *= val2;
				break;
			case '/':
				val /= val2;
				break;
			case '%':
#ifdef FLOATEXPR
				val = fmod(val, val2);
#else
				val %= val2;
#endif
				break;
			default:
				assert(FALSE);
			}
		}
		ValNum(val);
	}
	return val;
}


static exprval_t
Expr_pref(void)
/*
 *  <expr-pref>  : {'!' | '~' | '-' | '+'} <expr-pref>
 *               | <expr-pow>
 */
{
	exprval_t val;

	if (*CutSpace(srcp) == '!' && *(srcp+1) != '=') {
		srcp++;
		val = !Expr_pref();
	} else if (*srcp == '~') {
		srcp++;
		val = ~(exprintval_t)Expr_pref();
	} else if (*srcp == '-' && *(srcp+1) != '-' && *(srcp+1) != '=') {
		srcp++;
		val = -Expr_pref();
	} else if (*srcp == '+' && *(srcp+1) != '+' && *(srcp+1) != '=') {
		srcp++;
		val = +Expr_pref();
	} else 
		return Expr_pow();
	
	ValNum(val);
	return val;
}

static exprval_t
Ex_pow(exprval_t a, exprval_t b)
{
	if (nevflag) return 0;
	
	if (b == 0 || a == 1)
		return 1;
	else if (a == 0)
		return 0;

#ifdef FLOATEXPR
	return pow(a, b);

#else
	if (a == -1)
		return b & 1 ? -1 : 1;
	else if (b < 0)
		return 0;
	else if (b >= 64)	/* too big !! */
		return 0;
	else {
		exprval_t val = a;
		while (--b > 0)
			val *= a;
		return val;
	}
#endif
}

static exprval_t
Expr_pow(void)
/*
 *  <expr-pow> : <expr-inc> {'**' <expr-inc>}*
 */
{
	exprval_t val = Expr_inc();
	while (*CutSpace(srcp) == '*' && *(srcp+1) == '*' && *(srcp+2) != '=') {
		srcp += 2;
		val = Ex_pow(val, Expr_inc());
		ValNum(val);
	}
	return val;
}


#define IsIncDecOp(s)  ((*(s) == '+' || *(s) == '-') && *(s) == *((s)+1))

static exprval_t
Expr_inc(void)
/*
 *  <expr-inc>  : {'++' | '--'} <expr-prim>
 *              | <expr-prim> [ '++' | '--']
 */
{
	const uchar *sp0 = CutSpace(srcp);
	const uchar *sp1;
	exprval_t val;
	
	if (IsIncDecOp(srcp)) {
		srcp += 2;
		sp1 = CutSpace(srcp);
		val = Expr_prim();
		if (!IsVarStr(sp1)) {
			if (!noerrmode)
				AsgnErr(sp0, srcp);
		} else if (!nevflag) {
			if (*sp0 == '+')
				++val;
			else
				--val;
			ValNumStr(val);
			PutVar1(sp1, srcp-sp1, valstr, vallen);
		}
	} else {
		val = Expr_prim();
		sp1 = srcp;
		CutSpace(srcp);
		if (!IsIncDecOp(srcp))
			return val;

		if (!IsVarStr(sp0)) {
			if (!noerrmode)
				AsgnErr(sp0, srcp+2);
		} else if (!nevflag) {
			ValNumStr(*srcp == '+' ? val + 1 : val - 1);
			PutVar1(sp0, sp1-sp0, valstr, vallen);
		}
		srcp += 2;
	}
	ValNum(val);
	return val;
}

static int FuncCall ARGS((uchar *dst, const uchar *name, const uchar *src, const uchar **endp, exprval_t *fretvalp));

static exprval_t
Expr_prim(void)
/*
 *  <expr-prim>  : '(' <expr> ')'
 *               | '[' <expr> ']'
 *               | '{' <fstring> '}'
 *               | '"' <qstring> '"'
 *               | "'" <echar> "'"
 *               | '`' <expr-prim>
 *               | '@' <expr-prim>
 *               | <func-call>
 *               | <sys-var>
 *               | <usr-var>
 *               | <number>
 */
{
	uchar *dst = valstr;
	uchar *dstp = dst;
	const uchar *sp0;
	const uchar *p;
	exprval_t  val = 0;

	assert(nevflag || dstp != NULL);
	assert(srcp != NULL);

	unclosedflag = FALSE;			/* ʗނ̃`FbNp */

	while (*CutSpace(srcp) == '@')						/* '@' <expr-prim> */
		srcp++;

	sp0 = srcp;

	if (!nevflag) {
		*dstp = '\0';
		vallen = 0;
		val = 0;
	}

	if (*srcp == '(' || *srcp == '[') {					/* '(' <expr> ')' */
														/* '[' <expr> ']' */
		srcp = SkipSpace(srcp+1);
		if (*srcp != ')' && *srcp != ']')
			val = Expr();
		if (*CutSpace(srcp) == (*sp0 == '(' ? ')' : ']')) {
			srcp++;
			unclosedflag = FALSE;
		} else {
			if (!noerrmode)
#if UNIX
			{
				uchar *str, *mbs;
				int len;

				len = (int)(srcp - sp0);
				str = (uchar *)alloca(len + 1);
				memcpy((char *)str, (char *)sp0, len);
				str[len] = '\0';
				mbs = (uchar *)alloca(len * 2 + 1);
				sjis2mbstring((char *)mbs, (char *)str);
				Error("'%c' expected: %s", (*sp0 == '(' ? ')' : ']'), mbs);
			}
#else
				Error("'%c' expected: %.*s",
								(*sp0 == '(' ? ')' : ']'),
								(int)(srcp-sp0), sp0);
#endif
			while (*srcp && *srcp != ')' && *srcp != ']') {
				if (!IsExpr(srcp))
					srcp = SkipMoji(srcp);
				val = Expr();
			}
			if (*srcp) {
				srcp++;
				unclosedflag = FALSE;
			} else {
				unclosedflag = TRUE;
			}
		}
	} else if (*srcp == '{') {							/* '{' <fstring> '}' */
		dstp += EvalStringB(dstp, srcp+1, &srcp, 1);
		valstr = dst;
		if (!nevflag) {
			vallen = dstp - dst;
			val = ValVal(0);
		}
	} else if (*srcp == '"') {							/* '"' <qstring> '"' */
		do {
			dstp += ReadStringB(dstp, srcp+1, &srcp, '"');
			if (*srcp == '"') {
				srcp++;
			} else {
				unclosedflag = TRUE;
				if (!noerrmode)
#if UNIX
				{
					uchar *mbs = (uchar *)alloca(strlen((char *)sp0) * 2 + 1);
					sjis2mbstring((char *)mbs, (char *)sp0);
					Error("'\"' expected: %s", mbs);
				}
#else
					Error("'\"' expected: %s", sp0);
#endif
				else
					break;
			}
		} while (*srcp == '"');	
				/* _uNH[gAĂP̕Ƃ݂Ȃ */

		if (!nevflag) {
			vallen = dstp - dst;
			val = ValVal(0);
		}

	} else if (*srcp == '\'') {							/* "'" <echar> "'" */
		dstp += ReadStringB(dstp, srcp+1, &srcp, '\'');
		if (!nevflag) {
			for (p = valstr; p < dstp; p++) {
				val *= 0x100;
				val += *p;
			}
		}
		dstp = valstr;
		if (*srcp == '\'') {
			srcp++;
		} else {
			unclosedflag = TRUE;
			if (!noerrmode)
#if UNIX
				{
					uchar *mbs = (uchar *)alloca(strlen((char *)sp0) * 2 + 1);
					sjis2mbstring((char *)mbs, (char *)sp0);
					Error("\"'\" expected: %s", mbs);
				}
#else
				Error("\"'\" expected: %s", sp0);
#endif
		}
		ValNum(val);
	} else if (*srcp == '`') {							/* '`' <expr-prim> */
		srcp = SkipExpr(srcp+1, EXPR_PRIM, SKIP_ELSE0);
		if (!nevflag) {
			dstp += vallen = CopyStrDiff(dstp, SkipSpace(sp0+1), srcp);
			val = ValVal(0);
		}
	} else if (IsKSym1Str(srcp)) {
		srcp = SkipKSym2(srcp);
		if (IsExprPrimF(srcp)) {						/* <func-call> */
			dstp += FuncCall(dstp, sp0, srcp, &srcp, &val);
			valstr = dst;
			if (!nevflag) {
				vallen = dstp - dst;
				val = ValVal(val);
			}
		} else {										/* <usr-var> */
			if (!nevflag) {
				int len;
				p = GetVar1(sp0, srcp-sp0, &len, (exprval_t *)NULL);
				dstp += vallen = CopyStrN(dstp, p, len);
				val = ValVal(0);
			}
		}
	} else if (*srcp == '.' && !isdigit(*(srcp+1))) {	/* <sys-var> */
		srcp++;
		if (IsSym1_(*srcp)) {
			srcp = SkipSym2(srcp);
			if (!nevflag) {
				CopyStrDiff(dstp, sp0+1, srcp);
				GetVar1(sp0, srcp-sp0, (int *)NULL, &val);
				ValNum(val);
			}
		}
#if 0	/* %-form Ƃƍ̂ƂɂȂ̂ŁAp~ */
	} else if (*srcp == '%') {
		dstp += EvalPcForm(dstp, srcp+1, &srcp);
		valstr = dst;
		if (!nevflag) {
			vallen = dstp - dst;
			val = ValVal(0);
		}
#endif
	} else {											/* <number> */
		val = RdNumber(srcp, &p);
		if (p == srcp && *p != '.' && !isdigit(*p)) {
			/* lƂēǂ߂Ȃ */
			if (!noerrmode)
				ExprErr(expr, SkipMoji(p));
			val = 0;
		} else if (*(srcp = p) == '.' || isalnum(*srcp)) {
			val = 0;
			for (srcp++; isalnum(*srcp); srcp++);
			if (!noerrmode)
#if UNIX
				ERROR_SE("Illegal number: %s", sp0, srcp);
#else
				Error("Illegal number: %.*s", (int)(srcp - sp0), sp0);
#endif
		} else {
			ValNum(val);
		}
	}

	assert(dst == valstr);
	assert(!nevflag || dstp == valstr);

	return val;
}

/*************************************************************************/

int
RdNum(const uchar *src, const uchar **endp)
{
	return (int)strtol((const char *)src, (char**)endp, 10);
}


exprval_t
RdNumber(const uchar *src, const uchar **endp)
{
	const uchar *srcp = SkipSpace(src);
	int sn = *srcp == '+' ? 1 : *srcp == '-' ? -1 : 0;
	const uchar *end;
	exprval_t val;

	if (!*src) {
		if (endp)
			*endp = src;
		return 0;			/* k̒l 0 Ƃ */
	}

	if (sn)
		srcp++;
	
	if (*srcp == '0' && isalpha(*(srcp + 1)) && isxdigit(*(srcp + 2))) {
		int ch = TOLOWER(*(srcp + 1));
		int radix = ch == 'b' ? 2 :
					ch == 'o' ? 8 :
					ch == 'd' ? 10 :
					ch == 'x' ? 16 :
					0;
		if (radix) {
			long ival = (long)strtoul((const char *)srcp + 2, (char**)&end, radix);
			if (end != srcp + 2) {
				if (endp)
					*endp = end;
				return sn < 0 ? -ival : ival;
			}
		}
	}
#ifdef FLOATEXPR
	if ((*srcp == '.' && srcp++, isdigit(*srcp)))
		val = strtod((const char *)src, (char **)&end);
	else {
		val = 0;
		end = src;
	}
#else
	val = strtol(src, (char**)&end, 10);
#endif
	if (end == src) {
		/* Ƃēǂ߂Ȃꍇ */

		if (endp == NULL)
			val = (exprval_t)((unsigned)(*src) * 0x100 + *(src+1));

#if defined(FLOATEXPR) && defined(_MSC_VER)
		/* MSC ̑֕_Z(/FPa)gp̏ꍇ̂ */
		if (isdigit(*srcp)) {
			/* MSC 6.0 ̑֕_CugƁAstrtod 
			  I[o[t[ƂƂĂ̔F 0 ԂĂ܂
			   */
			val = sn < 0 ? EXPRVAL_MIN : EXPRVAL_MAX;
			srcp = SkipDigit(srcp);
			if (*srcp=='.')
				srcp++;
			end = srcp = SkipDigit(srcp);
			if (*srcp=='e'||*srcp=='E') {
				if (*++srcp == '-') {
					val = 0;
					srcp++;
				} else if (*srcp=='+') {
					srcp++;
				}
				if (isdigit(*srcp)) {
					end = SkipDigit(srcp);
				} else {
					uchar *p = DupStrDiff(src, end);
					val = strtod(p, NULL);
					XFree((voidstar)p);
				}
			}
		}
#endif
	}

	if (endp)
		*endp = end;

	return val;
}

int
WtNum(uchar *dst, int num)
{
	sprintf((char *)dst, "%d", num);
	return strlen((char *)dst);
}

int
WtNumber(uchar *dst, exprval_t num)
{
	sprintf((char *)dst, EXPRVAL_PRINTF_FMT, num);
	return strlen((char *)dst);
}

/******************************* EvalPcForm *******************************/

static uchar *
SkipPFmt(const uchar *p)
{
	p += strspn((const char *)p, "-+ #");
	p = SkipDigit(p);
	if (*p == '.')
		p = SkipDigit(p+1);
	return (uchar *)p;
}

static int
CommaNum(uchar *dst, const uchar *src)
{
	uchar *dstp = dst;
	const uchar *srcp = src;
	const uchar *srcp1;

	while (*srcp && !isalnum(*srcp))
		MoveMojiAdv(dstp, srcp);

	srcp1 = srcp;
	while (isalnum(*srcp))
		srcp++;

	dstp += StrCommaNum(dstp, srcp1, srcp - srcp1, ",", 1, 3);
	dstp += CopyStr(dstp, srcp);

	return dstp - dst;
}

static int
PFormatS(uchar *dst, const uchar *fmt, int f_type, const uchar *vals, int len)
{
	if (!*(fmt+1)) {
		/* tH[}bgw肪Ȃ΂̂܂܃Rs[ */
		return CopyStrN(dst, vals, len);
	} else {
		const uchar *p, *p2;
		int leftflag = (strchr((const char *)fmt+1, '-') != NULL);
		int fwidth = atoi((const char *)(p = fmt + 1 + strspn((const char *)fmt+1, "-+ #")));
		int zeroflag = !leftflag && fwidth > 0 && *p == '0';
		int fprec = (p2 = (uchar *)strchr((const char *)p, '.')) ? atoi((const char *)p2+1) :
			((f_type == 'S' || !f_type && !fwidth) && *p) ? fwidth : len;
			/* f_type=='S' fwidthw肪fprecw薳Ȃfprec=fwidth */
			/* f_type==0 fwidthw 0 fprecw薳Ȃfprec=0 */

		int plen;
		int flen;
			
		assert(fwidth >= 0);
		assert(fprec >= 0);
			
		if (len <= fprec)
			plen = len;
		else
			plen = NthIsKanji2(vals, fprec) ? fprec - 1 : fprec;
			
		flen = fwidth < plen ? 0 : fwidth - plen;
			
		if (leftflag) {
			CopyStrN(dst, vals, plen);
			memset(dst + plen, ' ', flen);
			*(dst + plen + flen) = '\0';
		} else {
			memset(dst, zeroflag ? '0' : ' ', flen);
			CopyStrN(dst + flen, vals, plen);
		}
		return plen + flen;
	}
}


int
PFormat(uchar *dst, const uchar *f_fmt, const uchar *vals, int len)
{
	uchar fmt[64];
	uchar tmp[64];
	exprval_t val = 0;
	uchar *fmtp;
	int f_type = 0;
	int n;

	fmt[0] = '%';
	if (f_fmt)
		strncpy((char *)fmt+1, (const char *)f_fmt, 50);
	else
		fmt[1] = '\0';
	
	fmtp = StrLast(fmt+1);
	if (isalpha(*fmtp)) {
		f_type = *fmtp;
		*fmtp = '\0';
	}

	if (f_type != 's' && f_type != 'S')
		val = RdNumber(vals, (const uchar **)NULL);
	
	fmtp = SkipPFmt(fmt+1);
	if (*fmtp) {
		if (!noerrmode)
#if UNIX
		{
			uchar *mbs = (uchar *)alloca(strlen((char *)f_fmt) * 2 + 1);
			sjis2mbstring((char *)mbs, (char *)f_fmt);
			Error("Invalid Format: %s", mbs);
		}
#else
			Error("Invalid Format: %s", f_fmt);
#endif
		else {
			fmtp = fmt+1;
			*fmtp = '\0';
		}
	}
	switch (f_type) {
	case 'S':
	case 's':
	case 0:
	_case_s:
		return PFormatS(dst, fmt, f_type, vals, len);
	case 'd':
		sprintf((char *)dst, strcat((char *)fmt, "ld"), (long)val);
		return strlen((char *)dst);
	case 'u':
		sprintf((char *)dst, strcat((char *)fmt, "lu"), (unsigned long)val);
		return strlen((char *)dst);
	case 'o':
		sprintf((char *)dst, strcat((char *)fmt, "lo"), (unsigned long)val);
		return strlen((char *)dst);
	case 'x':
		sprintf((char *)dst, strcat((char *)fmt, "lx"), (unsigned long)val);
		return strlen((char *)dst);
	case 'X':
		sprintf((char *)dst, strcat((char *)fmt, "lX"), (unsigned long)val);
		return strlen((char *)dst);
	case 'c':
		tmp[n = SetMoji((unsigned)val, tmp)] = '\0';	/* 當ɕϊ */
		return PFormat(dst, (uchar *)strcat((char *)fmt+1, "s"), tmp, n);

	case 'O':				/* Ordinal */
		n = MkNthNum(tmp, (long)val);
		return PFormat(dst, (uchar *)strcat((char *)fmt+1, "s"), tmp, n);
	case 'k':				/* kansuuji */
		n = StrKanjiNum(tmp, vals, len);
		return PFormat(dst, (uchar *)strcat((char *)fmt+1, "s"), tmp, n);
	case 'C':				/* numer whith thousand sep */
		n = CommaNum(tmp, vals);
		return PFormat(dst, (uchar *)strcat((char *)fmt+1, "s"), tmp, n);
	case 'r':
	case 'R':
		if (val < 1 || val > 3999)
			goto _case_s;

		n = MkRomNum(tmp, (int)val, isupper(f_type));
		return PFormat(dst, (uchar *)strcat((char *)fmt+1, "s"), tmp, n);
	case 'a':
	case 'A':
		if (val < 1 || val > 26)
			goto _case_s;

		sprintf((char *)dst, strcat((char *)fmt, "c"), (f_type - 1) + (int)val);

		return strlen((char *)dst);

#ifdef FLOATEXPR
	case 'f':
	case 'e':
	case 'E':
	case 'g':
	case 'G':
		*fmtp++ = f_type;
		*fmtp = '\0';

		sprintf((char *)dst, (char *)fmt, (double)val);

		return strlen((char *)dst);
#endif

	default:
		if (!noerrmode)
			Error("Unknown format type: %c", f_type);
		return 0;
	}
}


/**************************************/

static int
CopyEnvValN(uchar *dst, const uchar *name, int nlen)
{
	uchar *val = NULL;
	uchar var[128];
	CopyStrN(var, name, min(nlen, 127));
	StrUpper(var, var);
	val = (uchar *)getenv((char *)var);
	
	if (val) {
		return CopyStr(dst, val);
	} else {
		*dst = 0;
		return 0;
	}
}


int
CopyEnvVal(uchar *dst, const uchar *name)
{
	return CopyEnvValN(dst, name, strlen((const char *)name));
}

int
EvalPcForm(uchar *dst, const uchar *src, const uchar **endp)
/* src: <%-form2>   -- '%' ̎̕w */
{
	uchar *dstp = dst;
	const uchar *srcp = src;
	const uchar *sp0 = srcp;
	const uchar *sp1;
	int len;
	int n;

	uchar *fbuf = NULL;			/* ϊpobt@imalloc ŗ̈mہj */
	uchar *vbuf = NULL;			/* ϐi[pobt@imalloc ŗ̈mہj */

	if (IsExprPrimF(srcp)) {
		/*
		 * '%' <expr-prim-f>
		 */
		dstp += EvalExpr(dstp, srcp, &srcp, EXPR_PRIM);
	
	} else if (*srcp != '-' ? IsSym2_(*srcp) : IsSym2_(*(srcp+1))) {
		/* '%' ̌オp܂ '-'t̉pȂ */
		if (*srcp == '-')
			srcp++;
		sp1 = SkipDigit(srcp);
		srcp = SkipSym2(srcp);

		if (sp0 == sp1 && *srcp == '%') {
			/*
			 *  '%' <env-var> '%'
			 */
			if (!nevflag) {
				dstp += CopyEnvValN(dstp, sp0, srcp - sp0);
			}
			srcp++;
		} else if (sp1 == srcp) {
			/*
			 *	'%' ['-'] <arg-#>
			 */
			n = RdNum(sp0, &srcp);
			if (!nevflag)
				dstp += CopyArg(dstp, n);
		} else {
			/*
			 *  '%' ['-'] [<f-width>] <func-call*>
			 */
			if (sp1 > sp0)
				fbuf = DupStrDiff(sp0, sp1);
			len = FuncCall(dstp, sp1, srcp, &srcp, (exprval_t *)NULL);
			if (!nevflag) {
				if (fbuf) {
					vbuf = DupStrN(dstp, len);
					dstp += PFormat(dstp, fbuf, vbuf, len);
				} else {
					dstp += len;
				}
			}
		}
	} else switch (*srcp) {

#if 0	/* gݍ݊֐ cmd(str), _(str) ɖ䂸Ap~ */
	case '.':
		/*
		 * '%' '.' <expr-prim>
		 */
		vbuf = AEvalExpr(&len, srcp+1, &srcp, EXPR_PRIM);
		if (!nevflag)
			Command(vbuf);
		break;
#endif
	case ':':
		/*
		 * '%' ':' <format> <expr-prim-f>
		 */
		srcp = SkipSym2(SkipPFmt(srcp+1));
		fbuf = DupStrDiff(sp0+1, srcp);
		if (IsExprPrimF(srcp)) {
			vbuf = AEvalExpr(&len, srcp, &srcp, EXPR_PRIM);
			if (!nevflag) {
				dstp += PFormat(dstp, fbuf, vbuf, len);
			}
		}
		break;

#if 0	/* gݍ݊֐ fn(path, fname) ̂ŁA̓{c */
	case '/':
		/*
		 * '%' '/'
		 */
		srcp++;
		if (!nevflag) {
			if (*(dstp - 1) != DIRSLASH && *(dstp - 1) != ALTDIRSLASH)
				*dstp++ = DIRSLASH;
		}
		break;
#endif

	case '\\':
		/*
		 * '%' <\-sequence>
		 */
		dstp += ReadEscSequence(dstp, srcp+1, &srcp);
		break;
	case '%':
		/*
		 * '%' '%'
		 */
		srcp++;
		if (!nevflag)
			*dstp++ = '%';
		break;
	case '<':
		/*
		 * '%' '<'
		 */
		srcp++;
		if (!nevflag)
			*dstp++ = '{';
		break;
	case '>':
		/*
		 * '%' '>'
		 */
		srcp++;
		if (!nevflag)
			*dstp++ = '}';
		break;
	default:
		/*
		 * '%'
		 */
		/* '%' ̌オ̑̕ȂÂ܂ '%' Lɂ */
		if (!nevflag)
			*dstp++ = '%';
	}
	XFree((voidstar)fbuf);
	XFree((voidstar)vbuf);

	if (endp) *endp = srcp;
	if (!nevflag)
		*dstp = 0;
	assert(!nevflag || dstp == dst);
	return dstp - dst;
}




/******************************** FuncCall ********************************/

#if UNIX
#define ERROR_SS(fmt,n,s)												\
	do {																\
		uchar *_n, *_s;													\
		_n = (uchar *)alloca(strlen((char *)(n)) * 2 + 1);				\
		sjis2mbstring((char *)_n, (char *)(n));							\
		_s = (uchar *)alloca(strlen((char *)(s)) * 2 + 1);				\
		sjis2mbstring((char *)_s, (char *)(s));							\
		Error((uchar *)(fmt), _n, _s);									\
	} while (0)
#define ArgErr()		ERROR_SS("Invalid argument: %s%s", name, src)
#else
#define ArgErr()		Error(f_ArgErr, name, src)
static uchar f_ArgErr[] = "Invalid argument: %s%s";
#endif

#if UNIX
#define ManyArgErr() \
	ERROR_SS((IsExpr(srcp) ? "Too many arguments: %s%s" : "Invalid argument: %s%s"), name, src)
#else
#define ManyArgErr()	Error(IsExpr(srcp) ? f_ManyArgErr : f_ArgErr, \
								name, src)
static uchar f_ManyArgErr[] = "Too many arguments: %s%s";
#endif

static int
FuncCallSub(uchar *dst, const uchar *name, const uchar *src, const uchar **endp, exprval_t *fretvalp)
{
	uchar *dstp = dst;
	const uchar *srcp = src;
	uchar *vbuf = NULL;
	int   len = 0;
	uchar *p;
	sffnp_t 	funcp;
	sftype_t	sftype;
	int n1 = 0;
	int n2 = 0;
	exprval_t x1 = 0;
	exprval_t x2 = 0;
	uchar *vbuf2 = NULL;
	int len2 = 0;
	exprval_t val = 0;
	int fargcnt = 0;

	assert(!nevflag);
	assert(src != NULL);

	if ((sftype = GetSFunc(&funcp, name)) != SF_UNKNOWN) {
		/*
		 * <func> {<func-args> | <expr-prim-f>}
		 */
		if (*srcp != '(') {
			/* ʂň͂܂ĂȂꍇ */
			/* ̂݉\ */
			if (IsExprPrimF(srcp)) {
				fargcnt++;
				vbuf = AEvalExpr(&len, srcp, &srcp, EXPR_PRIM);
				if (sftype < SF_S) {
					x1 = exprval;
					if (x1 > INT_MIN && x1 < INT_MAX)
						n1 = (int)x1;
				}
			}
		} else {
			/*
			 * <func-args> : '(' [ <expr-asgn> { ',' <expr-asgn> }* ] ')'
			 */
			/* ʂň͂܂Ăꍇ */
			srcp++;
			CutSpace(srcp);
			if (sftype >= SF_S && IsExpr(srcp)) {
				/* ̏ */
				fargcnt++;
				vbuf = AEvalExpr(&len, srcp, &srcp, EXPR_SEMIMAX);
				if (*CutSpace(srcp) == ',')
					srcp++;
				
				if (sftype >= SF_Sn_Sn && *CutSpace(srcp) != ')') {
					/* QƂ֐̏ꍇ */
					fargcnt++;
					vbuf2 = AEvalExpr(&len2, srcp, &srcp, EXPR_SEMIMAX);
					if (*CutSpace(srcp) == ',')
						srcp++;
				}
			}
			if (*CutSpace(srcp) != ')') {
				/* l̏ */
				if ((sftype == SF_0 || sftype == SF_S || sftype == SF_Sn
									|| sftype == SF_Sn_Sn) && !noerrmode) {
					ManyArgErr();
				}
				fargcnt++;
				x1 = EvalExprVal(srcp, &srcp, EXPR_SEMIMAX);
				if (x1 >= INT_MIN && x1 <= INT_MAX)
					n1 = (int)x1;
				if (*CutSpace(srcp) == ',')
					srcp++;
				if (*CutSpace(srcp) != ')') {
					if ((sftype == SX_X || sftype == SF_X || sftype == SF_Sn_N
										|| sftype == SF_Sn_Sn_N)&&!noerrmode) {
						ManyArgErr();
					}
					fargcnt++;
					x2 = EvalExprVal(srcp, &srcp, EXPR_SEMIMAX);
					if (x2 >= INT_MIN && x2 <= INT_MAX)
						n2 = (int)x2;
					if (*CutSpace(srcp) == ',')
						srcp++;
				}
			}
			if (*CutSpace(srcp) == ')')
				srcp++;
			else {
				if (!noerrmode)
					ManyArgErr();
				srcp = SkipExpr(src, EXPR_PRIM, SKIP_NOERR);
			}
		}
		if (sftype >= SF_S && !vbuf)
			vbuf = DupStr("");

		fargc = fargcnt;

		switch (sftype) {
		case SF_0:
			len = ((sf00fnp_t)funcp)(dstp);
			break;
		case SF_X:
			len = ((sf01fnp_t)funcp)(dstp, x1);
			break;
		case SF_X_X:
			len = ((sf02fnp_t)funcp)(dstp, x1, x2);
			break;
		case SF_S:
			len = ((sfs0fnp_t)funcp)(dstp, vbuf);
			break;
		case SF_Sn:
			len = ((sf10fnp_t)funcp)(dstp, vbuf, len);
			break;
		case SF_Sn_N:
			len = ((sf11fnp_t)funcp)(dstp, vbuf, len, n1);
			break;
		case SF_Sn_N_N:
			len = ((sf12fnp_t)funcp)(dstp, vbuf, len, n1, n2);
			break;
		case SF_Sn_Sn:
			len = ((sf20fnp_t)funcp)(dstp, vbuf, len, vbuf2, len2);
			break;
		case SF_Sn_Sn_N:
			len = ((sf21fnp_t)funcp)(dstp, vbuf, len, vbuf2, len2, n1);
			break;
		case SF_Sn_Sn_N_N:
			len = ((sf22fnp_t)funcp)(dstp, vbuf, len, vbuf2, len2, n1, n2);
			break;
		case SX_X:
			val = ((sfx1fnp_t)funcp)(x1);
			len = (val == 0 || !fretvalp) ? WtNumber(dstp, val) : 0;
			break;
		case SX_X_X:
			val = ((sfx2fnp_t)funcp)(x1, x2);
			len = (val == 0 || !fretvalp) ? WtNumber(dstp, val) : 0;
			break;
		default:
			assert(FALSE);
		}
		*(dstp += len) = '\0';

	} else if ((p = GetSFVar(&len, name)) != NULL) {
		/*
		 * <func0arg>
		 */
		dstp += CopyStrN(dstp, p, len);
		if (*srcp == '(' && (srcp++, *CutSpace(srcp) == ')')) {
			srcp++;
		} else {
			srcp = src;
			if (fretvalp || IsExprPrimF(srcp)) {
				/* ֐Ăяo`̏ꍇ */
				if (!noerrmode)
					ManyArgErr();
				srcp = SkipExpr(srcp, EXPR_PRIM, SKIP_ELSE0);
			}
		}
	} else if (!noerrmode) {
#if UNIX
		uchar *mbs = (uchar *)alloca(strlen((char *)name) * 2 + 1);
		sjis2mbstring((char *)mbs, (char *)name);
		Error("Unknown function: %s", mbs);
#else
		Error("Unknown function: %s", name);
#endif
	}
	XFree((voidstar)vbuf2);
	XFree((voidstar)vbuf);
	if (endp) *endp = srcp;
	if (fretvalp) *fretvalp = val;
	return dstp - dst;
}


static int
FuncCall(uchar *dst, const uchar *name, const uchar *src, const uchar **endp, exprval_t *fretvalp)
{
	const uchar *srcp = src;
	macro_t		*macp;
	int			len = 0;

	assert(nevflag || dst != NULL);
	assert(src != NULL);

	name = DupStrDiff(name, src);

	unclosedflag = FALSE;	/* Xg̊ʂĂ邩̃`FbNp */

	if (nevflag || (macp = GetMacro(name)) != NULL) {
		if (IsExprPrimF(srcp)) {
			srcp = SkipExpr(src, EXPR_PRIM, SKIP_NOERR);
			if (unclosedflag && !nevflag && !noerrmode) {
				srcp = SkipExpr(src, EXPR_PRIM, SKIP_NORMAL);
				/* ŃG[ɂȂĂɂ͂Ȃ͂ */
				assert(FALSE);
			}
		}
		if (!nevflag && !unclosedflag) {
			uchar *vbuf;
			vbuf = (*src == '(' && srcp != src)
						  ? DupStrDiff(src+1, srcp-1)
						  : DupStrDiff(src, srcp);
			len = FuncMacroCall(dst, macp, vbuf);
			unclosedflag = FALSE;
			XFree((voidstar)vbuf);
		}
		if (fretvalp) *fretvalp = 0;
		if (endp) *endp = srcp;
	} else {
		len = FuncCallSub(dst, name, src, endp, fretvalp);
	}
	XFree((voidstar)name);
	return len;
}


/******************************* EvalString *******************************/

int
EvalString(uchar *dst, const uchar *src)
/* Ɂq%-ϊr{ł̃Rs[s */
/* dst Ɋi[ikjԂ */
{
	return EvalStringB(dst, src, (const uchar **)NULL, 0);
}

int
EvalStringB(uchar *dst, const uchar *src, const uchar **endp, int bflag)
/* bflag ^ȂA'{' ̎̕ŌĂ΂āAΉ '}' ܂œǂށB
 * ̏ꍇAŌ '}'̓Rs[Ȃœǂݎ̂ĂB
 */
{
	uchar *dstp = dst;
	const uchar *srcp = src;
	int nestlevel = 1;
	unsigned c;

	assert(nevflag || dst != NULL);
	assert(src != NULL);

	unclosedflag = FALSE;

	while (*srcp) {
		c = RdMoji(srcp);
		if (c == '%')
			dstp += EvalPcForm(dstp, srcp, &srcp);
		else {
			if (bflag) {
				if (c == '{')
					nestlevel++;
				else if (c == '}') {
					if (--nestlevel == 0)
						break;					/* ܂ */
				}
			}
			if (!nevflag)
				dstp += SetMoji(c, dstp);
		}
	}
	if (bflag && nestlevel != 0) {
		unclosedflag = TRUE;
		if (!noerrmode)
#if UNIX
		{
			uchar *mbs = (uchar *)alloca(strlen((char *)src) * 2 + 1);
			sjis2mbstring((char *)mbs, (char *)src);
			Error("'}' expected: {%s", mbs);
		}
#else
			Error("'}' expected: {%s", src);
#endif
	} else {
		unclosedflag = FALSE;
	}
	if (endp) *endp = srcp;
	if (!nevflag) *dstp = 0;
	assert(!nevflag || dstp == dst);
	return dstp - dst;
}


int
EvalStringN(uchar *dst, const uchar *src, int n)
{
	uchar *dstp = dst;
	uchar *dp1 = dst;
	const uchar *srcp = src;
	const uchar *src_e = src + n;

	assert(dst != NULL);
	assert(src != NULL);
	assert(n >= 0);

	while (srcp < src_e) {
		dp1 = dstp;
		if (*srcp == '%')
			dstp += EvalPcForm(dstp, srcp+1, &srcp);
		else
			MoveMojiAdv(dstp, srcp);
	}
	if (srcp > src_e)
		dstp = dp1;
	*dstp = 0;
	return dstp - dst;
}


/**************************************************************************/



int
EvalExprStr(uchar *dst, const uchar *src)
{
	return EvalExpr(dst, src, (const uchar **)NULL, EXPR_MAX);
}


exprval_t
EvalExprVal(const uchar *src, const uchar **endp, evlev_t evlevel)
/* ]ĐƂĂ̒lԂ */
{
	uchar *vbuf = AEvalExpr((int *)NULL, src, endp, evlevel);
	XFree((voidstar)vbuf);
	return exprval;
}

uchar *
SkipExpr(const uchar *src, evlev_t evlevel, skipmode_t skipmode)
/* ǂݔ΂ */
{
	int 	nevflag0 = nevflag;
	int 	noerrmode0 = noerrmode;
	uchar 	*vbuf;
	const uchar	*srcp;
	const uchar	*sp0 = SkipSpace(src);

	nevflag = TRUE;
	noerrmode = (skipmode != SKIP_NORMAL);
	vbuf = AEvalExpr((int *)NULL, sp0, &srcp, evlevel);
	XFree((voidstar)vbuf);
	
	if (unclosedflag || srcp == sp0) {
		switch (skipmode) {
		case SKIP_ELSE0:
			srcp = src;
			break;
		case SKIP_ELSE1:
			srcp = SkipMoji(sp0);
			break;
		default:
			;
		}
	}
	noerrmode = noerrmode0;
	nevflag = nevflag0;
	return (uchar*)srcp;
}

/**************************************/

/* AEval... ̈̊mەt */

#define AllocEvalBuf()	(nevflag ? (uchar *)NULL : (uchar *)XMalloc(evalbufsize))

static void
CheckEvalBufLen(int len)
{
	assert(!nevflag || len == 0);
	if (len >= (int)evalbufsize)
		FError("Eval buffer over");
}

uchar *
AEvalExpr(int *lenp, const uchar *src, const uchar **endp,
													evlev_t evlevel)
{
	int len;
	uchar *dst = AllocEvalBuf();
	len = EvalExpr(dst, src, endp, evlevel);
	CheckEvalBufLen(len);
	if (lenp) *lenp = len;
	return (uchar *)XRealloc((voidstar)dst, len+1);
}

uchar *
AEvalPcForm(int *lenp, const uchar *src, const uchar **endp)
{
	int len;
	uchar *dst = AllocEvalBuf();
	len = EvalPcForm(dst, src, endp);
	CheckEvalBufLen(len);
	if (lenp) *lenp = len;
	return (uchar *)XRealloc((voidstar)dst, len+1);
}

uchar *
AEvalString(int *lenp, const uchar *src)
{
	return AEvalStringB(lenp, src, (const uchar **)NULL, 0);
}

uchar *
AEvalStringB(int *lenp, const uchar *src, const uchar **endp, int bflag)
{
	int len;
	uchar *dst = AllocEvalBuf();
	len = EvalStringB(dst, src, endp, bflag);
	CheckEvalBufLen(len);
	if (lenp) *lenp = len;
	return (uchar *)XRealloc((voidstar)dst, len+1);
}

uchar *
AEvalStringN(int *lenp, const uchar *src, int n)
{
	int len;
	uchar *dst = AllocEvalBuf();
	len = EvalStringN(dst, src, n);
	CheckEvalBufLen(len);
	if (lenp) *lenp = len;
	return (uchar *)XRealloc((voidstar)dst, len+1);
}

uchar *
AEvalExprStr(int *lenp, const uchar *src)
{
	int len;
	uchar *dst = AllocEvalBuf();
	len = EvalExprStr(dst, src);
	CheckEvalBufLen(len);
	if (lenp) *lenp = len;
	return (uchar *)XRealloc((voidstar)dst, len+1);
}

uchar *
AReadString(int *lenp, const uchar *src)
{
	return AReadStringB(lenp, src, (const uchar **)NULL, EOF);
}

uchar *
AReadStringB(int *lenp, const uchar *src,const uchar **endp,int brkchr)
{
	int len;
	uchar *dst = AllocEvalBuf();
	len = ReadStringB(dst, src, endp, brkchr);
	CheckEvalBufLen(len);
	if (lenp) *lenp = len;
	return (uchar *)XRealloc((voidstar)dst, len+1);
}

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
