/* execdos.c */
/*****************************************************************************
					s@o@wsq

							mDOSR}hsn
*****************************************************************************/

#include "xtr.h"

#if defined(__TURBOC__) && __TURBOC__ > 0x0200
	/* Turbo C++ 1.0, Borland C++ 2.0  putenv ́Ã}jA̋Lqɂ
	   āAputenv ֐ strdup ɂĈRs[
	   environ ɓo^Ă̂ */
 #define PutEnv(env)		putenv(env)
#else
 #define PutEnv(env)		putenv(DupStr(env))
#endif


static uchar *
MakeTemp(uchar *buf)
{
#if MSDOS || WINNT
#define TEMPLATE "X$XXXXXX"
#else
#define TEMPLATE "xtrXXXXXX"
#endif

	static const uchar templet[] = TEMPLATE;
	if (tmppath) {			/* ϐ TMP  */
		strcpy((char *)buf, (char *)tmppath);
		PathCat(buf, templet);
	} else {
		strcpy((char *)buf, (const char *)templet);
	}
#if __human68k__
	{
#if DIRECT_SH
		extern char *_toslash();
		_toslash(buf);
#else /* !DIRECT_SH */
		extern char *_toslash(), *_tobslash();
		uchar *shell, *shelltype;
		enum {
			SHTYPE_COMMAND,
			SHTYPE_UNIX,
			SHTYPE_UNKNOWN
		} shtype;

		if ((shell = getenv("SYSTEM_SHELL")) != NULL) {
			shelltype = getenv("SYSTEM_SHELLTYPE");
		} else {
			shell = getenv("SHELL");
			shelltype = getenv("SHELLTYPE");
		}

		if (shelltype) {
			if (stricmp(shelltype, "COMMAND") == 0)
				shtype = SHTYPE_COMMAND;
			else if (stricmp(shelltype, "UNIX") == 0)
				shtype = SHTYPE_UNIX;
			else
				shtype = SHTYPE_UNKNOWN;
		} else {
			if (shell) {
				int len = strlen(shell);
				if ((len >= 7 && stricmp(shell + len - 7, "command") == 0) ||
				    (len >= 9 && stricmp(shell + len - 9, "command.x") == 0))
					shtype = SHTYPE_COMMAND;
				else
					shtype = SHTYPE_UNIX;
			} else {
				shtype = SHTYPE_COMMAND;
			}
		}

		switch (shtype) {
		case SHTYPE_COMMAND:
			_tobslash(buf);
			break;
		case SHTYPE_UNIX:
		case SHTYPE_UNKNOWN:
		default:
			_toslash(buf);
			break;
		}
#endif /* !DIRECT_SH */
	}
#endif /* __human68k__ */
	return (uchar *)mktemp((char *)buf);
}

#if DIRECT_SH
#if UNIX

#ifndef FILENAME_MAX
#define FILENAME_MAX 1024
#endif

#if !HAVE_PUTENV
extern int putenv ARGS((const char *));
#endif
extern void include_fd ARGS((int));
static int open_file ARGS((const uchar *, int));
static int exec_and_include ARGS((int, const uchar *cmd));
static void write_here_doc ARGS((int));
static const uchar *copy_filename ARGS((uchar *, const uchar *));
static int simple_output ARGS((const uchar *, int, int));
static int simple_include ARGS((const uchar *, int, int));
static int cmd_exec ARGS((const uchar *, int));

#if !HAVE_DUP2
int
dup2(int old_fd, int new_fd)
{
	close(new_fd);
	return dup(old_fd) != new_fd ? -1 : 0 ;
}
#endif

#define READ_MODE 0
#define CREATE_MODE 1
#define APPEND_MODE 2

static int
open_file(const uchar *fname, int mode)
{
	uchar *fn, *errmsg;
	int open_mode;
	int fd;

	if (fname == NULL || fname[0] == '\0') {
		errmsg = "Can't create temporary file.";
		fn = (uchar *)alloca(FILENAME_MAX);
		if (!MakeTemp(fn))
			Error(errmsg);
	} else {
		errmsg = "Can't create file: %s";
		fn = (uchar *)fname;
	}

	if (mode == 0)
		open_mode = O_RDONLY;
	else if (mode == 1)
		open_mode = O_RDWR | O_CREAT | O_TRUNC;
	else
		open_mode = O_WRONLY | O_CREAT | O_APPEND;

	if ((fd = open((char *)fn, open_mode, 0644)) < 0)
		Error(errmsg, fn);

	if (fname == NULL || fname[0] == '\0')
		unlink((char *)fn);

	return fd;
}

#ifdef SIGCHLD
static RETSIGTYPE reap_children ARGS((int));
static RETSIGTYPE
reap_children(int sig)
{
	int status;
	wait(&status);
}
#endif

static int
exec_and_include(int fd, const uchar *cmd)
{
	if (cmd[0] != '\0') {
#ifdef __human68k__
		uchar fname[FILENAME_MAX];
		int save_fds[2];
		int pipe_fd;

		if (fd != 0) {
			save_fds[0] = dup(0);
			dup2(fd, 0);
		}

		MakeTemp(fname);
		save_fds[1] = dup(1);
		pipe_fd = open_file(fname, CREATE_MODE);
		dup2(pipe_fd, 1);
		close(pipe_fd);

		spawnl(P_WAIT, "/bin/sh", "sh", "-c", cmd, (char *)NULL);

		if (fd != 0) {
			dup2(save_fds[0], 0);
			close(save_fds[0]);
			close(fd);
		}

		dup2(save_fds[1], 1);
		close(save_fds[1]);

		fd = open_file(fname, READ_MODE);
		unlink(fname);
#else /* !__human68k__ */
		int pipefds[2];
		pid_t child;

		if (pipe(pipefds) < 0)
			return 1;
#ifdef SIGCHLD
		signal(SIGCHLD, reap_children);
#endif
		if ((child = fork()) < 0)
			return 1;

		if (child == 0) {
			if (fd != 0) {
				dup2(fd, 0);
				close(fd);
			}
			dup2(pipefds[1], 1);
			close(pipefds[0]);
			close(pipefds[1]);

			execl("/bin/sh", "sh", "-c", cmd, (char *)NULL);

			_exit(127);
		}

		if (fd != 0)
			close(fd);
		close(pipefds[1]);

		fd = pipefds[0];
#endif /* !__human68k__ */
	}

	if (fd != 0) {
		int save_tmpincludeflag = tmpincludeflag;
		tmpincludeflag = 1;
		include_fd(fd);
		tmpincludeflag = save_tmpincludeflag;
	}

	return 0;
}

static void
write_here_doc(int fd)
{
	int len, n, buflen;
	uchar *buf, *mbbuf;
	int contlnflag;

	contlnflag = 0;
	while ((len = GetLine()) != 0) {
		ILineNoCount();
		if (contlnflag ||
		    *ibuf == cmddot_mchar ||
		    cmddot_char && *ibuf == cmddot_char) {
			n = CommandLineEnd(ibuf + 1, contlnflag) - ibuf;
			if (!contlnflag &&
			    CheckBlockEnd(ibuf + 1, n - 1, contlnflag, (const uchar **)NULL))
				break;
			contlnflag = ibuf[n] == '\\';
		}
		buf = AEvalStringN(&buflen, ibuf, len);
		mbbuf = (uchar *)alloca(buflen * 2 + 1);
		sjis2mbstring((char *)mbbuf, (char *)buf);
		write(fd, (char *)mbbuf, strlen((char *)mbbuf));
		XFree((voidstar)buf);
	}
}

static const uchar *
copy_filename(uchar *dst, const uchar *src)
{
	int c;

	while ((c = *src) != '\0' && !isspace(c)) {
		*dst++ = c;
		src++;
	}
	*dst = '\0';

	return src;
}

/* !>ofile */
/* !>ofile { */
static int
simple_output(const uchar *cmd, int block_mode, int open_mode)
{
	uchar fname[FILENAME_MAX];
	int fd;

	copy_filename(fname, SkipSpace(cmd + open_mode));
	fd = open_file(fname, open_mode);
	if (block_mode)
		write_here_doc(fd);
	close(fd);

	return 0;
}

/* !<ifile >ofile */
/* !<ifile */
static int
simple_include(const uchar *cmd, int block_mode, int open_mode)
{
	uchar src_fname[FILENAME_MAX];
	const uchar *p;

	p = copy_filename(src_fname, SkipSpace(cmd + open_mode));
	p = SkipSpace(p);
	if (*p == '>') {
		uchar dst_fname[FILENAME_MAX];
		char buffer[4096];
		int read_fd, write_fd;
		int n;

		n = 0;
		while (*p == '>') {
			p++;
			n++;
		}
		p = SkipSpace(p);
		if (*p == '\0')
			return 1;

		copy_filename(dst_fname, p);

		read_fd = open_file(src_fname, READ_MODE);
		write_fd = open_file(dst_fname, n);
#ifdef __human68k__
		setmode(read_fd, O_BINARY);
		setmode(write_fd, O_BINARY);
#endif
		while ((n = read(read_fd, buffer, sizeof(buffer))) > 0)
			write(write_fd, buffer, n);
		close(write_fd);
		close(read_fd);
	} else {
		int save_tmpincludeflag = tmpincludeflag;
		tmpincludeflag = 0;
		Include(src_fname, 1);
		tmpincludeflag = save_tmpincludeflag;
	}

	return 0;
}

/* !{ */
/* ! cmd { */
/* ! cmd >ofile { */
/* ! */
/* ! cmd */
/* ! cmd >ofile */
static int
cmd_exec(const uchar *cmd, int block_mode)
{
	int ret = 0;
	int fd = 0;
	const uchar *p;
	int c;

	if (block_mode) {
		fd = open_file((uchar *)NULL, CREATE_MODE);
		write_here_doc(fd);
		lseek(fd, (off_t)0, 0);
	}

	p = cmd;
	while ((c = *p) != '\0' && c != '=' && !isspace(c))
		p++;
	if (c == '=') {
		putenv((char *)cmd);
	} else if (c != '\0' &&
		   strnicmp("SET", (const char *)cmd, p - cmd) == 0 &&
		   (p = SkipSpace(p)) != NULL &&
		   *p != '\0') {
		uchar *buf, *bp;

		bp = buf = (uchar *)alloca(strlen((const char *)p) + 1);
		while ((c = *p) != '\0' && c != '=' && !isspace(c))
			*bp++ = c;
		*bp++ = '=';
		strcpy((char *)bp, (char *)(*p == '=' ? p + 1 : p));
		putenv((char *)buf);
	} else
		ret = exec_and_include(fd, cmd);

	return ret;
}

static void
exec_sh_command(const uchar *src)
{
	int block_mode = 0;
	int ret = 0;
	int len, buflen, n;
	uchar *buf, *cmd;

	src = CutSpace(src);
	len = strlen((const char *)src);
	if (StrNthE(src, len - 1) == '{') {
		block_mode = 1;
		len--;
	}

	buf = AEvalStringN(&buflen, src, len);
	cmd = SkipSpace(buf);

	if ((n = strspn((char *)cmd, ">")) > 0) {
		ret = simple_output(cmd, block_mode, n);
	} else if ((n = strspn((char *)cmd, "<")) > 0) {
		ret = simple_include(cmd, block_mode, n);
	} else {
		ret = cmd_exec(cmd, block_mode);
	}

	XFree((voidstar)buf);

	buf = (uchar *)alloca(32);
	WtNum(buf, ret);
	SetRetValue(DupStr(buf), strlen((char *)buf));
}
#endif /* UNIX */
#endif /* DIRECT_SH */

void
ExecDosCommand(const uchar *src)
/* src: <dos-command-line> ['{']*/
{
#if UNIX && DIRECT_SH
	exec_sh_command(src);
#else /* !(UNIX && DIRECT_SH) */

#ifndef FILENAME_MAX
#if MSDOS || WINNT
#define FILENAME_MAX 80
#else
#define FILENAME_MAX 1024
#endif
#endif
	const uchar *srcp = CutSpace(src);
	uchar fname1[FILENAME_MAX];
	uchar fname2[FILENAME_MAX];
	FILE  *fp = NULL;
#if UNIX
	uchar *cmdbuf;
#else
	uchar cmdbuf[160];
#endif
	uchar *vbuf = NULL;
	uchar *cmdp;
	uchar *p;
	uchar *argp;
	int   len;
	int   ret = 0;
	int   block_mode = 0;
	int   output_include = 0;
	int   simple_output = 0;
	int   simple_include = 0;
	int   void_cmd = 0;

#if UNIX
#define ALLOCA(p,n) p = (uchar *)alloca((n))
	fname1[0] = fname2[0] = '\0';
	cmdbuf = "";
#else
#define ALLOCA(p,n)
	fname1[0] = fname2[0] = cmdbuf[0] = '\0';
#endif

	len = strlen((const char *)srcp);
	if (StrNthE(srcp, len-1) == '{') {
		block_mode = 1;
		--len;
	}
	vbuf = AEvalStringN(&len, srcp, len);
	cmdp = SkipSpace(vbuf);

	if (!*cmdp) {
		void_cmd = 1;
	} else if (simple_output = strspn(cmdp, ">")) {
		strcpy(fname1, SkipSpace(cmdp + simple_output));
		if ((fp = fopen(fname1, simple_output == 1 ? WRITE_TEXT : APPEND_TEXT)) == NULL)
			Error("Can't create file: %s", fname1);
	} else if (simple_include = strspn(cmdp, "<")) {
		strcpy(fname2, SkipSpace(cmdp + simple_include));
	}
	if (!simple_output && !(p = strrchr(cmdp, '>')) || strchr(p, '\"')) {
		/* o̓_CNgwi>...jo͂荞ރ[h */
		output_include = 1;
	}

	if (block_mode) {
		/* ubN */
		int   contlnflag = 0;

		if (!simple_output) {
			if (!MakeTemp(fname1) ||
				(fp = fopen(fname1, WRITE_TEXT)) == NULL ||
				(output_include && !MakeTemp(fname2)))
			Error("Can't create temporary file.");
		}
		if (output_include) {
			if (void_cmd) {
				/* !{ */
				strcpy(fname2, fname1);
			} else {
				/* ! cmd { */
				ALLOCA(cmdbuf,
				       strlen(cmdp) + strlen(fname1) + strlen(fname2) + 5);
				sprintf(cmdbuf, "%s <%s >%s", cmdp, fname1, fname2);
			}
		} else if (simple_output) {
			/* !>ofile { */
			;
		} else {
			/* ! cmd >ofile { */
			ALLOCA(cmdbuf, strlen(cmdp) + strlen(fname1) + 3);
			sprintf(cmdbuf, "%s <%s", cmdp, fname1);
		}
		for ( ; ; ) {
			uchar *buf;

			if (!(len = GetLine()))			/* Psǂ ibuf Ɋi[ */
				break;						/* EOF ȂI */
			ILineNoCount();
			if (contlnflag || *ibuf==cmddot_mchar ||
							cmddot_char && *ibuf==cmddot_char) {
				int n = CommandLineEnd(ibuf+1, contlnflag) - ibuf;
				if (!contlnflag &&
						CheckBlockEnd(ibuf+1, n-1, contlnflag, (uchar **)NULL))
					break;					/* ".}" ŏI */
				contlnflag = ibuf[n] == '\\';
			}
			buf = AEvalStringN(&len, ibuf, len);
			fwrite(buf, 1, len, fp); 	/* ǂ񂾍st@Cɏ */
			XFree((voidstar)buf);
		}

	} else {
		/* ubNȂ */
		if (output_include) {
			if (void_cmd) {
				/* ! */
			} else if (simple_include) {
				/* !<ifile */
				;
			} else {
				/* ! cmd */
				if (!MakeTemp(fname2))
					Error("Can't create temporary file.");
				ALLOCA(cmdbuf, strlen(cmdp) + strlen(fname2) + 3);
				sprintf(cmdbuf, "%s >%s", cmdp, fname2);
			}
		} else if (simple_output) {
			/* !>ofile */
			;
		} else if (simple_include) {
			/* !<ifile >ofile */
#if UNIX
# if __human68k__
#   define BINCAT "cat %s"
# else
#   define BINCAT "/bin/cat %s"
# endif
#else
# define BINCAT "TYPE %s"
#endif
			ALLOCA(cmdbuf, strlen(cmdp + 1) + 10);
			sprintf(cmdbuf, BINCAT, cmdp + 1);
		} else {
			/* ! cmd >ofile */
			ALLOCA(cmdbuf, strlen(cmdp) + 1);
			strcpy(cmdbuf, cmdp);
		}
	}
	if (fp)
		fclose(fp);

	if (!simple_output) {
		for (argp = cmdp; *argp && *argp != '=' && !isspace(*argp); argp++) ;
		p = NULL;
		if (*argp) {
			if (*argp == '=') {		/* ϐݒ */
				p = argp;
				argp = cmdp;
			} else {
				*argp++ = '\0';
				CutSpace(argp);
			}
		}
		if (!cmdbuf[0]) {
			;
		} else if (p || !stricmp(cmdp, "SET") && (p = strchr(argp, '='))) {
			/*
			 * ϐ̃Zbg
			 *  envvar=value
			 *  SET envvar=value
			 */
#ifndef UNIX
			*p = '\0';
			StrUpper(argp, argp);
#endif
			*p = '=';
			PutEnv(argp);			/* SETR}h́Aɕϊ */
			output_include = 0;
		} else {
			ret = system(cmdbuf);			/* DOS R}hs */
		}
		if (output_include &&
				(simple_include || FileExists(fname2))) {
			int tmpincludeflag0 = tmpincludeflag;
			tmpincludeflag = !simple_include;
			Include(fname2, 1);			/* o͂荞 */
			if (!simple_include)
				remove(fname2);				/* e|t@C */
			tmpincludeflag = tmpincludeflag0;
		}
		if (block_mode)
			remove(fname1);
	}
	XFree((voidstar)vbuf);

	/* ^[R[hZbg */
	ALLOCA(cmdbuf, 32);
	WtNum(cmdbuf, ret);
	vbuf = DupStr(cmdbuf);
	SetRetValue(vbuf, strlen(vbuf));
#endif /* !(UNIX && DIRECT_SH) */
}

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
