/* xstring.c */
/*****************************************************************************
					s@o@wsq

							mcnrˑhn֘An
*****************************************************************************/

#include "xtr.h"

#if UNIX
# if !__human68k__
#   if HAVE_TERMIOS_H && HAVE_TERMIOS_FUNCS
#     include <termios.h>
#   else
#     if HAVE_TERMIO_H
#       include <termio.h>
#     else
#       include <sgtty.h>
#       if HAVE_SYS_IOCTL_H
#         include <sys/ioctl.h>
#       endif
#     endif
#   endif
#   if HAVE_SYS_SELECT_H
#     include <sys/select.h>
#   endif
# endif
#endif /* UNIX */

#if __human68k__
#define __DOS_INLINE__
#include <sys/dos.h>
#endif

#if UNIX
#ifndef __human68k__
static int close_tty = 0;
#endif
#endif

static RETSIGTYPE CDECL
CBreakHandler(int sig)
{
#if UNIX
#if !__human68k__
	if (RawMode(-1))
		RawMode(OFF);
#endif
#endif
	assert(sig == SIGINT);
	signal(sig, SIG_DFL);
	FError("USER ABORT");
}

static int cbrk_save;

static int
GetCBrk(void)
/* Rg[u[N`FbN̐ݒԂ擾 */
{
#if MSDOS
	union REGS regs;
	regs.x.ax = 0x3300;
	intdos(&regs, &regs);
	return regs.h.dl;
#else
#if __human68k__
	return _dos_breakck(-1);
#else
	return 0;
#endif
#endif
}

static int
SetCBrk(int cval)
/* Rg[u[N`FbNZbg */
{
#if MSDOS
	union REGS regs;
	regs.x.ax = 0x3301;
	regs.h.dl = cval;
	intdos(&regs, &regs);
	return regs.h.dl;
#else
#if __human68k__
	return _dos_breakck(cval);
#else
	return 0;
#endif
#endif
}

void
InitCBreak(void)
/* Ctrl-C 荞ݏ */
{

	signal(SIGINT, CBreakHandler);		/* Ctrl-C 荞݃nho^ */

	cbrk_save = GetCBrk();
	SetCBrk(1);							/* Enable Ctrl-C */
}

void
TermCBreak(void)
{
	SetCBrk(cbrk_save);
}

/**************/

void
ChgStdin(void)
/* stdin _CNgĂꍇA
 * _CNg͂̃t@C|C^ stdin  ifp ɕςāA
 * R\[͂ stdin ɂ
 */
{
#if MSDOS || WINNT || __human68k__
#define TTY "CON"
#else
#define TTY "/dev/tty"
#endif

	int fh;

	if ((fh = dup(fileno(stdin))) == -1) {
		perror("dup");
		FError("");
	}
	if ((ifp = fdopen(fh, "r")) == NULL) {
		perror("fdopen");
		FError("");
	}
	SetInMode(ifp);
	if (freopen(TTY, "r", stdin) == NULL) {
#if MSDOS || WINNT || __human68k__
		perror("freopen");
		FError("");
#else
		close_tty = 1;
#endif
	}
#ifdef UNIX
	setbuf(stdin, NULL);
#endif
}

void
SetModeB(FILE *fp, int binflag)
{
#if MSDOS || WINNT
	setmode(fileno(fp), (binflag ? O_BINARY : O_TEXT));
#ifdef __TURBOC__
	if (binflag)
		fp->flags |= _F_BIN;
	else
		fp->flags &= ~_F_BIN;
#endif
#else
#if __human68k__
	fmode(fp, binflag ? _IOBIN : _IOTEXT);
#endif
#endif
}

void
SetFModeB(int binflag)
{
#if MSDOS || WINNT || __human68k__
	_fmode = (binflag ? O_BINARY : O_TEXT);
#endif
}

void
SetInMode(FILE *fp)
/* ͂R\[`FbN */
{
#if __human68k__
	fmode(fp, _fmode == O_BINARY ? _IOBIN : _IOTEXT);
#endif
#if MSDOS || WINNT || UNIX
	coninmode = isatty(fileno(fp));
#endif
}


void
SetOutMode(FILE *fp)
/* o͂R\[v^`FbN */
{
#if MSDOS
	int fn = fileno(fp);
	union REGS regs;

	regs.x.bx = fn;
	regs.x.ax = 0x4400;					/* Get IOCTL Data */
	intdos(&regs, &regs);
	assert((isatty(fn) == 0) == ((regs.x.dx & 0x80) == 0));
	if ((regs.x.dx & 0x80) == 0) {
		/* foCXł͂Ȃ */
		conoutmode = prnoutmode = OFF;
	} else if (regs.x.dx & 0x01) {
		/* R\[o͂ł */
		conoutmode = ON;
		prnoutmode = OFF;
	} else {
		/* łȂ΃v^o͂낤 */
		regs.h.dh = 0;
		regs.h.dl |= 0x20;				/* raw mode */
		regs.x.bx = fn;
		regs.x.ax = 0x4401;				/* Set IOCTL Data */
		intdos(&regs, &regs);
		conoutmode = OFF;
		prnoutmode = ON;
	}
#else
#if WINNT
	conoutmode = isatty(fileno(fp));
#else
#if UNIX
	conoutmode = isatty(fileno(fp));
	prnoutmode = OFF;
#endif /* UNIX */
#endif /* !WINNT */
#endif /* !MSDOS */
}

#if UNIX
#if !__human68k__

#ifndef FD_SET
#define fd_set long
#define FD_SET(n,p) (*(p) |= (1 << (n)))
#define FD_ZERO(p) (*(p) = 0)
#endif

#if !HAVE_FLUSHALL
int
flushall()
{
	fflush(stdout);
	fflush(stderr);
	if (ofp != NULL)
		fflush(ofp);

	return 0;
}
#endif

#if !HAVE_SELECT
int
select(int nfds, fd_set *rfds, fd_set *wfds, fd_set *efds, struct timeval *timeout)
{
	return 1;
}
#endif

int
kbhit()
{
	struct timeval zero;
	fd_set fds;

	zero.tv_sec = 0;
	zero.tv_usec = 0;
	FD_ZERO(&fds);
	FD_SET(fileno(stdin), &fds);
	return select(fileno(stdin) + 1, &fds, (fd_set *)NULL, (fd_set *)NULL, &zero) <= 0
		? 0 : 1 ;
}

int
getch()
{
	uchar c;

	flushall();
	while (read(fileno(stdin), &c, 1) != 1)
		;
	return c;
}

int
RawMode(int flag)
{
	static int raw_mode = 0;

	if (close_tty)
		FError("There is no control-terminal.");

#if HAVE_TERMIOS_H && HAVE_TERMIOS_FUNCS
	struct termios s;
	static struct termios os;

	if (flag > 0) {
		tcgetattr(fileno(stdin), &s);
		memcpy(&os, &s, sizeof(struct termios));
		s.c_lflag &= ~(ICANON | ECHO | ECHOE | ECHOK | ECHONL);
		s.c_cc[VMIN] = 1;
		s.c_cc[VTIME] = 0;
		raw_mode = 1;
	} else if (flag == 0) {
		memcpy(&s, &os, sizeof(struct termios));
		raw_mode = 0;
	}
	tcsetattr(fileno(stdin), TCSADRAIN, &s);
#else /* !(HAVE_TERMIOS_H && HAVE_TERMIOS_FUNCS) */
#if HAVE_TERMIO_H
	struct termio s;
	static struct termio os;

	if (flag > 0) {
		ioctl(fileno(stdin), TCGETA, &s);
		memcpy(&os, &s, sizeof(struct termio));
		s.c_lflag &= ~(ICANON | ECHO | ECHOE | ECHOK | ECHONL);
		s.c_cc[VMIN] = 1;
		s.c_cc[VTIME] = 0;
		raw_mode = 1;
	} else if (flag == 0) {
		memcpy(&s, &os, sizeof(struct timeio));
		raw_mode = 0;
	}
	tcsetattr(fileno(stdin), TCSETAW, &s);
#else /* !HAVE_TERMIO_H */
	struct sgttyb s;
	static struct sgttyb os;

	if (flag > 0) {
		ioctl(fileno(stdin), TIOCGETP, &s);
		memcpy(&os, &s, sizeof(struct sgttyb));
		s.sg_flags |= CBREAK;
		s.sg_flags &= ~ECHO;
		raw_mode = 1;
	} else if (flag == 0) {
		memcpy(&s, &os, sizeof(struct sgttyb));
		raw_mode = 0;
	}
	ioctl(fileno(stdin), TIOCSETN, &s);
#endif /* !HAVE_TERMIO_H */
#endif /* !(HAVE_TERMIOS_H && HAVE_TERMIOS_FUNCS) */

	return raw_mode;
}
#endif /* !__human68k__ */
#endif /* UNIX */

/********** t@CɊւ鏈 ******************************/


int
IsFileName(const uchar *s)
/* ^ȂA s ̓t@C̎wł邩Ȃ */
{
#ifdef UNIX
	return *s == DIRSLASH ? *(s+1) != '\0' :
	       *s == '.' ||
	       isalnum(*s) ||
	       (*s && strchr("!#$%&()+,.^_`{}~", *s) != NULL);
#else
	return (*s == DIRSLASH || *s == ALTDIRSLASH) ? *(s+1) != '\0' :
	       *s == '.' ||
		   *s >= 0x80 ||
	       isalnum(*s) ||
	       (*s && strchr("$&#%'_^(){}~!", *s) != NULL);
	       /* DOSŉ\ȃt@C '-'  '@' ͏Ă */
#endif
}

int
FileExists(const uchar *fname)
/* t@C݂邩ׂ */
{
#ifndef F_OK
#define F_OK 0
#endif
#if UNIX
	return fname[0] != '\0' && access((const char *)fname, F_OK) == 0;
#else
	return access(fname, F_OK) == 0;
#endif
}

uchar *
FNameExt(const uchar *fname)
/* t@CɊgq邩ׁA炻 '.' ւ̃|C^Ԃ */
/* Ȃ΁ANULL Ԃ */
{
	const uchar *p;

	p = (const uchar *)strrchr((const char *)fname, '.');
#if MSDOS || WINNT || __human68k__
	if (p && (jstrchr(p, DIRSLASH) || jstrchr(p, ALTDIRSLASH)))
#else
	if (p && strchr((const char *)p, DIRSLASH))
#endif
		p = NULL;
	return (uchar*)p;
}

uchar *
FNameName(const uchar *fname)
/* fBNgt̃pX珃t@Ĉ݂Ԃ */
{
#if MSDOS || WINNT || __human68k__
	const uchar *p;
	const uchar *p2;

	p = (fname[0] && fname[1] == ':') ? fname+2 : fname;
	p2 = jstrrchr(p, DIRSLASH);
	if (p2) p = p2 + 1;
	p2 = jstrrchr(p, ALTDIRSLASH);
	if (p2) p = p2 + 1;
	return (uchar*)p;
#else	
	const uchar *p;

	p = (const uchar *)strrchr((const char *)fname, DIRSLASH);
	return (uchar *)(p != NULL ? p + 1 : fname);
#endif
}

int
FNameHasPath(const uchar *fname)
/* t@CpXtׂ */
{
#if MSDOS || WINNT || __human68k__
	return fname[0] == '.' ||
	       fname[0] == DIRSLASH ||
	       fname[0] == ALTDIRSLASH ||
	       fname[0] && fname[1] == ':';
#else
	return fname[0] == '.' || fname[0] == DIRSLASH;
#endif
}

uchar *
PathCat(uchar *path, const uchar *fname)
/* pXɃt@CȂ */
{
	RTrimSpace(path);

	if (!*path) {
		return (uchar *)strcpy((char *)path, (const char *)fname);
	} else {
		int c = *StrLast(path);
#if MSDOS || WINNT || __human68k__
		if (c != DIRSLASH && c != ALTDIRSLASH)
#else
		if (c != DIRSLASH)
#endif
			strcat((char *)path, DIRSLASHS);
		return (uchar *)strcat((char *)path, (const char *)fname);
	}
}

uchar *
PathFName(const uchar *path, const uchar *fname)
#if 0			/* {c */
/* t@C fname pXXg path ̃fBNgŌ
 * ÃpXtt@CAȂ NULL Ԃ
 */
{
	uchar *paths;
	uchar *p;
	int fnamelen = strlen(fname);
	uchar *pfname = NULL;

	paths = DupStr(pathlist);

	for (p = strtok(paths, PATH_DELIMITS);
				p && !pfname;
				p = strtok((char *)NULL, PATH_DELIMITS)) {
		pfname = (uchar *)XMalloc(strlen(p) + fnamelen + 16);
		strcpy(pfname, p);
		PathCat(pfname, fname);
		if (!FileExists(pfname)) {
			XFree((voidstar)pfname);
			pfname = NULL;
		}
	}
	XFree((voidstar)paths);
	return (uchar *)XRealloc((voidstar)pfname, strlen(pfname) + 1);
}
#else
#if UNIX
{
#if __human68k__
#define ISCOLON(c) ((c) == ':' || (c) == ';')
#define DRIVEPASS(p) (isalpha((p)[0]) && (p)[1] == ':' ? (p) + 2 : (p))
#else
#define ISCOLON(c) ((c) == ':')
#define DRIVEPASS(p) (p)
#endif
	const uchar *p, *end;
	uchar *fullpath;
	int fnamelen, len;

	fnamelen = strlen((const char *)fname);
	p = path;
	for (;;) {
		while (ISCOLON(*p))
			p++;
		if (*p == '\0')
			return NULL;
		end = DRIVEPASS(p);
		while (!ISCOLON(*end) && *end != '\0')
			end++;
		len = end - p;
		fullpath = (uchar *)XMalloc(len + fnamelen + 2);
		memcpy(fullpath, p, len);
		fullpath[len] = '\0';
		PathCat(fullpath, fname);
		if (FileExists(fullpath))
			return fullpath;
		XFree((voidstar)fullpath);
		p = end;
	}
}
#else /* !UNIX */
/* path ̃fBNg͂P */
{
	uchar *pfname = (uchar *)XMalloc(strlen(path) + strlen(fname) + 16);

	strcpy(pfname, path);
	PathCat(pfname, fname);
	return (uchar *)XRealloc((voidstar)pfname, strlen(pfname) + 1);
}
#endif /* !UNIX */
#endif

uchar *
ChgExt(const uchar *fnam, const uchar *fext)
/* gqtւ */
{
	const uchar *p;
	uchar 	*fname;
	int 	dotpos;

	if (*fext == '.')
		fext++;

	p = FNameExt(fnam);
	dotpos = p ? p - fnam : strlen((const char *)fnam);

	fname = (uchar *)XMalloc(dotpos + strlen((const char *)fext) + 16);

	memcpy(fname, fnam, dotpos);
	fname[dotpos] = '.';
	strcpy((char *)fname + dotpos + 1, (const char *)fext);
	return (uchar *)XRealloc((voidstar)fname, strlen((const char *)fname) + 1);
}

int
SameFile(const uchar *fnam1, const uchar *fnam2)
{
#if UNIX
#if __human68k__
	return (*STRCMP)(fnam1, fnam2) == 0;
#else
	return (strcmp((const char *)fnam1, (const char *)fnam2) == 0);
#endif
#else
	return (stricmp(fnam1, fnam2) == 0);
#endif
}

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
