/* display.c */
/*****************************************************************************
					s@o@wsq

				mfBXvCóClCdn
*****************************************************************************/

#include "xtr.h"

static int displayflag = OFF;

/************************** Disp **************************************/

#define PL(n)			((n) == 1 ? ' ' : 's')
#if  __human68k__
#define CONDRV_OFF(fp) fprintf((fp), "\033" "0")
#define CONDRV_ON(fp)  fprintf((fp), "\033" "1")
#else
#define CONDRV_OFF(fp)
#define CONDRV_ON(fp)
#endif

#define FNAME2LENMAX  38			/* Q̃t@C̒̍v̍ől */

#define NARROWS  (sizeof(arrowv)/sizeof(arrowv[0]))

/* ʐ̃GXP[vV[PX */
#if MSDOS
 #define E_CLRLN	"\033[K"		/* s܂ŃNA */
 #define E_MORE		"\033[;7m"		/* "-- More --" ̑ */
 #define E_GUIDE	"\033[35m"		/* g\̑ */
 #define E_PLAIN	"\033[m"		/* NA */
#else
#if __human68k__
 #define E_CLRLN	"\033[K"		/* s܂ŃNA */
 #define E_MORE		"\033[;7m"		/* "-- More --" ̑ */
 #define E_GUIDE	"\033[31m"		/* g\̑ */
 #define E_PLAIN	"\033[m"		/* NA */
#else
 #define E_CLRLN	""
 #define E_MORE		""
 #define E_GUIDE	""
 #define E_PLAIN	""
#endif
#endif

void
Disp(int endflag)
/* soߕ\ */
{
	static uchar *arrowv[] = {
							"-xtr->",
							"xt-r>-",
							"xtr>--",
							"-->xtr",
							"->x-tr",
							">-xtr>"
							};

	static int arrowc = 0;
	static uchar *previfilename = NULL;
	static uchar *prevofilename = NULL;
	static long fsize = 0;
	static uchar *ifile = NULL;
	static uchar *ofile = NULL;

	long fbytes;
	int fpar;
	long ofbytes;
	struct stat st;

	unsigned ilines = ilineno;
	unsigned olines = lineno;

	if (conoutmode || coninmode || silentmode || tmpincludeflag)
		return;

	if (ifilename != previfilename || ofilename != prevofilename) {
		/* ̓t@Co̓t@COƕςĂ */

		ifile = ifilename;
		ofile = ofilename;

		if (strlen((char *)ifile) + strlen((char *)ofile) > FNAME2LENMAX) {
			/* t@C̒̍vFNAME2LENMAXzȂ悤 */
			ifile = FNameName(ifile);
			if (strlen((char *)ifile) + strlen((char *)ofile) > FNAME2LENMAX) {
				ofile = FNameName(ofile);
			}
		}
		
		arrowc = 0;
		
		/* ̓t@C̃TCY𒲂ׂ */

		if (fstat(fileno(ifp), &st) == -1)
			return;

		fsize = st.st_size;

#if 0
		if (displayflag) {
			fprintf(stderr, "\n");	/* Õt@Čoߕ\Ήs */
		}
#endif
	}
	
	assert(ifile != NULL);
	assert(ofile != NULL);
	
	if (fsize == 0)
		return;

	if (endflag) {
		/* t@CIĂ痈Ȃ */
		fbytes = fsize;
		fpar = 100;
		arrowc = 0;
		--ilines;		/* JEgĂ镪߂ */
		--olines;
	} else if ((fbytes = ftell(ifp)) != -1L)
		fpar = (int)((fbytes * 100) / fsize);
	else
		return;						/* ftell ŃG[ */

	CONDRV_OFF(stderr);
	if (binarymode) {
		if (prnoutmode || (ofbytes = ftell(ofp)) == -1L) {
			fprintf(stderr, "\r%s %5ld Byte%c (%3d%%) %s %s" E_CLRLN "\r",
				ifile, fbytes, PL(fbytes),
				fpar, arrowv[arrowc], ofile);
		} else {
			fprintf(stderr,
				"\r%s %5ld Byte%c (%3d%%) %s %s %5ld Byte%c" E_CLRLN "\r",
				ifile, fbytes, PL(fbytes),
				fpar, arrowv[arrowc], ofile, ofbytes, PL(ofbytes));
		}
	} else {
		if (pagemode && !plaintextmode || abspageno > 1) {
			fprintf(stderr, "\r%s %4u Line%c (%3d%%) %s %s %2d Page%c" E_CLRLN "\r",
			   ifile, ilines, PL(ilines),
			   fpar, arrowv[arrowc], ofile, abspageno, PL(abspageno));
		} else {
			fprintf(stderr, "\r%s %4u Line%c (%3d%%) %s %s %4u Line%c" E_CLRLN "\r",
				ifile, ilines,PL(ilines),
				fpar, arrowv[arrowc], ofile, olines, PL(olines));
		}
	}
	if (endflag) {
		fprintf(stderr, "\n");
		displayflag = OFF;
	} else
		displayflag = ON;
	CONDRV_ON(stderr);

	if (!arrowc--)
		arrowc = NARROWS - 1;

	previfilename = ifilename;
	prevofilename = ofilename;
}



/************************** More **************************************/

void
More(void)
/* so͂̂Ƃɗ */
{
#if MSDOS || WINNT || __human68k__
	unsigned c;
	int reenterflag = 0;

	if (delaymode && conoutmode && !coninmode) {
		/* 胂[hij */
		int k;
		for (k = 0; k / 16 < delaytime; k++) kbhit();
	}
	if (!(moremode && conoutmode && !coninmode &&
					morecnt > 0 && --morecnt == 0))
		return;

	CONDRV_OFF(stdout);
	do {
		printf(E_MORE "-- More --" E_PLAIN);
		fflush(stdout);

		while (!kbhit()) ;		/* ^C 荞݂󂯕t邽 */

		c = getch();
		if (iskanji(c)) {
			c = c * 0x100 + getch();
		}
		printf("\r          " E_CLRLN "\r");
		reenterflag = 0;
		switch (c) {
		case '\r':
			morecnt = 1;		/* bqꂽ玟̈s\ */
			break;
		case ' ':				/* Xy[XȂ玟̂P */
		case ZENSP:
			morecnt = moresize;
			break;
		case '\033':			/* drbL[ȂIɂ */
			Terminate(0);
			break;
		default:				/* ̑̃L[Ȃ HELP */
			printf("            " E_GUIDE
				   "<Return> Next line, <Space> Next screen, <ESC> Exit"
				   E_PLAIN "\r");
			reenterflag = 1;
		}
	} while (reenterflag);
	CONDRV_ON(stdout);
#endif
}


/********************* Error ******************************************/

static void
CheckDisp(void)
{
	if (displayflag) {
		Disp(0);
		CONDRV_OFF(stderr);
		fprintf(stderr, "\n");	/* oߕ\ssĂ */
		CONDRV_ON(stderr);
		displayflag = OFF;
	}
}

#if UNIX
#define BELL_STR ""
#else
#define BELL_STR "\a"
#endif

static void
VError(const uchar *fmt, va_list argp, int ferrorflag)
{
	errorflag++;

	flushall();

	if (intextflag || includeflag) {
		CheckDisp();

		fprintf(stderr, "%s %4u %s*** ", ifilename, ilineno, BELL_STR);
		if (fmt && *fmt) {
			vfprintf(stderr, (const char *)fmt, argp);
			fprintf(stderr, " ***");
		}
		fprintf(stderr, ferrorflag ? " !!\n" : "\n");

		if (ferrorflag)
			Terminate(3);				/* exit failure */

		More();

		longjmp(errorjb, ERR);
	} else {
		fprintf(stderr, "XTR: %s*** ", BELL_STR);
		vfprintf(stderr, (const char *)fmt, argp);
		fprintf(stderr, " ***\n");
		Terminate(2);					/* exit failure */
	}
}

/* G[bZ[WoĒEo */
void
Error(const uchar *fmt, ...)
{
	va_list argp;
	VA_START(argp, fmt);
	VError(fmt, argp, 0);
	va_end(argp);
}


void
FError(const uchar *fmt, ...)
/* vIG[ */
{
	va_list argp;
	VA_START(argp, fmt);
	VError(fmt, argp, 1);
	va_end(argp);
}


void
Message(const uchar *fmt, ...)
/* PɃbZ[W\ */
{
	va_list argp;
	VA_START(argp, fmt);
	CheckDisp();
	vfprintf(stderr, (const char *)fmt, argp);
	va_end(argp);
}

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
