/* define.c */
/*****************************************************************************
					s@o@wsq

							mu`n
*****************************************************************************/

#include "xtr.h"


#define ModeCmp(mode1, mode2) (\
					  (signed)((mode1) & R_CMPMASK)\
					- (signed)((mode2) & R_CMPMASK))

#define RemoveSpecial()													\
    do {																\
		if (rlistpp != &srlist_top)										\
			DefineRpl(fnd, fndlen, rpl, rpllen,							\
					  mode | R_SPECIAL, cmode, grp, &srlist_top);		\
	} while (0)

static void
DefineRpl(const uchar *fnd, int fndlen, const uchar *rpl, int rpllen, unsigned mode, unsigned cmode, unsigned grp, rpl_t **rlistpp)
/* ̌Eȗgo^ */
/* (mode & R_REMOVE) Ȃ` */
{
	rpl_t *rlist, *rlist1 = NULL, *rlist0 = NULL;
	def_t *slist, *slist1 = NULL, *slist0 = NULL;
	int cmp = -1;
	int pref = TOUPPER(*fnd);

#if RE3_REGEXP
	if (remodeno == 3) {
		if (strchr(".*+?[({", pref) != NULL)
			pref = WILD_PREF;
		else if (pref == '\\')
			pref = TOUPPER(fnd[1]);
	} else
#endif
	if (mode & R_IZENHAN) {
		unsigned c = Moji(fnd);
 		if (Is1B(c) ? !iscntrl(c) : IsANKZen(c))
			pref = WILD_PREF;
	}

	if (fndlen) {
		for (rlist = *rlistpp;
				rlist != NULL;
				rlist1 = rlist, rlist = rlist->prev) {
			if ((cmp = (pref - rlist->pref)) == 0) {
				break;
			} else if (cmp > 0) {
				rlist0 = rlist;
				break;
			}
		}
	}

	if (fndlen && cmp != 0) {
		if (mode & R_REMOVE) {
			RemoveSpecial();
			return;				/* `̂ɒ`폜wȂAA */
		}
		rlist = (rpl_t *)XMalloc(sizeof(rpl_t));
		rlist->pref = pref;			/* 擪i啶jo^ */
		rlist->gmode = 0;
		rlist->maxlen = 0;
		rlist->slist = NULL;

		if (rlist1 == NULL) {
			rlist->prev = *rlistpp;
			*rlistpp = rlist;
		} else {
			rlist->prev = rlist0;
			rlist1->prev = rlist;
		}
	}

	cmp = -1;
	if (fndlen) {
		for ( slist = rlist->slist;
			  slist != NULL;
			  slist1 = slist, slist = slist->prev) {

			if ((cmp = memcmp(fnd, slist->fnd,
									min(fndlen, slist->fndlen))) == 0 &&
				(cmp = fndlen - slist->fndlen) == 0 &&
				(cmp = ModeCmp(mode, slist->mode)) == 0) {
				break;
			} else if (cmp > 0) {
				slist0 = slist;
				break;
			}
		}
	}
	if (cmp != 0) {
		if ((mode & R_REMOVE) && fndlen) {
			RemoveSpecial();
			return;				/* `̂ɒ`폜wȂAA */
		}
		slist = (def_t *)XMalloc(sizeof(def_t));
		if (fndlen == 0) {
			/* 񂪋Ȃ烊Xgɂ͓Ȃ */
		} else if (slist1 == NULL) {
			slist->prev = rlist->slist;
			rlist->slist = slist;
		} else {
			slist->prev = slist0;
			slist1->prev = slist;
		}
	} else {
		/* łɒ`΂ */
		assert(fndlen > 0);
		if (mode & R_REMOVE) {
			/* 폜Ȃ */
			mode = slist->mode | R_REMOVE;
			cmode = slist->cmode;
			grp = slist->grp;
		} else {
			VFree(slist->fnd);
			VFree(slist->rpl);
		}
	}
	if (!(mode & R_REMOVE) || !fndlen) {
		slist->fnd = DupStrN(fnd, fndlen);
		slist->fndlen = fndlen;
		slist->rpl = rpllen ? DupStrN(rpl, rpllen) : NULL;
		slist->rpllen = rpllen;
		slist->mode = mode;
		slist->cmode = cmode;
		slist->grp = grp;
#if RE3_REGEXP
		if (remodeno == 3)
			reg_compile((const char *)fnd, fndlen, mode);
#endif
	}
	if (mode & R_REMOVE) {		/* `폜wȂ */
		mode = slist->mode;
		if (fndlen) {
			/* `폜 */
			if (slist1 == NULL) {
				if (slist->prev == NULL) {
					/* rlist ɂЂƂ݂̂ꍇArlist 폜 */
					if (rlist1 == NULL) {
						*rlistpp = rlist->prev;
					} else {
						rlist1->prev = rlist->prev;
					}
					VFree(rlist);
				} else {
					rlist->slist = slist->prev;
				}
			} else {
				slist1->prev = slist->prev;
			}
#if RE3_REGEXP
			if (remodeno == 3)
				reg_free((const char *)fnd, fndlen, mode);
#endif
		}
		if (cmode) {
			RemFCntrl(&c_reset, slist);
			RemFCntrl(&c_terminate, slist);
			RemFCntrl(&c_newline, slist);
			RemFCntrl(&c_newpage, slist);
			RemFCntrl(&c_reset2, slist);
			RemFCntrl(&c_areset, slist);
			RemFCntrl(&c_vreset, slist);
			RemFCntrl(&c_qreset, slist);
			RemFCntrl(&c_wreset, slist);
			RemFCntrl(&c_hreset, slist);
			RemFCntrl(&c_freset, slist);
			RemFCntrl(&c_kicode, slist);
			RemFCntrl(&c_kocode, slist);
			RemFCntrl(&c_hicode, slist);
			RemFCntrl(&c_hocode, slist);
			RemFCntrl(&c_pagefont, slist);
			RemFCntrl(&c_pagekicode, slist);
			RemFCntrl(&c_pagekocode, slist);
		
			if (cmode == C_DOTCMD && (mode == R_SOL) && fndlen == 1
								  && cmddot_char == *fnd) {
				cmddot_char = 0;
			}
		}
		XFree((voidstar)slist->fnd);
		XFree((voidstar)slist->rpl);
		VFree(slist);
	} else {
		/* `o^ */
		int fndlen1 = fndlen;
		
		if (mode & R_IZENHAN)
			fndlen1 *= 2;
		if (mode & (R_EOL | R_EOL2 | R_EOW2 | R_EOW1))
			fndlen1 += 2;
		if (fndlen != 0 && fndlen1 > rlist->maxlen)
			rlist->maxlen = fndlen1;
		if (strchr((const char *)fnd, '\n'))
			rlist->gmode |= G_OVERNL;
		if (slist->mode & R_WILD)
			rlist->gmode |= G_WILD;

		switch (cmode) {
		case C_ARESET:
			c_areset = AddCntrl(c_areset, slist);
			break;
		case C_WRESET:
			c_wreset = AddCntrl(c_wreset, slist);
			break;
		case C_VRESET:
			c_vreset = AddCntrl(c_vreset, slist);
			break;
		case C_QRESET:
			c_qreset = AddCntrl(c_qreset, slist);
			break;
		case C_HRESET:
			c_hreset = AddCntrl(c_hreset, slist);
			break;
		case C_FRESET:
			c_freset = AddCntrl(c_freset, slist);
			break;
		case C_RESET:
			c_reset = AddCntrl(c_reset, slist);
			break;
		case C_TERMINATE:
			c_terminate = AddCntrl(c_terminate, slist);
			break;
		case C_NEWLINE:
			c_newline = AddCntrl(c_newline, slist);
			break;
		case C_NEWPAGE:
			c_newpage = AddCntrl(c_newpage, slist);
			break;
		case C_RESET2:
			c_reset2 = AddCntrl(c_reset2, slist);
			break;
		case C_KICODE:
			ResetCntrl(&c_kicode);
			c_kicode = AddCntrl((def_t *)NULL, slist);
			break;
		case C_KOCODE:
			ResetCntrl(&c_kocode);
			c_kocode = AddCntrl((def_t *)NULL, slist);
			break;
		case C_HICODE:
			ResetCntrl(&c_hicode);
			c_hicode = AddCntrl((def_t *)NULL, slist);
			break;
		case C_HOCODE:
			ResetCntrl(&c_hocode);
			c_hocode = AddCntrl((def_t *)NULL, slist);
			break;
		case C_DOTCMD:
			if (!cmddot_char && (mode == R_SOL) && fndlen == 1) {
				cmddot_char = *fnd;
			}
			break;
		default:
			;
		}
	}
	if (!fndlen && slist) {
		XFree((voidstar)slist->fnd);
		XFree((voidstar)slist->rpl);
		XFree((voidstar)slist);
	}
}



/*************************** DefineRplStr *********************************/

/*
* u`̃tH[}bgF
*  y^b^^b^{b{{b{zy}b}}b}$b$$b$zy/uy/[hzz
*
* ꂪ '/' ŋ؂ĕĂ悢
*/


#if RE3_REGEXP
static int ReadFndRegexp ARGS((uchar *, int *, const uchar *, const uchar **));
#endif

static int
ReadFndStr(uchar *dst, int *lenp, const uchar *src, const uchar **endp)
{
	const uchar *srcp = src;
	const uchar *sp1;
	uchar *dstp = dst;
	int n;
	int mode = 0;
	int quoteflag = FALSE;
	int c1, c2;

	assert(dst != NULL);
	assert(lenp != NULL);
	assert(src != NULL);
	assert(endp != NULL);

#if RE3_REGEXP
	if (remodeno == 3)
		return ReadFndRegexp(dst, lenp, src, endp);
#endif
	if (*srcp == '"') {
		srcp++;
		quoteflag = TRUE;
	}
	/* y^b^^b^{b{{b{z ǂ */
	if (remodeno > 0) {
		if (*srcp == '^') {
			if (*++srcp == '^' || *srcp == '{') {
				mode |= R_SOL2;
				++srcp;
			} else {
				mode |= R_SOL;
			}
		} else if (*srcp == '{') {
			if (*++srcp  == '{') {
				mode |= R_SOW2;
				++srcp;
			} else {
				mode |= R_SOW1;
			}
		}
	}
	/*  ǂ */
	sp1 = srcp;
	
	while (*srcp && (quoteflag || *srcp != '/')) {
		if (*srcp == '"') {
			srcp++;
			quoteflag = !quoteflag;
		} else if (*srcp == '\\') {
			srcp++;
			dstp += ReadEscSequence(dstp, srcp, &srcp);
		} else if (remodeno < 2) {
			MoveMojiAdv(dstp, srcp);
		} else if (*srcp == '?') {
			/* ChJ[h '?': 1 ̔Cӂ̕Ƀ}b` */
			*dstp++ = WILD_PREF;
			*dstp++ = WILD_SINGLE;
			mode |= R_WILD;
			srcp++;
		} else if (*srcp == '*') {
			/* ChJ[h '*' : 0 ȏ̔Cӂ̕Ƀ}b` */
			/* ChJ[h "**": 0 ȏ̔Cӂ̕邢͎Ƀ}b` */
			*dstp++ = WILD_PREF;
			*dstp++ = *(srcp+1) == '*' ? WILD_XMULTI : WILD_MULTI;
			mode |= R_WILD;
			while (*++srcp == '*');		/* dȂ */
		} else if (*srcp == ' ') {
			/* ChJ[h ' ': 0 ȏ̋󔒕XLbv */
			/* ChJ[h "  ": 1 ȏ̋󔒕XLbv */
			*dstp++ = WILD_PREF;
			*dstp++ = *(srcp+1) == ' ' ? WILD_SPACE : WILD_OPTSPACE;
			mode |= R_WILD;
			while (*++srcp == ' ');		/* dȂ */
		} else {
			MoveMojiAdv(dstp, srcp);
		}
	}
	
	n = srcp - sp1;
	if (StrNthE(sp1, n-1) == '"')
		--n;

	/* Ṓy}b}}b}$b$$b$z𒲂ׂ */

	if (dstp-1 < dst || !(c1 = StrNthE(sp1, n-1)) || c1 != *(dstp-1))
		c1 = c2 = 0;
	if (dstp-2 < dst || !(c2 = StrNthE(sp1, n-2)) || c2 != *(dstp-2))
		c2 = 0;

	if (remodeno > 0) {
		if (c1 == '$') {
			--dstp;
			if (c2 == '$' || c2 == '}') {
				mode |= R_EOL2;
				--dstp;
			} else {
				mode |= R_EOL;
			}
		} else if (c1 == '}') {
			--dstp;
			if (c2 == '}') {
				mode |= R_EOW2;
				--dstp;
			} else {
				mode |= R_EOW1;
			}
		}
	}
	*dstp = '\0';
	*lenp = dstp - dst;
	*endp = srcp;

	return mode;
}

#if RE3_REGEXP
int
ReadFndRegexp(uchar *dst, int *len, const uchar *src, const uchar **end)
{
	const uchar *tmp;
	uchar *save;
	int quote;
	int mode;
	int c;

	save = dst;
	quote = FALSE;
	mode = R_WILD;

	if (*src == '"') {
		src++;
		quote = TRUE;
	}

	if (*src == '^') {
		src++;
		mode |= R_SOL;
	}

	while ((c = *src) != '\0' && (quote || c != '/'))
		switch (c) {
		case '"':
			src++;
			quote = !quote;
			break;
		case '(':
		case '|':
			src++;
			*dst++ = c;
			if (*src == '^') {
				src++;
				*dst++ = '\\';
				*dst++ = '^';
			}
			break;
		case '$':
			src++;
			if (*src == '|' || *src == ')')
				*dst++ = '\\';
			*dst++ = c;
			break;
		case '\\':
			src++;
			if ((c = *src) != '\0' && strchr("$()*+.?[]^{|}", c) != NULL) {
				src++;
				*dst++ = '\\';
				*dst++ = c;
			} else {
				int n;

				n = ReadEscSequence(dst, src, &tmp);
				if (strchr("$()*+.?[]^{|}", *dst) != NULL) {
					c = *dst;
					*dst++ = '\\';
					*dst++ = c;
				} else {
					dst += n;
				}
				src = tmp;
			}
			break;
		default:
			MoveMojiAdv(dst, src);
			break;
		}

	if (dst[-1] == '$' && StrNthE(save, dst - save - 2) != '\\') {
		dst--;
		mode |= R_EOL;
	}

	*dst = '\0';
	*len = dst - save;
	*end = src;

	return mode;
}
#endif

#define WORKBUFSIZE		1024

void
DefineRplStr(const uchar *str)
/* u`ǂݒuXgւ̒`o^s */
{
	const uchar *s = str;
	uchar *p;
	uchar *fndstr = NULL;
	uchar *rplstr = NULL;
	int fndlen;
	int rpllen;
	unsigned mode;
	unsigned cmode;
	unsigned grp;
	uchar buf[WORKBUFSIZE];

	while (*s != '\0') {
		mode = 0;
		cmode = 0;
		grp = 0;

		p = fndstr = buf;

		mode = ReadFndStr(fndstr, &fndlen, s, &s);

		p += fndlen + 1;

		if (*s != '/') {	/* ̌ '/' Ȃ`̍폜 */
			DefineRpl(fndstr, fndlen, "", 0, mode | R_REMOVE, 0, 0,
						&rlist_top);
			continue;
		}
		s++;						/* '/' ̕ */

		/* u ǂ */
		rplstr = p;
		rpllen = ReadStringB(rplstr, s, &s, '/');

		/* ǔ́y/[hcz */
		if (*s == '/') {
			uchar *mstr = AReadStringB((int *)NULL, s+1, &s, '/');
			uchar *mp = mstr;
			while (*mp) {
				if (isdigit(*mp)) {
					/* O[vwȂ */
					grp = (uchar)strtol((char *)mp, (char**)&mp, 10);
				} else switch (*mp++) {
				case '-':		/* remove def. */
					mode |= R_REMOVE;
					break;

#if 0	/* sEsEꓪEꖖ ̎w͌ł̂ŁAsv */
				case '@':
					if (*mp == '@') {
						++mp;
						if (*mp == '^') {
							++mp;
							mode |= R_SOW2;
						} else if (*mp == '$') {
							++mp;
							mode |= R_EOW2;
						} else
							mode |= R_SOW2 | R_EOW2;
					} else {
						if (*mp == '^') {
							++mp;
							mode |= R_SOW1;
						} else if (*mp == '$') {
							++mp;
							mode |= R_EOW1;
						} else
							mode |= R_SOW1 | R_EOW1;
					}
					break;
				case '^':
					if (*mp == '^') {
						++mp;
						mode |= R_SOL2;
					} else
						mode |= R_SOL;
					break;
				case '$':
					if (*mp == '$') {
						++mp;
						mode |= R_EOL2;
					} else
						mode |= R_EOL;
					break;
#endif

				case 'i':		/* Ignore case */
					mode |= R_ICASE;
					break;
				case 'I':		/* Ignore case and zen/han */
					mode |= R_ICASE | R_IZENHAN;
					break;
				case 'Z':		/* Ignore zen/han */
					mode |= R_IZENHAN;
					break;
				case 's':		/* Same length */
					mode |= R_SAMELEN;
					break;
				case 'm':		/* Macro */
					mode |= R_MACRO;
					break;
				case 'M':		/* Macro with Eval */
					mode |= R_MACRO | R_EVAL;
					break;
				case 'E':		/* Eval */
					mode |= R_EVAL;
					break;
				case 'S':		/* Special */
					mode |= R_SPECIAL;
					break;
				case 'n':		/* No replace */
					rpllen = CopyStr(rplstr, "%0");
					mode |= R_EVAL;
					break;
				case 'N':		/* Non length */
					cmode = C_NIL;
					break;
				case 'a':		/* display Attribute */
					cmode = C_ATTR;
					break;
				case 'A':		/* display Attribute reset */
					cmode = C_ARESET;
					break;
				case 'w':		/* Wide */
					cmode = C_WIDE;
					break;
				case 'W':		/* Wide reset */
					cmode = C_WRESET;
					break;
				case 'v':		/* Vartical expand */
					cmode = C_VEXPAND;
					break;
				case 'V':		/* Vartical expand reset */
					cmode = C_VRESET;
					break;
				case 'q':		/* Quard expand */
					cmode = C_QEXPAND;
					break;
				case 'Q':		/* Quard expand reset */
					cmode = C_QRESET;
					break;
				case 'h':		/* Half */
					cmode = C_HALF;
					break;
				case 'H':		/* Half reset */
					cmode = C_HRESET;
					break;
				case 'f':		/* Font */
					cmode = C_FONT;
					break;
				case 'F':		/* Font reset */
					cmode = C_FRESET;
					break;
				case 'T':		/* Terminate */
					cmode = C_TERMINATE;
					break;
				case 'L':		/* newLine */
					cmode = C_NEWLINE;
					break;
				case 'P':		/* newPage */
					cmode = C_NEWPAGE;
					break;
				case 'r':		/* Reset */
					cmode = C_RESET;
					break;
				case 'R':		/* Reset attr */
					cmode = C_RESET2;
					break;
				case 'k':		/* Kanji-in code */
					cmode = C_KICODE;
					break;
				case 'K':		/* Kanji-out code */
					cmode = C_KOCODE;
					break;
				case 'j':		/* HW in */
					cmode = C_HICODE;
					break;
				case 'J':		/* HW out */
					cmode = C_HOCODE;
					break;
				case '.':		/* dot command line */
					cmode = C_DOTCMD;
					break;
				case '/':		/* indent setting */
					cmode = C_INDSET;
					break;
				case '>':		/* left expand */
					cmode = C_LEXPAND;
					break;
				case '<':		/* right expand */
					cmode = C_REXPAND;
					break;
				case '\\':		/* escape */
					cmode = C_ESCAPE;
					break;
				case '%':		/* %-form */
					cmode = C_PCFORM;
					break;
				case '|':		/* line break */
					cmode = C_LBREAK;
					break;
				case '{':		/* verbatim begin */
					cmode = C_VBEGIN;
					break;
				case '}':		/* verbatim end */
					cmode = C_VEND;
					break;
				default:
					Error("Unknown replace mode: %c", *(mp-1));
				}
			}
			XFree((voidstar)mstr);
		}
		p += rpllen + 1;

		if (p >= buf + WORKBUFSIZE)
			FError("Work buffer over");

		if ((mode & (R_SAMELEN | R_WILD | R_EVAL)) == R_SAMELEN &&
				rpllen > fndlen) {
#if UNIX
			uchar *mbs = (uchar *)alloca(rpllen * 2 + 1);
			sjis2mbstring((char *)mbs, (char *)rplstr);
			Error("New-string longer than old-string: %s", mbs);
#else
			Error("New-string longer than old-string: %s", rplstr);
#endif
		}

		if (mode & R_SPECIAL) {
			/* Special tȂ rlist_top ̑ srlist_top g */
			DefineRpl(fndstr, fndlen, rplstr, rpllen, mode, cmode, grp,
						&srlist_top);
		} else {
			DefineRpl(fndstr, fndlen, rplstr, rpllen, mode, cmode, grp,
						&rlist_top);
		}

		/* ؂ / 菜 */
		if (*s == '/')
			s++;
	}
}


void
ResetRplList(rpl_t **rlistpp)
/* u`Xg *rlistpp Jċɂ */
{
	rpl_t *p = *rlistpp;
	rpl_t *pprev;

	assert(rlistpp != NULL);

	while (p) {
		pprev = p->prev;
		ResetCntrl(&p->slist);
		XFree((voidstar)p);
		p = pprev;
	}
	*rlistpp = NULL;

	if (rlistpp == &rlist_top)
		cmddot_char = 0;
}

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
