/* command.c */
/*****************************************************************************
					s@o@wsq

							mR}hn
*****************************************************************************/

#include "xtr.h"

#define COMMENT_MARK			';'
#define COMMENT_LINE_MARK		'*'


/******************************** Command *********************************/

static uchar *SpecialCommand ARGS((const uchar *cmd));

void
Command(const uchar *cmds)
{
	const uchar *p1;
	uchar *cmd;

	CutSpace(cmds);

	while (*cmds && (cmds = SpecialCommand(cmds)) != NULL) {
		p1 = SkipCommandArg(cmds);
		cmd = DupStrDiff(cmds, p1);
		SimpleCommand(cmd);
		XFree((voidstar)cmd);
		cmds = SkipSpace(p1);
	}
}


#define IsSlashParamCmd(p)		(isalpha(*(p)) && (*((p)+1) == '/' || \
				(isalpha(*((p)+1)) && *((p)+2) == '/')))


static uchar *
SpecialCommand(const uchar *cmd)
/* VvłȂR}hB
 * s܂őR}h NULL ԂB
 * R}hĎc肪΁Ac̃R}hւ̃|C^ԂB
 * ȂɂȂ炽Ƃ̃|C^ԂB
 */
{
	do {
		switch (*cmd) {
		case COMMENT_MARK:			/* ; */
		case COMMENT_LINE_MARK:		/* * */
			cmd = NULL;
			break;
		case '!':					/* ! : exec dos-command */
			ExecDosCommand(cmd+1);
			cmd = NULL;
			break;
		case '$':					/* $[<n>] : save parameters with counter */
		case '+':					/* +[<n>] : save parameters with counter */
			cmd++;
		_case_num:
			if (*cmd == '(' || isdigit(*cmd)) {
				int num = *cmd == '(' ? (int)EvalExprVal(cmd, &cmd, EXPR_PRIM)
									: (int)strtol((char *)cmd, (char **)&cmd, 10);
				PushParam(num);
								/* ݂̃p[^ԂuX^bNvɕۑ */
								/* lŎw肳ꂽso͂ԕ*/
				ClearRetValue();
			} else if (*cmd == ']') {
				cmd++;				/* $] : restore parameters 2 */
				PopParam(-2);		/* ŏ̃x܂Ŗ߂ */
				ClearRetValue();
			} else {
				/* ̂Pŝݐ`[hύX */
				PushParam(-1);		/* ݂̃p[^Ԃۑ */
				Command(cmd);		/* c̃R}h */
				PopParam(-1);		/* ̃[hɖ߂ */
				cmd = NULL;
			}
			break;
		case '[':					/* [ : save parameters */
			PushParam(-1);			/* ݂̃p[^Ԃۑ */
			cmd++;
			ClearRetValue();
			break;
		case ']':					/* ] : restore parameters */
			PopParam(-1);			/* Õp[^Ԃ𕜌 */
			cmd++;
			ClearRetValue();
			break;
		case '/':					/* / : break line */
			FreshLine();			/* s̓rȂs */
			cmd++;
			ClearRetValue();
			break;
		case '.':					/* . : ignore */
			cmd++;
			break;
		case '-':					/* - : verbatim mode 1 */
			Command(clrcmd1);
			if (*++cmd == '-') {	/* -- : verbatim mode 2 */
				Command(clrcmd2);
				cmd++;
			}
			break;
		case '#':					/* # : eval expr */
		case '?':					/* ? : eval and watch expr */
			if (*cmd == '#' && *(cmd+1) == '#') {
				/* '##' ... }N` */
				DefineCommand(cmd+2);
				ClearRetValue();
			} else {
				/* '#' ... ̕] */
				/* '?' ... ̕]ƕ\ */
				EvalReturnExpr(cmd+1, EXPR_MAX);
				if (*cmd == '?') {
#if UNIX
					uchar *mbs;

					if (retvalue.s) {
						mbs = (uchar *)alloca(retvalue.len * 2 + 1);
						sjis2mbstring((char *)mbs, (char *)retvalue.s);
					} else
						mbs = (uchar *)"";
					Message("%s\n", mbs);
#else /* !UNIX */
					Message("%s\n", retvalue.s ? retvalue.s : (uchar *)"");
#endif /* !UNIX */
				}
			}
			cmd = NULL;
			break;
		case '&':					/* & : eval string and exec commands */
			cmd = AEvalString((int *)NULL, cmd+1);
			Command(cmd);
			XFree((voidstar)cmd);
			cmd = NULL;
			break;
		default:
#if 1		/* 폜ƁAڐlÂ`̓G[ɂȂ */
			if (isdigit(*cmd))		/* l <num> ̎w +<num> Ɠ */
				goto _case_num;
#endif

			if (MacroCommand(cmd)) {			/* }NR}h */
				cmd = NULL;

#if 0		/* LɂƁAph/`Ȃǂ͂PsɂЂƂȂȂ */
			} else if (IsSlashParamCmd(cmd)) {
				/* g/hɂÂp[^Ƃꍇ */
				SimpleCommand(cmd);
				cmd = NULL;
#endif
			} else {
				return (uchar *)cmd;				/* A */
			}
		}
	} while (cmd && *CutSpace(cmd));

	return NULL;
}


/**************************************/

void
EvalReturnExpr(const uchar *expr, evlev_t evlevel)
{
	uchar *val;
	int len;

	assert(expr != NULL);

	val = AEvalExpr(&len, expr, NULL, evlevel);
	if (len == 0) {
		XFree((voidstar)val);
		ClearRetValue();
	} else
		SetRetValue(val, len);
	retvalue.len = len;
}


/***************************** SkipCommandArg *****************************/

uchar *
SkipCommandArg(const uchar *s)
/* P̃R}hǂ݂񂾃|C^Ԃ */
{
	const uchar *p = s;

	while (*p && !isspace(*p)) {
		switch (*p) {
		case '(':
		case '{':
		case '"':
			p = SkipExpr(p, EXPR_PRIM, SKIP_ELSE1);
			break;
		case '/':
		case '\\':
			p = SkipStringB(p, 0);
			break;
		default:
			p = SkipMoji(p);
		}
	}
	return (uchar*)p;
}


/***************************** CommandLineEnd *****************************/

uchar *
CommandLineEnd(const uchar *s, int contlnflag)
/* R}hs̍s̃Xy[XARgŌ̗Lȕ̎ւ
 * |C^ԂB
 * sɌps̃}[N '\\' ΁Aւ̃|C^ԂB
 */
{
	const uchar *p;
	const uchar *end;
	const uchar *p1;

	p = SkipSpace(s);

	if (!*p || (!contlnflag && *p == COMMENT_LINE_MARK) || *p == COMMENT_MARK)
		return (uchar*)s;

	do {
		p1 = p;
		end = SkipCommandArg(p);
		p = SkipSpace(end);
		if (!*p || *p == COMMENT_MARK)
			end -= StrRSpn(p1, end - p1, (uchar *)NULL);	/* E̋󔒂 */
	} while (*p && (*p != COMMENT_MARK || p == end));

	if (!*p && StrNthE(p1, end - p1 - 1) == '\\') {
		/* RgȂōs̍Ōオps}[N('\\')Ȃ */
		--end;				/* ps}[Nւ̃|C^ɂ */
	}
	return (uchar*)end;
}

/***************************** GetCommandLine *****************************/


uchar *
GetCommandLine(int *lenp)
/* ߍ݃R}hsǂ */
/* Rg̏Aps̏𔺂 */
{
	int bufsize = 512;
	uchar *buf = (uchar *)XMalloc(bufsize);
	uchar *p = buf;
	int len;
	int offs;
	int contlnflag = FALSE;

	do {
		len = GetLine();			/* s܂łǂ݁Aibuf Ɋi[ */
		offs = StrSpn(ibuf, (uchar *)NULL);	/* 擪̋󔒕̒ */
		if (p + len - buf >= bufsize) {
			uchar *buf2 = (uchar *)XRealloc((voidstar)buf, bufsize += len + 512);
			p = buf2 + (p - buf);
			buf = buf2;
		}
		CopyStrN(p, ibuf+offs, len-offs);
		p = CommandLineEnd(p, contlnflag);
		contlnflag = *p == '\\';
	} while (contlnflag);			/* psȂɂȂ܂ */
	*p = '\0';
	if (lenp) *lenp = p - buf;
	return (uchar *)XRealloc((voidstar)buf, (p - buf) + 1);
}


/***************************** CheckBlockEnd ******************************/

int
CheckBlockEnd(const uchar *src, int n, int contlnflag,const uchar **endp)
/* ubNi{...}j̏I̍sׂ */
{
	const uchar *p = src;
	static int nesting_count = 0;
	
	if (!contlnflag && *CutSpace(p) == '}') {
		p++;
		if (nesting_count == 0) {
			if (endp) *endp = p;
			return TRUE;
		} else
			--nesting_count;
	}
	if (src[n] != '\\' && StrNthE(src, n - 1) == '{')
		nesting_count++;
	return FALSE;
}

/**************************************************************************/

#if 0 /* sv */
int
IsSpecialCmd(const uchar *s)
{
	if (!*CutSpace(s))
		return FALSE;
	else if (strchr("-+[]/.!#?;*", *s))
		return TRUE;
	else if (!IsKSym1Str(s))
		return FALSE;
#if 0
	else if (IsSlashParamCmd(s))
		return TRUE;
#endif
	else {
		uchar buf[128];
		uchar *p = SkipKSym2(s);
		if (IsFuncArgStr(p))
			return FALSE;

		CopyStrDiff(buf, s, p);
		if (GetMacro(buf))
			return TRUE;
		else
			return FALSE;
	}
}
#endif

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
