/* cntrl.c */
/*****************************************************************************
					s@o@wsq

							mR[hn
*****************************************************************************/

#include "xtr.h"

#define SameSeq(a, b) 	((a)->rpllen == (b)->rpllen && \
						 !memcmp((a)->rpl, (b)->rpl, (a)->rpllen))

#define SameGrp(a, b)	((a)->grp == (b)->grp)
#define SameGrp1(a, b)	(SameGrp((a), (b)) && \
							((a)->grp || (a)->cmode == (b)->cmode))
#define SameGrpS(a, b) 	(SameGrp((a), (b)) && \
							((a)->grp || (a)->cmode == (b)->cmode && \
											SameSeq((a), (b))))

#define FreeCntrl1(obj)	(XFree((voidstar)(obj)->fnd), XFree((voidstar)(obj)->rpl), XFree((voidstar)(obj)))


static int
MemberSameGrp(def_t *obj, def_t *clist)
/* obj ƓO[v̗vf clist ɂ邩 */
{
	if (obj != NULL) {
		for (; clist != NULL; clist = clist->prev) {
			if (SameGrpS(obj, clist))
				return TRUE;
		}
	}
	return FALSE;
}

static int
MemberCntrl(def_t *obj, def_t *clist)
/* obj  clist ̗vf */
{
	if (obj != NULL) {
		for (; clist != NULL; clist = clist->prev) {
			if (obj == clist)
				return TRUE;
		}
	}
	return FALSE;
}

static void
FreeCntrl(def_t *cntrl)
/* R[hXg cntrl J */
{
	def_t *pprev;

	while (cntrl) {
		pprev = cntrl->prev;
		FreeCntrl1(cntrl);
		cntrl = pprev;
	}
}

/**************************************************************************/

void
ResetCntrl(def_t **cntrlp)
/* R[hXg *cntrlp Jċɂ */
{
	assert(cntrlp != NULL);

	FreeCntrl(*cntrlp);
	*cntrlp = NULL;
}

def_t *
DupCntrl1(def_t *org)
{
	if (org == NULL) {
		return NULL;
	} else {
		def_t *cntrl = (def_t *)XMalloc(sizeof(def_t));
#if 0
		cntrl->fnd = DupStrN(org->fnd, org->fndlen);
		cntrl->fndlen = org->fndlen;
#else
		cntrl->fnd = NULL;
		cntrl->fndlen = 0;
#endif
		cntrl->rpl = DupStrN(org->rpl, org->rpllen);
		cntrl->rpllen = org->rpllen;
		cntrl->mode = org->mode;
		cntrl->cmode = org->cmode;
		cntrl->grp = org->grp;
		cntrl->prev = NULL;
		return cntrl;
	}
}

def_t *
DupCntrl(def_t *org)
{
	if (org == NULL) {
		return NULL;
	} else {
		def_t *cntrl = DupCntrl1(org);
		cntrl->prev = DupCntrl(org->prev);
		return cntrl;
	}
}


/**************************************************************************/

def_t *
AddCntrl(def_t *org, def_t *add)
{
	assert(add != NULL);

	if (org != NULL && SameGrp(org, add) && SameSeq(org, add)) {
		return org;
	} else {
		def_t *cntrl = DupCntrl1(add);
		cntrl->prev = org;
		return cntrl;
	}
}

static def_t *
RemCntrlSub(def_t *org, def_t *rem)
{
	assert(rem != NULL);

	if (org == NULL)
		return NULL;
	else if (SameGrpS(org, rem))
		return org->prev;
	else
		return AddCntrl(RemCntrlSub(org->prev, rem), org);
}

def_t *
RemCntrl(def_t *org, def_t *rem)
/* R[hXg org  rem ܂́A
   rem ƓO[v̐R[hP菜
   R[hXgԂBijIj */
{
	assert(rem != NULL);

	if (MemberSameGrp(rem, org))
		return RemCntrlSub(org, rem);
	else
		return org;
}


/**************************************************************************/

int
RemFCntrl(def_t **cntrlp, def_t *rem)
/* R[hXg *cntrlp  rem ܂́A*/
/* rem ƓO[v̐R[hP菜 */
/* 菜 1 AłȂ 0 Ԃ */
{
	def_t **cp = cntrlp;
	def_t *p = *cntrlp;

	assert(cntrlp != NULL);
	assert(rem != NULL);

	while (p) {
		if (SameGrpS(p, rem)) {
			/*  */
			*cp = p->prev;
			FreeCntrl1(p);
			return 1;
		}
		cp = &(p->prev);
		p = *cp;
	}
	return 0;
}


/**************************************************************************/

/* SGRV[PXȂ^Ԃ */
#define IsSGRseq(seq, len)	\
	(seq[0] == '\033' && seq[1] == '[' && seq[len-1] == 'm')

static int
WasSGRseq(void)
/* OPC98SGRV[PXł邩𒲂ׂ */
{
	uchar *p = cbufp;
	if (--p <= cbuf || *p != 'm')
		return 0;				/* Ō̕ 'm' łȂȂU */
	
	while (--p > cbuf)			/* 납猩Ă */
		if (*p == '[')
			return 1;			/* '[' ^ */
		else if (*p < 0x30 || *p > 0x3b)
			return 0;			/*  ';' ȊO΋U */
	return 0;
}

static void
ExtractCntrl1(def_t *cntrl)
/* ̐R[h̓eo */
{
	uchar *rpl = cntrl->rpl;
	int	   len = cntrl->rpllen;
	
	if (cntrl->mode & R_EVAL) {
		/* ]w肪 */
		marg_t	*margv0 = margv;
		int		margc0 = margc;
		margv = NULL;
		margc = 0;
		rpl = AEvalStringN(&len, rpl, len);					/* %-ϊ */
		margc = margc0;
		margv = margv0;
	}
	if (cbufp - len >= cbuf && memcmp(rpl, cbufp - len, len)==0) {
		/* ÕR[hƓeȂȗ */
		;	
	} else {
		/* @@ ̏ł͕s[ */
		if (sgr98mode && IsSGRseq(rpl, len) && WasSGRseq()) {
			/* APC98 SGR mode ŁÂƒO̐R[h
			   SGR V[PXAQ SGR seq A */
			/* F "\x1b[7m" + "\x1b[32m"  "\x1b[7;32m" */
			*(cbufp - 1) = ';';		/* O SGR seq  "m"  ";" ɕς */
			rpl += 2;				/*  "\x1b[" ΂ */
			len -= 2;
		}
		memcpy(cbufp, rpl, len);
		cbufp += len;
		if (cbufp > cbuf + CBUFSIZE)
			FError("Code buffer over");
	}
	if (cntrl->mode & R_EVAL)
		XFree((voidstar)rpl);
}


static void
ExtractCntrl2(def_t *cntrls, int grp)
/* R[hXg cntrls ̓eoăobt@ cbufp ɓWJ */
/* 0 ȊO grp ^ĂA grp ƈv̂̂ݎo */
/* R[h̒̕A|C^ cbufp i߂ */
{
	if (cntrls == NULL)
		return;
	else {
		ExtractCntrl2(cntrls->prev, grp);	/* ܂AuÓvvf */
		if (!grp || grp == cntrls->grp) {
			/* O[vw薳ijO[vv */
			ExtractCntrl1(cntrls);
		}
	}
}


int
ExtractCntrl(def_t *cntrls, int grp)
/* R[hXg cntrls ̓eoăobt@ cbuf[] ɓWJ */
/* 0 ȊO grp ^ĂA grp ƈv̂̂ݎo */
/* Ԃ */
{
	cbufp = cbuf;
	ExtractCntrl2(cntrls, grp);
	*cbufp = 0;
	return clength = cbufp - cbuf;
}


int
ExtractResetCntrl(def_t *cntrls, def_t *rescntrls)
/* ݂̕C̐R[hXg cntrlsA
   C̐R[hXg rescntrls ƂāA
   ݂̕ĈɕKvȐR[ĥ݂ cbuf[] ɓWJ */
{
	cbufp = cbuf;
	for ( ; cntrls; cntrls = cntrls->prev)
		ExtractCntrl2(rescntrls, cntrls->grp);

	*cbufp = 0;
	return clength = cbufp - cbuf;
}


static void
ExtractReputCntrl2(def_t *cntrls,def_t *rescntrls,def_t *rescntrl)
{
	assert(rescntrl != NULL);

	if (cntrls == NULL)
		return;

	ExtractReputCntrl2(cntrls->prev, rescntrls, rescntrl); /* Ôɏ */
	for ( ; rescntrls ; rescntrls = rescntrls->prev) {
		if (SameGrp1(cntrls, rescntrls) && SameSeq(rescntrls, rescntrl)) {
			/* O[vv镶C̃R[hirescntrls ̗vfj
			   Oɏo͂C̃R[h rescntrl ƃR[he
			   ł鐧R[h cntrls ̗vfƂđ݂
			   o */
			ExtractCntrl1(cntrls);
		}
	}
}


int
ExtractReputCntrl(def_t *rescntrl)
/* rescntrl o͂ƂňꏏɉĂ܂C
   鐧R[hƂ肾 */
{
	assert(rescntrl != NULL);

	cbufp = cbuf;

	if (c_attr)
		ExtractReputCntrl2(c_attr, c_areset, rescntrl);
	if (c_wide)
		ExtractReputCntrl2(c_wide, c_wreset, rescntrl);
	if (c_vexpand)
		ExtractReputCntrl2(c_vexpand, c_vreset, rescntrl);
	if (c_qexpand)
		ExtractReputCntrl2(c_qexpand, c_qreset, rescntrl);
	if (c_half)
		ExtractReputCntrl2(c_half, c_hreset, rescntrl);
	if (c_font)
		ExtractReputCntrl2(c_font, c_freset, rescntrl);

	*cbufp = 0;
	return clength = cbufp - cbuf;
}

static void InitCntrlPosVects ARGS((void));

void
ResetCntrlLists(void)
{
	ResetCntrl(&c_reset);
	ResetCntrl(&c_terminate);
	ResetCntrl(&c_newline);
	ResetCntrl(&c_newpage);
	ResetCntrl(&c_reset2);
	ResetCntrl(&c_areset);
	ResetCntrl(&c_vreset);
	ResetCntrl(&c_qreset);
	ResetCntrl(&c_wreset);
	ResetCntrl(&c_hreset);
	ResetCntrl(&c_freset);
	ResetCntrl(&c_kicode);
	ResetCntrl(&c_kocode);
	ResetCntrl(&c_hicode);
	ResetCntrl(&c_hocode);
	ResetCntrl(&c_attr);
	ResetCntrl(&c_wide);
	ResetCntrl(&c_vexpand);
	ResetCntrl(&c_qexpand);
	ResetCntrl(&c_half);
	ResetCntrl(&c_font);
	ResetCntrl(&c_pagefont);
	ResetCntrl(&c_pagekicode);
	ResetCntrl(&c_pagekocode);

	InitCntrlPosVects();
}


/**************************************************************************/


/* R[hߍ݈ʒuLxN^̗vf */
typedef struct cpos {
	ushort		x;		/* R[hߍ݈ʒu */
	struct def	*cntrl;		/* R[hXg */
} cpos_t;

/* R[hߍ݈ʒuLxN^ */
static cpos_t cposv_a[CPOSVSIZE];
static cpos_t cposv_w[CPOSVSIZE];
static cpos_t cposv_v[CPOSVSIZE];
static cpos_t cposv_q[CPOSVSIZE];
static cpos_t cposv_h[CPOSVSIZE];
static cpos_t cposv_f[CPOSVSIZE];
static int cposc_a = 0;
static int cposc_w = 0;
static int cposc_v = 0;
static int cposc_q = 0;
static int cposc_h = 0;
static int cposc_f = 0;

static def_t *c_a = NULL;
static def_t *c_w = NULL;
static def_t *c_v = NULL;
static def_t *c_q = NULL;
static def_t *c_h = NULL;
static def_t *c_f = NULL;

static def_t *
CntrlWrapSub(int cposc, cpos_t *cposv)
{
	while (cposc > 0 && (int)cposv[cposc].x > x)
		cposc--;

	return cposv[cposc].cntrl;
}

void
CntrlWrapBefor(void)
/* ߍݐR[h̃[hbvO */
/* [hbvŖߍݐR[h܂ŎsɑĂ
   CLԂ̃R[h̑ȌԂɖ߂ */
{
	c_a = c_attr;
	c_w = c_wide;
	c_v = c_vexpand;
	c_q = c_qexpand;
	c_h = c_half;
	c_f = c_font;
	c_attr = CntrlWrapSub(cposc_a, cposv_a);
	c_wide = CntrlWrapSub(cposc_w, cposv_w);
	c_vexpand = CntrlWrapSub(cposc_v, cposv_v);
	c_qexpand = CntrlWrapSub(cposc_q, cposv_q);
	c_half = CntrlWrapSub(cposc_h, cposv_h);
	c_font = CntrlWrapSub(cposc_f, cposv_f);
}

void
CntrlWrapAfter(void)
/* ߍݐR[h̃[hbv㏈ */
{
	c_attr 	= c_a;
	c_wide 	= c_w;
	c_vexpand = c_v;
	c_qexpand = c_q;
	c_half 	= c_h;
	c_font 	= c_f;
	c_a = NULL;
	c_w = NULL;
	c_v = NULL;
	c_q = NULL;
	c_h = NULL;
	c_f = NULL;
	SetCntrlPosVects();
}



static void
FreeCntrlPosv(int cposc, cpos_t *cposv, def_t *c1, def_t *c2)
{
	def_t *p;
	def_t *pprev;
	int i, j;

	for (i = cposc; i >= 0; i--) {
		p = cposv[i].cntrl;
		cposv[i].x = 0;
		cposv[i].cntrl = NULL;

		while (p) {
			if (MemberCntrl(p, c2) || (c1 != c2 && MemberCntrl(p, c1)))
				goto next;

			for (j = i - 1; j >= 0; j--) {
				if (MemberCntrl(p, cposv[j].cntrl))
					goto next;
			}
			pprev = p->prev; 
			FreeCntrl1(p);
			p = pprev;
		}
	next:;
	}
}


static void
InitCntrlPosVects(void)
{
	cposc_a = cposc_w = cposc_v = cposc_q = cposc_h = cposc_f = 0;
	cposv_a[0].x = 0;
	cposv_a[0].cntrl = c_attr;
	cposv_w[0].x = 0;
	cposv_w[0].cntrl = c_wide;
	cposv_v[0].x = 0;
	cposv_v[0].cntrl = c_vexpand;
	cposv_q[0].x = 0;
	cposv_q[0].cntrl = c_qexpand;
	cposv_h[0].x = 0;
	cposv_h[0].cntrl = c_half;
	cposv_f[0].x = 0;
	cposv_f[0].cntrl = c_font;
}


void
ResCntrlPosVects(void)
{
	FreeCntrlPosv(cposc_a, cposv_a, c_attr, c_a);
	FreeCntrlPosv(cposc_w, cposv_w, c_wide, c_w);
	FreeCntrlPosv(cposc_v, cposv_v, c_vexpand, c_v);
	FreeCntrlPosv(cposc_q, cposv_q, c_qexpand, c_q);
	FreeCntrlPosv(cposc_h, cposv_h, c_half, c_h);
	FreeCntrlPosv(cposc_f, cposv_f, c_font, c_f);

	InitCntrlPosVects();
}

void
SetCntrlPosVects(void)
{
	if (cposv_a[cposc_a].cntrl != c_attr && ++cposc_a < CPOSVSIZE) {
		cposv_a[cposc_a].x = x;
		cposv_a[cposc_a].cntrl = c_attr;
	}
	if (cposv_w[cposc_w].cntrl != c_wide && ++cposc_w < CPOSVSIZE) {
		cposv_w[cposc_w].x = x;
		cposv_w[cposc_w].cntrl = c_wide;
	}
	if (cposv_v[cposc_v].cntrl != c_vexpand && ++cposc_v < CPOSVSIZE) {
		cposv_v[cposc_v].x = x;
		cposv_v[cposc_v].cntrl = c_vexpand;
	}
	if (cposv_q[cposc_q].cntrl != c_qexpand && ++cposc_q < CPOSVSIZE) {
		cposv_q[cposc_q].x = x;
		cposv_q[cposc_q].cntrl = c_qexpand;
	}
	if (cposv_h[cposc_h].cntrl != c_half && ++cposc_h < CPOSVSIZE) {
		cposv_h[cposc_h].x = x;
		cposv_h[cposc_h].cntrl = c_half;
	}
	if (cposv_f[cposc_f].cntrl != c_font && ++cposc_f < CPOSVSIZE) {
		cposv_f[cposc_f].x = x;
		cposv_f[cposc_f].cntrl = c_font;
	}
}

/*
 * Local variables:
 * mode: c
 * c-indent-level: 4
 * c-continued-statement-offset: 4
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * tab-width: 4
 * tab-stop-list: (4 8 12 16 20 24 28 32 36 40 44 48 52 56 60 64 68 72 76 80)
 * End:
 */
