/* xjstring.h */
#ifndef XJSTRING_H
#define XJSTRING_H 1

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef NULL
#define NULL 0
#endif

#ifdef __STDC__
#define __XJ_ARGS(args) args
#else
#define __XJ_ARGS(args) ()
#endif

#define CT_ANK  0
#define CT_KJ1  1
#define CT_KJ2  2
#define CT_ILGL -1

extern char *jstradv __XJ_ARGS((const char *, int));
extern char *jstrchr __XJ_ARGS((const char *, unsigned int));
extern int jstrlen __XJ_ARGS((const char *));
extern char *jstrmatch __XJ_ARGS((const char *, const char *));
extern char *jstrrchr __XJ_ARGS((const char *, unsigned int));
extern char *jstrskip __XJ_ARGS((const char *, const char *));
extern char *jstrstr __XJ_ARGS((const char *, const char *));
extern int btom __XJ_ARGS((const char *, int));
extern int mtob __XJ_ARGS((const char *, int));
extern unsigned int jistojms __XJ_ARGS((unsigned int));
extern unsigned int jmstojis __XJ_ARGS((unsigned int));
extern unsigned int jtolower __XJ_ARGS((unsigned int));
extern unsigned int jtoupper __XJ_ARGS((unsigned int));
extern int nthctype __XJ_ARGS((const char *, int));

#define jisspace(c)	((unsigned int)(c) == 0x8140)
#define jisdigit(c)	((unsigned int)(c) >= 0x824f && (unsigned int)(c) <= 0x8258)
#define jislower(c)	((unsigned int)(c) >= 0x8281 && (unsigned int)(c) <= 0x829a)
#define jisupper(c)	((unsigned int)(c) >= 0x8260 && (unsigned int)(c) <= 0x8279)
#define jisalpha(c)	(jisupper(c) || jislower(c))

#endif /* !XJSTRING_H */
