/* xjctype.h */
#ifndef XJCTYPE_H
#define XJCTYPE_H 1

#include <ctype.h>
#include "mbc.h"

#ifndef NULL
#define NULL 0
#endif

extern unsigned char _xjctype[];

#define _XJKPUN 001
#define _XJKANA 002

#define iskpun(c)	(_xjctype[(c) & 0377] & _XJKPUN)
#define iskmoji(c)	(_xjctype[(c) & 0377] & _XJKANA)
#define iskana(c)	(_xjctype[(c) & 0377] & (_XJKPUN | _XJKANA))
#define isalkana(c)	(isalpha((c) & 0377) || iskmoji(c))
#define ispnkana(c)	(ispunct((c) & 0377) || iskpun(c))
#define isalnmkana(c)	(isalnum((c) & 0377) || iskmoji(c))
#define isprkana(c)	(isprint((c) & 0377) || iskana(c))
#define isgrkana(c)	(isgraph((c) & 0377) || iskana(c))
#define iskanji(c)	(_mb_table_sjis[(c) & 0377] & _MBUBYTE)
#define iskanji2(c)	(_mb_table_sjis[(c) & 0377] & _MBLBYTE)

#endif /* !XJCTYPE_H */
