/* strnicmp -
   Copyright (C) 1995  Katsuyuki Okabe <hgc02147@niftyserve.or.jp>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License
   as published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ctype.h>

#define TOLOWER(c) (isupper((c)) ? tolower((c)) : (c))

int
strnicmp(str1, str2, n)
     const char *str1;
     const char *str2;
     int n;
{
  int c1, c2;

  while (n-- > 0)
    {
      c1 = *str1++ & 0377;
      c1 = TOLOWER(c1);
      c2 = *str2++ & 0377;
      c2 = TOLOWER(c2);
      if (c1 != c2)
	return c1 - c2;
      if (c1 == '\0')
	return 0;
    }

  return 0;
}

/*
 * End:
 */
