/* memcmp -
   Copyright (C) 1995  Katsuyuki Okabe <hgc02147@niftyserve.or.jp>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License
   as published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

int
memcmp(ptr1, ptr2, len)
     const char *ptr1;
     const char *ptr2;
     int len;
{
  const unsigned char *p1;
  const unsigned char *p2;

  p1 = (const unsigned char *)ptr1;
  p2 = (const unsigned char *)ptr2;
  while (len-- > 0)
    if (*p1++ != *p2++)
      return p1[-1] - p2[-1];

  return 0;
}

/*
 * End:
 */
