/* Multi-byte Library
   Copyright (C) 1995  Katsuyuki Okabe <hgc02147@niftyserve.or.jp>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License
   as published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef MBC_H
#define MBC_H 1

#ifdef __STDC__
#define __MB_ARGS(args) args
#else
#define __MB_ARGS(args) ()
#endif

extern unsigned char _mb_table_ascii[];
extern unsigned char _mb_table_euc[];
extern unsigned char _mb_table_sjis[];
extern unsigned char *_mb_table;
extern int mbtype;
#define current_mbctype mbtype
extern unsigned int euc2sjis __MB_ARGS((int, int));
extern unsigned int sjis2euc __MB_ARGS((int, int));
extern unsigned int (*MB2S) __MB_ARGS((int, int));
extern unsigned int (*S2MB) __MB_ARGS((int, int));
extern char *sjis2mbstring __MB_ARGS((char *, const char *));
extern char *mb2sjisstring __MB_ARGS((char *, const char *));

extern void mbinit __MB_ARGS((int));
#define mbcinit(type) mbinit((type))

#define MBTYPE_EUC 1
#define MBTYPE_SJIS 2

#define MBCTYPE_ASCII 0
#define MBCTYPE_EUC 1
#define MBCTYPE_SJIS 2

#define _MBUBYTE (1)
#define _MBLBYTE (_MBUBYTE << 1)

#define ismbuchar(c) (_mb_table[(c) & 0377] & _MBUBYTE)
#define ismblchar(c) (_mb_table[(c) & 0377] & _MBLBYTE)

#ifdef XTR
extern int ismbchar __MB_ARGS((int));
#else
#define ismbchar(c)  ismbuchar(c)
#endif

#endif /* !MBC_H */
