/* Multi-byte Library
   Copyright (C) 1995  Katsuyuki Okabe <hgc02147@niftyserve.or.jp>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License
   as published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "mbc.h"

#define U _MBUBYTE
#define L _MBLBYTE
#define K (_MBLBYTE << 1)
#define M (U | L)
#define MK (M | K)

unsigned char _mb_table_ascii[256] = {
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 0 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 1 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 2 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 3 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 4 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 5 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 6 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 7 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,U ,0 , /* 8 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 9 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* A */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* B */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* C */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* D */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* E */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* F */
};

unsigned char _mb_table_euc[256] = {
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 0 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 1 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 2 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 3 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 4 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 5 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 6 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 7 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,U ,0 , /* 8 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 9 */
  0 ,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK, /* A */
  MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK, /* B */
  MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK, /* C */
  MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK,MK, /* D */
  M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M , /* E */
  M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,0 , /* F */
};

unsigned char _mb_table_sjis[256] = {
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 0 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 1 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 2 */
  0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 , /* 3 */
  L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L , /* 4 */
  L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L , /* 5 */
  L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L , /* 6 */
  L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,0 , /* 7 */
  L ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M , /* 8 */
  M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M , /* 9 */
  L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L , /* A */
  L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L , /* B */
  L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L , /* C */
  L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L ,L , /* D */
  M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M , /* E */
  M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,M ,0 ,0 ,0 , /* F */
};


#define SS2 0x8e

unsigned int
euc2sjis(ubyte, lbyte)
     int ubyte;
     int lbyte;
{
  unsigned int ub;
  unsigned int lb;

  ub = ubyte & 0377;
  lb = lbyte & 0377;
  if (ub == SS2)
    return lbyte;
  if (ub & 1) {
    ubyte = ub / 2 + (ub < 0xdf ? 0x31 : 0x71);
    lbyte = lb - (lb >= 0xe0 ? 0x60 : 0x61);
  } else {
    ubyte = ub / 2 + (ub < 0xdf ? 0x30 : 0x70);
    lbyte = lb - 2;
  }

  return (ubyte << 8) + lbyte;
}

unsigned int
sjis2euc(ubyte, lbyte)
     int ubyte;
     int lbyte;
{
  unsigned int ub;
  unsigned int lb;

  ub = ubyte & 0377;
  lb = lbyte & 0377;
  if (lb >= 0x9f) {
    ubyte = ub * 2 - (ub >= 0xe0 ? 0xe0 : 0x60);
    lbyte = lb + 2;
  } else {
    ubyte = ub * 2 - (ub >= 0xe0 ? 0xe1 : 0x61);
    lbyte = lb + (lb >= 0x7f ? 0x60 : 0x61);
  }

  return (ubyte << 8) + lbyte;  
}

static unsigned int
sjis2sjis(ubyte, lbyte)
     int ubyte;
     int lbyte;
{
  ubyte &= 0377;
  lbyte &= 0377;
  return (ubyte << 8) + lbyte;
}

unsigned char *_mb_table = _mb_table_ascii;
int mbtype = MBCTYPE_ASCII;

unsigned int (*MB2S) __MB_ARGS((int, int)) = &sjis2sjis;
unsigned int (*S2MB) __MB_ARGS((int, int)) = &sjis2sjis;

#define issjis(c) (_mb_table_sjis[(unsigned char)(c)] & U)
#define iskana(c) (_mb_table[(unsigned char)(c)] & K)

char *
sjis2mbstring(dst, src)
     char *dst;
     const char *src;
{
  char *save;
  unsigned int c, wc;

  save = dst;
  while ((c = *src++ & 0377) != '\0')
    if (issjis(c))
      {
	wc = (*S2MB)(c, *src++ & 0377);
	*dst++ = wc >> 8;
	*dst++ = wc;
      }
    else
      {
	if (iskana(c))
	  *dst++ = SS2;
	*dst++ = c;
      }
  *dst = '\0';

  return save;
}

char *
mb2sjisstring(dst, src)
     char *dst;
     const char *src;
{
  char *save;
  unsigned int c, ch, wc;

  save = dst;
  while ((c = *src++ & 0377) != '\0')
    if (ismbuchar(c))
      {
	wc = (*MB2S)(c, *src++ & 0377);
	if ((ch = wc >> 8) != '\0')
	  *dst++ = ch;
	*dst++ = wc;
      }
    else
      *dst++ = c;
  *dst = '\0';

  return save;
}

void
mbinit(type)
     int type;
{
  switch (type)
    {
    case MBCTYPE_ASCII:
      _mb_table = _mb_table_ascii;
      MB2S = &sjis2sjis;
      S2MB = &sjis2sjis;
      break;
    case MBCTYPE_EUC:
      _mb_table = _mb_table_euc;
      MB2S = &euc2sjis;
      S2MB = &sjis2euc;
      break;
    case MBCTYPE_SJIS:
      _mb_table = _mb_table_sjis;
      MB2S = &sjis2sjis;
      S2MB = &sjis2sjis;
      break;
    }
  mbtype = type;
}

/*
 * End:
 */
