/* jstrstr -
   Copyright (C) 1995  Katsuyuki Okabe <hgc02147@niftyserve.or.jp>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License
   as published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if HAVE_STRING_H || STDC_HEADERS
#include <string.h>
#else
#include <strings.h>
#endif
#ifndef HAVE_STRSTR
extern char *strstr();
#endif

#include "xjctype.h"
#include "xjstring.h"

char *jstrstr (const char *str1, const char *str2)
{
  char *p;
  int no_kanji2;
  
  p = (char*)str1;
  no_kanji2 = !iskanji2(str2[0]);
  while ((p = strstr (p, str2)) != 0)
    {
      if (no_kanji2 || nthctype(str1, p - str1) != CT_KJ2)
	break;
      p++;
    }
  return p;
}

/*
 * End:
 */
