#define  INCL_WINSWITCHLIST
#include <os2emx.h>
#include <string.h>
#include <process.h>
#include <sys/types.h>

#include <wget.h>
#include <utils.h>

/* change wget process title in PM tasklist */

void os2title(init, url)
int init;
const char *url;
{
  static char new_title[MAXNAMEL];
  static char *org_title;
  static HSWITCH hswitch;
  static SWCNTRL sw;
  static PSWCNTRL psw = (PSWCNTRL) &sw;
  switch(init) {
    case 1:
      /* save current process title */
      hswitch = WinQuerySwitchHandle(0, getpid());
      WinQuerySwitchEntry(hswitch, psw);
      if(psw->uchVisibility) {
	org_title = (char *) malloc(strlen(psw->szSwtitle)+1);
	strcpy(org_title, psw->szSwtitle);
      }	
      break;
    case -1:
      /* restore original task title */
      if(psw->uchVisibility) {
	strcpy(psw->szSwtitle, org_title);
	WinChangeSwitchEntry(hswitch, psw);
      }	
      break;
    case 0:
      /* show current url in title */
      if(psw->uchVisibility && url != NULL && *url) {
	strncpy(new_title, url, MAXNAMEL-9);
	sprintf(psw->szSwtitle, "WGet [%s]", new_title);
	WinChangeSwitchEntry(hswitch, psw);
      }	
      break;
  }
}

/* before termination, restore process title */

void os2break(arg)
int arg;
{
  os2title(-1, NULL);
  printf("\nTerminated by signal.\n");
  exit(3);
}

/* Encodes the '?' characters in a given string,
   returning a malloc-ed %3F encoded string.     */

char *replace_question(s)
const char *s;
{
  const char *b;
  char *p, *res;
  int i;
  b = s;
  for (i = 0; *s; s++, i++)
    if (*s == '?' || *s == '\\')
      i += 2;
  res = (char *)xmalloc (i + 1);
  s = b;
  for (p = res; *s; s++)
    if (*s == '?' || *s == '\\') {
      sprintf(p,"%%%.2X", *s);
      p += 3;
    /*
      *p++ = '%';
      *p++ = '3';
      *p++ = 'F';
    */
    } else
      *p++ = *s;
  *p = '\0';
  return res;
}

/* replace '%' character with other ('_'). for those who uses 4OS2,
   where '%' is the prefix to environment variables */

void replace_percent(s)
char *s;
{
  char *p;
  for (p = s; *p; p++)
    if (*p == '%')
      *p = '_';
}

/* make '--background' working under os/2
   spawning new wget process detached.     */

void spawn_process(argc, argv)
int argc;
char *const *argv;
{
  int i;
  char **newargs;
  pid_t pid = 0;
  HSWITCH hswitch;
  SWCNTRL sw;
  PSWCNTRL psw = (PSWCNTRL) &sw;

  /* Whether we arrange our own version of opt.lfilename here.  */
  int changedp = 0;

  if (!opt.lfilename) {
    opt.lfilename = unique_name (DEFAULT_LOGFILE);
    changedp = 1;
  }

  /* test where wget process is detached.
     if it is not, new detached process will be spawned, continue otherwise.
     so you can still use 'detach' command
     and there will be no new processes */

  hswitch = WinQuerySwitchHandle(0, getpid());
  WinQuerySwitchEntry(hswitch, psw);
  if(psw->uchVisibility) {
    /* parent here */
    newargs = (char **) malloc(sizeof(char *) * (argc + 1));
    for(i = 0; i <= argc; i++)
        newargs[i] = (i == argc) ? NULL : strdup(argv[i]);
    pid = spawnv(P_NOWAIT | P_DETACH, argv[0], newargs);
    for(i = 0; newargs[i]; i++)
      free(newargs[i]);
    free(newargs);
  }
  if (pid == -1) {
    /* parent, error */
    perror ("spawn");
    exit (1);
  } else
    if (pid != 0) {
      /* parent, no error */
      printf (_("Continuing in background. pid=%d\n"), pid);
      if (changedp)
	printf (_("Output will be written to `%s'.\n"), opt.lfilename);
      exit (0);
    }
  /* child: keep running */
}
