#include "eventwin.h"

PMEventWindow::PMEventWindow (const char *afontspec, int event_buffer_size,
			      int init_width, int init_height)
: MessageWindow (afontspec, init_width, init_height),
  q (pmio_make_eventq (event_buffer_size))
{
}

MRESULT PMEventWindow::msg_char (unsigned short flags,
				 unsigned char repeat_count,
				 unsigned char scancode,
				 unsigned short charcode,
				 unsigned short virtualkeycode)
{
  PMIOEvent e;
  e.event_type = pmio_event_char;
  e.e.key.flags = flags;
  e.e.key.repeat_count = repeat_count;
  e.e.key.scancode = scancode;
  e.e.key.charcode = charcode;
  e.e.key.ch = charcode;
  e.e.key.virtualkeycode = virtualkeycode;
  q->nonblocking_insert (&e);
  return (MRESULT) TRUE;
}
