#define INCL_DOSDATETIME
#include <os2.h>
#include <sys/time.h>
#include <time.h>
#include <errno.h>

int gettimeofday (struct timeval *tp, struct timezone *tzp)
{
   ULONG rc;
   DATETIME dt;
   struct tm tim;
   
   rc = DosGetDateTime (&dt);

   if (rc) {
      errno = 0;
      return (-1);
   }

   tim.tm_sec = dt.seconds;		/* seconds after the minute [0-60] */
   tim.tm_min = dt.minutes;		/* minutes after the hour [0-59] */
   tim.tm_hour = dt.hours;		/* hours since midnight [0-23] */
   tim.tm_mday = dt.day;		/* day of the month [1-31] */
   tim.tm_mon = dt.month - 1;		/* months since January [0-11] */
   tim.tm_year = dt.year - 1900;	/* years since 1900 */
   tim.tm_wday = dt.weekday;		/* days since Sunday [0-6] */
   tim.tm_yday = 0;			/* days since January 1 [0-365] */
   tim.tm_isdst = 0;			/* Daylight Savings Time flag */
   tim.tm_gmtoff = 0;			/* offset from CUT in seconds */
   *tim.tm_zone = 0;			/* timezone abbreviation */

   if (tp) {
      tp -> tv_sec = mktime (&tim);
      tp -> tv_usec = dt.hundredths * 10000;
   }

   if (tzp) {
      tzp -> tz_minuteswest = dt.timezone;
      tzp -> tz_dsttime = 0;
   }

   return (0);
}

