#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#include <os2.h>
#include <errno.h>
#include <process.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

extern int __vfork_active;
extern int __vfork_result;
extern int __vfork_tid;

int execle (const char *path, const char *arg0, ...)
{
   ULONG rc;
   int total_arg_length;
   int total_env_length;
   char *arg_strings;
   char *env_strings;
   char *ptr;
   RESULTCODES ReturnCodes;
   char ObjNameBuf[512];
   char exe_name[512];
   char **argptr;
   PTIB ptib;
   PPIB ppib;

   if (__vfork_active) {
      DosGetInfoBlocks (&ptib, &ppib);
      if (__vfork_tid != ptib -> tib_ptib2 -> tib2_ultid) {
         errno = EPERM;
         return (-1);
      }
   } else {
      errno = EPERM;
      return (-1);
   }


   strcpy (exe_name, path);

   if (strstr (exe_name, ".exe") == 0 && strstr (exe_name, ".EXE") == 0)
      strcat (exe_name, ".EXE");

   /* construct the command args for DosExecPgm */

   for (argptr = (char **)&arg0, total_arg_length = 1; *argptr; ++argptr)
      total_arg_length += strlen (*argptr) + 1;

   for (++argptr, total_env_length = 1; *argptr; ++argptr)
      total_env_length += strlen (*argptr) + 1;

   arg_strings = (char *)malloc (total_arg_length);
   env_strings = (char *)malloc (total_env_length);

   for (argptr = (char **)&arg0, ptr = arg_strings; *argptr; ++argptr)
   {
      bcopy (*argptr, ptr, strlen (*argptr)+1);
      ptr += strlen (*argptr);
      if (argptr == (char **)&arg0)
         ptr++;
      else
         *ptr++ = ' ';
   }

   *ptr = '\0';

   for (++argptr, ptr = env_strings; *argptr; ++argptr)
   {
      char *tmpptr = ptr;
      bcopy (*argptr, ptr, strlen (*argptr)+1);
      while (*tmpptr != '=' && *tmpptr)
      {
         *tmpptr = toupper (*tmpptr);
         ++tmpptr;
      }
      ptr += strlen (*argptr) + 1;
   }

   *ptr = '\0';

   rc = DosExecPgm (&ObjNameBuf[0],
                    512,
                    EXEC_ASYNCRESULT,
                    arg_strings,
                    env_strings,
                    &ReturnCodes,
                    exe_name);

   if (rc)
   {
      if (rc == ERROR_FILE_NOT_FOUND || rc == ERROR_PATH_NOT_FOUND)
      {
         errno = ENOENT;
         return (-1);
      }

      errno = EIO;
      return (-1);
   }

   __vfork_result = ReturnCodes.codeTerminate;
   __vfork_active = 0;
   DosExit (EXIT_THREAD, ReturnCodes.codeTerminate);
   return (-1); /* for lint */
}

