
struct _dll_registry {
    struct _dll_registry *next;
    void *ctor_table;
    void *dtor_table;
};

static struct _dll_registry *_registry = 0;

void _dllctor_add_registry(struct _dll_registry *newrecord)
{
  newrecord->next = _registry;
  _registry = newrecord;
}

#include <stdio.h>
static void exec_table(void *table_ptr)
{
  void **tptr;

  for (tptr = (void **) table_ptr; *tptr != (void *) 0; tptr++)
    if (*tptr == (void *) -1)
      continue;
    else {
      void (*fptr)(void) = (void (*)(void)) *tptr;
      fptr();
    }
}

void _dllctor_execute_ctors(void)
{
  struct _dll_registry *reg;

  for (reg = _registry; reg != 0; reg = reg->next)
    exec_table(reg->ctor_table);
}

void _dllctor_execute_dtors(void)
{
  struct _dll_registry *reg;

  for (reg = _registry; reg != 0; reg = reg->next)
    exec_table(reg->dtor_table);
}
