#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#include <os2.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <errno.h>

pid_t wait4 (pid_t wpid, int *status, int options, struct rusage *rusage)
{
   ULONG rc;
   RESULTCODES rc_wait;
   PID pid;

   rc = DosWaitChild (DCWA_PROCESS, /* wait for process id'ed by parm 5 */
                      DCWW_WAIT,    /* wait for process to end */
                      &rc_wait,     /* place to put termination results */
                      &pid,         /* place to put the pid of the dead process */
                      0);           /* wait for any child process to end */

   if (rc)
   {
      if (rc == ERROR_WAIT_NO_CHILDREN || rc == ERROR_NO_CHILD_PROCESS)
      {
         errno = ECHILD;
         return (-1);
      }

      errno = EFAULT;
      return (-1);
   }

   if (rc_wait.codeTerminate == 4)
      *status = 0x400 | (rc_wait.codeResult & 0xff);
   else
      *status = (rc_wait.codeResult & 0xff) << 8;

   return (pid);
}

