#include <signal.h>
#include <errno.h>

extern int __handler_mask[32];
extern void *__signal_proc[32];

int sigaction (int sig, const struct sigaction *act, struct sigaction *oact)
{
    if (sig < 1 || sig > 31)
   {
      errno = EINVAL;
      return (-1);
   }

   if (sig == SIGKILL || sig == SIGSTOP || sig == SIGCONT)
   {
      errno = EINVAL;
      return (-1);
   }

   if (oact)
   {
      oact -> sa_handler = __signal_proc[sig];
      oact -> sa_mask = __handler_mask[sig];
      oact -> sa_flags = 0;
   }

   if (act)
   {
      __signal_proc[sig] = act -> sa_handler;
      __handler_mask[sig] = act -> sa_mask;
   }

   return (0);
}

