#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <sys/file.h>
#include <errno.h>

int lseek (int fd, long offset, int whence)
{
   ULONG rc;
   ULONG NewPos;

   if (whence == L_SET)
      rc = DosSetFilePtr (fd, offset, FILE_BEGIN, &NewPos);
   else
      if (whence == L_INCR)
         rc = DosSetFilePtr (fd, offset, FILE_CURRENT, &NewPos);
      else
         if (whence == L_XTND)
            rc = DosSetFilePtr (fd, offset, FILE_END, &NewPos);
         else
         {
            errno = EINVAL;
            return (-1);
         }

   if (rc)
   {
      if (rc == ERROR_INVALID_HANDLE)
      {
         errno = EBADF;
         return (-1);
      }

      errno = EIO;
      return (-1);
   }

   return (NewPos);
}

