#define INCL_DOSEXCEPTIONS
#define INCL_DOSFILEMGR
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#include <os2.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>

extern void *start_of_data();
extern void _init_rusage();

char *__CopyRight[] = {
   "/*",
   " * Copyright (c) 1985 Regents of the University of California.",
   " * All rights reserved.",
   " *",
   " * Redistribution and use in source and binary forms, with or without",
   " * modification, are permitted provided that the following conditions",
   " * are met:",
   " * 1. Redistributions of source code must retain the above copyright",
   " *    notice, this list of conditions and the following disclaimer.",
   " * 2. Redistributions in binary form must reproduce the above copyright",
   " *    notice, this list of conditions and the following disclaimer in the",
   " *    documentation and/or other materials provided with the distribution.",
   " * 3. All advertising materials mentioning features or use of this software",
   " *    must display the following acknowledgement:",
   " *	This product includes software developed by the University of",
   " *	California, Berkeley and its contributors.",
   " * 4. Neither the name of the University nor the names of its contributors",
   " *    may be used to endorse or promote products derived from this software",
   " *    without specific prior written permission.",
   " *",
   " * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND",
   " * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE",
   " * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE",
   " * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE",
   " * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL",
   " * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS",
   " * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)",
   " * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT",
   " * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY",
   " * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF",
   " * SUCH DAMAGE.",
   " */"
};

extern ULONG __SignalHandler();

static void line_buffer_stdout(void);
static void setargv (char * command_line, char ***argv, int *argc);
static void interpolate_response_files(char ***argv, int *argc);
static int read_response_file(char *filename, char ***argv, int *argc);
static void append_args(char ***argv, int *argc, char **nargv, int nargc);
static void init_env(void);

int _argc = 0;
char **_argv = 0;
static char *_env = 0;
char **environ = 0;
int _DisableSignals = 0;

void _dynamic_crt1(char *command_line, int (*main)())
{
   int rc;
   EXCEPTIONREGISTRATIONRECORD ExRegRec;

    /* Initialize the heap */
   start_of_data();

    /* Initialize resource usage values */
   _init_rusage();

    /* set argc and build argv[] */
   setargv(command_line, &_argv, &_argc);

   /* interpolate response files */
   interpolate_response_files(&_argv, &_argc);

   /* Line buffer stdout if tty */
   line_buffer_stdout();

   /* init envp[] */
   init_env();

   if (!_DisableSignals) {
      ExRegRec.prev_structure = 0;
      ExRegRec.ExceptionHandler = __SignalHandler;
      DosSetExceptionHandler (&ExRegRec);
   }

    /* GO! */
   rc = main(_argc, _argv, environ);

    /* Flush all stdio buffers */
   fflush(0);

    /* Terminate the process */
   exit (rc);
}

static void line_buffer_stdout(void)
{
    /* I *think* ANSI says we only need to line buffer it if stdout is a tty,
       but we'll fully unbuffer it because that is less suprising to
       people who are used to DOS compilers */
    unsigned rc;
    unsigned long handle_type, flags;
    rc = DosQueryHType(1, &handle_type, &flags);
    if (rc == 0 && (handle_type & 255) == 1) {
	/* Stdout is a tty */
	stdout->_flags |= __SNBF;
    }
}

static void setargv (char * command_line, char ***argv, int *argc)
{
   char *cline;
   int count, i;
   char *tmp;

   if (command_line[0] == '\0')
      return;

    /* count the args */
   for (cline = command_line; *cline++;) ;

   while (*cline) {
      if (*cline == ' ' || *cline == '\t' || *cline == '\n' || *cline == '\r')
         ++cline;
      else {
         (*argc)++;
         while (*cline && *cline != ' ' && *cline != '\t' && *cline != '\n'
		&& *cline != '\r')
            ++cline;
      }
   }

    /* allocate space for argv[] */
   *argv = (char **) malloc ((++*argc + 1) * sizeof(char *));

   (*argv)[0] = strdup (command_line);

   for (cline = command_line; *cline++;) ;

   for (count = 1; count < (*argc); ++count) {
      while (*cline == ' ' || *cline == '\t' || *cline == '\r'
	     || *cline == '\n') ++cline;

      i = 0;
      while (cline[i] && cline[i] != ' ' && cline[i] != '\t' 
	     && cline[i] != '\n' && cline[i] != '\r') i++;
      tmp = (char *) malloc(i+1);

      i = 0;
      while (*cline && *cline != ' ' && *cline != '\t' && *cline != '\n'
	     && *cline != '\r')
         tmp[i++] = *cline++;

      tmp[i] = '\0';

      (*argv)[count] = tmp;
   }
   (*argv)[count] = 0;
}

static void setargv2 (char * command_line, char ***argv, int *argc)
{
   char *cline;
   int count, i;
   char *tmp;

    /* count the args */
   *argc = 0;
   cline = command_line;
   while (*cline) {
      if (*cline == ' ' || *cline == '\t' || *cline == '\n' || *cline == '\r')
         ++cline;
      else {
         (*argc)++;
         while (*cline && *cline != ' ' && *cline != '\t' && *cline != '\n'
		&& *cline != '\r')
            ++cline;
      }
   }

    /* allocate space for argv[] */
   *argv = (char **) malloc ((*argc + 1) * sizeof(char *));

   cline = command_line;
   for (count = 0; count < (*argc); ++count) {
      while (*cline == ' ' || *cline == '\t' || *cline == '\r'
	     || *cline == '\n') ++cline;

      i = 0;
      while (cline[i] && cline[i] != ' ' && cline[i] != '\t' 
	     && cline[i] != '\n' && cline[i] != '\r') i++;
      tmp = (char *) malloc(i+1);

      i = 0;
      while (*cline && *cline != ' ' && *cline != '\t' && *cline != '\n'
	     && *cline != '\r')
         tmp[i++] = *cline++;

      tmp[i] = '\0';

      (*argv)[count] = tmp;
   }
   (*argv)[count] = 0;
}

static void interpolate_response_files(char ***argv, int *argc)
{
    char **final_argv = 0;
    int final_argc = 0;
    char **temp_argv;
    int temp_argc;
    char *arg;
    int i;
    int code;

    for (i = 0; i < *argc; i++) {
	arg = (*argv)[i];
	if (arg[0] == '@') {
	    code = read_response_file(arg+1, &temp_argv, &temp_argc);
	    if (code != -1) {
		append_args(&final_argv, &final_argc, temp_argv, temp_argc);
		continue;
	    }
	}
	append_args(&final_argv, &final_argc, &arg, 1);
    }
    *argv = final_argv;
    *argc = final_argc;
}

static int read_response_file(char *filename, char ***argv, int *argc)
{
    static char *buf = 0;
    static int alloc_len = 0;
    int cursize, read;
    HFILE fd;
#if 0
    ULONG trash;
#endif
    ULONG code;

    code = open(filename, 0);
    if (code == -1) return -1;
    fd = code;
#if 0
    code = DosOpen((PSZ)filename, &fd, &trash, 0, FILE_READONLY, 
		   OPEN_ACTION_FAIL_IF_NEW, 
		   OPEN_FLAGS_SEQUENTIAL | OPEN_ACCESS_READONLY,
		   0);
    if (code != 0) return -1;
#endif

    if (alloc_len == 0 || buf == NULL) {
	alloc_len = 1024;
	buf = (char *) malloc(alloc_len);
    }
    cursize = 0;
    for(;;) {
	code = DosRead(fd, buf+cursize, alloc_len - cursize, &read);
	if (code != 0 && code != 234) {
	    DosClose(fd);
	    return -1;
	}
	if (read == 0) break;
	cursize += read;
	if (cursize == alloc_len) {
	    alloc_len += 1024;
	    buf = (char *) realloc(buf, alloc_len);
	    if (buf == NULL) return -1;
	}
    }
    if (cursize == alloc_len) {
	alloc_len += 1024;
	buf = (char *) realloc(buf, alloc_len);
	if (buf == NULL) return -1;
    }
    buf[cursize] = '\0';
    setargv2(buf, argv, argc);
    DosClose(fd);
    return 0;
}

static void append_args(char ***argv, int *argc, char **nargv, int nargc)
{
    if (*argc == 0 || *argv == 0) {
	*argv = (char **) malloc(sizeof(char *) * nargc);
    } else {
	*argv = (char **) realloc(*argv, sizeof(char *) * (*argc + nargc));
    }
    while (nargc-- > 0) (*argv)[(*argc)++] = *nargv++;
}

static void init_env(void)
{
    TIB *tib;
    PIB *pib;
    char *p;
    int count;

    /* Sometimes, it's hard to beleive the identifiers OS/2 uses */
    DosGetInfoBlocks(&tib, &pib);
    _env = pib->pib_pchenv;

    /* Count the number of environment strings */
    for (p = _env, count = 0; *p != '\0'; p += strlen(p)+1, count++);

    /* Create an environment array */
    environ = (char **) malloc(sizeof(char *) * (count+1));

    /* Fill it with duplicates of strings */
    for (p = _env, count = 0; *p != '\0'; p += strlen(p)+1)
	environ[count++] = strdup(p);
    environ[count] = 0;
}

static PFNTHREAD real_thread_entry;

void
_threadcrt (ULONG parm)
{
   EXCEPTIONREGISTRATIONRECORD ExRegRec;

   if (!_DisableSignals) {
      ExRegRec.prev_structure = 0;
      ExRegRec.ExceptionHandler = __SignalHandler;
      DosSetExceptionHandler (&ExRegRec);
   }

   real_thread_entry (parm);

   DosExit (EXIT_THREAD, 0);
}

TID
_beginthread (PFNTHREAD entry,
              int when,
              ULONG stacksize,
              ULONG parm)
{
   TID Tid;
   ULONG rc;

   real_thread_entry = entry;

   rc = DosCreateThread (&Tid,
                         _threadcrt,
                         parm,
                         when,
                         stacksize);

   if (rc) {

      if (rc == ERROR_NOT_ENOUGH_MEMORY) {
         errno = ENOMEM;
         return (-1);
      }

      if (rc == ERROR_INTERRUPT) {
         errno = EINTR;
         return (-1);
      }

      if (rc == ERROR_PROTECTION_VIOLATION) {
         errno = EFAULT;
         return (-1);
      }

      errno = EPERM;
      return (-1);
   }

   return (Tid);
}


