#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <errno.h>
#include <unistd.h>

int close (int fd)
{
   ULONG rc;

   rc = DosClose (fd);

   if (rc)
   {
      if (rc == ERROR_INVALID_HANDLE || rc == ERROR_FILE_NOT_FOUND)
      {
         errno = EBADF;
         return (-1);
      }

      if (rc == ERROR_ACCESS_DENIED)
      {
         errno = EACCES;
         return (-1);
      }

      errno = EIO;
      return (-1);
   }

   return (0);
}

