/* var_func.h */
/* Copyright (C) 1988, 1989, 1990, 1991 Free Software Foundation, Inc.
This file is part of GNU Make.

GNU Make is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Make is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Make; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* variable.c */

struct variable *define_variable (char *name, int length, char *value
	, enum variable_origin origin, int recursive);
struct variable *define_variable_for_file (char *name, int length
	, char *value, enum variable_origin origin, int recursive
	, struct file *file);
struct variable *lookup_variable (char *name, int length);
void initialize_file_variables (struct file *file);
void pop_variable_scope (void);
void push_new_variable_scope (void);
void merge_variable_set_lists (struct variable_set_list **setlist0
	, struct variable_set_list *setlist1);
void define_automatic_variables (void);
char *variable_buffer_output (char *ptr, char *string, int length);
char * initialize_variable_output (void);
char **target_environment (struct file *file);
int try_variable_definition (char *line, enum variable_origin origin);
void print_variable_data_base (void);
void print_file_variables (struct file *file);
char *save_variable_output (void);
void restore_variable_output (char *save);


/* function.c */

char *subst_expand (char *o, char *text, char *subst, char *replace
	, int slen, int rlen, int by_word, int suffix_only);
char *patsubst_expand (char *o, char *text, char *pattern, char *replace
	, char *pattern_percent, char *replace_percent);
int pattern_matches (char *pattern, char *percent, char *word);
int handle_function (char **op, char **stringp);

/* expand.c */

char *variable_expand (char *line);
char *expand_argument (char *str, char *end);
char *variable_expand_for_file (char *line, struct file *file);
char *allocated_variable_expand (char *line);
char *allocated_variable_expand_for_file (char *line, struct file *file);


