/*
 * A simple pmio program that demonstrates color.
 */

#include <stdio.h>
#include <pmio.h>
#include <unistd.h>

const char *color_names[] = {
  "Black", "Blue", "Green", "Cyan", "Red", "Magenta", "Brown", "Light Gray",
  "Dark Gray", "Light Blue", "Light Green", "Light Cyan", "Light Red",
  "Light Magenta", "Yellow", "White"
  };

int main ()
{
  start_pmio ();
  printf ("Hello, world!\n");
  int i;
  for (i = 0; i < 16; i++)
    {
      set_fg ((i < 8) ? WHITE : BLACK);
      set_bg (i);
      printf (color_names[i]);
      clreol ();
      printf ("\n");
      usleep (250000);
    }
  set_fg (BLACK);
  set_bg (WHITE);
  printf ("\n\nGoodbye world....\n");
  for (i = 0; i < 16; i++)
    {
      printf ("%d\n", 16-i);
      usleep (250000);
    }
  // Speed test
  for (i = 0; i < 16; i++)
    {
      set_fg ((i < 8) ? WHITE : BLACK);
      set_bg (i);
      clrscr ();
      printf (color_names[i]);
    }
  return 0;
}
