/***************************************************************************
PSCOMPRESS.CMD -- OS/2 version of pscompress to accompany Psfig
 
    This version uses grep and gzip, available from numerous places (including
    ftp.cdrom.com:/pub/os2/32bit/unix).  You then need to define (either as an
    alias or small cmd file) the following zcat command:
        zcat = @gzip -cdq %1

    Clark K. Gaylord
    3 January 1995
    cgaylord@vt.edu

***************************************************************************/
 
/* Original pscompress *****************************************************
#!/bin/csh -f
while ($1 != "") 
	if (-e $1.bb || -e $1.Z) then
		echo will not overwrite $1.bb or $1.Z, skipping
		shift
	else 
		echo "%\!" > $1.bb
		grep \%\%BoundingBox $1 >> $1.bb
		compress $1
		shift
	endif
end
***************************************************************************/

NeedHelp = 0
OverWrite = 0

PARSE ARG ArgList
IF ((ArgList='') | (ArgList='-?') | (ArgList='-h')) THEN
    SIGNAL Help

DO UNTIL ArgList=''
    PARSE Value(ArgList) WITH NextArg ArgList
    IF ((NextArg='-o') | (NextArg='-O')) THEN
        OverWrite = 1
    ELSE DO
        SAY ''
        SAY 'Processing' NextArg
        IF (\Exist(NextArg)) THEN DO
            SAY 'File' NextArg 'not found.'
            NeedHelp = 1
        END
        ELSE IF ((Exist(NextArg'.bb')|Exist(NextArg'.z'))&(1-OverWrite)) THEN DO
            SAY NextArg'.bb and/or' NextArg'.Z exist.'
            SAY 'PSCompress will not overwrite.'
            NeedHelp = 1
        END
        ELSE DO
            "@echo %%! >" NextArg".bb"
            "@grep %%%%BoundingBox" NextArg " >> " NextArg".bb"
            "@gzip -f -S .Z" NextArg
            SAY NextArg 'compressed.'
        END
    END
END
IF (NeedHelp) THEN
    SIGNAL Help
EXIT

Help:
    SAY ''
    SAY 'PSCompress -- Compress PS files for use by Trevor Darrell''s Psfig'
    SAY 'Syntax: PSCompress [FILE] ... [-o] [FILE] ...'
    SAY ''
    SAY 'File names must include extension and cannot include any spaces.'
    SAY '-o tells PSCompress to overwrite the BB and Z files if necessary'
    SAY 'for all subsequent files  All arguments must be space delimited.'
    RETURN

Exist:
    PARSE ARG File
    Return (Stream( File, 'C', 'Query exists') \= '')
