#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "manuals.h"
#include "bugme.h"

//#define NDEBUG

Manual manual;

/*********************/
/**** Manual Page ****/
/*********************/

ManualPage::ManualPage (const char *apagename, const char *afilename)
: pagename (strdup (apagename)), filename (strdup (afilename))
{
  BUGME(("ManualPage::ManualPage('%s','%s')", apagename, afilename));
}

/************************/
/**** Manual Section ****/
/************************/

ManualSection::ManualSection (const char *asection_name)
: section_name (strdup (asection_name)),
  npages(0)
{
  allocation = 64;
  pages = (ManualPage **) malloc (allocation * sizeof (ManualPage *));
}

void ManualSection::addmanpage (const char *pagename, const char *dir,
				const char *filename)
{
  BUGME(("ManualSection::addmanpage('%s','%s', '%s')",
	 pagename, dir, filename));
  if (npages >= allocation)
    {
      int newalloc = npages + 16;
      ManualPage **newpages = 
	(ManualPage **) realloc (pages, newalloc * sizeof (ManualPage *));
      if (newpages == 0)
	return;
      allocation = newalloc;
      pages = newpages;
    }

  /* Build the full path */
  char path[ strlen (dir) + strlen (section_name) + strlen (filename) + 4 ];
  sprintf (path, "%s/%s/%s", dir, section_name, filename);

  pages [npages++] = new ManualPage (pagename, path);
}

/****************/
/**** Manual ****/
/****************/


void Manual::addmanpage(const char *pagename, const char *section, 
			const char *dir, const char *filename)
{
  BUGME(("Manual::addmanpage('%s', '%s', '%s', '%s')", 
	 pagename, section, dir, filename));
  if (nsections >= allocation)
    {
      int newallocation = nsections + 16;
      ManualSection **newsections =
	(ManualSection **) realloc (sections, 
				    newallocation * sizeof (ManualSection *));
      if (newsections == 0)
	return;
      sections = newsections;
      allocation = newallocation;
    }

  /* Attempt to find an appropriate section */
  int i;
  for (i=0; i < nsections; i++)
    if (!strcmp (section, sections[i]->section_name))
      break;

  /* Allocate a new section, if not found */
  if (i >= nsections)
    sections [nsections++] = new ManualSection (section);

  /* Think about it: in either case, i is pointing at the right place */

  /* Now add the page to the section */
  sections[i]->addmanpage (pagename, dir, filename);
}

extern "C" const char *_gcc2_get_unixish_path();

Manual::Manual ()
: nsections (0)
{
  allocation = 16;
  sections = (ManualSection **) malloc (allocation * sizeof (ManualSection *));
  const char *gcc2 = _gcc2_get_unixish_path();
  if (gcc2 == 0)
    gcc2 = "/gcc2";
  const char *man = "/man";
  char directory[ strlen(gcc2) + strlen (man) + 1 ];
  sprintf (directory, "%s%s", gcc2, man);
  read_dir(directory);
}

static const char *safe_getline(FILE *f)
{
    static char *buf = NULL;
    static int bufsize = 0;

    if (buf == NULL) {
	bufsize = 1024;
	buf = (char *) malloc(bufsize);
    }
    int buffill = 0;
    for(;;) {
	if (buffill == bufsize) {
	    bufsize += 1024;
	    buf = (char *) realloc(buf, bufsize);
	}
	char *p = fgets(buf + buffill, bufsize - buffill, f);
	if (p == NULL) {
	    if (buffill == 0) return NULL;
	    break;
	}
	buffill += strlen(buf + buffill) - 1;
	if (buf[buffill] == '\n') {
	    buf[buffill] = '\0';
	    break;
	}
    }
    return buf;
}

void Manual::read_dir(const char *dirname)
{
  BUGME(("Manual::read_dir('%s')", dirname));
  const char * const hashfilename = "pmman.dir";
  char directory_hash_file[ strlen (dirname) + strlen (hashfilename) + 2 ];
  sprintf (directory_hash_file, "%s/%s", dirname, hashfilename);
  FILE *f = fopen (directory_hash_file, "rt");
  if (f == 0)
    return;
  char *section = 0;
  BUGME(("Reading pmman.dir..."));
  for (;;)
    {
      const char *p = safe_getline (f);
      BUGME(("Looking at '%s'", p));
      if (p == 0)
	break;
      const char * const dirkey = "Directory: ";
      if (!strncmp (p, dirkey, strlen (dirkey)))
	  {
	    if (section)
	      free (section);
	    section = strdup (p + strlen (dirkey));
	    BUGME(("Looking at section '%s'", section));
	    continue;
	  }
      if (section == 0)
	continue;
      char *p2 = strchr (p, ' ');
      if (p2 == 0)
	continue;
      while (*p2 == ' ')
	*p2++ = '\0';
      if (p[0] == '\0' || p2[0] == '\0')
	continue;
      addmanpage (p, section, dirname, p2);
    }
}
