
/*
     Program PM-Info: a program for viewing GNU-style hypertext info
     documentation files.
     Copyright (C) 1992,1993,1994  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/

#include "font.h"

struct TextPoint
{
    int line;
    int position;
    TextPoint() : line(0), position(0) {}
    TextPoint(int aline, int aposition): line(aline), position(aposition) {}
};

class TextRegion
{
public:
    int contains(TextPoint);
    TextPoint start, end;
    TextRegion(TextPoint astart, TextPoint aend);
};

class TextFonts;

class Attribute
{
public:
    TextRegion region;
    virtual void set(TextFonts *) = 0;
    virtual void button() {}
    Attribute(TextRegion aregion);
    virtual ~Attribute();
};

class TextFonts: public FontList
{
  int normal_id;
  int bold_id;
  int italic_id;
 public:
  void bold (HPS hps) { select_font (hps, bold_id); }
  void normal (HPS hps) { select_font (hps, normal_id); }
  void italic (HPS hps) { select_font (hps, italic_id); }
  TextFonts ();
  ~TextFonts ();
};

class TextAttributes
{
    int allocated, current;
    Attribute **attr;
public:
    TextFonts text_fonts;
    void add_attribute(Attribute *new_attribute);
    TextAttributes();
    ~TextAttributes();

    TextPoint next_transition(TextPoint);
    void set_attributes(TextPoint);
    void set_button(TextPoint);
};

class VisibleAttribute: public Attribute
{
protected:
    static HPS hps;
public:
    static void set_default_attributes(HPS, TextFonts *);
    static void setup_hps(HPS, TextFonts *);
    VisibleAttribute(TextRegion r): Attribute(r) {};
};

class Bold: public VisibleAttribute
{
public:
    virtual void set(TextFonts *);
    Bold(TextRegion r): VisibleAttribute(r) {};
};

class Italic: public VisibleAttribute
{
 public:
  virtual void set (TextFonts *);
  Italic (TextRegion r): VisibleAttribute (r) {}
};

class Color: public VisibleAttribute
{
    const unsigned int color;
public:
    virtual void set(TextFonts *);
    Color(unsigned int acolor, TextRegion r)
	: VisibleAttribute(r), color(acolor) { };
};

class RedAttr: public Color
{
public:
    RedAttr(TextRegion r);
};

class NodeReference: public RedAttr
{
    virtual void button();
protected:
    char *refname;
    char *nodename;
public:
    static char *button_nodename;
    NodeReference(TextRegion r, const char *reference);
    virtual ~NodeReference();
};

class SimpleView;

class MenuItem: public NodeReference
{
public:
    static SimpleView *all_items, *all_nodenames;
    MenuItem(TextRegion r, const char *reference);
    ~MenuItem();
};

class ReferenceItem: public NodeReference
{
public:
    static SimpleView *all_items, *all_nodenames;
    ReferenceItem(TextRegion r, const char *reference);
    ~ReferenceItem();
};
