.SUFFIXES:

# Uncomment this file to get executables statically linked to DLLs.
#DO_NOT_USE_DLL = 1

# Choose something like prefix=/usr/local if you wanna let MAKE do
# the installation process.
prefix		= /NCurses-1.9.9e
exec_prefix	= ${prefix}
bindir		= $(exec_prefix)/bin
libdir		= $(exec_prefix)/lib
dlldir		= $(exec_prefix)/dll
mandir		= $(exec_prefix)/man
includedir	= $(exec_prefix)/include
ticdir		= $(exec_prefix)/lib/terminfo

INSTALL		= cp
INSTALL_DATA	= ${INSTALL}
INSTALL_PROGRAM = ${INSTALL}

AWK		= gawk
LN_S		= cp

CXX		= gcc
CXXFLAGS	= -O

CC		= gcc
CPP		= gcc.exe -E
CFLAGS		= -O -Wall -Winline -Wshadow -Wstrict-prototypes \
		  -Wmissing-prototypes -Wbad-function-cast \
                  -Wmissing-declarations

INCDIR		= ../include
CPPFLAGS	= -I. -I$(srcdir) -I../include -DNDEBUG -DHAVE_CONFIG_H \
		  -DTERMINFO=\"$(ticdir)\" -D__ST_MT_ERRNO__

CCFLAGS		= $(CPPFLAGS) $(CFLAGS)

CFLAGS_NORMAL	= $(CCFLAGS)
CFLAGS_DEBUG	= $(CCFLAGS) -DTRACE -g
CFLAGS_PROFILE	= $(CCFLAGS) -pg
CFLAGS_SHARED	= $(CCFLAGS) -Zomf -Zcrtdll -Zmt

LINK		= $(CC)
LDFLAGS		= -Zmt

MK_SHARED_LIB	= $(CC) -Zomf -Zmt -Zcrtdll -Zdll -o $@
REL_VERSION	= 1.9.9e
ABI_VERSION	= 3.0

RANLIB		= ar s

ifdef DEBUG
  O		= o
  MODEL		= ../objects
  CFLAGS_DEFAULT= $(CFLAGS_DEBUG)
  LOCAL_LIBS	= ../lib/form.a ../lib/menu.a ../lib/panel.a ../lib/ncurses_g.a
  LIB_CURSES	= ../lib/ncurses_g.a
else
ifdef DO_NOT_USE_DLL
  O		= o
  MODEL		= ../objects
  CFLAGS_DEFAULT= $(CFLAGS_NORMAL)
  LOCAL_LIBS	= ../lib/form.a ../lib/menu.a ../lib/panel.a ../lib/ncurses.a
  LIB_CURSES	= ../lib/ncurses.a
else
  O		= obj
  MODEL		= ../obj_s
  CFLAGS_DEFAULT= $(CFLAGS_SHARED)
  LOCAL_LIBS	= ../lib/form.lib ../lib/menu.lib ../lib/panel.lib ../lib/ncurses.lib
  LIB_CURSES	= ../lib/ncurses.lib
endif #DO_NOT_USE_DLL
endif #DEBUG

MKINSTALLDIRS = $(basedir)\mkinstalldirs.cmd

all::

$(includedir) \
$(libdir) \
$(bindir) \
$(ticdir) \
$(mandir) \
$(dlldir):
	$(MKINSTALLDIRS) $@
