/*
 * Copyright (c) 1984,1985,1989,1994  Mark Nudelman
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice in the documentation and/or other materials provided with 
 *    the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN 
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* OS/2 definition file for less.  */
/*
 * This file has 2 sections:
 * User preferences.
 * Settings always true for the emx compiler for OS/2 systems. 
 */


/* User preferences.  */

/*
 * SECURE is 1 if you wish to disable a bunch of features in order to
 * be safe to run by unprivileged users.
 */
#define	SECURE		0

/*
 * SHELL_ESCAPE is 1 if you wish to allow shell escapes.
 * (This is possible only if your system supplies the system() function.)
 */
#define	SHELL_ESCAPE	(!SECURE)

/*
 * EXAMINE is 1 if you wish to allow examining files by name from within less.
 */
#define	EXAMINE		(!SECURE)

/*
 * TAB_COMPLETE_FILENAME is 1 if you wish to allow the TAB key
 * to complete filenames at prompts.
 */
#define	TAB_COMPLETE_FILENAME	(!SECURE)

/*
 * CMD_HISTORY is 1 if you wish to allow keys to cycle through
 * previous commands at prompts.
 */
#define	CMD_HISTORY	1

/*
 * HILITE_SEARCH is 1 if you wish to have search targets to be 
 * displayed in standout mode.
 */
#define	HILITE_SEARCH	1

/*
 * EDITOR is 1 if you wish to allow editor invocation (the "v" command).
 * (This is possible only if your system supplies the system() function.)
 * EDIT_PGM is the name of the (default) editor to be invoked.
 */
#define	EDITOR		(!SECURE)
#define	EDIT_PGM	"emacs"

/*
 * TAGS is 1 if you wish to support tag files.
 */
#define	TAGS		(!SECURE)

/*
 * USERFILE is 1 if you wish to allow a .less file to specify 
 * user-defined key bindings.
 */
#define	USERFILE	(!SECURE)

/*
 * GLOB is 1 if you wish to have shell metacharacters expanded in filenames.
 * This will generally work if your system provides the "popen" function
 * and the "echo" shell command.
 */
#define	GLOB		(!SECURE)

/*
 * PIPEC is 1 if you wish to have the "|" command
 * which allows the user to pipe data into a shell command.
 */
#define	PIPEC		(!SECURE)

/*
 * LOGFILE is 1 if you wish to allow the -l option (to create log files).
 */
#define	LOGFILE		(!SECURE)

/*
 * GNU_OPTIONS is 1 if you wish to support the GNU-style command
 * line options --help and --version.
 */
#define	GNU_OPTIONS	1

/*
 * ONLY_RETURN is 1 if you want RETURN to be the only input which
 * will continue past an error message.
 * Otherwise, any key will continue past an error message.
 */
#define	ONLY_RETURN	0

/*
 * LESSKEYFILE is the filename of the default lesskey output file 
 * (in the HOME directory).
 * DEF_LESSKEYINFILE is the filename of the default lesskey input 
 * (in the HOME directory).
 */
#define	LESSKEYFILE		"less.ini"
#define	DEF_LESSKEYINFILE	"lesskey.ini"


/*
 * HELPFILE is the full pathname of the help file.
 */
#define	HELPFILE	"less.hlp"

/* Settings always true for the emx compiler for OS/2 systems.  */
#define OS2 1

/*
 * HAVE_SYS_TYPES_H is 1 if your system has <sys/types.h>.
 */
#define HAVE_SYS_TYPES_H	1

/*
 * HAVE_STAT is 1 if your system has the stat() call.
 */
#define	HAVE_STAT	1

/*
 * HAVE_PERROR is 1 if your system has the perror() call.
 * (Actually, if it has sys_errlist, sys_nerr and errno.)
 */
#define	HAVE_PERROR	1

/*
 * HAVE_TIME is 1 if your system has the time() call.
 */
#define	HAVE_TIME	1

/*
 * HAVE_SHELL is 1 if your system supports a SHELL command interpreter.
 */
#define	HAVE_SHELL	0

/* Define to `long' if <sys/types.h> doesn't define.  */
/* #define	off_t	long */

/* Define as the return type of signal handlers (int or void).  */
#define RETSIGTYPE void

/* Define if you have the ANSI C header files.  */
#define STDC_HEADERS	1

/*
 * Regular expression library.
 * Define exactly one of the following to be 1:
 * HAVE_POSIX_REGCOMP: POSIX regcomp() and regex.h
 * HAVE_RE_COMP: BSD re_comp()
 * HAVE_REGCMP: System V regcmp()
 * HAVE_V8_REGCOMP: Henry Spencer V8 regcomp() and regexp.h
 * NO_REGEX: pattern matching is supported, but without metacharacters.
 */
/* #undef HAVE_POSIX_REGCOMP */
/* #undef HAVE_RE_COMP */
/* #undef HAVE_REGCMP */
#define HAVE_V8_REGCOMP 1
/* #undef NO_REGEX */

/* Define HAVE_VOID if your compiler supports the "void" type. */
#define HAVE_VOID 1

/* Define HAVE_TIME_T if your system supports the "time_t" type. */
#define HAVE_TIME_T 0

/* Define HAVE_STRERROR if you have the strerror() function. */
#define HAVE_STRERROR 1

/* Define HAVE_FILENO if you have the fileno() macro. */
#define HAVE_FILENO 1

/* Define HAVE_ERRNO if you have the errno variable */
#define HAVE_ERRNO 1

/* Define HAVE_SYS_ERRLIST if you have the sys_errlist[] variable */
#define HAVE_SYS_ERRLIST 1

/* Define HAVE_OSPEED if your termcap library has the ospeed variable */
#define HAVE_OSPEED 0
/* Define MUST_DEFINE_OSPEED if you have ospeed but it is not defined
 * in termcap.h. */
#define MUST_DEFINE_OSPEED 0

/* Define HAVE_LOCALE if you have locale.h and setlocale. */
#define HAVE_LOCALE 0

/* Define HAVE_TERMIOS_FUNCS if you have tcgetattr/tcsetattr */
#define HAVE_TERMIOS_FUNCS 0

/* Define HAVE_UPPER_LOWER if you have isupper, islower, toupper, tolower */
#define HAVE_UPPER_LOWER 1

/* Define if you have the _setjmp function.  */
#define HAVE__SETJMP	0

/* Define if you have the memcpy function.  */
#define HAVE_MEMCPY 1

/* Define if you have the sigsetmask function.  */
#define HAVE_SIGSETMASK	0

/* Define if you have the strchr function.  */
#define HAVE_STRCHR 1

/* Define if you have the system function.  */
#define HAVE_SYSTEM	1

/* Define if you have the <ctype.h> header file.  */
#define HAVE_CTYPE_H 1

/* Define if you have the <errno.h> header file.  */
#define HAVE_ERRNO_H 0

/* Define if you have the <fcntl.h> header file.  */
#define HAVE_FCNTL_H 1

/* Define if you have the <stdio.h> header file.  */
#define HAVE_STDIO_H 1

/* Define if you have the <sys/ioctl.h> header file.  */
#define HAVE_SYS_IOCTL_H 0

/* Define if you have the <sys/ptem.h> header file.  */
#define HAVE_SYS_PTEM_H	0

/* Define if you have the <sys/stream.h> header file.  */
#define HAVE_SYS_STREAM_H	0

/* Define if you have the <termcap.h> header file.  */
#define HAVE_TERMCAP_H 0

/* Define if you have the <termio.h> header file.  */
#define HAVE_TERMIO_H	0

/* Define if you have the <termios.h> header file.  */
#define HAVE_TERMIOS_H 0

/* Define if you have the <time.h> header file.  */
#define HAVE_TIME_H 1

/* Define if you have the <unistd.h> header file.  */
#define HAVE_UNISTD_H 1

/* Define if you have the <values.h> header file.  */
#define HAVE_VALUES_H 0
