/*  RUNLATEX.CMD
    Copyright 1994, Myron Uecker

    Simple cmd file for running latex, dvipm and prthplj.

    This program takes the following parameters:

    FILE:x          Name of the file to be processed without the extension
                    You will be prompted if this option is left off.
    NPASS:x         Number of passes through LaTeX
                    Default is 1 pass
    VIEW:YES/NO     YES to view the file (VP) or NO to not view
                    Default is to view the file
    PRINT:YES/NO    YES to print the file or NO to not print
                    Default is to not print the file
    PRINTPARAMS:x   The remainder of the line is fed directly into the print
                    command.

*/

'@echo off'
fname = ''
npass = ''
view = ''
print = ''
printparams = ''

parse upper arg line

/* Parse the command line */
do w = 1 to WORDS(line)
   param = word(line,w)
   parse var param command':'parameter

   select
      when command = 'FILE' then
         fname = parameter
      when command = 'NPASS' then
         npass = parameter
      when command = 'VIEW' then
         view = parameter
      when command = 'PRINT' then
         print = parameter
      when command = 'PRINTPARAMS' then do
         parse var line 'PRINTPARAMS:'printparams
         leave
      end  /* Do */
      otherwise
   end /* select */

end /* do */

/* Request the file name if it wasn't given */
if fname = '' then do
   say 'Enter the file to be processed without the extension'
   pull fname
end  /* Do */
else
   NOP

/* Decide how many passes to make */
if npass = '' then
   npass = 1
else
   NOP

/* Process the file through LATEX */
do i = 1 to npass
   Say
   Say 'Running LaTeX pass #'i
   'LATEX 'fname
end /* do */

/* Default is to view the file */
if view = '' then
   view = 'YES'
else
   NOP

/* View the file using dvipm. */
if LEFT(view,1) = 'Y' then do
   Say 'Starting dvipm'
   'dvipm @p6l.cnf /fl=-1 'fname
end /* do */
else
   NOP

/* Default is to not print the file */
if print = '' then
   print = 'NO'
else
   nop

/* This segment prints the file.  Replace the dvihplj call with the code from
   your preferred printer driver.  Note:  The /od option below formats the
   printouts for a HP Deskjet printer.  Remove this parameter if you are using
   an HP LaserJet.  Replace the statement for other types of printers.
*/
if LEFT(print,1) = 'Y' then do
   Say 'Printing the file'
   'dvihplj @lj.cnf /po=prn /od 'fname printparams
end
else
   NOP

exit
