/*  PICFMT.CMD
    Copyright 1994, Myron Uecker

    Rexx script to reformat PIC files created by TeXcad.

    When TeXcad creates a file, it adds extra spaces to the left and top to
    match the location where the drawing was placed.  PICFMT will take out
    the extra spaces.
*/

/*  Change the following lines to the file extension you use for your picture
    files.
*/
iext = '.PIC'
oext = '.CIP'

'@echo off'
parse upper arg lfname
if lfname = '' then do
   Say "Enter the name of the file to be reformatted without the extension."
   pull lfname
end
else
   NOP

fname = lfname||iext
outfname = lfname||oext

linen.0 = LINES(fname)
if linen.0 = 0 then do
   Say "The file "fname" doesn't exist."
   exit 1
end
else 
   NOP

'ERASE 'outfname

/* Create a couple of large starting values for minx and miny */
minx = 100000
miny = 100000

/* Now parse each line to find the minx and miny values. */
/* look for put commands first */
i = 0
do while LINES(fname) = 1
   i = i + 1
   linen.i = LINEIN(fname)
   if LEFT(linen.i,4) = '\put' then do
      parse var linen.i '\put('x1','y1')'.
      if x1 < minx then
         minx = x1
      else
         NOP
      if y1 < miny then
         miny = y1
      else
         NOP
   end  /* Do */
   /* now look for emline commands */
   else if LEFT(linen.i,7) = '\emline' then do
      parse var linen.i '\emline{'x1'}{'y1'}{'.'}{'x2'}{'y2'}'.
      if x1 < minx then
         minx = x1
      else if x2 < minx then
         minx = x2
      else
         NOP
      if y1 < miny then
         miny = y1
      else if y2 < miny then
         miny = y2
      else
         NOP
   end  /* Do */
   /* Finally find the bezier commands */
   else if LEFT(linen.i,7) = '\bezier' then do
      parse var linen.i '\bezier{'.'}('x1','y1')('x2','y2')('x3','y3')'.
      if x1 < minx then
         minx = x1
      else if x2 < minx then
         minx = x2
      else if x3 < minx then
         minx = x3
      else
         NOP
      if y1 < miny then
         miny = y1
      else if y2 < miny then
         miny = y2
      else if y3 < miny then
         miny = y3
      else
         NOP
   end  /* Do */
end /* do */
linen.0 = i

/* Now that we have the min values, put the lines back together with the new
   x and y values. */
do i = 1 to linen.0
   if LEFT(linen.i,15) = '\begin{picture}' then do
      parse var linen.i '\begin{picture}('x1','y1')'
      linout = '\begin{picture}('x1-minx','y1-miny')'
   end  /* Do */
   else if LEFT(linen.i,4) = '\put' then do
      parse var linen.i '\put('x1','y1')'rest
      linout = '\put('x1-minx','y1-miny')'rest
   end
   else if LEFT(linen.i,7) = '\emline' then do
      parse var linen.i '\emline{'x1'}{'y1'}{'pt1'}{'x2'}{'y2'}'rest
      linout = '\emline{'x1-minx'}{'y1-miny'}{'pt1'}{'x2-minx'}{'y2-miny'}'rest
   end
   else if LEFT(linen.i,7) = '\bezier' then do
      parse var linen.i '\bezier{'num'}('x1','y1')('x2','y2')('x3','y3')'
      linout = '\bezier{'num'}('x1-minx','y1-miny')('x2-minx','y2-miny')('x3-minx','y3-miny')'
   end
   else
      linout = linen.i

   call LINEOUT outfname, linout
end

exit
