/*****************************************************************************
 * $Id: ak_rmt.h,v 2.5 1994/09/07 18:45:03 edvkai Exp $
 *****************************************************************************
 * $Log: ak_rmt.h,v $
 * Revision 2.5  1994/09/07  18:45:03  edvkai
 * AIX
 *
 * Revision 2.4  1993/12/05 13:50:11  ak
 * Moved rmt doc to rmt/*.
 *
 * Revision 2.3  1993/11/29  17:02:38  edvkai
 * Multivolume QFA fixes.
 * Smaller size of tape directory.
 *
 * Revision 2.2  1993/11/25  20:23:27  edvkai
 * Major QFA changes.
 *
 * QFA now supports both block id and relative addressing. Relative
 * addressing is more efficient with short distances. 4mm and 8mm devices
 * do well with relative addressing only. For the sake of QIC tapes, TAR
 * optimizes QFA using block ids for large distances.
 *
 * The format of the tape-directory changed. No longer compatible to prior
 * versions. Maybe I'll add a utility for conversion.
 *
 * Rmt interface changed. Now using block numbers instead of byte offsets
 * for seek. Previously the lseek limitation to 2GB limited QFA archive
 * capacity. Changed rmtlseek to rmtseek to indicate that it is different.
 *
 * QFA should be able to handle multi-volume archives now.
 *
 * If a volume name is specified on the command line, QFA skips archives
 * having a different volume name.
 *
 * Code for header pretty-printing cleaned. Doesn't depend on hstat any
 * longer and requires less globals. No explanation text behind names in
 * tape directory.
 *
 * A few bugfixes.
 *
 * Revision 2.1  1993/08/08  19:06:34  ak
 * Merge of network TAR with 2.12.
 *
 * Revision 1.1  1993/04/26  15:16:42  AK
 * Network TAR.
 * Added GZip option.
 * Initial revision
 *
 *****************************************************************************/

#ifdef OS2
 int	(*rmt_open)();
 int	(*rmt_read)();
 int	(*rmt_write)();
 long	(*rmt_seek)();
 int	(*rmt_close)();
 int	(*rmt_ioctl)();
 int	(*rmt_block)();
 long	(*rmt_error)();
 char *	(*rmt_status)();
 int	def_ioctl();
 int	def_block();
 long	def_error();
 char *	def_status();
#else
 int	rmt_open(char *path, int oflag, int mode);
 int	rmt_read(int fd, void *buf, unsigned size);
 int	rmt_write(int fd, void *buf, unsigned size);
 long	rmt_seek(int fd, long block, unsigned blocksize, int mode);
 int	rmt_close(int fd);
 int	rmt_ioctl(int fd, int code, void *arg);
 int	rmt_block(int fd);
 long	rmt_error(void);
 char *	rmt_status(long rcode);
#endif

int	open_rmt();
long	rcode(long);
long	seek();

#define _RMT_BIAS	10000
#define _remdev(path)	(strlen(path) >= 2 && strchr(path+2, ':'))
#define _isrmt(fd)	((fd) >= _RMT_BIAS)
#define rmtfd(fd)	((fd) - _RMT_BIAS)

void	rmtinit(char *);
int	rmtflag;
char *	rmtstatus(long rc);
#define rmtopen(n,m,p)	 (rmtflag ? rcode(open_rmt(n,m,p)) : open(n,m,p))
#define rmtread(fd,p,n)	 (_isrmt(fd) ? rcode(rmt_read(rmtfd(fd),p,n))		: read(fd,p,n))
#define rmtwrite(fd,p,n) (_isrmt(fd) ? rcode(rmt_write(rmtfd(fd),p,n))		: write(fd,p,n))
#define rmtseek(fd,b,n)  (_isrmt(fd) ? rcode(rmt_seek(rmtfd(fd),b,blocksize,n)) : seek(fd,b,blocksize,n))
#define rmtclose(fd)	 (_isrmt(fd) ? rcode(rmt_close(rmtfd(fd)))		: close(fd))
#define rmtioctl(fd,t,p) (_isrmt(fd) ? rcode(rmt_ioctl(rmtfd(fd),t,p))		: ioctl(fd,t,p))
#define rmtblock(fd)	 (_isrmt(fd) ? rcode(rmt_block(rmtfd(fd)))		: 512)

#define rmtcreat(path,mode) rmtopen(path,O_CREAT|O_TRUNC|O_BINARY|O_WRONLY,mode)
