/*--------------------------------------------------------------*/
/*								*/
/*                        GTAK Backup				*/
/*								*/
/*--------------------------------------------------------------*/
/*
  GTAK backup using TCP/IP sockets

  Paremeters
    1. Socket number
    2. Name of Server
    3. drive:
*/
parse arg Socket Server Drive

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

label = SUBSTR(WORD(SysDriveInfo(Drive||":"), 4), 1, 11, ' ')
bytes = WORD(SysDriveInfo(Drive||":"), 3)
select
  when bytes > 1024*1024*1024 then
    size = SUBSTR(FORMAT(bytes/(1024*1024*1024), 4, 0)||"Gb", 1, 6, ' ')
  when bytes > 1024*1024      then
    size = SUBSTR(FORMAT(bytes/(1024*1024), 4, 0)||"Gb", 1, 6, ' ')
end  
log = "C:\BACKUP\DRIVE."Drive

'C:'
'CD \GTAK.240'
"SET TAPE=TCP:+"Socket"@"Server
'TAR -c -b 64 -E -p -pp -P -l -M -X EXCLUDE.LST --totals --reset-archive -D rel,'log' -V 'label' 'Drive':/'

 
