/* $Id: fit.h 1.1 1993/08/01 04:21:29 cg Exp cg $ */

/*
 *	Header file: public functions in fit.c
 *
 *
 *	Copyright of this module:   Carsten Grammes, 1993
 *      Experimental Physics, University of Saarbruecken, Germany
 *
 *	Internet address: cagr@rz.uni-sb.de
 *
 *	Permission to use, copy, and distribute this software and its
 *	documentation for any purpose with or without fee is hereby granted,
 *	provided that the above copyright notice appear in all copies and
 *	that both that copyright notice and this permission notice appear
 *	in supporting documentation.
 *
 *      This software is provided "as is" without express or implied warranty.
 */


#ifndef FIT_H		/* avoid multiple inclusions */
#define FIT_H

#ifdef EXT
#undef EXT
#endif

#ifdef FIT_MAIN
#define EXT
#else
#define EXT extern
#endif

#include "type.h"
#include "plot.h"

#define FIT_SKIP "FIT_SKIP"

EXT char    *fit_index;


/******* public functions ******/

EXT void    error_ex (char *s, ...);
EXT char    *get_next_word (char **s, char *subst);

#ifdef STRNICMP
EXT int strnicmp (char *s1, char *s2, int n);
#endif

EXT void    init_fit ();
EXT void    setvar (char *varname, struct value data);
EXT int     getivar (char *varname);
EXT void    update (char *pfile);
EXT void    do_fit (char *fitfunc, char *datafile, int xcol, int ycol, 
	    		int dycol, char *paramsfile);

#endif
