NB tried to fix a bug by editing this patch file - hope it works...

NB this file now contains _two_ patches - one to 'improve' data file
handling, and t'other to allow commas, etc in (any) expressions.
data patch is applied only if you compile with DIV_HACKS defined.
comma patch is only activated if you compile with EVAL_HACKS defined.
The original data-only patch is probably in /anonymous/data.patch


26/8/93

scanner.c - line 320

uses vaxc &1 which gnu c baulks on - changed to { int one=1; ... &one... }

x11.trm line 243 - ditto


replaced post.trm by my divpost.trm - changing BOOLEAN to TBOOLEAN


under VMS, fopen with "mbc=60" - my standard i/o speedup

folded command.com, pending 'improvements'



multi-column data plotting !

'thru' is okay, but still limited...

I do it thusly...

1)  modify 'using' to accept _either_ a constant, which is column number,
   or (an arbitrary expression), to be evaluated for each data point.
   Parser uses the '(' to distinguish the two cases.
   Yes, I _know_ that the ( was already valid syntax, but didn't
   think anyone would use it - open to suggestions for an alternative
   syntax....


   One other possibility - $3 / column(3) etc return 'undefined' if
   we aren't in a data file. So we could try to work out column numbers,
   then if calc fails, assume it contained $, and mark it as a run-time
   expression..

   
2)  modify the expression stuff to allow 'callbacks' to the data.
    First I added column(x) - a standard fn to provide data in column x,
   or undefined if x is no good (eg bad data column, or we aren't doing
   a data file)...

3)   ... but this was a bit verbose, so I added an awk-like notation...
    ie $3 is 3rd-column data.
    retained (2), since it is more flexible - run-time choice of column...



NB 1   - plot 'data' using (1):(2)    was actually perfectly valid before.
         So files using that will be broken

NB 2   - deals with missing data columns differently - given
1 2
3
4 5

      [plot 'data' using 1:2] used to plot (1,2) (1,3) (4,5)
      It now omits point (1,3)

Points for which the expression returns invalid (eg division by 0)
are quietly ignored...

example
plot 'data' using 1:(sin($2))  will plot sine of column 2 vs column 1

      

Patches available as divhack.patch - keep the originals as these
patches aren't stable yet - or just download the following files.
Originals (I think !) are in /local/gnuplt34/original

Apply the patches, and compile with DIV_HACKS defined...

[ to enable a macro, this usually means add "-DDIV_HACKS" to the cc
  command line  - in the unix makefile, for example, there is a line
    OPTIONS = -DREADLINE ...
  you could add -DDIV_HACKS to this.
  Under VMS, you would add it to a list looking like
   /DEFINE=(READLINE,...)
]

- email me if you want to be added to my 'mailing list' for
bugs / changes / etc


27/8/93

All changes surrounded by #ifdef DIV_HACKS...
[ actually, needn't have been, as [my] patch offers to put in #if's ]

command.c -  added the following...
                  #define MAX_DATA_COLS 40
                  int no_data_cols;
                  double data_column[MAX_DATA_COLS];
                  int column_good[MAX_DATA_COLS];

          - completely rewrote function get_data()
               [cos I couldn't understand original !]

          - changed parsing of 'using' in eval_plots()

standard.c - add f_column() - defn of standard fn column()

internal.c - add f_dollars() - defn of internal $ command

plot.c  - add column() to lookup table of standard fns
        - add dollars to lookup table of internal fns
        - declarations for f_column() and f_dollars()

plot.h  - add dollars to the p-code

scanner.c - accept $ as a token

parse.c  - in factor(), compile $i



5/10/93

Oops - forgot to test number of columns read when checking for good data.
ie   plot file using 1:2
would plot 3 points given data
1 2
3
4 5
when I intended to plot only (1,2) and (4,5)
[ behaviour different with / without the using statement ]
[ Not sure what it's _supposed_ to do, but I want it to ignore lines that
  dont match the using spec... ]


Oops - another bug - comes from original using 'i' for number of points...
wasn't handling breaks in data properly...



21/10/93

get_data() - need to check the 'undefined' variable after eval, to make
sure there were no divisions by 0, etc

Add a valid(x) gnuplot function, to say whether column(x) contains
valid data. Might be useful for ...using ( valid(2) ? column(2) : ... )
Hence more changes to plot.c and standard.c 



12/11/93

Just ocurred to me - I have _another_ patch under development, that implements
comma and assignment operators in expressions. Haven't tried the two patches
together, but cant see why they shouldn't work. - patch might fail in
plot.h where it defines external fns, and in plot.c where it prepares the
lookup tables of internal fns, so might have to fix that by hand.
Take care to make the order of the entries in the table of plot.c
match the order in the enum in plot.h

comma does what it does in c - an expression can be
(expression1, expression2, expression3, ..., expressionz)
and each expression is evaluated, and the _whole_ expression has the value
of expressionz

Now this is only useful if you can do side-effects in expression1, etc
Assignment works, but unfortunately (for ease of implementation) it goes
backwards... ie to assign 3 to x you'd do 3=x

[ in a fn defn, you can assign to the dummy args, BTW ]

[ the patch also invents 'iterate'  - whole reason for the patch, actually.
  iterate(expression)  will repeatedly evaluate 'expression' while it is
  true - expression can of course be expression1,expression2,...
]


That would allow you to assign data values to gnuplot variables, so you can
come back later in the data file to pick up the values...

eg my data files are of the form

d1
x1 y1 sd1
x2 y2 sd2
x3 y3 sd3
etc

d2
x1 y1 sd1
x2 y2 sd2
etc


now it might be nice to have the current value of d around...

so I might try something like...

plot 'data' using 1:( valid(2) ? f($2,d) : ($1=d, 1/0) )

which means...  [untested !]

if there is a number in column 2  [ valid(2) ]
then calculate/plot my function of $2 and d
else assign current $1 to d, and evaluate an illegal expression, to force
omission of this 'point' on the graph.



This may also be able to automatically normalise a graph, if you try
plotting it twice, first time adding the values, and second time dividing...

total=0
plot 'data' using (total+$2=total, 1/0), 'data' using ($2 / total)

where first plot is thrown away since all points are undefined (?)
and second plot is normalised.

- when I tried something quickly, specifying notitle on first plot didn't
work, but I may have got something wrong..?


- DONT FORGET TO SET total=0 BEFORE (RE)PLOTTING !


As you can see, this is a _real_ hackers approach, but may be useful...

extrmemely untested - I dont even have this stuff in my system-wide local
copy yet !

- I did intend replacing = by ->, so that assigments become 3->x, etc
but never got round to it - be careful with the '=' !!!!

patch is in /local/gnuplt34/comma/evalhack.patch  on sotona.phys.soton.ac.uk


BTW - undocumented command 'show at (expression)' will let you see the
p-code generated by my operators.


16/11/93

decided to merge the patches [ie I needed one of the above !]

keep two different macros, though - need to compile with EVAL_HACKS to
get the commas and so forth...


I append the readme file I had for this patch - one day I'll write some
proper documentation.


3/12/93

Oops - a rather silly bug, after evaluating the (complex) expression, it
used the magnitude(), rather than real() to get the datum.
- how come no-one spotted this !




patches to allow commas, assignments and iterate() in gnuplot expressions...
files are in /local/gnuplt34/comma/... if you need access to them...

compile with EVAL_HACKS defined, and optionally DEBUG_EVAL, to see a
trace of execution.

Undocumented 'show at expression' command is extremely useful !
[ BTW - is there a bug in it ?
 gnuplot>  sum(x,y)=x+y
 gnuplot>  show at sum(1,2)

        pushc 1
        pushc 2
        pushc 2
        calln sum
          pushd1 s dummy    <---- not right
          pushd2 u dummy    <---- ??? [even worse for s(x,y) !]
          plus
]

----- comma -----------

it ocurred to me that allowing comma anywhere would break
gnuplot> plot f(x), g(x)
since that is _one_ function - eval f(x), pop, eval g(x)

[plot f(x) w l, g(x) would still work....]

so I decided to only allow comma inside ()'s
[alternative would be to use a different symbol than comma]
ie to plot the single expression f(x),g(x) you'd say

plot (f(x),g(x))


------ assignments ----------

Assignments - i think I said, it is easy to allow assignments _after_
the expresion...

at the moment, I use = for assignments, purely to save poking around inside
the parser... so to increment a variable one must use the rather ugly

( ... , i+1=i , ... )

I would go for -> maybe, ie ( ... , i+1 -> i , ...) but i'll leave that
up to you - just be a bit careful testing - it is of course the most
natural thing in the world to use i=i+1...

value is not popped from stack, so multiple assignments can be done, like
c

1+2=x=y=z
(3=x)+y=z

[ completely reverse the order of the tokens to get equivalent c !!! ]

-------- iterate --------

iterate(expression,expression,....)
Keep evaluating expression while it is true
ie #define iterate(x) do ; while(x)   (???)

value of this is 1 - it had to have a value of something to prevent
stack underflow...will have to be followed by comma to be useful


-------- examples -----------

gnuplot> show at (x,y)

        push x
        pop
        push y

gnuplot> show at (1+2=x,x+1=y,y)

        pushc 1
        pushc 2
        plus
        assign x
        pop
        push x
        pushc 1
        plus
        assign y
        pop
        push y

gnuplot> f(x,y)=y=x=a     -- assign dummy y to dummy x and global a
gnuplot> show at f(1,2)

        pushc 1
        pushc 2
        pushc 2
        calln f
          pushd1 f dummy
          pushc 1
          assignd
          assign a
 
gnuplot> show at ( 0=i=sum, iterate(sum+i=sum, i+1=i, i<=10), sum)

        pushc 0
        assign i
        assign sum
        pop
        push sum
        push i
        plus
        assign sum
        pop
        push i
        pushc 1
        plus
        assign i    \
        pop          -  not optimal
        push i      /
        pushc 10
        le
        iterate
        pop
        push sum

- can optimise by hand using

gnuplot> show at ( 0=i=sum, iterate(sum+i=sum, (i+1=i)<=10), sum)

        pushc 0
        assign i
        assign sum
        pop
        push sum
        push i
        plus
        assign sum
        pop
        push i
        pushc 1
        plus
        assign i   <-----
        pushc 10
        le
        iterate
        pop
        push sum
  
gnuplot> print ( 0=i=sum, iterate(sum+i=sum, (i+1=i)<=10), sum)
        55


BUT THE SYNTAX IS ___EXTREMELY___ UGLY :-(

------------- files affected -----------

All changes conditional on EVAL_HACKS


plot.h - add  POP,ASSIGN,ASSIGND, ITERATE to p-code 'mnemonics'

plot.c - add the above to the tables of internal fns

eval.c  - put in some eval tracing code #ifdef EVAL_DEBUG

internal.c - put in fns to implement new mnemonics

misc.c  - add some code in disp_at for the undocumented SHOW AT command

parse.c - code to parse the new expressions


---------- patches follow ------------



-------- patches follow -------------

*** [.original]command.c
--- command.c
**************
*** 40,46
   * 
   * 19 September 1992  Lawrence Crowl  (crowl@cs.orst.edu)
   * Added user-specified bases for log scaling.
!  * 
   * There is a mailing list for gnuplot users. Note, however, that the
   * newsgroup 
   *	comp.graphics.gnuplot 
--- 40,57 -----
   * 
   * 19 September 1992  Lawrence Crowl  (crowl@cs.orst.edu)
   * Added user-specified bases for log scaling.
!  *
!  * 2 September, 1993  David Denholm (denholm@sotona.phys.soton.ac.uk)
!  * 'improve' data-file handling... - compile with #define DIV_HACKS
!  * the 'using' command can now specify _either_ a column number _or_
!  * an arbitrary expression (enclosed in round brackets).
!  * The arbitrary expression may use $2 or column(2) to access the data
!  * read from column two [or the second item read by a user-supplied
!  * scanf string]
!  * eg  plot 'datafile' using 1:(sin($2)+cos($3))
!  * will plot the sum of the sine of column 2 and cosine of column 3
!  * against column 1.
!  *
   * There is a mailing list for gnuplot users. Note, however, that the
   * newsgroup 
   *	comp.graphics.gnuplot 
**************
*** 65,70
  #include <math.h>
  #include <ctype.h>
  
  #ifdef AMIGA_AC_5
  #include <time.h>
  void            sleep();	/* defined later */
--- 76,89 -----
  #include <math.h>
  #include <ctype.h>
  
+ #ifdef DIV_HACKS
+ #include <stdlib.h>    /* for strtod */
+ #define MAX_DATA_COLS 1024
+ double data_column[MAX_DATA_COLS];
+ int column_good[MAX_DATA_COLS];   /* ignore columns with invalid data */
+ int no_data_cols;
+ #endif
+ 
  #ifdef AMIGA_AC_5
  #include <time.h>
  void            sleep();	/* defined later */
**************
*** 75,80
  extern jmp_buf env;       /* from plot.c */
  #endif
  
  #if defined(MSDOS) || defined(DOS386)
  #ifdef DJGPP
  #include <dos.h>
--- 94,105 -----
  extern jmp_buf env;       /* from plot.c */
  #endif
  
+ #ifdef VMS  /* div was here - speed up vax c i/o */
+ # define FOPEN(x,y) fopen(x,y,"mbc=60")
+ #else
+ # define FOPEN(x,y) fopen(x,y)
+ #endif
+ 
  #if defined(MSDOS) || defined(DOS386)
  #ifdef DJGPP
  #include <dos.h>
**************
*** 934,939
      }
  }
  
  get_data(this_plot)
      struct curve_points *this_plot;
  {
--- 959,966 -----
      }
  }
  
+ #ifdef DIV_HACKS
+ /*{{{  get_data(this_plot)*/
  get_data(this_plot)
      struct curve_points *this_plot;
  
**************
*** 936,941
  
  get_data(this_plot)
      struct curve_points *this_plot;
  {
  	register int    i, j, l_num, datum;
  	int fcol[5], scol[5], ncol[5], prevmin, col;
--- 963,979 -----
  /*{{{  get_data(this_plot)*/
  get_data(this_plot)
      struct curve_points *this_plot;
+ 
+ /* sorry, I dont understand your variables, so I rename them...
+  * Besides, who in their right mind uses i and j for things
+  * other than loop counters :-) 
+  *
+  * parse 'using' and 'thru' stuff.
+  * read columns into data_cols using scanf string or col by col.
+  * record number of cols read, and whether contained valied data
+  * in column_good[].
+  * Put data into v[] using the using spec or by making it up...
+  */
  {
  	register int    i, j, l_num, datum;
  
**************
*** 938,944
      struct curve_points *this_plot;
  {
  	register int    i, j, l_num, datum;
! 	int fcol[5], scol[5], ncol[5], prevmin, col;
  	char  format[MAX_LINE_LEN + 1], data_file[MAX_LINE_LEN + 1],
  	      line[MAX_LINE_LEN + 1];
  	/* conversion variables */
--- 976,989 -----
   */
  {
  	register int    i, j, l_num, datum;
! 
! 	/* read 'using' stuff into the following. */
! 
! 	struct { int column ; struct at_type *at; } use[5];
! 	int no_use_specs=0;
! 
! 	int no_points = 0;  /* used to be 'i' !!!!! */
! 	
  	char  format[MAX_LINE_LEN + 1], data_file[MAX_LINE_LEN + 1],
  	      line[MAX_LINE_LEN + 1];
  
**************
*** 941,946
  	int fcol[5], scol[5], ncol[5], prevmin, col;
  	char  format[MAX_LINE_LEN + 1], data_file[MAX_LINE_LEN + 1],
  	      line[MAX_LINE_LEN + 1];
  	/* conversion variables */
  	int n, m, linestat, using;
  	char *s;
--- 986,1270 -----
  	
  	char  format[MAX_LINE_LEN + 1], data_file[MAX_LINE_LEN + 1],
  	      line[MAX_LINE_LEN + 1];
+ 
+ 	double v[5];  /* we build up the values via use[] to here */
+ 	
+ 	float fval[5];	/* for use in sscanf */
+ 
+ /*{{{  close old file, if necessary*/
+ 	/* close forgotten input file (in case of a syntax error) */
+ 	if( data_fp ) {
+ #if defined(unix) || defined(PIPES)
+ 		if (pipe_open) {
+ 			(void) pclose(data_fp);
+ 			pipe_open = FALSE;
+ 		} else
+ #endif /* unix || PIPES */
+ 		(void) fclose(data_fp);
+ 		data_fp=NULL;
+ 	}
+ /*}}}*/
+ 
+ 	quotel_str(data_file, c_token);
+ 	this_plot->plot_type = DATA;
+ /*	if (parametric)
+ 		int_error("Parametric data files not yet implemented", NO_CARET);
+ */
+ /*{{{  open data file*/
+ #if defined(unix) || defined(PIPES)
+ 	if (*data_file == '<') {
+ 		if ((data_fp = popen(data_file + 1, "r")) == (FILE *) NULL)
+ 			os_error("cannot create pipe for data", c_token);
+ 		else
+ 			pipe_open = TRUE;
+ 	} else
+ #endif /* unix || PIPES */
+ 	if ((data_fp = FOPEN(data_file, "r")) == (FILE *) NULL)
+ 		os_error("can't open data file", c_token);
+ /*}}}*/
+ 
+ 	format[0] = '\0';
+ 
+ 	/* set up use array in case no using string is given */
+ 	for (i=0; i<5; ++i)
+ 	{	use[i].column=i+1;
+ 		use[i].at = NULL;  /* expression */
+ 	}
+ 	
+ 	c_token++;			/* skip data file name */
+ 
+ 	/*{{{  deal with thru*/
+ 	/* jev -- support for passing data from file thru user function */
+ 	
+ 	if (almost_equals(c_token, "thru$")) {
+ 		c_token++;
+ 		if (ydata_func.at)
+ 			free(ydata_func.at);
+ 		dummy_func = &ydata_func;
+ 		ydata_func.at = perm_at();
+ 	} else {
+ 		if (ydata_func.at)
+ 			free(ydata_func.at);
+ 		ydata_func.at = NULL;
+ 	}
+ 	/*}}}*/
+ 
+ 	/*{{{  deal with using*/
+ 	if (almost_equals(c_token,"u$sing"))
+ 	{
+ 		if (!END_OF_COMMAND && !isstring(++c_token))
+ 		{
+ 			struct value a;
+ 	
+ 			do
+ 			{
+ 				if (equals(c_token, "("))
+ 					use[no_use_specs++].at = perm_at();
+ 				else
+ 					use[no_use_specs++].column = (int)magnitude(const_express(&a));
+ 			} while (no_use_specs < 5 && equals(c_token,":") && ++c_token);
+ 		}
+ 	
+ 		if (!END_OF_COMMAND && isstring(c_token)) {
+ 			quotel_str(format, c_token);
+ 			c_token++;	/* skip format */
+ 		}
+ 	}
+ 	/*}}}*/
+     
+ 	l_num = 0;
+ 	datum = 0;
+ 
+ 	while (fgets(line, MAX_LINE_LEN, data_fp) != (char *) NULL)
+ 	{
+ 		int line_okay = 1;
+ 		l_num++;
+ 		
+ 		/*{{{  skip comments*/
+ 		if (is_comment(line[0]))
+ 		   	continue;		/* ignore comments */
+ 		/*}}}*/
+ 		
+ 		/*{{{  realloc if necessary*/
+ 		if (no_points >= this_plot->p_max)
+ 		{
+ 			/*
+ 			 * overflow about to occur. Extend size of points[] array. We
+ 			 * either double the size, or add 1000 points, whichever is a
+ 			 * smaller increment. Note i=p_max.
+ 			 */
+ 		   	cp_extend(this_plot, no_points + (no_points < 1000 ? no_points : 1000));
+ 		}
+ 		/*}}}*/
+ 		
+ 		/*{{{  check for blank line*/
+ 		if (!line[1]) 		/* is it blank line ? */
+ 		{
+ 			/* break in data, make next point undefined */
+ 			this_plot->points[no_points++].type = UNDEFINED;
+ 			continue;
+ 		}
+ 		/*}}}*/
+ 
+ 		for(i=0; i<5; i++)			/* wipe the array */
+ 			v[i] = 0.0;
+ 		
+ 
+ 		if (strlen(format) != 0)
+ 			/*{{{  do a sscanf*/
+ 			{
+ 				/* use old sscanf if a format string was given */
+ 				no_data_cols = sscanf(line, format, &fval[0], &fval[1], &fval[2], &fval[3], &fval[4]);
+ 				/*{{{  convert float to double*/
+ 				for (i=0; i<5 && i<no_data_cols; i++)		/* convert floats from sscanf to double */
+           {
+ 					data_column[i] = (double)fval[i];
+              column_good[i] = 1;
+           }
+ 				/*}}}*/
+ 			}
+ 			/*}}}*/
+ 		else
+ 			/*{{{  read the data column by column*/
+ 			{	char *s = line, *ss;
+ 			
+ 				/* implement our own sscanf that skips lines with invalid data 
+ 				 * if a using statement was given */
+ 				/* convert the array to its constituents */
+ 			
+ 				no_data_cols = 0;
+ 				
+ 				while (*s && (no_data_cols < MAX_DATA_COLS))
+ 				{
+ 					/*{{{  skip spaces*/
+ 					while (isspace(*s)) s++;
+ 					/*}}}*/
+ 					/*{{{  check for end of line*/
+ 					if (*s == '\0')
+ 						break;
+ 					/*}}}*/
+ 					data_column[no_data_cols] = strtod(s, &ss);
+ 					column_good[no_data_cols++] = !*ss || isspace(*ss);
+ 					/*{{{  skip chars to end of column*/
+ 					while ((!isspace(*s)) && (*s != '\0')) s++;
+ 					/*}}}*/
+ 				}
+ 			}
+ 			/*}}}*/
+ 
+ 		/*{{{  if there was no using spec, make one up !*/
+ 		(i=no_use_specs) || ( (i=no_data_cols) <= 5 ) || (i=5);
+ 		
+ 		/* choose no_use_specs if it is non-zero, or min(no_data_cols,5) */
+ 		/*}}}*/
+ 
+ 		/*{{{  copy values from data_column[] to v[] via use[]*/
+ 			
+ 		for (j=0; j<i; ++j)
+ 			if (use[j].at)
+ 			{	struct  value a;
+ 				evaluate_at(use[j].at, &a);
+ 				if (undefined)
+ 					line_okay=0;
+ 				v[j]=real(&a);
+ 			}
+ 			else if (use[j].column)
+ 			{
+ 				v[j] = data_column[use[j].column-1];
+ 				if ( (use[j].column > no_data_cols) || !column_good[use[j].column-1])
+ 					line_okay = 0;
+ 			}
+ 			else
+ 				v[j] = datum;	/* using 0:n */
+ /*}}}*/
+ 
+ 		if (!line_okay)
+ 			continue;
+ 			
+ /*{{{        switch based on no of columns read / desired..*/
+ 		switch (i) {
+ 		    case 1: {		/* only one number */
+ 		    	/* x is index, assign number to y */
+ 				v[1]=v[0];
+ 				v[0]=datum;
+ 				/* nobreak */
+ 		    }
+ 		    case 2: {		/* x, y */
+ 				/* ylow and yhigh are same as y */
+ 				datum++;
+ 				store2d_point(this_plot, no_points++, v[0], v[1], v[1], v[1], -1.0);
+ 				break;
+ 		    }
+ 		    case 3: {		/* x, y, ydelta */
+ 				/* ydelta is in the ylow variable */
+ 				datum++;
+ 				store2d_point(this_plot, no_points++, v[0], v[1], v[1]-v[2], v[1]+v[2], -1.0);
+ 				break;
+ 		    }
+ 		    case 4: {		/* x, y, ylow, yhigh */
+ 				datum++;
+ 				store2d_point(this_plot, no_points++, v[0], v[1], v[2], v[3], -1.0);
+ 				break;
+ 		    }
+ 		    case 5: {		/* x, y, ylow, yhigh, width */
+ 				datum++;
+ 				store2d_point(this_plot, no_points++, v[0], v[1], v[2], v[3], v[4]);
+ 				break;
+ 		    }
+ 		    default: {  /* is this ever reached in unhacked version ??? */
+ 				(void) sprintf(line, "bad data on line %d", l_num);
+         		/* close file before exiting to command level */
+ #if defined(unix) || defined(PIPES)
+ 				if (pipe_open) {
+ 					(void) pclose(data_fp);
+ 					pipe_open = FALSE;
+ 				} else
+ #endif /* unix || PIPES */
+ 					(void) fclose(data_fp);
+ 				data_fp=NULL;
+ 				int_error(line, c_token);
+ 		    }
+ 		}
+ /*}}}*/
+ 
+ 	}
+ 
+ 	if (no_points)  /* get round an existing gnuplot bug... */
+ 	{	this_plot->p_count = no_points;
+ 		cp_extend(this_plot, no_points);	/* shrink to fit */
+ 	}
+ 
+ 	/*{{{  free any expression storage*/
+ 	for (i=0; i<no_use_specs; ++i)
+ 		if (use[i].at)
+ 		{
+ 			free(use[i].at);
+ 			use[i].at = NULL;
+ 		}
+ 	/*}}}*/
+ 
+ 	no_data_cols = 0;  /* no longer needed - mark column(x) as invalid */
+ 		
+ /*{{{  close data file*/
+ #if defined(unix) || defined(PIPES)
+ 	if (pipe_open) {
+ 		(void) pclose(data_fp);
+ 		pipe_open = FALSE;
+ 	} else
+ #endif /* unix || PIPES */
+ 	(void) fclose(data_fp);
+ 	data_fp=NULL;
+ /*}}}*/
+ 
+ 	if (no_points==0)
+ 		int_error("No (valid) data", c_token);
+ }
+ /*}}}*/
+ #else
+ get_data(this_plot)
+     struct curve_points *this_plot;
+ {
+ 	register int    i, j, l_num, datum;
+ 	int fcol[5], scol[5], ncol[5], prevmin, col;
+ 	char  format[MAX_LINE_LEN + 1], data_file[MAX_LINE_LEN + 1],
+ 	      line[MAX_LINE_LEN + 1];
  	/* conversion variables */
  	int n, m, linestat, using;
  	char *s;
**************
*** 972,978
  			pipe_open = TRUE;
  	} else
  #endif /* unix || PIPES */
! 	if ((data_fp = fopen(data_file, "r")) == (FILE *) NULL)
  		os_error("can't open data file", c_token);
  
  	format[0] = '\0';
--- 1296,1302 -----
  			pipe_open = TRUE;
  	} else
  #endif /* unix || PIPES */
! 	if ((data_fp = FOPEN(data_file, "r")) == (FILE *) NULL)
  		os_error("can't open data file", c_token);
  
  	format[0] = '\0';
**************
*** 1174,1179
  	(void) fclose(data_fp);
  	data_fp=NULL;
  }
  
  
  /* called by get_data for each point */
--- 1498,1504 -----
  	(void) fclose(data_fp);
  	data_fp=NULL;
  }
+ #endif
  
  /* called by get_data for each point */
  store2d_point(this_plot, i, x, y, ylow, yhigh, width)
**************
*** 1175,1181
  	data_fp=NULL;
  }
  
- 
  /* called by get_data for each point */
  store2d_point(this_plot, i, x, y, ylow, yhigh, width)
      struct curve_points *this_plot;
--- 1500,1505 -----
  }
  #endif
  
  /* called by get_data for each point */
  store2d_point(this_plot, i, x, y, ylow, yhigh, width)
      struct curve_points *this_plot;
**************
*** 1474,1480
  		pipe_open = TRUE;
  	} else
  #endif /* unix || PIPES */
! 	    if ((data_fp = fopen(data_file, "r")) == (FILE *) NULL)
  		os_error("can't open data file", c_token);
  
  	/* Initialize defualt values. */
--- 1798,1804 -----
  		pipe_open = TRUE;
  	} else
  #endif /* unix || PIPES */
! 	    if ((data_fp = FOPEN(data_file, "r")) == (FILE *) NULL)
  		os_error("can't open data file", c_token);
  
  	/* Initialize defualt values. */
**************
*** 2242,2247
  		    (void) temp_at();
  		}
  		if (almost_equals(c_token, "u$sing")) {
  		    c_token++;	/* skip "using" */
  		    if (!isstring(c_token)) {
  			struct value    a;
--- 2566,2577 -----
  		    (void) temp_at();
  		}
  		if (almost_equals(c_token, "u$sing")) {
+ #ifdef DIV_HACKS
+ 			if (!isstring(++c_token))
+ 				do
+ 					temp_at();  /* dont moan about $i undefined */
+ 				while (equals(c_token, ":") && ++c_token);  /* inc c_token iff : */
+ #else
  		    c_token++;	/* skip "using" */
  		    if (!isstring(c_token)) {
  			struct value    a;
**************
*** 2263,2268
  			    (void) magnitude(const_express(&a));	/* skip wcol */
  			}
  		    }
  		    if (isstring(c_token))
  			c_token++;	/* skip format string */
  		}
--- 2593,2599 -----
  			    (void) magnitude(const_express(&a));	/* skip wcol */
  			}
  		    }
+ #endif
  		    if (isstring(c_token))
  			c_token++;	/* skip format string */
  		}
*** [.original]internal.c
--- internal.c
**************
*** 159,164
  	push(&(x->udf_arg->dummy_values[param.v.int_val]));
  }
  
  
  #define ERR_FUN "undefined function: "
  
--- 159,171 -----
  	push(&(x->udf_arg->dummy_values[param.v.int_val]));
  }
  
+ #ifdef EVAL_HACKS
+ f_pop(x)
+ union argument *x;
+ {
+ 	struct value param;
+ 	pop(&param);
+ }
  
  f_assign(x)
  union argument *x;
**************
*** 160,166
  }
  
  
! #define ERR_FUN "undefined function: "
  
  f_call(x)  /* execute a udf */
  union argument *x;
--- 167,178 -----
  	pop(&param);
  }
  
! f_assign(x)
! union argument *x;
! {
! 	x->udv_arg->udv_value = top_of_stack;   /* dont pop */
! 	x->udv_arg->udv_undef = 0;  /* it is defined */
! }
  
  f_assignd(x)
  union argument *x;
**************
*** 162,167
  
  #define ERR_FUN "undefined function: "
  
  f_call(x)  /* execute a udf */
  union argument *x;
  {
--- 174,191 -----
  	x->udv_arg->udv_undef = 0;  /* it is defined */
  }
  
+ f_assignd(x)
+ union argument *x;
+ {
+ 	struct value param;
+ 	pop(&param);
+ 	x->udf_arg->dummy_values[param.v.int_val] = top_of_stack; /* dont pop */
+ }
+ 
+ #endif
+ 
+ #define ERR_FUN "undefined function: "
+ 
  f_call(x)  /* execute a udf */
  union argument *x;
  {
**************
*** 890,892
  	else
  		return(x->j_arg);		/* go jump to FALSE code */
  }
--- 914,955 -----
  	else
  		return(x->j_arg);		/* go jump to FALSE code */
  }
+ 
+ #ifdef EVAL_HACKS
+ f_iterate(x)
+ union argument *x;
+ {
+ 	struct value a;
+ 	int_check(&top_of_stack);
+ 	if (top_of_stack.v.int_val)  /* non-zero */
+ 	{
+ 		(void) pop(&a);           /* pop */
+ 		return(x->j_arg);         /* jump */
+ 	}
+ 	else
+ 		return 1;				     /* no jump - break from loop */
+ }
+ 	
+ #endif
+ 
+ 
+ #ifdef DIV_HACKS
+ f_dollars(x)
+ struct value *x;
+ {
+ 	extern int no_data_cols;
+ 	extern double data_column[];
+ 	extern int column_good[];
+ 	int column = x->v.int_val - 1;
+ 		/* we checked it was an integer > 0 at compile time */
+ 	struct value a;
+ 
+ 	if (column >= no_data_cols || !column_good[column])
+ 	{	undefined = TRUE;
+ 		push (Gcomplex(&a, 0.0, 0.0) );
+ 	}
+ 	else
+ 		push( Gcomplex(&a, data_column[column], 0.0) );
+ }
+ #endif
+ 
*** [.original]parse.c
--- parse.c
**************
*** 222,229
  struct at_type *
  perm_at()
  {
! 	register struct at_type *at_ptr;
! 	register unsigned int len;
  
  	(void)temp_at();
  	len = sizeof(struct at_type) -
--- 222,229 -----
  struct at_type *
  perm_at()
  {
! 	struct at_type *at_ptr;
! 	unsigned int len;
  
  	(void)temp_at();
  	len = sizeof(struct at_type) -
**************
*** 247,252
  }
  #endif				/* NOCOPY */
  
  
  express()
  {				/* full expressions */
--- 247,253 -----
  }
  #endif				/* NOCOPY */
  
+ #ifdef EVAL_HACKS
  
  exp_with_commas()
  {	/* allowing commas in _any_ expression will break 'plot f(x),g(x)'
**************
*** 248,253
  #endif				/* NOCOPY */
  
  
  express()
  {				/* full expressions */
  	xterm();
--- 249,278 -----
  
  #ifdef EVAL_HACKS
  
+ exp_with_commas()
+ {	/* allowing commas in _any_ expression will break 'plot f(x),g(x)'
+ 	 * this one is called only after an opening bracket
+ 	 */
+ 
+ 	do
+ 		express();  /* one expression, without commas */
+ 	while (equals(c_token, ",") && ++c_token && add_action(POP));
+ }
+ 
+ express()   /* one expression without commas */
+ {
+ 	wterm();   /* expression without assignments */
+ 	wterms();  /* look for one or more assignments */
+ }
+ 
+ wterm()  /* one expression without assignments [original express()] */
+ {
+ 	xterm();
+ 	xterms();
+ }
+ 
+ #else
+ 
  express()
  {				/* full expressions */
  	xterm();
**************
*** 254,259
  	xterms();
  }
  
  xterm()
  {				/* ? : expressions */
  	aterm();
--- 279,286 -----
  	xterms();
  }
  
+ #endif
+ 
  xterm()
  {				/* ? : expressions */
  	aterm();
**************
*** 321,326
  {
  	register int    value;
  
  	if (equals(c_token, "(")) {
  		c_token++;
  		express();
--- 348,371 -----
  {
  	register int    value;
  
+ #ifdef EVAL_HACKS
+ 	if (equals(c_token, "iterate"))
+ 	{	int save_pc = at.a_count;
+ 		int displacement;
+ 		
+ 		if (!equals(++c_token, "("))
+ 			int_error("Expected (", c_token);
+ 		++c_token;
+ 		exp_with_commas();
+ 		if (!equals(c_token, ")"))
+ 			int_error("Expected )", c_token);
+ 		++c_token;
+ 		displacement = save_pc - at.a_count;
+ 		add_action(ITERATE)->j_arg = displacement;
+ 	}
+ 	else
+ #endif
+ 
  	if (equals(c_token, "(")) {
  		c_token++;
  #ifdef EVAL_HACKS
**************
*** 323,328
  
  	if (equals(c_token, "(")) {
  		c_token++;
  		express();
  		if (!equals(c_token, ")"))
  			int_error("')' expected", c_token);
--- 368,376 -----
  
  	if (equals(c_token, "(")) {
  		c_token++;
+ #ifdef EVAL_HACKS
+ 		exp_with_commas();   /* allow commas */
+ #else
  		express();
  #endif
  		if (!equals(c_token, ")"))
**************
*** 324,329
  	if (equals(c_token, "(")) {
  		c_token++;
  		express();
  		if (!equals(c_token, ")"))
  			int_error("')' expected", c_token);
  		c_token++;
--- 372,378 -----
  		exp_with_commas();   /* allow commas */
  #else
  		express();
+ #endif
  		if (!equals(c_token, ")"))
  			int_error("')' expected", c_token);
  		c_token++;
**************
*** 327,332
  		if (!equals(c_token, ")"))
  			int_error("')' expected", c_token);
  		c_token++;
  	} else if (isnumber(c_token)) {
  		convert(&(add_action(PUSHC)->v_arg), c_token);
  		c_token++;
--- 376,392 -----
  		if (!equals(c_token, ")"))
  			int_error("')' expected", c_token);
  		c_token++;
+ #ifdef DIV_HACKS
+ 	} else if (equals(c_token,"$")) {
+ 		struct value a;
+ 		if (!isnumber(++c_token))
+ 			int_error("Column number expected", c_token);
+ 		convert(&a, c_token++);
+ 		if (a.type != INTGR || a.v.int_val < 1)
+ 			int_error("Positive integer expected", c_token);
+ 		add_action(DOLLARS)->v_arg = a;
+ #endif
+ 
  	} else if (isnumber(c_token)) {
  		convert(&(add_action(PUSHC)->v_arg), c_token);
  		c_token++;
**************
*** 413,418
  	}
  }
  
  
  
  xterms()
--- 473,513 -----
  	}
  }
  
+ #ifdef EVAL_HACKS
+ 
+ wterms()
+ {
+ 	/* look for one or more assignments */
+ 
+ 	int i;
+ 	
+ 	while (equals(c_token, "="))
+ 	{
+ 		if (++c_token >= num_tokens || !isletter(c_token))
+ 			int_error("Expected assignment variable", c_token);
+ 
+ 		for (i = 0; i < MAX_NUM_VAR; i++)
+ 		{
+ 			if (equals(c_token, c_dummy_var[i]))
+ 			{
+ 				struct value num_params;
+ 				num_params.type = INTGR;
+ 				num_params.v.int_val = i;
+ 				add_action(PUSHC)->v_arg = num_params;
+ 				add_action(ASSIGND)->udf_arg = dummy_func;
+ 				goto found;
+ 			}
+ 		}
+ 		
+ 		/* get here if we didn't find it in list of dummy params */
+ 		add_action(ASSIGN)->udv_arg = add_udv(c_token);
+ 
+ 		found:
+ 		++c_token;
+ 	}
+ }
+ 
+ #endif
  
  
  xterms()
*** [.original]plot.c
--- plot.c
**************
*** 116,121
  	f_ge(),f_le(),f_plus(),f_minus(),f_mult(),f_div(),f_mod(),f_power(),
  	f_factorial(),f_bool(),f_jump(),f_jumpz(),f_jumpnz(),f_jtern();
  
  extern f_real(),f_imag(),f_arg(),f_conjg(),f_sin(),f_cos(),f_tan(),f_asin(),
  	f_acos(),f_atan(),f_sinh(),f_cosh(),f_tanh(),f_int(),f_abs(),f_sgn(),
  	f_sqrt(),f_exp(),f_log10(),f_log(),f_besj0(),f_besj1(),f_besy0(),f_besy1(),
--- 116,125 -----
  	f_ge(),f_le(),f_plus(),f_minus(),f_mult(),f_div(),f_mod(),f_power(),
  	f_factorial(),f_bool(),f_jump(),f_jumpz(),f_jumpnz(),f_jtern();
  
+ #ifdef EVAL_HACKS
+ extern f_pop(), f_assign(), f_assignd(), f_iterate();
+ #endif
+ 
  extern f_real(),f_imag(),f_arg(),f_conjg(),f_sin(),f_cos(),f_tan(),f_asin(),
  	f_acos(),f_atan(),f_sinh(),f_cosh(),f_tanh(),f_int(),f_abs(),f_sgn(),
  	f_sqrt(),f_exp(),f_log10(),f_log(),f_besj0(),f_besj1(),f_besy0(),f_besy1(),
**************
*** 123,128
  	f_floor(),f_ceil(),
  	f_normal(), f_inverse_erf(), f_inverse_normal();   /* XXX - JG */
  
  
  struct ft_entry GPFAR ft[] = {	/* built-in function table */
  
--- 127,135 -----
  	f_floor(),f_ceil(),
  	f_normal(), f_inverse_erf(), f_inverse_normal();   /* XXX - JG */
  
+ #ifdef DIV_HACKS
+ extern f_dollars(), f_column(), f_valid();
+ #endif
  
  struct ft_entry GPFAR ft[] = {	/* built-in function table */
  
**************
*** 137,144
  	{"le", f_le},		{"plus", f_plus},	{"minus", f_minus},
  	{"mult", f_mult},	{"div", f_div},		{"mod", f_mod},
  	{"power", f_power}, {"factorial", f_factorial},
! 	{"bool", f_bool},	{"jump", f_jump},	{"jumpz", f_jumpz},
! 	{"jumpnz",f_jumpnz},{"jtern", f_jtern},
  
  /* standard functions: */
  	{"real", f_real},	{"imag", f_imag},	{"arg", f_arg},
--- 144,150 -----
  	{"le", f_le},		{"plus", f_plus},	{"minus", f_minus},
  	{"mult", f_mult},	{"div", f_div},		{"mod", f_mod},
  	{"power", f_power}, {"factorial", f_factorial},
! 	{"bool", f_bool},
  
  #ifdef DIV_HACKS
  	{"dollars", f_dollars},
**************
*** 140,145
  	{"bool", f_bool},	{"jump", f_jump},	{"jumpz", f_jumpz},
  	{"jumpnz",f_jumpnz},{"jtern", f_jtern},
  
  /* standard functions: */
  	{"real", f_real},	{"imag", f_imag},	{"arg", f_arg},
  	{"conjg", f_conjg}, {"sin", f_sin},		{"cos", f_cos},
--- 146,167 -----
  	{"power", f_power}, {"factorial", f_factorial},
  	{"bool", f_bool},
  
+ #ifdef DIV_HACKS
+ 	{"dollars", f_dollars},
+ #endif
+ #ifdef EVAL_HACKS
+ 	{"pop", f_pop},
+ 	{"assign", f_assign},
+ 	{"assignd", f_assignd},
+ #endif
+ 
+ 	{"jump", f_jump},	{"jumpz", f_jumpz},
+ 	{"jumpnz",f_jumpnz},{"jtern", f_jtern},
+ #ifdef EVAL_HACKS
+ 	{"iterate", f_iterate},
+ #endif
+ 
+ 
  /* standard functions: */
  	{"real", f_real},	{"imag", f_imag},	{"arg", f_arg},
  	{"conjg", f_conjg}, {"sin", f_sin},		{"cos", f_cos},
**************
*** 156,161
      {"norm",        f_normal},              /* XXX-JG */
      {"inverf",      f_inverse_erf},         /* XXX-JG */
      {"invnorm",     f_inverse_normal},      /* XXX-JG */
  
  	{NULL, NULL}
  };
--- 178,188 -----
      {"norm",        f_normal},              /* XXX-JG */
      {"inverf",      f_inverse_erf},         /* XXX-JG */
      {"invnorm",     f_inverse_normal},      /* XXX-JG */
+ 
+ #ifdef DIV_HACKS
+ 	{ "column",      f_column },    /* access data file column */
+ 	{ "valid",       f_valid },     /* reports column(x) is valid */
+ #endif
  
  	{NULL, NULL}
  };
*** [.original]scanner.c
--- scanner.c
**************
*** 200,205
  			case ':':
  			case '?':
  			case ',':
  				break;
  			case '&':
  			case '|':
--- 200,208 -----
  			case ':':
  			case '?':
  			case ',':
+ #ifdef DIV_HACKS
+ 			case '$':
+ #endif
  				break;
  			case '&':
  			case '|':
*** [.original]standard.c
--- standard.c
**************
*** 984,986
  		undefined = TRUE ;
  	}
  }
--- 984,1023 -----
  		undefined = TRUE ;
  	}
  }
+ 
+ 
+ 
+ #ifdef DIV_HACKS
+ f_column()
+ {
+ 	extern int no_data_cols;
+ 	extern double data_column[];
+ 	extern int column_good[];
+ 
+ 	struct value a;
+ 	int column;
+ 	(void) pop(&a);
+ 	column = (int) magnitude(&a) - 1;
+ 	if (column < 0 || column >= no_data_cols || !column_good[column])
+ 	{	undefined = TRUE;
+ 		push (Gcomplex(&a, 0.0, 0.0) );
+ 	}
+ 	else
+ 		push( Gcomplex(&a, data_column[column], 0.0) );
+ }
+ 
+ f_valid()
+ {
+ 	extern int no_data_cols;
+ 	extern double data_column[];
+ 	extern int column_good[];
+ 
+ 	struct value a;
+ 	int column,good;
+ 	(void) pop(&a);
+ 	column = (int) magnitude(&a) - 1;
+ 	good = column >= 0 && column < no_data_cols && column_good[column];
+ 	push (Ginteger(&a, good));
+ }
+ #endif
+ 	
*** [.original]plot.h
--- plot.h
**************
*** 100,105
  #define STACK_DEPTH 100
  #define NO_CARET (-1)
  
  #ifdef MSDOS
  #define MAX_NUM_VAR	3	/* Ploting projection of func. of max. five vars. */
  #else
--- 100,109 -----
  #define STACK_DEPTH 100
  #define NO_CARET (-1)
  
+ #ifdef DIV_HACKS
+ #define MAX_DATA_COLS 40   /* max columns of data */
+ #endif
+ 
  #ifdef MSDOS
  #define MAX_NUM_VAR	3	/* Ploting projection of func. of max. five vars. */
  #else
**************
*** 334,340
  enum operators {
  	PUSH, PUSHC, PUSHD1, PUSHD2, PUSHD, CALL, CALLN, LNOT, BNOT, UMINUS,
  	LOR, LAND, BOR, XOR, BAND, EQ, NE, GT, LT, GE, LE, PLUS, MINUS, MULT,
! 	DIV, MOD, POWER, FACTORIAL, BOOLE, JUMP, JUMPZ, JUMPNZ, JTERN, SF_START
  };
  
  
--- 338,355 -----
  enum operators {
  	PUSH, PUSHC, PUSHD1, PUSHD2, PUSHD, CALL, CALLN, LNOT, BNOT, UMINUS,
  	LOR, LAND, BOR, XOR, BAND, EQ, NE, GT, LT, GE, LE, PLUS, MINUS, MULT,
! 	DIV, MOD, POWER, FACTORIAL, BOOLE,
! #ifdef DIV_HACKS
! 	DOLLARS,  /* keep in step with plot.c - must go before jump */
! #endif
! #ifdef EVAL_HACKS
! 	POP, ASSIGN, ASSIGND,
! #endif
! 	JUMP, JUMPZ, JUMPNZ, JTERN,
! #ifdef EVAL_HACKS
! 	ITERATE,        /* here so it is recognised as a jump instruction */
! #endif
! 	SF_START
  };
  
  
*** [.original]eval.c
--- eval.c
**************
*** 143,148
  
  	count = at_ptr->a_count;
  	for (i = 0; i < count;) {
  		index = (int)at_ptr->actions[i].index;
  		offset = (*ft[index].func)(&(at_ptr->actions[i].arg));
  		if (is_jump(index))
--- 143,152 -----
  
  	count = at_ptr->a_count;
  	for (i = 0; i < count;) {
+ #ifdef DEBUG_EVAL		
+ 		fputs(ft[(int)(at_ptr->actions[i].index)].f_name,stderr);
+ 		fputc('\n', stderr);
+ #endif
  		index = (int)at_ptr->actions[i].index;
  		offset = (*ft[index].func)(&(at_ptr->actions[i].arg));
  		if (is_jump(index))
*** [.original]misc.c
--- misc.c
**************
*** 903,908
  			/* now print optional argument */
  
  		switch(curr_at->actions[i].index) {
  		  case PUSH:	fprintf(stderr," %s\n", arg->udv_arg->udv_name);
  					break;
  		  case PUSHC:	(void) putc(' ',stderr);
--- 903,911 -----
  			/* now print optional argument */
  
  		switch(curr_at->actions[i].index) {
+ #ifdef EVAL_HACKS
+ 		  case ASSIGN:
+ #endif
  		  case PUSH:	fprintf(stderr," %s\n", arg->udv_arg->udv_name);
  					break;
  #ifdef DIV_HACKS
**************
*** 905,910
  		switch(curr_at->actions[i].index) {
  		  case PUSH:	fprintf(stderr," %s\n", arg->udv_arg->udv_name);
  					break;
  		  case PUSHC:	(void) putc(' ',stderr);
  					disp_value(stderr,&(arg->v_arg));
  					(void) putc('\n',stderr);
--- 908,916 -----
  #endif
  		  case PUSH:	fprintf(stderr," %s\n", arg->udv_arg->udv_name);
  					break;
+ #ifdef DIV_HACKS
+         case DOLLARS:
+ #endif
  		  case PUSHC:	(void) putc(' ',stderr);
  					disp_value(stderr,&(arg->v_arg));
  					(void) putc('\n',stderr);
