#include <stdlib.h>
#include <io.h>
#include <fcntl.h>

#define DEVICE "lpt1"  /* default */

void print(int input, char *out)
{
  char buf[1024];
  int output, bytes;

  if ( (output = open(out, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666)) == -1 )
    return;

  while ( (bytes = read(input, buf, sizeof(buf))) > 0 )
    if ( write(output, buf, bytes) == -1 )
      break;
    
  close(output);
}

void main(int argc, char **argv)
{
  char *dev = getenv("LP_DEVICE");
  int arg, file;

  if ( argc == 1 )
    if ( isatty(0) )
    {
      printf("\nUsage: %s [file ...]"
             "\n   or: command | %s\n", argv[0], argv[0]);
      exit(1);
    }
    else
    {
      setmode(0, O_BINARY);
      print(0, dev ? dev : DEVICE);
    }
  else
    for ( arg = 1; arg < argc; arg++ )
      if ( (file = open(argv[arg], O_RDONLY | O_BINARY)) != -1 )
      {
        print(file, dev ? dev : DEVICE);
        close(file);
      }
  
  exit(0);
}
