/* DISKTAPE.H
 *
 * "tape on a disk" Emulator for MS-DOS and OS/2.
 *
 * Autor:    Kai Uwe Rommel
 * Datum:    Thu 28-Dec-1989
 * Stand:    Wed 4-Mar-1992
 *
 * Compiler: MS C ab 5.10
 * System:   OS/2 ab 1.1, PS/MS-DOS ab 3.20
 *
 */


int dsk_isdev(char *path);
int dsk_open(char *path, int oflag, int logical);
int dsk_close(int handle);
int dsk_read(int handle, char *buf, unsigned nbyte);
int dsk_write(int handle, char *buf, unsigned nbyte);
long dsk_lseek(int handle, long offset, int whence);
int dsk_size(int handle, long *total, long *cylinder);


#define _dev(p)         dsk_isdev(p)
#define _dsk(f)         ((f) >= 256)

#define open(p, f, m)  (_dev(p) ? dsk_open(p, f, use_logical) + 256 : open(p, f, m))
#define read(f, b, n)   (_dsk(f) ? dsk_read(f - 256, b, n) : read(f, b, n))
#define write(f, b, n)  (_dsk(f) ? dsk_write(f - 256, b, n) : write(f, b, n))
#define lseek(f, o, w)  (_dsk(f) ? dsk_lseek(f - 256, o, w) : lseek(f, o, w))
#define close(f)        (_dsk(f) ? dsk_close(f - 256) : close(f))


/* Ende DISKTAPE.H */
