------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--            S Y S T E M . I N T E R R U P T _ M A N A G E M E N T         --
--                                                                          --
--                                  S p e c                                 --
--                          (Version for new GNARL)                         --
--                                                                          --
--                             $Revision: 1.2 $                            --
--                                                                          --
--   Copyright (C) 1991,1992,1993,1994,1995,1996 Florida State University   --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This is an OS/2 version of this package.

--  This package encapsulates and centralizes information about
--  all uses of interrupts (or signals), including then
--  target-dependent mapping of interrupts (or signals) to exceptions.

--  PLEASE DO NOT add any with-clauses to this package.
--  This is designed to work for both tasking and non-tasking systems,
--  without pulling in any of the tasking support.

--  PLEASE DO NOT remove the Elaborate_Body pragma from this package.
--  Elaboration of this package should happen early, as most other
--  initializations depend on it.
--  Forcing immediate elaboration of the body also helps to enforce
--  the design assumption that this is a second-level
--  package, just one level above System.OS_Interface, with no
--  cross-dependences.

--  PLEASE DO NOT put any subprogram declarations with arguments of
--  type Interrupt_ID into the visible part of this package.
--  The type Interrupt_ID is used to derive the type in Ada.Interrupts,
--  and adding more operations to that type would be illegal according
--  to the Ada Reference Manual.  (This is the reason why the signals sets
--  below are implemented as visible arrays rather than functions.)

--  This version is a stub, for systems that
--  do not support interrupts (or signals).

package System.Interrupt_Management is
   type Interrupt_ID is new Integer range 0 .. 2;
end System.Interrupt_Management;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.1
--  date: 1996/06/06 19:25:22;  author: doh;  state: Exp;
--  Initial revision
--  ----------------------------
--  revision 1.2
--  date: 1996/06/12 04:03:08;  author: doh;  state: Exp;  lines: +3 -1
--  Indicate the target name in the header.
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
