------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                     I N T E R F A C E S . O S 2 L I B                    --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.9 $                             --
--                                                                          --
--          Copyright (C) 1993-1997 Free Software Foundation, Inc.          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --
------------------------------------------------------------------------------

with Interfaces.OS2Lib.Errors; use Interfaces.OS2Lib.Errors;
with System.Error_Reporting; use System.Error_Reporting;

package body Interfaces.OS2Lib is

   -------------------
   -- Must_Not_Fail --
   -------------------

   procedure Must_Not_Fail (Return_Code : APIRET) is
   begin
      pragma Assert (Return_Code = NO_ERROR
        or else Shutdown ("OS/2 error code is" & Return_Code'Img));
      null;
   end Must_Not_Fail;

   -----------------------
   -- Sem_Must_Not_Fail --
   -----------------------

   procedure Sem_Must_Not_Fail (Return_Code : OS2Lib.APIRET) is
   begin
      pragma Assert
        (Return_Code = NO_ERROR
           or else
         Return_Code = ERROR_ALREADY_POSTED
           or else
         Shutdown ("OS/2 error code is" & Return_Code'Img));
      null;
   end Sem_Must_Not_Fail;

end Interfaces.OS2Lib;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.7
--  date: 1997/08/24 23:23:23;  author: dewar;  state: Exp;  lines: +2 -2
--  Checked in for bosch by dewar
--  Cleanups and additions for new GNULLI
--  ----------------------------
--  revision 1.8
--  date: 1997/08/24 23:40:19;  author: dewar;  state: Exp;  lines: +7 -2
--  Cleanup from 1.7 change (was not done right)
--  ----------------------------
--  revision 1.9
--  date: 1997/08/27 03:42:32;  author: dewar;  state: Exp;  lines: +7 -4
--  (Sem_Must_Not_Fail): Add shutdown condition
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
